/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.DuplicateJvmSignatureUtilKt;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.SyntaxErrorDiagnostic;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactoryImpl;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporter;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticReporterKt;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicDiagnosticsHandler;
import org.jetbrains.kotlin.test.frontend.classic.handlers.ClassicFrontendAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DiagnosticsService;
import org.jetbrains.kotlin.test.services.DiagnosticsServiceKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J8\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0018\u0010*\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticsHandler;", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicFrontendAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "diagnosticsService", "Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "getDiagnosticsService", "()Lorg/jetbrains/kotlin/test/services/DiagnosticsService;", "directivesContainers", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectivesContainers", "globalMetadataInfoHandler", "Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "getGlobalMetadataInfoHandler", "()Lorg/jetbrains/kotlin/test/services/GlobalMetadataInfoHandler;", "reporter", "Lorg/jetbrains/kotlin/test/frontend/classic/handlers/ClassicDiagnosticReporter;", "computeJvmSignatureDiagnostics", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "info", "Lorg/jetbrains/kotlin/test/frontend/classic/ClassicFrontendOutputArtifact;", "processAfterAllModules", "", "someAssertionWasFailed", "", "processDebugInfoDiagnostics", "configuration", "Lorg/jetbrains/kotlin/checkers/utils/DiagnosticsRenderingConfiguration;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "withNewInferenceModeEnabled", "processModule", "tests-common-new"})
public final class ClassicDiagnosticsHandler
extends ClassicFrontendAnalysisHandler {
    @NotNull
    private final List<DirectivesContainer> directivesContainers;
    @NotNull
    private final List<ServiceRegistrationData> additionalServices;
    @NotNull
    private final ClassicDiagnosticReporter reporter;

    public ClassicDiagnosticsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, false, 6, null);
        this.directivesContainers = CollectionsKt.listOf((Object)DiagnosticsDirectives.INSTANCE);
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        this.additionalServices = CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(DiagnosticsService.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
        this.reporter = new ClassicDiagnosticReporter(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectivesContainers() {
        return this.directivesContainers;
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        return this.additionalServices;
    }

    private final GlobalMetadataInfoHandler getGlobalMetadataInfoHandler() {
        return GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler(this.getTestServices());
    }

    private final DiagnosticsService getDiagnosticsService() {
        return DiagnosticsServiceKt.getDiagnosticsService(this.getTestServices());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module2, @NotNull ClassicFrontendOutputArtifact info) {
        void $this$groupByTo$iv$iv;
        Diagnostic it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Iterable destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Diagnostics diagnostics2 = info.getAnalysisResult().getBindingContext().getDiagnostics();
        Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"info.analysisResult.bindingContext.diagnostics");
        List allDiagnostics = CollectionsKt.plus((Iterable)diagnostics2, (Iterable)this.computeJvmSignatureDiagnostics(info));
        if (module2.getDirectives().contains(AdditionalFilesDirectives.INSTANCE.getCHECK_TYPE())) {
            $this$filter$iv = allDiagnostics;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getFactory().getName(), (Object)Errors.UNDERSCORE_USAGE_WITHOUT_BACKTICKS.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            allDiagnostics = (List)destination$iv$iv;
        }
        if (module2.getDirectives().contains(LanguageSettingsDirectives.INSTANCE.getAPI_VERSION())) {
            $this$filter$iv = allDiagnostics;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Diagnostic)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getFactory().getName(), (Object)Errors.NEWER_VERSION_IN_SINCE_KOTLIN.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            allDiagnostics = (List)destination$iv$iv;
        }
        Iterable $this$groupBy$iv = allDiagnostics;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv22 : $this$groupByTo$iv$iv) {
            Object object;
            Diagnostic it2 = (Diagnostic)element$iv$iv22;
            boolean bl = false;
            PsiFile key$iv$iv = it2.getPsiFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv22);
        }
        Map diagnosticsPerFile = destination$iv$iv2;
        boolean withNewInferenceModeEnabled = ClassicDiagnosticReporterKt.withNewInferenceModeEnabled(this.getTestServices());
        DiagnosticsRenderingConfiguration configuration2 = this.reporter.createConfiguration(module2);
        Object object = info.getKtFiles();
        $i$f$groupByTo = false;
        Iterator<Map.Entry<TestFile, KtFile>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv22;
            Object element$iv$iv;
            element$iv$iv = object = iterator2.next();
            boolean element$iv$iv22 = false;
            TestFile file2 = (TestFile)element$iv$iv.getKey();
            element$iv$iv22 = object;
            boolean bl = false;
            KtFile ktFile = (KtFile)element$iv$iv22.getValue();
            List list2 = (List)diagnosticsPerFile.get(ktFile);
            List diagnostics3 = list2 == null ? CollectionsKt.emptyList() : list2;
            for (Diagnostic diagnostic : diagnostics3) {
                if (!diagnostic.isValid() || !this.getDiagnosticsService().shouldRenderDiagnostic(module2, diagnostic.getFactory().getName(), diagnostic.getSeverity())) continue;
                this.reporter.reportDiagnostic(diagnostic, module2, file2, configuration2, withNewInferenceModeEnabled);
            }
            for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges((PsiElement)ktFile)) {
                this.reporter.reportDiagnostic(new SyntaxErrorDiagnostic(errorElement), module2, file2, configuration2, withNewInferenceModeEnabled);
            }
            this.processDebugInfoDiagnostics(configuration2, module2, file2, ktFile, info, withNewInferenceModeEnabled);
        }
    }

    private final Set<Diagnostic> computeJvmSignatureDiagnostics(ClassicFrontendOutputArtifact info) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestModule it = (TestModule)element$iv;
                    boolean bl2 = false;
                    if (!(!JvmPlatformKt.isJvm(it.getTargetPlatform()))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return SetsKt.emptySet();
        }
        if (!TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(DiagnosticsDirectives.INSTANCE.getREPORT_JVM_DIAGNOSTICS_ON_FRONTEND())) {
            return SetsKt.emptySet();
        }
        BindingContext bindingContext = info.getAnalysisResult().getBindingContext();
        Project project = info.getProject();
        HashSet<Diagnostic> jvmSignatureDiagnostics = new HashSet<Diagnostic>();
        for (KtFile ktFile : info.getKtFiles().values()) {
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)ktFile), KtDeclaration.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(ktFil\u2026tDeclaration::class.java)");
            Collection declarations2 = collection;
            for (KtDeclaration declaration2 : declarations2) {
                Intrinsics.checkNotNullExpressionValue((Object)declaration2, (String)"declaration");
                PsiElement psiElement = declaration2;
                Diagnostics diagnostics2 = bindingContext.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"bindingContext.diagnostics");
                Diagnostics diagnostics3 = diagnostics2;
                diagnostics2 = GlobalSearchScope.allScope((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)diagnostics2, (String)"allScope(project)");
                Diagnostics diagnostics4 = DuplicateJvmSignatureUtilKt.getJvmSignatureDiagnostics(psiElement, diagnostics3, (GlobalSearchScope)diagnostics2);
                if (diagnostics4 == null) continue;
                Diagnostics diagnostics5 = diagnostics4;
                jvmSignatureDiagnostics.addAll(diagnostics5.forElement(declaration2));
            }
        }
        return jvmSignatureDiagnostics;
    }

    /*
     * WARNING - void declaration
     */
    private final void processDebugInfoDiagnostics(DiagnosticsRenderingConfiguration configuration2, TestModule module2, TestFile file2, KtFile ktFile, ClassicFrontendOutputArtifact info, boolean withNewInferenceModeEnabled) {
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        String string2;
        Object object2;
        Object answer$iv$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable iterable = this.getGlobalMetadataInfoHandler().getExistingMetaInfosForFile(file2);
        boolean $i$f$groupBy = false;
        Iterator<ActualDiagnostic> iterator2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object3;
            ParsedCodeMetaInfo it2 = (ParsedCodeMetaInfo)element$iv$iv;
            boolean $i$a$-groupBy-ClassicDiagnosticsHandler$processDebugInfoDiagnostics$diagnosedRanges$32 = false;
            key$iv$iv = new IntRange(it2.getStart(), it2.getEnd());
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            ParsedCodeMetaInfo $i$a$-groupBy-ClassicDiagnosticsHandler$processDebugInfoDiagnostics$diagnosedRanges$32 = (ParsedCodeMetaInfo)element$iv$iv;
            object2 = list$iv$iv;
            boolean bl = false;
            string2 = it.getTag();
            object2.add(string2);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $dstr$_u24__u24$it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl = false;
            object = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            string2 = object;
            object2 = $this$getOrPut$iv$iv$iv;
            boolean bl2 = false;
            void var23_32 = $dstr$_u24__u24$it;
            boolean bl3 = false;
            List it = (List)var23_32.getValue();
            Set set = CollectionsKt.toMutableSet((Iterable)it);
            object2.put(string2, set);
        }
        Map diagnosedRanges = destination$iv$iv;
        $i$f$mapValues = false;
        List<ActualDiagnostic> debugAnnotations = CheckerTestUtil.INSTANCE.getDebugInfoDiagnostics((PsiElement)ktFile, info.getAnalysisResult().getBindingContext(), module2.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getMARK_DYNAMIC_CALLS()), new ArrayList(), configuration2, new DataFlowValueFactoryImpl(info.getLanguageVersionSettings()), (ModuleDescriptorImpl)info.getAnalysisResult().getModuleDescriptor(), diagnosedRanges);
        boolean onlyExplicitlyDefined = module2.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getREPORT_ONLY_EXPLICITLY_DEFINED_DEBUG_INFO());
        for (ActualDiagnostic debugAnnotation : debugAnnotations) {
            DiagnosticFactory<?> factory2 = debugAnnotation.getDiagnostic().getFactory();
            if (!this.getDiagnosticsService().shouldRenderDiagnostic(module2, factory2.getName(), factory2.getSeverity())) continue;
            if (onlyExplicitlyDefined) {
                boolean bl;
                block9: {
                    Iterable $this$any$iv = debugAnnotation.getDiagnostic().getTextRanges();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            TextRange it = (TextRange)element$iv;
                            boolean bl4 = false;
                            Map map = diagnosedRanges;
                            object = new IntRange(it.getStartOffset(), it.getEndOffset());
                            boolean bl5 = false;
                            Map map2 = map;
                            boolean bl6 = false;
                            if (!map2.containsKey(object)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
            }
            this.reporter.reportDiagnostic(debugAnnotation.getDiagnostic(), module2, file2, configuration2, withNewInferenceModeEnabled);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

