/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CommonSMAPTestUtil;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumperImpl;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directivesContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectivesContainers", "()Ljava/util/List;", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumperImpl;", "isSeparateCompilation", "", "processAfterAllModules", "", "someAssertionWasFailed", "processModule", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "separateDumpsEnabled", "Companion", "tests-common-new"})
public final class SMAPDumpHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MultiModuleInfoDumperImpl dumper;
    @NotNull
    public static final String SMAP_EXT = "smap";
    @NotNull
    public static final String SMAP_SEP_EXT = "smap-separate-compilation";
    @NotNull
    public static final String SMAP_NON_SEP_EXT = "smap-nonseparate-compilation";

    public SMAPDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, 2, null);
        this.dumper = new MultiModuleInfoDumperImpl(null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectivesContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module2, @NotNull BinaryArtifacts.Jvm info) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$groupByTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Iterable $this$sortedBy$iv;
        void $this$mapNotNullTo$iv$iv322;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (!module2.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_SMAP())) {
            return;
        }
        Iterable $this$map$iv3 = module2.getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv3;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            TestFile testFile = (TestFile)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.getName();
            object2.add(object);
        }
        List originalFileNames = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = CommonSMAPTestUtil.INSTANCE.extractSMAPFromClasses(ClassFileUtilsKt.getClassFiles(info.getClassFileFactory()));
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv322;
        boolean $i$f$forEach = false;
        Pair bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            CommonSMAPTestUtil.SMAPAndFile it = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            boolean bl3 = false;
            String name2 = StringsKt.removePrefix((String)it.getSourceFile(), (CharSequence)"/");
            int index2 = originalFileNames.indexOf(name2);
            TestFile testFile = module2.getFiles().get(index2);
            if ((testFile.getDirectives().contains(CodegenTestDirectives.INSTANCE.getNO_SMAP_DUMP()) ? null : TuplesKt.to((Object)index2, (Object)it)) == null) continue;
            pair = pair;
            boolean bl4 = false;
            boolean bl5 = false;
            Pair it$iv$iv = pair;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        boolean $this$mapNotNullTo$iv$iv322 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = (Integer)it.getFirst();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = (Integer)it.getFirst();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$map2 = false;
        void $this$mapNotNullTo$iv$iv322 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            bl = (Pair)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl7 = false;
            object = (CommonSMAPTestUtil.SMAPAndFile)it.getSecond();
            object2.add(object);
        }
        List compiledSmaps = (List)destination$iv$iv2;
        CommonSMAPTestUtil.INSTANCE.checkNoConflictMappings(compiledSmaps, this.getAssertions());
        Object $this$groupBy$iv = compiledSmaps;
        boolean $i$f$groupBy = false;
        destination$iv$iv2 = $this$groupBy$iv;
        Object destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            CommonSMAPTestUtil.SMAPAndFile it = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv;
            boolean bl8 = false;
            String key$iv$iv = it.getSourceFile();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl9 = false;
                List answer$iv$iv$iv22 = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv22);
                object3 = answer$iv$iv$iv22;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo3 = false;
        Iterator item$iv$iv = $this$mapTo$iv$iv;
        boolean element$iv$iv = false;
        Iterator list$iv$iv = item$iv$iv.entrySet().iterator();
        while (list$iv$iv.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv2;
            void it;
            Map.Entry item$iv$iv2;
            Map.Entry key$iv$iv = item$iv$iv2 = list$iv$iv.next();
            object2 = destination$iv$iv3;
            boolean bl10 = false;
            Iterable $this$sortedByDescending$iv = (Iterable)it.getValue();
            boolean $i$f$sortedByDescending = false;
            boolean answer$iv$iv$iv22 = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    CommonSMAPTestUtil.SMAPAndFile p0 = (CommonSMAPTestUtil.SMAPAndFile)b;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)p0.getOutputFile());
                    p0 = (CommonSMAPTestUtil.SMAPAndFile)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string2 = p0.getOutputFile();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            });
            boolean $i$f$mapNotNull2 = false;
            void answer$iv$iv$iv22 = $this$mapNotNull$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                String string2;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl11 = false;
                CommonSMAPTestUtil.SMAPAndFile p0 = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv2;
                boolean bl12 = false;
                if (p0.getSmap() == null) continue;
                boolean bl13 = false;
                boolean bl14 = false;
                String it$iv$iv = string2;
                boolean bl15 = false;
                destination$iv$iv4.add(it$iv$iv);
            }
            String smap = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv4), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            CharSequence charSequence = smap;
            boolean bl16 = false;
            object = new CommonSMAPTestUtil.SMAPAndFile(charSequence.length() > 0 ? smap : null, (String)it.getKey(), "NOT_SORTED");
            object2.add(object);
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associateBy$iv;
        Map destination$iv$iv5 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv3 : $this$associateByTo$iv$iv) {
            void it;
            CommonSMAPTestUtil.SMAPAndFile item$iv$iv2 = (CommonSMAPTestUtil.SMAPAndFile)element$iv$iv3;
            object2 = destination$iv$iv5;
            boolean bl17 = false;
            object = it.getSourceFile();
            object2.put(object, element$iv$iv3);
        }
        Map compiledData = destination$iv$iv5;
        StringBuilder stringBuilder2 = this.dumper.builderForModule(module2);
        boolean bl18 = false;
        boolean bl19 = false;
        StringBuilder $this$processModule_u24lambda_u2d8 = stringBuilder2;
        boolean bl20 = false;
        for (CommonSMAPTestUtil.SMAPAndFile source : compiledData.values()) {
            StringBuilder stringBuilder3 = $this$processModule_u24lambda_u2d8;
            String string3 = Intrinsics.stringPlus((String)"// FILE: ", (Object)StringsKt.removePrefix((String)source.getSourceFile(), (CharSequence)"/"));
            boolean bl21 = false;
            StringBuilder stringBuilder4 = stringBuilder3.append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4;
            boolean bl22 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            stringBuilder3 = $this$processModule_u24lambda_u2d8;
            string3 = source.getSmap();
            string3 = string3 == null ? "" : string3;
            bl21 = false;
            StringBuilder stringBuilder6 = stringBuilder3.append(string3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            stringBuilder5 = stringBuilder6;
            bl22 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.dumper.isEmpty()) {
            return;
        }
        boolean separateDumpEnabled = this.separateDumpsEnabled();
        boolean isSeparateCompilation = this.isSeparateCompilation();
        String extension = !separateDumpEnabled ? SMAP_EXT : (isSeparateCompilation ? SMAP_SEP_EXT : SMAP_NON_SEP_EXT);
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File expectedFile = FileUtilsKt.withExtension(testDataFile, extension);
        Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, this.dumper.generateResultingDump(), null, 4, null);
        if (separateDumpEnabled && isSeparateCompilation) {
            String otherExtension = isSeparateCompilation ? SMAP_NON_SEP_EXT : SMAP_SEP_EXT;
            File otherFile = FileUtilsKt.withExtension(expectedFile, otherExtension);
            if (!otherFile.exists()) {
                return;
            }
            String expectedText = FilesKt.readText$default((File)expectedFile, null, (int)1, null);
            if (Intrinsics.areEqual((Object)expectedText, (Object)FilesKt.readText$default((File)otherFile, null, (int)1, null))) {
                File smapFile = FileUtilsKt.withExtension(expectedFile, SMAP_EXT);
                FilesKt.writeText$default((File)smapFile, (String)expectedText, null, (int)2, null);
                expectedFile.delete();
                otherFile.delete();
                this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(expectedFile, otherFile, smapFile, testDataFile){
                    final /* synthetic */ File $expectedFile;
                    final /* synthetic */ File $otherFile;
                    final /* synthetic */ File $smapFile;
                    final /* synthetic */ File $testDataFile;
                    {
                        this.$expectedFile = $expectedFile;
                        this.$otherFile = $otherFile;
                        this.$smapFile = $smapFile;
                        this.$testDataFile = $testDataFile;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return StringsKt.trimIndent((String)("\n                    Contents of " + this.$expectedFile.getName() + " and " + this.$otherFile.getName() + " are equals, so they are deleted\n                     and joined to " + this.$smapFile.getName() + ". Please remove " + CodegenTestDirectives.INSTANCE.getSEPARATE_SMAP_DUMPS() + " directive from\n                     " + this.$testDataFile.getName() + " and rerun test\n                    "));
                    }
                }));
                throw null;
            }
        }
    }

    private final boolean isSeparateCompilation() {
        return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules().size() > 1;
    }

    private final boolean separateDumpsEnabled() {
        return TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getSEPARATE_SMAP_DUMPS());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SMAPDumpHandler$Companion;", "", "()V", "SMAP_EXT", "", "SMAP_NON_SEP_EXT", "SMAP_SEP_EXT", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

