/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public final class InTextDirectivesUtils {
    private static final String DIRECTIVES_FILE_NAME = "directives.txt";
    public static final String IGNORE_BACKEND_DIRECTIVE_PREFIX = "// IGNORE_BACKEND: ";

    private InTextDirectivesUtils() {
    }

    @Nullable
    public static Integer getPrefixedInt(@NotNull String fileText, @NotNull String prefix) {
        String[] strings2;
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(1);
        }
        if ((strings2 = InTextDirectivesUtils.findArrayWithPrefixes(fileText, prefix)).length > 0) {
            assert (strings2.length == 1);
            return Integer.parseInt(strings2[0]);
        }
        return null;
    }

    @Nullable
    public static Boolean getPrefixedBoolean(@NotNull String fileText, @NotNull String prefix) {
        String[] strings2;
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(2);
        }
        if (prefix == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(3);
        }
        if ((strings2 = InTextDirectivesUtils.findArrayWithPrefixes(fileText, prefix)).length > 0) {
            assert (strings2.length == 1);
            return Boolean.parseBoolean(strings2[0]);
        }
        return null;
    }

    @NotNull
    public static String[] findArrayWithPrefixes(@NotNull String fileText, String ... prefixes) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(4);
        }
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(5);
        }
        String[] stringArray = ArrayUtil.toStringArray(InTextDirectivesUtils.findListWithPrefixes(fileText, prefixes));
        if (stringArray == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @NotNull
    public static List<String> findListWithPrefixes(@NotNull String fileText, String ... prefixes) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(7);
        }
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(8);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String line : InTextDirectivesUtils.findLinesWithPrefixesRemoved(fileText, prefixes)) {
            InTextDirectivesUtils.splitValues(result2, line);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static List<String> splitValues(@NotNull List<String> result2, @NotNull String line) {
        String unquoted;
        if (result2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(10);
        }
        if (line == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(11);
        }
        if (!(unquoted = StringUtil.unquoteString((String)line)).equals(line)) {
            result2.add(unquoted);
        } else {
            String[] variants;
            for (String variant : variants = line.split(",")) {
                result2.add(variant.trim());
            }
        }
        return result2;
    }

    public static boolean isDirectiveDefined(@NotNull String fileText, @NotNull String directive2) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(12);
        }
        if (directive2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(13);
        }
        return !InTextDirectivesUtils.findListWithPrefixes(fileText, directive2).isEmpty();
    }

    @Nullable
    public static String findStringWithPrefixes(@NotNull String fileText, String ... prefixes) {
        List<String> strings2;
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(14);
        }
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(15);
        }
        if ((strings2 = InTextDirectivesUtils.findListWithPrefixes(fileText, prefixes)).isEmpty()) {
            return null;
        }
        if (strings2.size() != 1) {
            throw new IllegalStateException("There is more than one string with given prefixes " + Arrays.toString(prefixes) + ":\n" + StringUtil.join(strings2, (String)"\n") + "\nUse findListWithPrefixes() instead.");
        }
        return strings2.get(0);
    }

    @NotNull
    public static List<String> findLinesWithPrefixesRemoved(@NotNull String fileText, String ... prefixes) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(16);
        }
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(17);
        }
        return InTextDirectivesUtils.findLinesWithPrefixesRemoved(fileText, true, true, prefixes);
    }

    @NotNull
    public static List<String> findLinesWithPrefixesRemoved(@NotNull String fileText, boolean trim, boolean strict, String ... prefixes) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(18);
        }
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(19);
        }
        if (prefixes.length == 0) {
            throw new IllegalArgumentException("Please specify the prefixes to check");
        }
        ArrayList<String> result2 = new ArrayList<String>();
        List<String> cleanedPrefixes = InTextDirectivesUtils.cleanDirectivesFromComments(Arrays.asList(prefixes));
        block0: for (String line : InTextDirectivesUtils.fileNonEmptyCommentedLines(fileText)) {
            for (String prefix : cleanedPrefixes) {
                if (!line.startsWith(prefix)) continue;
                String noPrefixLine = line.substring(prefix.length());
                if (noPrefixLine.isEmpty() || Character.isWhitespace(noPrefixLine.charAt(0)) || Character.isWhitespace(prefix.charAt(prefix.length() - 1))) {
                    result2.add(trim ? noPrefixLine.trim() : StringUtil.trimTrailing((String)StringsKt.drop((String)noPrefixLine, (int)1)));
                    continue block0;
                }
                if (strict) {
                    throw new AssertionError((Object)("Line starts with prefix \"" + prefix + "\", but doesn't have space symbol after it: " + line));
                }
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    public static void assertHasUnknownPrefixes(@NotNull String fileText, @NotNull Collection<String> knownPrefixes) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(21);
        }
        if (knownPrefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(22);
        }
        HashSet<String> prefixes = new HashSet<String>();
        for (String line : InTextDirectivesUtils.fileNonEmptyCommentedLines(fileText)) {
            String prefix = InTextDirectivesUtils.probableDirective(line);
            if (prefix == null) continue;
            prefixes.add(prefix);
        }
        prefixes.removeAll(InTextDirectivesUtils.cleanDirectivesFromComments(knownPrefixes));
        KtAssert.assertTrue("File contains some unexpected directives" + prefixes, prefixes.isEmpty());
    }

    private static String probableDirective(@NotNull String line) {
        String[] arr;
        String firstWord;
        if (line == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(23);
        }
        if ((firstWord = (arr = line.split(" ", 2))[0]).length() > 1 && StringUtil.toUpperCase((String)firstWord).equals(firstWord)) {
            return firstWord;
        }
        return null;
    }

    private static List<String> cleanDirectivesFromComments(@NotNull Collection<String> prefixes) {
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(24);
        }
        ArrayList resultPrefixes = Lists.newArrayList();
        for (String prefix : prefixes) {
            if (prefix.startsWith("//") || prefix.startsWith("##")) {
                resultPrefixes.add(StringUtil.trimLeading((String)prefix.substring(2)));
                continue;
            }
            resultPrefixes.add(prefix);
        }
        return resultPrefixes;
    }

    @NotNull
    private static List<String> fileNonEmptyCommentedLines(@NotNull String fileText) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(25);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(fileText));){
            String line;
            while ((line = reader.readLine()) != null) {
                String uncommentedLine;
                if (!(line = line.trim()).startsWith("//") && !line.startsWith("##") || (uncommentedLine = line.substring(2).trim()).isEmpty()) continue;
                result2.add(uncommentedLine);
            }
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow(e);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private static String textWithDirectives(@NotNull File file2) {
        if (file2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(27);
        }
        try {
            String fileText;
            if (file2.isDirectory()) {
                File directivesFile = new File(file2, DIRECTIVES_FILE_NAME);
                if (!directivesFile.exists()) {
                    return "";
                }
                fileText = FileUtil.loadFile((File)directivesFile);
            } else {
                fileText = FileUtil.loadFile((File)file2);
            }
            return fileText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCompatibleTarget(@NotNull TargetBackend targetBackend, @NotNull File file2) {
        if (targetBackend == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(28);
        }
        if (file2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(29);
        }
        if (targetBackend == TargetBackend.ANY) {
            return true;
        }
        List<String> doNotTarget = InTextDirectivesUtils.findLinesWithPrefixesRemoved(InTextDirectivesUtils.textWithDirectives(file2), "// DONT_TARGET_EXACT_BACKEND: ");
        if ((doNotTarget = doNotTarget.stream().flatMap(s -> Arrays.stream(s.split(" "))).collect(Collectors.toList())).contains(targetBackend.name())) {
            return false;
        }
        List<String> backends = InTextDirectivesUtils.findLinesWithPrefixesRemoved(InTextDirectivesUtils.textWithDirectives(file2), "// TARGET_BACKEND: ");
        return InTextDirectivesUtils.isCompatibleTargetExceptAny(targetBackend, backends);
    }

    private static boolean isCompatibleTargetExceptAny(@NotNull TargetBackend targetBackend, @NotNull List<String> backends) {
        if (targetBackend == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(30);
        }
        if (backends == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(31);
        }
        if (targetBackend == TargetBackend.ANY) {
            return false;
        }
        return backends.isEmpty() || backends.contains(targetBackend.name()) || InTextDirectivesUtils.isCompatibleTargetExceptAny(targetBackend.getCompatibleWith(), backends);
    }

    public static boolean isIgnoredTarget(@NotNull TargetBackend targetBackend, @NotNull File file2, @NotNull String ignoreBackendDirectivePrefix) {
        if (targetBackend == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(32);
        }
        if (file2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(33);
        }
        if (ignoreBackendDirectivePrefix == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(34);
        }
        List<String> ignoredBackends = InTextDirectivesUtils.findListWithPrefixes(InTextDirectivesUtils.textWithDirectives(file2), ignoreBackendDirectivePrefix);
        return ignoredBackends.contains(targetBackend.name());
    }

    public static boolean isIgnoredTarget(@NotNull TargetBackend targetBackend, @NotNull File file2) {
        if (targetBackend == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(35);
        }
        if (file2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(36);
        }
        return InTextDirectivesUtils.isIgnoredTarget(targetBackend, file2, IGNORE_BACKEND_DIRECTIVE_PREFIX);
    }

    public static boolean dontRunGeneratedCode(@NotNull TargetBackend targetBackend, @NotNull File file2) {
        if (targetBackend == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(38);
        }
        List<String> backends = InTextDirectivesUtils.findListWithPrefixes(InTextDirectivesUtils.textWithDirectives(file2), "// DONT_RUN_GENERATED_CODE: ");
        return backends.contains(targetBackend.name());
    }

    public static boolean isPassingTarget(@NotNull TargetBackend targetBackend, @NotNull File file2) {
        if (targetBackend == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(39);
        }
        if (file2 == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(40);
        }
        return InTextDirectivesUtils.isCompatibleTarget(targetBackend, file2) && !InTextDirectivesUtils.isIgnoredTarget(targetBackend, file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 20: 
            case 26: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 20: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 6: 
            case 9: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/InTextDirectivesUtils";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directive";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownPrefixes";
                break;
            }
            case 27: 
            case 29: 
            case 33: 
            case 36: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBackend";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backends";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreBackendDirectivePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/InTextDirectivesUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findArrayWithPrefixes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findListWithPrefixes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findLinesWithPrefixesRemoved";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "fileNonEmptyCommentedLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixedInt";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixedBoolean";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findArrayWithPrefixes";
                break;
            }
            case 6: 
            case 9: 
            case 20: 
            case 26: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findListWithPrefixes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "splitValues";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectiveDefined";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findStringWithPrefixes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLinesWithPrefixesRemoved";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "assertHasUnknownPrefixes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "probableDirective";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cleanDirectivesFromComments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fileNonEmptyCommentedLines";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "textWithDirectives";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleTarget";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleTargetExceptAny";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredTarget";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "dontRunGeneratedCode";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isPassingTarget";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 9: 
            case 20: 
            case 26: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

