/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorVisitorEmptyBodies;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.Assertions;

public class ExpectedLoadErrorsUtil {
    public static final String ANNOTATION_CLASS_NAME = "org.jetbrains.kotlin.jvm.compiler.annotation.ExpectLoadError";

    public static void checkForLoadErrors(@NotNull PackageViewDescriptor packageFromJava, @NotNull BindingContext bindingContext, @NotNull Assertions assertions) {
        if (packageFromJava == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(1);
        }
        if (assertions == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(2);
        }
        Map<SourceElement, List<String>> expectedErrors = ExpectedLoadErrorsUtil.getExpectedLoadErrors(packageFromJava);
        Map<SourceElement, List<String>> actualErrors = ExpectedLoadErrorsUtil.getActualLoadErrors(bindingContext);
        for (SourceElement source : ContainerUtil.union(expectedErrors.keySet(), actualErrors.keySet())) {
            List<String> actual = actualErrors.get(source);
            List<String> expected = expectedErrors.get(source);
            assertions.assertNotNull(expected, (Function0<String>)((Function0)() -> "Unexpected load error(s):\n" + actual + "\ncontainer:" + source));
            assertions.assertNotNull(actual, (Function0<String>)((Function0)() -> "Missing load error(s):\n" + expected + "\ncontainer:" + source));
            assertions.assertSameElements(actual, expected, (Function0<String>)((Function0)() -> "Unexpected/missing load error(s)\ncontainer:" + source));
        }
    }

    private static Map<SourceElement, List<String>> getExpectedLoadErrors(@NotNull PackageViewDescriptor packageFromJava) {
        if (packageFromJava == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(3);
        }
        final HashMap<SourceElement, List<String>> map = new HashMap<SourceElement, List<String>>();
        packageFromJava.acceptVoid((DeclarationDescriptorVisitor<Void, Void>)new DeclarationDescriptorVisitorEmptyBodies<Void, Void>(){

            @Override
            public Void visitPackageViewDescriptor(PackageViewDescriptor descriptor2, Void data) {
                return this.visitDeclarationRecursively(descriptor2, descriptor2.getMemberScope());
            }

            @Override
            public Void visitClassDescriptor(ClassDescriptor descriptor2, Void data) {
                return this.visitDeclarationRecursively(descriptor2, descriptor2.getDefaultType().getMemberScope());
            }

            @Override
            public Void visitFunctionDescriptor(FunctionDescriptor descriptor2, Void data) {
                return this.visitDeclaration(descriptor2);
            }

            @Override
            public Void visitPropertyDescriptor(PropertyDescriptor descriptor2, Void data) {
                return this.visitDeclaration(descriptor2);
            }

            private Void visitDeclaration(@NotNull DeclarationDescriptor descriptor2) {
                AnnotationDescriptor annotation2;
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((annotation2 = descriptor2.getAnnotations().findAnnotation(new FqName(ExpectedLoadErrorsUtil.ANNOTATION_CLASS_NAME))) == null) {
                    return null;
                }
                ConstantValue<?> argument2 = annotation2.getAllValueArguments().values().iterator().next();
                String error = (String)argument2.getValue();
                List<String> errors = Arrays.asList(error.split("\\|"));
                ExpectedLoadErrorsUtil.putError(map, descriptor2, errors);
                return null;
            }

            private Void visitDeclarationRecursively(@NotNull DeclarationDescriptor descriptor2, @NotNull MemberScope memberScope2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (memberScope2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (DeclarationDescriptor member2 : DescriptorUtils.getAllDescriptors(memberScope2)) {
                    member2.acceptVoid(this);
                }
                return this.visitDeclaration(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "memberScope";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/jvm/compiler/ExpectedLoadErrorsUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclaration";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDeclarationRecursively";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return map;
    }

    private static Map<SourceElement, List<String>> getActualLoadErrors(@NotNull BindingContext bindingContext) {
        if (bindingContext == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(4);
        }
        HashMap<SourceElement, List<String>> result2 = new HashMap<SourceElement, List<String>>();
        Collection<DeclarationDescriptor> descriptors = bindingContext.getKeys(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS);
        for (DeclarationDescriptor descriptor2 : descriptors) {
            List<String> errors = bindingContext.get(JvmBindingContextSlices.LOAD_FROM_JAVA_SIGNATURE_ERRORS, descriptor2);
            if (errors == null) continue;
            ExpectedLoadErrorsUtil.putError(result2, descriptor2, errors);
        }
        return result2;
    }

    private static void putError(@NotNull Map<SourceElement, List<String>> result2, @NotNull DeclarationDescriptor descriptor2, @NotNull List<String> errors) {
        if (result2 == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(6);
        }
        if (errors == null) {
            ExpectedLoadErrorsUtil.$$$reportNull$$$0(7);
        }
        assert (descriptor2.getOriginal() instanceof DeclarationDescriptorWithSource) : "Signature errors should be reported only on declarations with source, but " + descriptor2 + " found";
        result2.put(((DeclarationDescriptorWithSource)descriptor2.getOriginal()).getSource(), errors);
    }

    private ExpectedLoadErrorsUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFromJava";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/jvm/compiler/ExpectedLoadErrorsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForLoadErrors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpectedLoadErrors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getActualLoadErrors";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "putError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

