/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.CustomInstruction;
import org.jetbrains.kotlin.ir.interpreter.DefaultCallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterTimeOutError;
import org.jetbrains.kotlin.ir.interpreter.proxy.CommonProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bB%\b\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB#\b\u0002\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010\"\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020!2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\u00020!2\n\u0010&\u001a\u0006\u0012\u0002\b\u000308H\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020!2\u0006\u0010=\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020!2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020!2\u0006\u0010=\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020HH\u0002J\u0010\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020NH\u0002J\u0010\u0010O\u001a\u00020!2\u0006\u0010&\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u00020!2\u0006\u0010R\u001a\u00020SH\u0002J\u0010\u0010T\u001a\u00020!2\u0006\u0010&\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020!2\u0006\u0010&\u001a\u00020WH\u0002J\u0010\u0010X\u001a\u00020!2\u0006\u0010&\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020!2\u0006\u00102\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020!2\u0006\u0010]\u001a\u00020^H\u0002J\u0010\u0010_\u001a\u00020!2\u0006\u0010&\u001a\u00020`H\u0002J\u0010\u0010a\u001a\u00020!2\u0006\u0010&\u001a\u00020bH\u0002J\u0010\u0010c\u001a\u00020!2\u0006\u0010&\u001a\u00020dH\u0002J\u0010\u0010e\u001a\u00020!2\u0006\u0010&\u001a\u00020fH\u0002J\u0010\u0010g\u001a\u00020!2\u0006\u0010#\u001a\u00020hH\u0002J\u0010\u0010i\u001a\u00020!2\u0006\u0010&\u001a\u00020jH\u0002J\u0010\u0010k\u001a\u00020!2\u0006\u0010l\u001a\u00020mH\u0002J\u0010\u0010n\u001a\u00020!2\u0006\u0010&\u001a\u00020oH\u0002J\u0010\u0010p\u001a\u00020!2\u0006\u0010B\u001a\u00020qH\u0002J0\u0010r\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\u0019\u0010s\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010t\u00a2\u0006\u0002\buH\u0000\u00a2\u0006\u0002\bvJ\f\u0010w\u001a\u00020!*\u00020xH\u0002J\f\u0010y\u001a\u00020!*\u00020zH\u0002R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006{"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Ljava/util/Map;)V", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;Ljava/util/Map;)V", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "(Ljava/util/Map;Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;)V", "getBodyMap$ir_interpreter", "()Ljava/util/Map;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "commandCount", "", "getEnvironment$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "getUnitState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "incrementAndCheckCommands", "", "interpret", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "interpretBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "interpretBody", "body", "interpretBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "interpretCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "interpretClassReference", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "interpretConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "interpretConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "interpretConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interpretDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "interpretDoWhile", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "interpretEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "interpretEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interpretField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "interpretFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "interpretFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "interpretFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "interpretGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "interpretGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interpretGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interpretInstanceInitializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "interpretPropertyReference", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "interpretReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "interpretSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "interpretStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "interpretThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "interpretTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "interpretTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "interpretValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "interpretVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "interpretWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "withNewCallStack", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withNewCallStack$ir_interpreter", "handle", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "tryResetFunctionBody", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.interpreter"})
public final class IrInterpreter {
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final CallInterceptor callInterceptor;
    private int commandCount;

    private IrInterpreter(Map<IdSignature, ? extends IrBody> bodyMap, IrInterpreterEnvironment environment) {
        this.bodyMap = bodyMap;
        this.environment = environment;
        this.callInterceptor = new DefaultCallInterceptor(this);
    }

    @NotNull
    public final Map<IdSignature, IrBody> getBodyMap$ir_interpreter() {
        return this.bodyMap;
    }

    @NotNull
    public final IrInterpreterEnvironment getEnvironment$ir_interpreter() {
        return this.environment;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.environment.getIrBuiltIns();
    }

    private final CallStack getCallStack() {
        return this.environment.getCallStack();
    }

    public IrInterpreter(@NotNull IrBuiltIns irBuiltIns, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
        Intrinsics.checkNotNullParameter(bodyMap, (String)"bodyMap");
        this(bodyMap, new IrInterpreterEnvironment(irBuiltIns, new CallStack()));
    }

    public /* synthetic */ IrInterpreter(IrBuiltIns irBuiltIns, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irBuiltIns, (Map<IdSignature, ? extends IrBody>)map);
    }

    private IrInterpreter(IrInterpreterEnvironment environment, Map<IdSignature, ? extends IrBody> bodyMap) {
        this(bodyMap, environment);
    }

    /* synthetic */ IrInterpreter(IrInterpreterEnvironment irInterpreterEnvironment, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        this(irInterpreterEnvironment, (Map<IdSignature, ? extends IrBody>)map);
    }

    public IrInterpreter(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        this(MapsKt.emptyMap(), new IrInterpreterEnvironment(irModule));
    }

    private final void incrementAndCheckCommands() {
        IrInterpreter irInterpreter = this;
        int n = irInterpreter.commandCount;
        irInterpreter.commandCount = n + 1;
        if (this.commandCount >= 1000000) {
            UtilsKt.handleUserException(new InterpreterTimeOutError(), this.environment);
        }
    }

    private final State getUnitState() {
        Complex complex = this.environment.getMapOfObjects().get(this.getIrBuiltIns().getUnitClass());
        Intrinsics.checkNotNull((Object)complex);
        return complex;
    }

    private final void handle(Instruction $this$handle) {
        Instruction instruction = $this$handle;
        if (instruction instanceof CompoundInstruction) {
            InstructionsUnfolderKt.unfoldInstruction($this$handle.getElement(), this.environment);
        } else if (instruction instanceof SimpleInstruction) {
            this.interpret(((SimpleInstruction)$this$handle).getElement());
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            this.incrementAndCheckCommands();
        } else if (instruction instanceof CustomInstruction) {
            ((CustomInstruction)$this$handle).getEvaluate().invoke();
        }
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression2, @Nullable IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.commandCount = 0;
        this.getCallStack().newFrame(expression2, file2);
        this.getCallStack().addInstruction(new CompoundInstruction(expression2));
        while (!this.getCallStack().hasNoInstructions()) {
            this.handle(this.getCallStack().popInstruction());
        }
        IrExpression irExpression = UtilsKt.toIrExpression(this.getCallStack().popState(), expression2);
        boolean bl = false;
        boolean bl2 = false;
        IrExpression $this$interpret_u24lambda_u2d1 = irExpression;
        boolean bl3 = false;
        this.getCallStack().dropFrame();
        return irExpression;
    }

    public static /* synthetic */ IrExpression interpret$default(IrInterpreter irInterpreter, IrExpression irExpression, IrFile irFile, int n, Object object) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        return irInterpreter.interpret(irExpression, irFile);
    }

    @NotNull
    public final State withNewCallStack$ir_interpreter(@NotNull IrCall call2, @NotNull Function1<? super IrInterpreter, ? extends Object> init2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        IrInterpreter irInterpreter = new IrInterpreter(this.environment.copyWithNewCallStack(), this.bodyMap);
        boolean bl = false;
        boolean bl2 = false;
        IrInterpreter $this$withNewCallStack_u24lambda_u2d3 = irInterpreter;
        boolean bl3 = false;
        $this$withNewCallStack_u24lambda_u2d3.getCallStack().newFrame(call2.getSymbol().getOwner());
        $this$withNewCallStack_u24lambda_u2d3.getCallStack().newSubFrame(call2);
        init2.invoke((Object)$this$withNewCallStack_u24lambda_u2d3);
        while (!$this$withNewCallStack_u24lambda_u2d3.getCallStack().hasNoInstructions()) {
            $this$withNewCallStack_u24lambda_u2d3.handle($this$withNewCallStack_u24lambda_u2d3.getCallStack().popInstruction());
            $this$withNewCallStack_u24lambda_u2d3.incrementAndCheckCommands();
        }
        State state = $this$withNewCallStack_u24lambda_u2d3.getCallStack().popState();
        boolean bl4 = false;
        boolean bl5 = false;
        State $this$withNewCallStack_u24lambda_u2d3_u24lambda_u2d2 = state;
        boolean bl6 = false;
        $this$withNewCallStack_u24lambda_u2d3.getCallStack().dropFrame();
        return state;
    }

    private final void interpret(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrSimpleFunction) {
            this.interpretFunction((IrSimpleFunction)element);
        } else if (irElement instanceof IrConstructor) {
            this.interpretConstructor((IrConstructor)element);
        } else if (irElement instanceof IrCall) {
            this.interpretCall((IrCall)element);
        } else if (irElement instanceof IrConstructorCall) {
            this.interpretConstructorCall((IrFunctionAccessExpression)element);
        } else if (irElement instanceof IrEnumConstructorCall) {
            this.interpretEnumConstructorCall((IrEnumConstructorCall)element);
        } else if (irElement instanceof IrDelegatingConstructorCall) {
            this.interpretDelegatingConstructorCall((IrDelegatingConstructorCall)element);
        } else if (irElement instanceof IrValueParameter) {
            this.interpretValueParameter((IrValueParameter)element);
        } else if (irElement instanceof IrInstanceInitializerCall) {
            this.interpretInstanceInitializerCall((IrInstanceInitializerCall)element);
        } else if (irElement instanceof IrField) {
            this.interpretField((IrField)element);
        } else if (irElement instanceof IrBody) {
            this.interpretBody((IrBody)element);
        } else if (irElement instanceof IrBlock) {
            this.interpretBlock((IrBlock)element);
        } else if (irElement instanceof IrReturn) {
            this.interpretReturn((IrReturn)element);
        } else if (irElement instanceof IrSetField) {
            this.interpretSetField((IrSetField)element);
        } else if (irElement instanceof IrGetField) {
            this.interpretGetField((IrGetField)element);
        } else if (irElement instanceof IrGetObjectValue) {
            this.interpretGetObjectValue((IrGetObjectValue)element);
        } else if (irElement instanceof IrGetEnumValue) {
            this.interpretGetEnumValue((IrGetEnumValue)element);
        } else if (irElement instanceof IrEnumEntry) {
            this.interpretEnumEntry((IrEnumEntry)element);
        } else if (irElement instanceof IrConst) {
            this.interpretConst((IrConst)element);
        } else if (irElement instanceof IrVariable) {
            this.getCallStack().addVariable(new Variable(((IrVariable)element).getSymbol(), this.getCallStack().popState()));
        } else if (irElement instanceof IrSetValue) {
            this.getCallStack().setState(((IrSetValue)element).getSymbol(), this.getCallStack().popState());
        } else if (irElement instanceof IrTypeOperatorCall) {
            this.interpretTypeOperatorCall((IrTypeOperatorCall)element);
        } else if (irElement instanceof IrBranch) {
            this.interpretBranch((IrBranch)element);
        } else if (irElement instanceof IrWhileLoop) {
            this.interpretWhile((IrWhileLoop)element);
        } else if (irElement instanceof IrDoWhileLoop) {
            this.interpretDoWhile((IrDoWhileLoop)element);
        } else if (irElement instanceof IrWhen) {
            this.getCallStack().dropSubFrame();
        } else if (irElement instanceof IrVararg) {
            this.interpretVararg((IrVararg)element);
        } else if (irElement instanceof IrTry) {
            this.interpretTry((IrTry)element);
        } else if (irElement instanceof IrThrow) {
            this.interpretThrow((IrThrow)element);
        } else if (irElement instanceof IrStringConcatenation) {
            this.interpretStringConcatenation((IrStringConcatenation)element);
        } else if (irElement instanceof IrFunctionExpression) {
            this.interpretFunctionExpression((IrFunctionExpression)element);
        } else if (irElement instanceof IrFunctionReference) {
            this.interpretFunctionReference((IrFunctionReference)element);
        } else if (irElement instanceof IrPropertyReference) {
            this.interpretPropertyReference((IrPropertyReference)element);
        } else if (irElement instanceof IrClassReference) {
            this.interpretClassReference((IrClassReference)element);
        } else {
            String string2 = element.getClass() + " not supported for interpretation";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }
    }

    private final void tryResetFunctionBody(IrFunction $this$tryResetFunctionBody) {
        IdSignature idSignature = $this$tryResetFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return;
        }
        IdSignature signature2 = idSignature;
        if (this.bodyMap.get(signature2) != null) {
            $this$tryResetFunctionBody.setBody(null);
        }
    }

    private final void interpretFunction(IrSimpleFunction function2) {
        this.tryResetFunctionBody(function2);
        if (UtilsKt.checkCast(function2, this.environment)) {
            this.getCallStack().dropFrameAndCopyResult();
        }
    }

    private final void interpretValueParameter(IrValueParameter valueParameter2) {
        State state;
        IrFunction irFunction2 = (IrFunction)valueParameter2.getParent();
        State result2 = this.getCallStack().popState();
        if (StateKt.isNull(result2) && AdditionalIrUtilsKt.isVararg(valueParameter2)) {
            boolean bl = false;
            state = UtilsKt.toPrimitiveStateArray(CollectionsKt.emptyList(), ((Primitive)result2).getType());
        } else {
            state = result2;
        }
        State state2 = state;
        State state3 = StateKt.checkNullability(state2, valueParameter2.getType(), this.environment, (Function0<? extends Throwable>)((Function0)new Function0<Throwable>(irFunction2, valueParameter2){
            final /* synthetic */ IrFunction $irFunction;
            final /* synthetic */ IrValueParameter $valueParameter;
            {
                this.$irFunction = $irFunction;
                this.$valueParameter = $valueParameter;
                super(0);
            }

            @NotNull
            public final Throwable invoke() {
                if (IrInterpreter.access$interpretValueParameter$isReceiver(this.$irFunction, this.$valueParameter)) {
                    return new NullPointerException();
                }
                String method = UtilsKt.getCapitalizedFileName(this.$irFunction) + '.' + IrUtilsKt.getFqNameWhenAvailable(this.$irFunction);
                Name parameter = this.$valueParameter.getName();
                return new IllegalArgumentException("Parameter specified as non-null is null: method " + method + ", parameter " + parameter);
            }
        }));
        if (state3 == null) {
            return;
        }
        this.getCallStack().addVariable(new Variable(valueParameter2.getSymbol(), state2));
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretCall(IrCall call2) {
        void $this$filterTo$iv$iv;
        Object element$iv;
        Iterator it;
        State $this$mapTo$iv$iv322;
        State state;
        State state2;
        Object it22;
        boolean bl;
        IrValueParameterSymbol irValueParameterSymbol;
        State state3;
        IrSimpleFunction owner = (IrSimpleFunction)call2.getSymbol().getOwner();
        State dispatchReceiver = null;
        IrValueParameterSymbol irValueParameterSymbol2 = UtilsKt.getDispatchReceiver(owner);
        if (irValueParameterSymbol2 == null) {
            state3 = null;
        } else {
            irValueParameterSymbol = irValueParameterSymbol2;
            boolean bl2 = false;
            bl = false;
            it22 = irValueParameterSymbol;
            boolean bl3 = false;
            state3 = state2 = this.getCallStack().getState((IrSymbol)it22);
        }
        dispatchReceiver = state3;
        irValueParameterSymbol = UtilsKt.getExtensionReceiver(owner);
        if (irValueParameterSymbol == null) {
            state = null;
        } else {
            IrValueParameterSymbol irValueParameterSymbol3 = irValueParameterSymbol;
            bl = false;
            boolean it22 = false;
            IrValueParameterSymbol it3 = irValueParameterSymbol3;
            boolean bl4 = false;
            state = this.getCallStack().getState(it3);
        }
        State extensionReceiver = state;
        Iterable $this$map$iv = owner.getValueParameters();
        boolean $i$f$map22 = false;
        it22 = $this$map$iv;
        Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv322.iterator();
        while (iterator2.hasNext()) {
            void it4;
            Object item$iv$iv = iterator2.next();
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            state2 = this.getCallStack().getState(it4.getSymbol());
            collection.add(state2);
        }
        List valueArguments = (List)((Object)destination$iv$iv);
        $this$mapTo$iv$iv322 = dispatchReceiver;
        IrDeclarationParent $i$f$map22 = $this$mapTo$iv$iv322 == null ? null : $this$mapTo$iv$iv322.getIrFunctionByIrCall(call2);
        IrFunction irFunction2 = $i$f$map22 == null ? call2.getSymbol().getOwner() : $i$f$map22;
        $i$f$map22 = irFunction2.getParent();
        destination$iv$iv = dispatchReceiver;
        State state4 = $this$mapTo$iv$iv322 = destination$iv$iv instanceof Complex ? (Complex)((Object)destination$iv$iv) : null;
        dispatchReceiver = Intrinsics.areEqual((Object)$i$f$map22, $this$mapTo$iv$iv322 == null ? null : ((destination$iv$iv = $this$mapTo$iv$iv322.getSuperWrapperClass()) == null ? null : ((Wrapper)((Object)destination$iv$iv)).getIrClass())) ? (State)((Complex)dispatchReceiver).getSuperWrapperClass() : dispatchReceiver;
        this.getCallStack().dropSubFrame();
        this.getCallStack().newFrame(irFunction2);
        this.getCallStack().addInstruction(new SimpleInstruction(irFunction2));
        this.getCallStack().addVariable(new Variable(irFunction2.getSymbol(), new KTypeState(call2.getType(), (IrClass)this.getIrBuiltIns().getAnyClass().getOwner())));
        boolean $this$mapTo$iv$iv322 = false;
        List args = new ArrayList();
        IrValueParameterSymbol $this$mapTo$iv$iv322 = UtilsKt.getDispatchReceiver(irFunction2);
        if ($this$mapTo$iv$iv322 != null) {
            destination$iv$iv = $this$mapTo$iv$iv322;
            $i$f$mapTo = false;
            boolean bl6 = false;
            it = destination$iv$iv;
            boolean bl7 = false;
            State bl5 = dispatchReceiver;
            if (bl5 != null) {
                State state5 = bl5;
                boolean bl8 = false;
                boolean bl9 = false;
                State receiver = state5;
                boolean bl10 = false;
                args.add(new Variable((IrSymbol)((Object)it), receiver));
            }
        }
        $this$mapTo$iv$iv322 = UtilsKt.getExtensionReceiver(irFunction2);
        if ($this$mapTo$iv$iv322 != null) {
            destination$iv$iv = $this$mapTo$iv$iv322;
            $i$f$mapTo = false;
            boolean bl11 = false;
            it = destination$iv$iv;
            boolean bl12 = false;
            State bl5 = extensionReceiver;
            args.add(new Variable((IrSymbol)((Object)it), bl5 == null ? (State)CollectionsKt.first((List)valueArguments) : bl5));
        }
        int shift = irFunction2.getExtensionReceiverParameter() != null && extensionReceiver == null ? 1 : 0;
        Iterable $this$forEachIndexed$iv = irFunction2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param;
            int bl5 = index$iv22++;
            boolean bl13 = false;
            if (bl5 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int i = bl5;
            boolean bl14 = false;
            args.add(new Variable(param.getSymbol(), (State)valueArguments.get(i + shift)));
        }
        Object $this$forEach$iv = args;
        boolean $i$f$forEach = false;
        Object index$iv22 = $this$forEach$iv.iterator();
        while (index$iv22.hasNext()) {
            element$iv = index$iv22.next();
            Variable it5 = (Variable)element$iv;
            boolean bl15 = false;
            this.getCallStack().addVariable(it5);
        }
        Iterable $this$filter$iv = irFunction2.getTypeParameters();
        boolean $i$f$filter = false;
        index$iv22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrTypeParameter it6 = (IrTypeParameter)element$iv$iv;
            boolean bl16 = false;
            if (!it6.isReified()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv.iterator();
        while (iterator3.hasNext()) {
            element$iv = iterator3.next();
            IrTypeParameter it7 = (IrTypeParameter)element$iv;
            boolean bl17 = false;
            CallStack callStack = this.getCallStack();
            IrSymbol irSymbol2 = it7.getSymbol();
            IrType irType = call2.getTypeArgument(it7.getIndex());
            Intrinsics.checkNotNull((Object)irType);
            callStack.addVariable(new Variable(irSymbol2, new KTypeState(irType, (IrClass)this.getIrBuiltIns().getAnyClass().getOwner())));
        }
        if (dispatchReceiver == null && extensionReceiver == null && AdditionalIrUtilsKt.isLocal(irFunction2)) {
            this.getCallStack().copyUpValuesFromPreviousFrame();
        }
        if (dispatchReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)dispatchReceiver));
        }
        if (extensionReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)extensionReceiver));
        }
        if (dispatchReceiver instanceof Complex && (($this$forEach$iv = IrUtilsKt.getParentClassOrNull(irFunction2)) == null ? false : ((IrClass)$this$forEach$iv).isInner())) {
            $this$forEach$iv = SequencesKt.generateSequence((Object)((Complex)dispatchReceiver).getOuterClass(), (Function1)interpretCall.7.INSTANCE);
            $i$f$forEach = false;
            iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                element$iv = iterator3.next();
                Variable it8 = (Variable)element$iv;
                boolean bl18 = false;
                this.getCallStack().addVariable(it8);
            }
        }
        Object[] objectArray = new State[]{dispatchReceiver, extensionReceiver};
        this.callInterceptor.interceptCall(call2, irFunction2, dispatchReceiver, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)valueArguments), (Function0<Unit>)((Function0)new Function0<Unit>(this, irFunction2){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ IrFunction $irFunction;
            {
                this.this$0 = $receiver;
                this.$irFunction = $irFunction;
                super(0);
            }

            public final void invoke() {
                IrInterpreter.access$getCallStack(this.this$0).addInstruction(new CompoundInstruction(this.$irFunction));
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretInstanceInitializerCall(IrInstanceInitializerCall call2) {
        void $this$filterIsInstanceTo$iv$iv;
        IrClass irClass2 = (IrClass)call2.getClassSymbol().getOwner();
        Iterable $this$filterIsInstance$iv = irClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classProperties = (List)destination$iv$iv;
        Iterable $this$forEach$iv = classProperties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrExpressionBody irExpressionBody;
            IrExpression irExpression;
            Object element$iv$iv;
            IrProperty property2 = (IrProperty)element$iv;
            boolean bl = false;
            element$iv$iv = property2.getBackingField();
            IrExpression irExpression2 = element$iv$iv == null ? null : (irExpression = (irExpressionBody = ((IrField)element$iv$iv).getInitializer()) == null ? null : irExpressionBody.getExpression());
            if (irExpression == null) continue;
            IrValueParameter irValueParameter = irClass2.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrValueParameterSymbol receiver = irValueParameter.getSymbol();
            element$iv$iv = property2.getBackingField();
            if ((element$iv$iv == null ? null : ((IrField)element$iv$iv).getInitializer()) == null) continue;
            State receiverState = this.getCallStack().getState(receiver);
            Variable propertyVar = new Variable(property2.getSymbol(), this.getCallStack().popState());
            receiverState.setField(propertyVar);
        }
    }

    private final void interpretField(IrField field2) {
        IrClass irClass2 = IrUtilsKt.getParentAsClass(field2);
        IrValueParameter irValueParameter = irClass2.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameterSymbol receiver = irValueParameter.getSymbol();
        State receiverState = this.getCallStack().getState(receiver);
        IrPropertySymbol irPropertySymbol = field2.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        receiverState.setField(new Variable(irPropertySymbol, this.getCallStack().popState()));
    }

    private final void interpretBody(IrBody body2) {
        if (this.getCallStack().peekState() == null) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretBlock(IrBlock block) {
        this.getCallStack().dropSubFrame();
        if (this.getCallStack().peekState() == null) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretConstructor(IrConstructor constructor2) {
        this.getCallStack().dropFrameAndCopyResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretConstructorCall(IrFunctionAccessExpression constructorCall) {
        IrValueSymbol superReceiver;
        IrValueSymbol irValueSymbol;
        IrStatement irStatement;
        Object object;
        State state;
        int n;
        void $this$mapTo$iv$iv;
        IrFunction constructor2 = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        Iterable $this$map$iv = constructor2.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            n = 0;
            State state2 = this.getCallStack().getState(it.getSymbol());
            collection.add(state2);
        }
        List valueArguments = (List)destination$iv$iv;
        IrClass irClass2 = IrUtilsKt.getParentAsClass(constructor2);
        State objectState = this.getCallStack().getState(UtilsKt.getThisReceiver(constructorCall));
        if (AdditionalIrUtilsKt.isLocal(irClass2)) {
            this.getCallStack().storeUpValues((StateWithClosure)((Object)objectState));
        }
        if (irClass2.isInner()) {
            CallStack callStack = this.getCallStack();
            IrValueParameter irValueParameter = constructor2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            state = callStack.getState(irValueParameter.getSymbol());
        } else {
            state = null;
        }
        State outerClass2 = state;
        this.getCallStack().dropSubFrame();
        this.getCallStack().newFrame(constructor2);
        this.getCallStack().addInstruction(new SimpleInstruction(constructor2));
        this.getCallStack().addVariable(new Variable(UtilsKt.getThisReceiver(constructorCall), objectState));
        Iterable $this$forEachIndexed$iv = constructor2.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        Object object2 = $this$forEachIndexed$iv.iterator();
        while (object2.hasNext()) {
            void param;
            Object item$iv = object2.next();
            n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int i = n;
            boolean bl2 = false;
            this.getCallStack().addVariable(new Variable(param.getSymbol(), (State)valueArguments.get(i)));
        }
        if (AdditionalIrUtilsKt.isLocal(irClass2)) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)objectState));
        }
        if (outerClass2 != null) {
            IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(irClass2).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            Variable outerClassVar = new Variable(irValueParameter.getSymbol(), outerClass2);
            ((Complex)objectState).setOuterClass(outerClassVar);
            CallStack callStack = this.getCallStack();
            IrValueParameter irValueParameter2 = constructor2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter2);
            callStack.addVariable(new Variable(irValueParameter2.getSymbol(), outerClass2));
            this.getCallStack().addVariable(outerClassVar);
        }
        IrStatement irStatement2 = (object = constructor2.getBody()) == null ? null : (irStatement = (object2 = IrUtilsKt.getStatements((IrBody)object)) == null ? null : (IrStatement)object2.get(0));
        if (irStatement == null) {
            irValueSymbol = null;
        } else if (irStatement instanceof IrTypeOperatorCall) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)((IrTypeOperatorCall)irStatement).getArgument());
        } else if (irStatement instanceof IrFunctionAccessExpression) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement);
        } else if (irStatement instanceof IrBlock) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)CollectionsKt.last(((IrBlock)irStatement).getStatements()));
        } else {
            object = irStatement.getClass() + " is not supported as first statement in constructor call";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + (String)object);
        }
        IrValueSymbol irValueSymbol2 = superReceiver = irValueSymbol;
        if (irValueSymbol2 != null) {
            object = irValueSymbol2;
            boolean bl = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            this.getCallStack().addVariable(new Variable((IrSymbol)it, objectState));
        }
        this.callInterceptor.interceptConstructor(constructorCall, objectState, valueArguments, (Function0<Unit>)((Function0)new Function0<Unit>(this, objectState, constructor2){
            final /* synthetic */ IrInterpreter this$0;
            final /* synthetic */ State $objectState;
            final /* synthetic */ IrFunction $constructor;
            {
                this.this$0 = $receiver;
                this.$objectState = $objectState;
                this.$constructor = $constructor;
                super(0);
            }

            public final void invoke() {
                IrInterpreter.access$getCallStack(this.this$0).pushState(this.$objectState);
                IrInterpreter.access$getCallStack(this.this$0).addInstruction(new CompoundInstruction(this.$constructor));
            }
        }));
    }

    private final void interpretDelegatingConstructorCall(IrDelegatingConstructorCall constructorCall) {
        if (Intrinsics.areEqual((Object)((IrConstructor)constructorCall.getSymbol().getOwner()).getParent(), (Object)this.getIrBuiltIns().getAnyClass().getOwner())) {
            this.getCallStack().dropSubFrame();
            return;
        }
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretEnumConstructorCall(IrEnumConstructorCall constructorCall) {
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretConst(IrConst<?> expression2) {
        IrType signedType = IrInterpreter.interpretConst$getSignedType(this, expression2.getType());
        if (signedType != null) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClassSymbol unsignedClass = irClassSymbol;
            IrConstructor constructor2 = (IrConstructor)((IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(unsignedClass))).getOwner();
            IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor2.getReturnType(), constructor2.getSymbol(), null, 4, null);
            constructorCall.putValueArgument(0, UtilsKt.toIrConst$default(expression2.getValue(), signedType, 0, 0, 6, null));
            this.getCallStack().addInstruction(new CompoundInstruction(constructorCall));
            return;
        }
        this.getCallStack().pushState(UtilsKt.toPrimitive(expression2));
    }

    private final void interpretReturn(IrReturn expression2) {
        IrReturnTarget irReturnTarget = expression2.getReturnTargetSymbol().getOwner();
        IrFunction function2 = irReturnTarget instanceof IrFunction ? (IrFunction)irReturnTarget : null;
        irReturnTarget = function2;
        if (irReturnTarget != null) {
            this.tryResetFunctionBody((IrFunction)irReturnTarget);
        }
        if (UtilsKt.checkCast(function2, this.environment)) {
            this.getCallStack().returnFromFrameWithResult(expression2);
        }
    }

    private final void interpretWhile(IrWhileLoop loop2) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop2);
            this.getCallStack().addInstruction(new SimpleInstruction(loop2));
            this.getCallStack().addInstruction(new CompoundInstruction(loop2.getCondition()));
            this.getCallStack().addInstruction(new CompoundInstruction(loop2.getBody()));
        }
    }

    private final void interpretDoWhile(IrDoWhileLoop loop2) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop2);
            this.getCallStack().addInstruction(new SimpleInstruction(loop2));
            this.getCallStack().addInstruction(new CompoundInstruction(loop2.getCondition()));
            this.getCallStack().addInstruction(new CompoundInstruction(loop2.getBody()));
        }
    }

    private final void interpretBranch(IrBranch branch) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        if (result2) {
            this.getCallStack().dropSubFrame();
            this.getCallStack().addInstruction(new CompoundInstruction(branch.getResult()));
        }
    }

    private final void interpretSetField(IrSetField expression2) {
        IrExpression irExpression = expression2.getReceiver();
        if (irExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDeclarationReference");
        }
        IrSymbol receiver = ((IrDeclarationReference)irExpression).getSymbol();
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull((Object)irPropertySymbol);
        IrPropertySymbol propertySymbol = irPropertySymbol;
        State state = this.getCallStack().getState(receiver);
        boolean bl = false;
        boolean bl2 = false;
        State $this$interpretSetField_u24lambda_u2d19 = state;
        boolean bl3 = false;
        $this$interpretSetField_u24lambda_u2d19.setField(new Variable(propertySymbol, this.getCallStack().popState()));
    }

    private final void interpretGetField(IrGetField expression2) {
        Object object;
        Object initializerExpression;
        IrExpression irExpression = expression2.getReceiver();
        IrDeclarationReference irDeclarationReference = irExpression instanceof IrDeclarationReference ? (IrDeclarationReference)irExpression : null;
        IrSymbol receiver = irDeclarationReference == null ? null : irDeclarationReference.getSymbol();
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        if (Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && field2.isStatic()) {
            IrExpressionBody irExpressionBody = field2.getInitializer();
            Object object2 = initializerExpression = irExpressionBody == null ? null : irExpressionBody.getExpression();
            if (initializerExpression instanceof IrConst) {
                this.getCallStack().addInstruction(new SimpleInstruction((IrElement)initializerExpression));
            } else {
                this.callInterceptor.interceptJavaStaticField(expression2);
            }
        } else if (Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.PROPERTY_BACKING_FIELD.INSTANCE) && ((initializerExpression = field2.getCorrespondingPropertySymbol()) == null ? false : ((object = (IrProperty)initializerExpression.getOwner()) == null ? false : ((IrProperty)object).isConst()))) {
            this.getCallStack().addInstruction(new CompoundInstruction((initializerExpression = field2.getInitializer()) == null ? null : ((IrExpressionBody)initializerExpression).getExpression()));
        } else if (UtilsKt.accessesTopLevelOrObjectField(expression2)) {
            IrExpressionBody irExpressionBody;
            IrExpressionBody irExpressionBody2;
            IrField irField;
            object = field2.getCorrespondingPropertySymbol();
            IrProperty propertyOwner = object == null ? null : (IrProperty)object.getOwner();
            IrProperty irProperty2 = propertyOwner;
            boolean isConst = (irProperty2 == null ? false : irProperty2.isConst()) || ((irProperty2 = propertyOwner) == null ? null : ((irField = irProperty2.getBackingField()) == null ? null : ((irExpressionBody2 = irField.getInitializer()) == null ? null : irExpressionBody2.getExpression()))) instanceof IrConst;
            boolean bl = false;
            if (_Assertions.ENABLED && !isConst) {
                boolean bl2 = false;
                String string2 = "Cannot interpret get method on top level non const properties";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            this.getCallStack().addInstruction(new CompoundInstruction((irExpressionBody = field2.getInitializer()) == null ? null : irExpressionBody.getExpression()));
        } else {
            CallStack callStack = this.getCallStack();
            IrSymbol irSymbol2 = receiver;
            Intrinsics.checkNotNull((Object)irSymbol2);
            State state = callStack.getState(irSymbol2);
            IrPropertySymbol irPropertySymbol = field2.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull((Object)irPropertySymbol);
            State result2 = state.getField(irPropertySymbol);
            CallStack callStack2 = this.getCallStack();
            State state2 = result2;
            Intrinsics.checkNotNull((Object)state2);
            callStack2.pushState(state2);
        }
    }

    private final void interpretGetObjectValue(IrGetObjectValue expression2) {
        this.callInterceptor.interceptGetObjectValue(expression2, (Function0<Unit>)((Function0)new Function0<Unit>(expression2, this){
            final /* synthetic */ IrGetObjectValue $expression;
            final /* synthetic */ IrInterpreter this$0;
            {
                this.$expression = $expression;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                IrClass objectClass = (IrClass)this.$expression.getSymbol().getOwner();
                Common state = new Common(objectClass);
                Map<IrSymbol, Complex> map = this.this$0.getEnvironment$ir_interpreter().getMapOfObjects();
                Object object = objectClass.getSymbol();
                boolean bl = false;
                map.put((IrSymbol)object, state);
                CallStack callStack = IrInterpreter.access$getCallStack(this.this$0);
                IrValueParameter irValueParameter = objectClass.getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                callStack.addVariable(new Variable(irValueParameter.getSymbol(), state));
                if (!UtilsKt.hasAnnotation(objectClass, UtilsKt.getCompileTimeAnnotation())) {
                    IrInterpreter.access$getCallStack(this.this$0).pushState(state);
                    return;
                }
                object = (IrConstructor)SequencesKt.firstOrNull(IrUtilsKt.getConstructors(objectClass));
                if (object == null) {
                    IrInterpreter.access$getCallStack(this.this$0).pushState(state);
                    return;
                }
                Object constructor2 = object;
                IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, ((IrFunction)constructor2).getReturnType(), ((IrConstructor)constructor2).getSymbol(), null, 4, null);
                IrInterpreter.access$getCallStack(this.this$0).newSubFrame(constructorCall);
                IrInterpreter.access$getCallStack(this.this$0).addInstruction(new SimpleInstruction(constructorCall));
            }
        }));
    }

    private final void interpretGetEnumValue(IrGetEnumValue expression2) {
        CallStack callStack = this.getCallStack();
        Complex complex = this.environment.getMapOfEnums().get(expression2.getSymbol());
        Intrinsics.checkNotNull((Object)complex);
        callStack.pushState(complex);
    }

    private final void interpretEnumEntry(IrEnumEntry enumEntry) {
        this.callInterceptor.interceptEnumEntry(enumEntry, (Function0<Unit>)((Function0)new Function0<Unit>(enumEntry, this){
            final /* synthetic */ IrEnumEntry $enumEntry;
            final /* synthetic */ IrInterpreter this$0;
            {
                this.$enumEntry = $enumEntry;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                IrEnumConstructorCall $this$forEachIndexed$iv2;
                Object $this$filterIsInstanceTo$iv$iv;
                IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)this.$enumEntry.getSymbol().getOwner());
                Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
                boolean $i$f$filterIsInstance22 = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Object destination$iv$iv222 = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                Object object = $this$filterIsInstanceTo$iv$iv.iterator();
                while (object.hasNext()) {
                    T element$iv$iv = object.next();
                    if (!(element$iv$iv instanceof IrEnumEntry)) continue;
                    destination$iv$iv222.add(element$iv$iv);
                }
                List enumEntries = (List)destination$iv$iv222;
                $this$filterIsInstanceTo$iv$iv = IrUtilsKt.getPrimaryConstructor(enumClass2);
                IrStatement $i$f$filterIsInstance22 = $this$filterIsInstanceTo$iv$iv == null ? null : ((destination$iv$iv222 = ((IrFunction)$this$filterIsInstanceTo$iv$iv).getBody()) == null ? null : (($i$f$filterIsInstanceTo = IrUtilsKt.getStatements((IrBody)destination$iv$iv222)) == null ? null : (IrStatement)CollectionsKt.firstOrNull($i$f$filterIsInstanceTo)));
                IrEnumConstructorCall enumSuperCall = $i$f$filterIsInstance22 instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)$i$f$filterIsInstance22 : null;
                Function0 cleanEnumSuperCall2 = (Function0)new Function0<Unit>(enumSuperCall, this.this$0){
                    final /* synthetic */ IrEnumConstructorCall $enumSuperCall;
                    final /* synthetic */ IrInterpreter this$0;
                    {
                        this.$enumSuperCall = $enumSuperCall;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        IrEnumConstructorCall irEnumConstructorCall = this.$enumSuperCall;
                        if (irEnumConstructorCall != null) {
                            IrEnumConstructorCall irEnumConstructorCall2 = irEnumConstructorCall;
                            boolean bl = false;
                            boolean bl2 = false;
                            IrEnumConstructorCall $this$invoke_u24lambda_u2d1 = irEnumConstructorCall2;
                            boolean bl3 = false;
                            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)$this$invoke_u24lambda_u2d1.getValueArgumentsCount());
                            boolean $i$f$forEach = false;
                            Iterator<T> iterator2 = $this$forEach$iv.iterator();
                            while (iterator2.hasNext()) {
                                int element$iv;
                                int it = element$iv = ((IntIterator)iterator2).nextInt();
                                boolean bl4 = false;
                                $this$invoke_u24lambda_u2d1.putValueArgument(it, null);
                            }
                        }
                        IrInterpreter.access$getCallStack(this.this$0).dropSubFrame();
                    }
                };
                $this$filterIsInstanceTo$iv$iv = enumEntries;
                boolean destination$iv$iv222 = false;
                if (!$this$filterIsInstanceTo$iv$iv.isEmpty() && enumSuperCall != null) {
                    Object[] destination$iv$iv222 = new IrConst[]{UtilsKt.toIrConst$default(this.$enumEntry.getName().asString(), this.this$0.getIrBuiltIns().getStringType(), 0, 0, 6, null), UtilsKt.toIrConst$default(enumEntries.indexOf(this.$enumEntry), this.this$0.getIrBuiltIns().getIntType(), 0, 0, 6, null)};
                    List valueArguments = CollectionsKt.listOf((Object[])destination$iv$iv222);
                    Iterable $this$forEachIndexed$iv2 = valueArguments;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (E item$iv : $this$forEachIndexed$iv2) {
                        void irConst;
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        IrConst irConst2 = (IrConst)item$iv;
                        int index2 = n;
                        boolean bl2 = false;
                        enumSuperCall.putValueArgument(index2, (IrExpression)irConst);
                    }
                }
                Object object2 = (object = this.$enumEntry.getInitializerExpression()) == null ? null : ((IrExpressionBody)object).getExpression();
                IrEnumConstructorCall irEnumConstructorCall = $this$forEachIndexed$iv2 = object2 instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)object2 : null;
                if ($this$forEachIndexed$iv2 == null) {
                    throw new InterpreterError("Initializer at enum entry " + IrUtilsKt.getFqNameWhenAvailable(this.$enumEntry) + " is null");
                }
                IrEnumConstructorCall enumConstructorCall = $this$forEachIndexed$iv2;
                Variable enumClassObject = new Variable(UtilsKt.getThisReceiver(enumConstructorCall), new Common((IrClass)((object2 = this.$enumEntry.getCorrespondingClass()) == null ? enumClass2 : object2)));
                object2 = this.this$0.getEnvironment$ir_interpreter().getMapOfEnums();
                object = this.$enumEntry.getSymbol();
                Complex complex = (Complex)enumClassObject.getState();
                boolean bl = false;
                object2.put(object, complex);
                IrInterpreter.access$getCallStack(this.this$0).newSubFrame(this.$enumEntry);
                IrInterpreter.access$getCallStack(this.this$0).addInstruction(new CustomInstruction((Function0<Unit>)cleanEnumSuperCall2));
                IrInterpreter.access$getCallStack(this.this$0).addInstruction(new CompoundInstruction(enumConstructorCall));
                IrInterpreter.access$getCallStack(this.this$0).addVariable(enumClassObject);
            }
        }));
    }

    private final void interpretTypeOperatorCall(IrTypeOperatorCall expression2) {
        IrTypeParameter irTypeParameter2;
        IrClassifierSymbol typeClassifier = IrTypesKt.getClassifierOrFail(expression2.getTypeOperand());
        IrSymbolOwner irSymbolOwner = typeClassifier.getOwner();
        IrTypeParameter irTypeParameter3 = irTypeParameter2 = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        boolean isReified = irTypeParameter2 == null ? false : irTypeParameter2.isReified();
        boolean isErased = typeClassifier.getOwner() instanceof IrTypeParameter && !isReified;
        IrType typeOperand = isReified ? ((KTypeState)this.getCallStack().getState(typeClassifier)).getIrType() : expression2.getTypeOperand();
        IrTypeOperator irTypeOperator = expression2.getOperator();
        int n = WhenMappings.$EnumSwitchMapping$1[irTypeOperator.ordinal()];
        switch (n) {
            case 1: {
                this.getCallStack().popState();
                break;
            }
            case 2: 
            case 3: {
                if (isErased) break;
                State state = this.getCallStack().peekState();
                Intrinsics.checkNotNull((Object)state);
                if (StateKt.isSubtypeOf(state, typeOperand)) break;
                FqName convertibleClassName = IrUtilsKt.getFqNameWhenAvailable(this.getCallStack().popState().getIrClass());
                UtilsKt.handleUserException(new ClassCastException(convertibleClassName + " cannot be cast to " + RenderIrElementKt.render(typeOperand)), this.environment);
                break;
            }
            case 4: {
                if (isErased) break;
                State state = this.getCallStack().peekState();
                Intrinsics.checkNotNull((Object)state);
                if (StateKt.isSubtypeOf(state, typeOperand)) break;
                this.getCallStack().popState();
                this.getCallStack().pushState(UtilsKt.toState(null, this.getIrBuiltIns().getNothingNType()));
                break;
            }
            case 5: {
                boolean isInstance = StateKt.isSubtypeOf(this.getCallStack().popState(), typeOperand) || isErased;
                this.getCallStack().pushState(UtilsKt.toState(isInstance, this.getIrBuiltIns().getBooleanType()));
                break;
            }
            case 6: {
                boolean isInstance = StateKt.isSubtypeOf(this.getCallStack().popState(), typeOperand) || isErased;
                this.getCallStack().pushState(UtilsKt.toState(!isInstance, this.getIrBuiltIns().getBooleanType()));
                break;
            }
            case 7: {
                break;
            }
            default: {
                String string2 = (Object)((Object)expression2.getOperator()) + " not implemented";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretVararg(IrVararg expression2) {
        State state;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = expression2.getElements();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrVarargElement it = (IrVarargElement)element$iv$iv;
            boolean bl = false;
            State result2 = this.getCallStack().popState();
            Iterable list$iv$iv = result2 instanceof Wrapper ? CollectionsKt.listOf((Object)((Wrapper)result2).getValue()) : (result2 instanceof Primitive ? (IrTypePredicatesKt.isArray(expression2.getVarargElementType()) || UtilsKt.isPrimitiveArray(expression2.getVarargElementType()) ? CollectionsKt.listOf((Object)result2) : IrInterpreter.interpretVararg$arrayToList(((Primitive)result2).getValue())) : (result2 instanceof Common ? (UtilsKt.isUnsignedArray(IrUtilsKt.getDefaultType(result2.getIrClass())) ? IrInterpreter.interpretVararg$arrayToList(((Primitive)((Variable)CollectionsKt.single(result2.getFields())).getState()).getValue()) : CollectionsKt.listOf((Object)CommonProxy.Companion.asProxy$ir_interpreter$default(CommonProxy.Companion, (Common)result2, this.callInterceptor, null, 2, null))) : CollectionsKt.listOf((Object)result2)));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List args = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        if (UtilsKt.isUnsignedArray(expression2.getType())) {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Object element$iv$iv;
            Object object;
            IrClass owner;
            block6: {
                void $this$first$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
                Intrinsics.checkNotNull((Object)irClassSymbol);
                owner = (IrClass)irClassSymbol.getOwner();
                Iterable $this$filterIsInstance$iv = owner.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrProperty it = (IrProperty)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"storage")) continue;
                    break block6;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty storageProperty = (IrProperty)element$iv2;
            Iterable $this$map$iv = args;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            element$iv$iv = $this$mapTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                void it;
                Object item$iv$iv;
                Object e = item$iv$iv = element$iv$iv.next();
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                void var16_28 = it;
                void var18_30 = var16_28 instanceof Proxy ? ((Primitive)((Variable)CollectionsKt.single(((Proxy)it).getState().getFields())).getState()).getValue() : it;
                collection.add(var18_30);
            }
            List primitiveArray = (List)destination$iv$iv3;
            IrField irField = storageProperty.getBackingField();
            Intrinsics.checkNotNull((Object)irField);
            Primitive<?> unsignedArray = UtilsKt.toPrimitiveStateArray(primitiveArray, irField.getType());
            object = new Common(owner);
            boolean bl = false;
            boolean bl3 = false;
            Object $this$interpretVararg_u24lambda_u2d24 = object;
            boolean bl4 = false;
            ((Common)$this$interpretVararg_u24lambda_u2d24).getFields().add(new Variable(storageProperty.getSymbol(), unsignedArray));
            state = (State)object;
        } else {
            state = UtilsKt.toPrimitiveStateArray(args, expression2.getType());
        }
        State array = state;
        this.getCallStack().pushState(array);
    }

    private final void interpretTry(IrTry element) {
        IrExpression irExpression;
        State possibleException = this.getCallStack().peekState();
        this.getCallStack().dropSubFrame();
        if (possibleException instanceof ExceptionState) {
            Function0 checkUnhandledException2 = (Function0)new Function0<Unit>(this, possibleException){
                final /* synthetic */ IrInterpreter this$0;
                final /* synthetic */ State $possibleException;
                {
                    this.this$0 = $receiver;
                    this.$possibleException = $possibleException;
                    super(0);
                }

                public final void invoke() {
                    IrInterpreter.access$getCallStack(this.this$0).pushState(this.$possibleException);
                    IrInterpreter.access$getCallStack(this.this$0).dropFramesUntilTryCatch();
                }
            };
            this.getCallStack().addInstruction(new CustomInstruction((Function0<Unit>)checkUnhandledException2));
        }
        if ((irExpression = element.getFinallyExpression()) != null) {
            InstructionsUnfolderKt.handleAndDropResult$default(irExpression, this.getCallStack(), false, 2, null);
        }
    }

    private final void interpretThrow(IrThrow expression2) {
        State exception = this.getCallStack().popState();
        this.getCallStack().newSubFrame(expression2);
        State state = exception;
        if (state instanceof Common) {
            this.getCallStack().pushState(new ExceptionState((Common)exception, this.getCallStack().getStackTrace()));
        } else if (state instanceof Wrapper) {
            this.getCallStack().pushState(new ExceptionState((Wrapper)exception, this.getCallStack().getStackTrace()));
        } else if (state instanceof ExceptionState) {
            this.getCallStack().pushState(exception);
        } else {
            throw new InterpreterError(Reflection.getOrCreateKotlinClass(exception.getClass()) + " cannot be used as exception state");
        }
        this.getCallStack().dropFramesUntilTryCatch();
    }

    private final void interpretStringConcatenation(IrStringConcatenation expression2) {
        int n = 0;
        List result2 = new ArrayList();
        n = expression2.getArguments().size();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int it = n2;
            boolean bl2 = false;
            Collection collection = result2;
            State state = this.getCallStack().popState();
            String string2 = state instanceof Primitive ? String.valueOf(((Primitive)state).getValue()) : (state instanceof Wrapper ? ((Wrapper)state).getValue().toString() : state.toString());
            boolean bl3 = false;
            collection.add(string2);
        }
        this.getCallStack().dropSubFrame();
        this.getCallStack().pushState(UtilsKt.toState(CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)result2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null), expression2.getType()));
    }

    private final void interpretFunctionExpression(IrFunctionExpression expression2) {
        IrFunction irFunction2 = expression2.getFunction();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        KFunctionState function2 = new KFunctionState(irFunction2, (IrClass)irClassSymbol.getOwner());
        if (AdditionalIrUtilsKt.isLocal(expression2.getFunction())) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    private final void interpretFunctionReference(IrFunctionReference reference) {
        boolean bl;
        Variable variable2;
        Collection collection;
        KFunctionState kFunctionState;
        State receiver;
        boolean bl2;
        boolean bl3;
        State state;
        State state2;
        State state3;
        boolean bl4;
        Object object;
        State state4;
        KFunctionState function2 = new KFunctionState(reference);
        IrFunction irFunction2 = function2.getIrFunction();
        IrExpression irExpression = reference.getDispatchReceiver();
        if (irExpression == null) {
            state4 = null;
        } else {
            object = irExpression;
            boolean bl5 = false;
            bl4 = false;
            IrExpression it = object;
            boolean bl6 = false;
            CallStack callStack = this.getCallStack();
            IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver(irFunction2);
            Intrinsics.checkNotNull((Object)irValueParameterSymbol);
            state4 = callStack.getState(irValueParameterSymbol);
        }
        State dispatchReceiver = state4;
        object = reference.getExtensionReceiver();
        if (object == null) {
            state3 = null;
        } else {
            IrExpression irExpression2 = object;
            bl4 = false;
            boolean bl7 = false;
            IrExpression it = irExpression2;
            boolean bl8 = false;
            CallStack callStack = this.getCallStack();
            IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getExtensionReceiver(irFunction2);
            Intrinsics.checkNotNull((Object)irValueParameterSymbol);
            state3 = callStack.getState(irValueParameterSymbol);
        }
        State extensionReceiver = state3;
        this.getCallStack().dropSubFrame();
        object = UtilsKt.getDispatchReceiver(irFunction2);
        if (object != null) {
            Object object2 = object;
            bl4 = false;
            boolean bl9 = false;
            Object it = object2;
            boolean bl10 = false;
            state2 = dispatchReceiver;
            if (state2 != null) {
                state = state2;
                bl3 = false;
                bl2 = false;
                receiver = state;
                boolean bl11 = false;
                kFunctionState = function2;
                collection = kFunctionState.getFields();
                variable2 = new Variable((IrSymbol)it, receiver);
                bl = false;
                collection.add(variable2);
            }
        }
        object = UtilsKt.getExtensionReceiver(irFunction2);
        if (object != null) {
            Object object3 = object;
            bl4 = false;
            boolean bl12 = false;
            Object it = object3;
            boolean bl13 = false;
            state2 = extensionReceiver;
            if (state2 != null) {
                state = state2;
                bl3 = false;
                bl2 = false;
                receiver = state;
                boolean bl14 = false;
                kFunctionState = function2;
                collection = kFunctionState.getFields();
                variable2 = new Variable((IrSymbol)it, receiver);
                bl = false;
                collection.add(variable2);
            }
        }
        if (AdditionalIrUtilsKt.isLocal(irFunction2)) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    private final void interpretPropertyReference(IrPropertyReference propertyReference) {
        State state;
        IrElementBase it;
        boolean bl;
        boolean bl2;
        IrElementBase irElementBase;
        IrElementBase irElementBase2;
        IrValueParameterSymbol irValueParameterSymbol;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = propertyReference.getGetter();
        if (irSimpleFunctionSymbol == null) {
            irValueParameterSymbol = null;
        } else {
            irElementBase2 = (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
            if (irElementBase2 == null) {
                irValueParameterSymbol = null;
            } else {
                irElementBase = irElementBase2;
                bl2 = false;
                bl = false;
                it = irElementBase;
                boolean bl3 = false;
                IrValueParameterSymbol irValueParameterSymbol2 = UtilsKt.getDispatchReceiver((IrFunction)it);
                irValueParameterSymbol = irValueParameterSymbol2 == null ? UtilsKt.getExtensionReceiver((IrFunction)it) : irValueParameterSymbol2;
            }
        }
        IrValueParameterSymbol receiverSymbol = irValueParameterSymbol;
        irElementBase = propertyReference.getDispatchReceiver();
        IrElementBase irElementBase3 = irElementBase2 = irElementBase == null ? propertyReference.getExtensionReceiver() : irElementBase;
        if (irElementBase2 == null) {
            state = null;
        } else {
            irElementBase = irElementBase2;
            bl2 = false;
            bl = false;
            it = irElementBase;
            boolean bl4 = false;
            CallStack callStack = this.getCallStack();
            IrValueParameterSymbol irValueParameterSymbol3 = receiverSymbol;
            Intrinsics.checkNotNull((Object)irValueParameterSymbol3);
            state = callStack.getState(irValueParameterSymbol3);
        }
        State receiver = state;
        this.getCallStack().dropSubFrame();
        KPropertyState propertyState = new KPropertyState(propertyReference, receiver);
        this.getCallStack().pushState(propertyState);
    }

    private final void interpretClassReference(IrClassReference classReference) {
        IrClassifierSymbol irClassifierSymbol = classReference.getSymbol();
        if (irClassifierSymbol instanceof IrTypeParameterSymbol) {
            KTypeState kTypeState = (KTypeState)this.getCallStack().getState(classReference.getSymbol());
            CallStack callStack = this.getCallStack();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kTypeState.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            IrClass irClass2 = (IrClass)irClassSymbol.getOwner();
            IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(classReference.getType());
            Intrinsics.checkNotNull((Object)irClassSymbol2);
            callStack.pushState(new KClassState(irClass2, (IrClass)irClassSymbol2.getOwner()));
        } else {
            this.getCallStack().pushState(new KClassState(classReference));
        }
    }

    private static final boolean interpretValueParameter$isReceiver(IrFunction irFunction2, IrValueParameter $valueParameter) {
        return Intrinsics.areEqual((Object)irFunction2.getDispatchReceiverParameter(), (Object)$valueParameter) || Intrinsics.areEqual((Object)irFunction2.getExtensionReceiverParameter(), (Object)$valueParameter);
    }

    private static final IrType interpretConst$getSignedType(IrInterpreter this$0, IrType unsignedType) {
        IrType irType;
        UnsignedType unsignedType2 = IrTypePredicatesKt.getUnsignedType(unsignedType);
        int n = unsignedType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unsignedType2.ordinal()];
        switch (n) {
            case 1: {
                irType = this$0.getIrBuiltIns().getByteType();
                break;
            }
            case 2: {
                irType = this$0.getIrBuiltIns().getShortType();
                break;
            }
            case 3: {
                irType = this$0.getIrBuiltIns().getIntType();
                break;
            }
            case 4: {
                irType = this$0.getIrBuiltIns().getLongType();
                break;
            }
            default: {
                irType = null;
            }
        }
        return irType;
    }

    private static final List<Object> interpretVararg$arrayToList(Object value2) {
        Object object = value2;
        return CollectionsKt.reversed((Iterable)(object instanceof byte[] ? ArraysKt.toList((byte[])((byte[])value2)) : (object instanceof char[] ? ArraysKt.toList((char[])((char[])value2)) : (object instanceof short[] ? ArraysKt.toList((short[])((short[])value2)) : (object instanceof int[] ? ArraysKt.toList((int[])((int[])value2)) : (object instanceof long[] ? ArraysKt.toList((long[])((long[])value2)) : (object instanceof float[] ? ArraysKt.toList((float[])((float[])value2)) : (object instanceof double[] ? ArraysKt.toList((double[])((double[])value2)) : (object instanceof boolean[] ? ArraysKt.toList((boolean[])((boolean[])value2)) : (object instanceof Object[] ? ArraysKt.toList((Object[])((Object[])value2)) : CollectionsKt.listOf((Object)value2)))))))))));
    }

    public static final /* synthetic */ boolean access$interpretValueParameter$isReceiver(IrFunction irFunction2, IrValueParameter $valueParameter) {
        return IrInterpreter.interpretValueParameter$isReceiver(irFunction2, $valueParameter);
    }

    public static final /* synthetic */ CallStack access$getCallStack(IrInterpreter $this) {
        return $this.getCallStack();
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnsignedType.values().length];
            nArray[UnsignedType.UBYTE.ordinal()] = 1;
            nArray[UnsignedType.USHORT.ordinal()] = 2;
            nArray[UnsignedType.UINT.ordinal()] = 3;
            nArray[UnsignedType.ULONG.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrTypeOperator.values().length];
            nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            nArray[IrTypeOperator.CAST.ordinal()] = 2;
            nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 3;
            nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

