/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.testFramework;

import com.intellij.core.CoreEncodingProjectManager;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.test.testFramework.MockProjectEx;
import org.picocontainer.MutablePicoContainer;

public abstract class KtPlatformLiteFixture
extends KtUsefulTestCase {
    protected MockProjectEx myProject;

    public static MockApplication getApplication() {
        return (MockApplication)ApplicationManager.getApplication();
    }

    public void initApplication() {
        MockApplication instance = new MockApplication(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)instance, FileTypeManager::getInstance, (Disposable)this.getTestRootDisposable());
        KtPlatformLiteFixture.getApplication().registerService(EncodingManager.class, CoreEncodingProjectManager.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        KtPlatformLiteFixture.clearFields((Object)this);
        this.myProject = null;
    }

    public static <T> T registerComponentInstance(MutablePicoContainer container, Class<T> key, T implementation) {
        Object old = container.getComponentInstance(key);
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
        return (T)old;
    }
}

