/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.MuteWithDatabaseKt;
import org.jetbrains.kotlin.test.mutes.MuteWithDatabaseWrapperKt;
import org.jetbrains.kotlin.test.mutes.MutedTest;
import org.jetbrains.kotlin.test.mutes.MutedTestKt;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J,\u0010\r\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u000e\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/MuteInInvocationInterceptor;", "Lorg/junit/jupiter/api/extension/InvocationInterceptor;", "()V", "interceptTestMethod", "", "invocation", "Lorg/junit/jupiter/api/extension/InvocationInterceptor$Invocation;", "Ljava/lang/Void;", "invocationContext", "Lorg/junit/jupiter/api/extension/ReflectiveInvocationContext;", "Ljava/lang/reflect/Method;", "extensionContext", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "interceptTestTemplateMethod", "interceptWithMuteInDatabase", "tests-common"})
public final class MuteInInvocationInterceptor
implements InvocationInterceptor {
    public void interceptTestTemplateMethod(@NotNull InvocationInterceptor.Invocation<Void> invocation, @NotNull ReflectiveInvocationContext<Method> invocationContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter(invocationContext, (String)"invocationContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        this.interceptWithMuteInDatabase(invocation, extensionContext);
    }

    public void interceptTestMethod(@NotNull InvocationInterceptor.Invocation<Void> invocation, @NotNull ReflectiveInvocationContext<Method> invocationContext, @NotNull ExtensionContext extensionContext) {
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        Intrinsics.checkNotNullParameter(invocationContext, (String)"invocationContext");
        Intrinsics.checkNotNullParameter((Object)extensionContext, (String)"extensionContext");
        this.interceptWithMuteInDatabase(invocation, extensionContext);
    }

    private final void interceptWithMuteInDatabase(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) {
        Class testClass = MuteWithDatabaseKt.access$getTestClassNullable(extensionContext);
        Method testMethod = MuteWithDatabaseKt.access$getTestMethodNullable(extensionContext);
        if (testClass != null && testMethod != null) {
            Object object = testMethod.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testMethod.name");
            MutedTest mutedTest = MutedTestKt.getMutedTest((Class)testClass, (String)object);
            if (mutedTest != null && MuteWithDatabaseWrapperKt.isPresentedInDatabaseWithoutFailMarker((MutedTest)mutedTest)) {
                if (mutedTest.isFlaky()) {
                    invocation.proceed();
                    return;
                }
                Function0 function0 = (Function0)new Function0<Unit>(invocation){
                    final /* synthetic */ InvocationInterceptor.Invocation<Void> $invocation;
                    {
                        this.$invocation = $invocation;
                        super(0);
                    }

                    public final void invoke() {
                        this.$invocation.proceed();
                    }
                };
                object = testMethod.getDeclaringClass();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testMethod.declaringClass");
                MuteWithDatabaseWrapperKt.invertMutedTestResultWithLog((Function0)function0, (String)MuteWithDatabaseWrapperKt.testKey((Class)object, (String)mutedTest.getMethodKey()));
                return;
            }
        }
        invocation.proceed();
    }
}

