/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettings;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.jvm.compiler.LoadDescriptorUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.JvmCompilationUtils;
import org.jetbrains.kotlin.test.MuteWithDatabaseKt;
import org.jetbrains.kotlin.test.RunnableWithThrowable;
import org.jetbrains.kotlin.test.TagsTestDataUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestFiles;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.WithMutedInDatabaseRunTest;
import org.jetbrains.kotlin.test.util.JUnit4Assertions;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.util.StringUtilsKt;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.junit.Assert;

public class KotlinTestUtils {
    public static String TEST_MODULE_NAME = "test-module";
    public static final String TEST_GENERATOR_NAME = "org.jetbrains.kotlin.generators.tests.TestsPackage";
    private static final boolean RUN_IGNORED_TESTS_AS_REGULAR = Boolean.getBoolean("org.jetbrains.kotlin.run.ignored.tests.as.regular");
    private static final boolean PRINT_STACKTRACE_FOR_IGNORED_TESTS = Boolean.getBoolean("org.jetbrains.kotlin.print.stacktrace.for.ignored.tests");
    private static final boolean DONT_IGNORE_TESTS_WORKING_ON_COMPATIBLE_BACKEND = Boolean.getBoolean("org.jetbrains.kotlin.dont.ignore.tests.working.on.compatible.backend");
    private static final boolean AUTOMATICALLY_UNMUTE_PASSED_TESTS = false;
    private static final boolean AUTOMATICALLY_MUTE_FAILED_TESTS = false;
    private static final Pattern DIRECTIVE_PATTERN = Pattern.compile("^//\\s*[!]?([A-Z_]+)(:[ \\t]*(.*))?$", 8);

    private KotlinTestUtils() {
    }

    @NotNull
    public static AnalysisResult analyzeFile(@NotNull KtFile file, @NotNull KotlinCoreEnvironment environment) {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            KotlinTestUtils.$$$reportNull$$$0(1);
        }
        AnalysisResult analysisResult = JvmResolveUtil.analyze((KtFile)file, (KotlinCoreEnvironment)environment);
        if (analysisResult == null) {
            KotlinTestUtils.$$$reportNull$$$0(2);
        }
        return analysisResult;
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithMockJdkAndIdeaAnnotations(Disposable disposable) {
        return KotlinTestUtils.createEnvironmentWithMockJdkAndIdeaAnnotations(disposable, ConfigurationKind.ALL);
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithMockJdkAndIdeaAnnotations(Disposable disposable, @NotNull ConfigurationKind configurationKind) {
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(3);
        }
        return KotlinTestUtils.createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea(disposable, configurationKind, TestJdkKind.MOCK_JDK);
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea(@NotNull Disposable disposable, @NotNull ConfigurationKind configurationKind, @NotNull TestJdkKind jdkKind) {
        if (disposable == null) {
            KotlinTestUtils.$$$reportNull$$$0(4);
        }
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(5);
        }
        if (jdkKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(6);
        }
        KotlinCoreEnvironment kotlinCoreEnvironment = KotlinCoreEnvironment.createForTests((Disposable)disposable, (CompilerConfiguration)KotlinTestUtils.newConfiguration(configurationKind, jdkKind, KtTestUtil.getAnnotationsJar()), (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        if (kotlinCoreEnvironment == null) {
            KotlinTestUtils.$$$reportNull$$$0(7);
        }
        return kotlinCoreEnvironment;
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithFullJdkAndIdeaAnnotations(Disposable disposable) {
        return KotlinTestUtils.createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea(disposable, ConfigurationKind.ALL, TestJdkKind.FULL_JDK);
    }

    @NotNull
    public static File tmpDirForTest(TestCase test2) throws IOException {
        File file = KtTestUtil.tmpDirForTest((String)test2.getClass().getSimpleName(), (String)test2.getName());
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public static CompilerConfiguration newConfiguration() {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)TEST_MODULE_NAME);
        if ("true".equals(System.getProperty("kotlin.ni"))) {
            CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration, (LanguageVersionSettings)new CompilerTestLanguageVersionSettings(Collections.emptyMap(), LanguageVersionSettingsImpl.DEFAULT.getApiVersion(), LanguageVersionSettingsImpl.DEFAULT.getLanguageVersion(), Collections.emptyMap()));
        }
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)new MessageCollector(){

            public void clear() {
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
                if (severity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (severity == CompilerMessageSeverity.ERROR) {
                    String prefix = location == null ? "" : "(" + location.getPath() + ":" + location.getLine() + ":" + location.getColumn() + ") ";
                    throw new AssertionError((Object)(prefix + message));
                }
            }

            public boolean hasErrors() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "severity";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/test/KotlinTestUtils$1";
                objectArray[2] = "report";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CompilerConfiguration compilerConfiguration = configuration;
        if (compilerConfiguration == null) {
            KotlinTestUtils.$$$reportNull$$$0(9);
        }
        return compilerConfiguration;
    }

    @NotNull
    public static CompilerConfiguration newConfiguration(@NotNull ConfigurationKind configurationKind, @NotNull TestJdkKind jdkKind, File ... extraClasspath) {
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(10);
        }
        if (jdkKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(11);
        }
        if (extraClasspath == null) {
            KotlinTestUtils.$$$reportNull$$$0(12);
        }
        return KotlinTestUtils.newConfiguration(configurationKind, jdkKind, Arrays.asList(extraClasspath), Collections.emptyList());
    }

    @NotNull
    public static CompilerConfiguration newConfiguration(@NotNull ConfigurationKind configurationKind, @NotNull TestJdkKind jdkKind, @NotNull List<File> classpath, @NotNull List<File> javaSource) {
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(13);
        }
        if (jdkKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(14);
        }
        if (classpath == null) {
            KotlinTestUtils.$$$reportNull$$$0(15);
        }
        if (javaSource == null) {
            KotlinTestUtils.$$$reportNull$$$0(16);
        }
        CompilerConfiguration configuration = KotlinTestUtils.newConfiguration();
        JvmContentRootsKt.addJavaSourceRoots((CompilerConfiguration)configuration, javaSource);
        if (jdkKind == TestJdkKind.MOCK_JDK) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)KtTestUtil.findMockJdkRtJar());
            configuration.put(JVMConfigurationKeys.NO_JDK, (Object)true);
        } else if (jdkKind == TestJdkKind.MODIFIED_MOCK_JDK) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)KtTestUtil.findMockJdkRtModified());
            configuration.put(JVMConfigurationKeys.NO_JDK, (Object)true);
        } else if (jdkKind == TestJdkKind.ANDROID_API) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)KtTestUtil.findAndroidApiJar());
            configuration.put(JVMConfigurationKeys.NO_JDK, (Object)true);
        } else if (jdkKind == TestJdkKind.FULL_JDK_6) {
            String jdk6 = System.getenv("JDK_16");
            assert (jdk6 != null) : "Environment variable JDK_16 is not set";
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)new File(jdk6));
        } else if (jdkKind == TestJdkKind.FULL_JDK_9) {
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)KtTestUtil.getJdk9Home());
        } else if (jdkKind == TestJdkKind.FULL_JDK_15) {
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)KtTestUtil.getJdk15Home());
        } else if (SystemInfo.IS_AT_LEAST_JAVA9) {
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)new File(System.getProperty("java.home")));
        }
        if (configurationKind.getWithRuntime()) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.runtimeJarForTests());
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.scriptRuntimeJarForTests());
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.kotlinTestJarForTests());
        } else if (configurationKind.getWithMockRuntime()) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.minimalRuntimeJarForTests());
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.scriptRuntimeJarForTests());
        }
        if (configurationKind.getWithReflection()) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.reflectJarForTests());
        }
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)configuration, classpath);
        CompilerConfiguration compilerConfiguration = configuration;
        if (compilerConfiguration == null) {
            KotlinTestUtils.$$$reportNull$$$0(17);
        }
        return compilerConfiguration;
    }

    public static void resolveAllKotlinFiles(KotlinCoreEnvironment environment) throws IOException {
        List roots = ContentRootsKt.getKotlinSourceRoots((CompilerConfiguration)environment.getConfiguration());
        if (roots.isEmpty()) {
            return;
        }
        ArrayList<KtFile> ktFiles = new ArrayList<KtFile>();
        for (KotlinSourceRoot root : roots) {
            File file = new File(root.getPath());
            if (file.isFile()) {
                ktFiles.add(KotlinTestUtils.loadJetFile(environment.getProject(), file));
                continue;
            }
            for (File childFile : file.listFiles()) {
                if (!childFile.getName().endsWith(".kt") && !childFile.getName().endsWith(".kts")) continue;
                ktFiles.add(KotlinTestUtils.loadJetFile(environment.getProject(), childFile));
            }
        }
        JvmResolveUtil.analyze(ktFiles, (KotlinCoreEnvironment)environment);
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull Editor editor) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            KotlinTestUtils.$$$reportNull$$$0(19);
        }
        KotlinTestUtils.assertEqualsToFile(expectedFile, editor, true);
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull Editor editor, Boolean enableSelectionTags) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            KotlinTestUtils.$$$reportNull$$$0(21);
        }
        Caret caret = editor.getCaretModel().getCurrentCaret();
        ArrayList tags = Lists.newArrayList((Object[])new TagsTestDataUtil.TagInfo[]{new TagsTestDataUtil.TagInfo<String>(caret.getOffset(), true, "caret")});
        if (enableSelectionTags.booleanValue()) {
            int selectionStart = caret.getSelectionStart();
            int selectionEnd = caret.getSelectionEnd();
            tags.add(new TagsTestDataUtil.TagInfo<String>(selectionStart, true, "selection"));
            tags.add(new TagsTestDataUtil.TagInfo<String>(selectionEnd, false, "selection"));
        }
        String afterText = TagsTestDataUtil.insertTagsInText(tags, editor.getDocument().getText(), t -> null);
        KotlinTestUtils.assertEqualsToFile(expectedFile, afterText);
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual2) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(22);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(23);
        }
        KotlinTestUtils.assertEqualsToFile(expectedFile, actual2, (Function1<String, String>)((Function1)s -> s));
    }

    public static void assertEqualsToFile(@NotNull String message, @NotNull File expectedFile, @NotNull String actual2) {
        if (message == null) {
            KotlinTestUtils.$$$reportNull$$$0(24);
        }
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(25);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(26);
        }
        KotlinTestUtils.assertEqualsToFile(message, expectedFile, actual2, (Function1<String, String>)((Function1)s -> s));
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual2, @NotNull Function1<String, String> sanitizer) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(27);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(28);
        }
        if (sanitizer == null) {
            KotlinTestUtils.$$$reportNull$$$0(29);
        }
        KotlinTestUtils.assertEqualsToFile("Actual data differs from file content", expectedFile, actual2, sanitizer);
    }

    public static void assertEqualsToFile(@NotNull String message, @NotNull File expectedFile, @NotNull String actual2, @NotNull Function1<String, String> sanitizer) {
        if (message == null) {
            KotlinTestUtils.$$$reportNull$$$0(30);
        }
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(31);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(32);
        }
        if (sanitizer == null) {
            KotlinTestUtils.$$$reportNull$$$0(33);
        }
        try {
            String expected;
            String expectedText;
            String actualText = StringUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF((String)StringUtil.convertLineSeparators((String)actual2.trim()));
            if (!expectedFile.exists()) {
                FileUtil.writeToFile((File)expectedFile, (String)actualText);
                Assert.fail((String)("Expected data file did not exist. Generating: " + expectedFile));
            }
            if (!Objects.equals(sanitizer.invoke((Object)(expectedText = StringUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF((String)StringUtil.convertLineSeparators((String)(expected = FileUtil.loadFile((File)expectedFile, (String)"UTF-8", (boolean)true)).trim())))), sanitizer.invoke((Object)actualText))) {
                throw new FileComparisonFailure(message + ": " + expectedFile.getName(), expected, actual2, expectedFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    public static boolean compileKotlinWithJava(@NotNull List<File> javaFiles, @NotNull List<File> ktFiles, @NotNull File outDir, @NotNull Disposable disposable, @Nullable File javaErrorFile) throws IOException {
        if (javaFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(34);
        }
        if (ktFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(35);
        }
        if (outDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(36);
        }
        if (disposable == null) {
            KotlinTestUtils.$$$reportNull$$$0(37);
        }
        return KotlinTestUtils.compileKotlinWithJava(javaFiles, ktFiles, outDir, disposable, javaErrorFile, null);
    }

    public static boolean compileKotlinWithJava(@NotNull List<File> javaFiles, @NotNull List<File> ktFiles, @NotNull File outDir, @NotNull Disposable disposable, @Nullable File javaErrorFile, @Nullable Function1<CompilerConfiguration, Unit> updateConfiguration) throws IOException {
        if (javaFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(38);
        }
        if (ktFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(39);
        }
        if (outDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(40);
        }
        if (disposable == null) {
            KotlinTestUtils.$$$reportNull$$$0(41);
        }
        if (!ktFiles.isEmpty()) {
            KotlinCoreEnvironment environment = KotlinTestUtils.createEnvironmentWithFullJdkAndIdeaAnnotations(disposable);
            CompilerTestLanguageVersionSettingsKt.setupLanguageVersionSettingsForMultifileCompilerTests(ktFiles, environment);
            if (updateConfiguration != null) {
                updateConfiguration.invoke((Object)environment.getConfiguration());
            }
            LoadDescriptorUtil.compileKotlinToDirAndGetModule(ktFiles, outDir, environment);
        } else {
            boolean mkdirs = outDir.mkdirs();
            assert (mkdirs) : "Not created: " + outDir;
        }
        if (javaFiles.isEmpty()) {
            return true;
        }
        return KotlinTestUtils.compileJavaFiles(javaFiles, Arrays.asList("-classpath", outDir.getPath() + File.pathSeparator + ForTestCompileRuntime.runtimeJarForTests(), "-d", outDir.getPath()), javaErrorFile);
    }

    @NotNull
    public static Directives parseDirectives(String expectedText) {
        return KotlinTestUtils.parseDirectives(expectedText, new Directives());
    }

    @NotNull
    public static Directives parseDirectives(String expectedText, @NotNull Directives directives) {
        if (directives == null) {
            KotlinTestUtils.$$$reportNull$$$0(42);
        }
        Matcher directiveMatcher = DIRECTIVE_PATTERN.matcher(expectedText);
        while (directiveMatcher.find()) {
            String name = directiveMatcher.group(1);
            String value = directiveMatcher.group(3);
            directives.put(name, value);
        }
        Directives directives2 = directives;
        if (directives2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(43);
        }
        return directives2;
    }

    public static List<String> loadBeforeAfterText(String filePath) {
        String content2;
        try {
            content2 = FileUtil.loadFile((File)new File(filePath), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<String> files = TestFiles.createTestFiles("", content2, new TestFiles.TestFileFactoryNoModules<String>(){

            @Override
            @NotNull
            public String create(@NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
                if (fileName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (directives == null) {
                    2.$$$reportNull$$$0(2);
                }
                int firstLineEnd = text.indexOf(10);
                String string = StringUtil.trimTrailing((String)text.substring(firstLineEnd + 1));
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "directives";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/test/KotlinTestUtils$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/test/KotlinTestUtils$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        Assert.assertTrue((String)"Exactly two files expected: ", (files.size() == 2 ? 1 : 0) != 0);
        return files;
    }

    public static String getLastCommentedLines(@NotNull Document document) {
        if (document == null) {
            KotlinTestUtils.$$$reportNull$$$0(44);
        }
        ArrayList<CharSequence> resultLines = new ArrayList<CharSequence>();
        for (int i = document.getLineCount() - 1; i >= 0; --i) {
            int lineStart = document.getLineStartOffset(i);
            int lineEnd = document.getLineEndOffset(i);
            if (document.getCharsSequence().subSequence(lineStart, lineEnd).toString().trim().isEmpty()) continue;
            if (!"//".equals(document.getCharsSequence().subSequence(lineStart, lineStart + 2).toString())) break;
            resultLines.add(document.getCharsSequence().subSequence(lineStart + 2, lineEnd));
        }
        Collections.reverse(resultLines);
        StringBuilder result = new StringBuilder();
        for (CharSequence line : resultLines) {
            result.append(line).append("\n");
        }
        result.delete(result.length() - 1, result.length());
        return result.toString();
    }

    @NotNull
    public static String getLastCommentInFile(@NotNull KtFile file) {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(45);
        }
        String string = (String)CollectionsKt.first(KotlinTestUtils.getLastCommentsInFile(file, CommentType.ALL, true));
        if (string == null) {
            KotlinTestUtils.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public static List<String> getLastCommentsInFile(@NotNull KtFile file, CommentType commentType, boolean assertMustExist) {
        PsiElement lastChild;
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(47);
        }
        if ((lastChild = file.getLastChild()) != null && lastChild.getNode().getElementType().equals(KtTokens.WHITE_SPACE)) {
            lastChild = lastChild.getPrevSibling();
        }
        assert (lastChild != null);
        ArrayList<String> comments = new ArrayList<String>();
        while (true) {
            if (lastChild.getNode().getElementType().equals(KtTokens.BLOCK_COMMENT)) {
                if (commentType == CommentType.ALL || commentType == CommentType.BLOCK_COMMENT) {
                    String lastChildText = lastChild.getText();
                    comments.add(lastChildText.substring(2, lastChildText.length() - 2).trim());
                }
            } else {
                if (!lastChild.getNode().getElementType().equals(KtTokens.EOL_COMMENT)) break;
                if (commentType == CommentType.ALL || commentType == CommentType.LINE_COMMENT) {
                    comments.add(lastChild.getText().substring(2).trim());
                }
            }
            lastChild = lastChild.getPrevSibling();
        }
        if (comments.isEmpty() && assertMustExist) {
            throw new AssertionError((Object)String.format("Test file '%s' should end in a comment of type %s; last node was: %s", new Object[]{file.getName(), commentType, lastChild}));
        }
        ArrayList<String> arrayList = comments;
        if (arrayList == null) {
            KotlinTestUtils.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    public static boolean compileJavaFiles(@NotNull Collection<File> files, List<String> options) throws IOException {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(49);
        }
        return KotlinTestUtils.compileJavaFiles(files, options, null);
    }

    private static boolean compileJavaFiles(@NotNull Collection<File> files, List<String> options, @Nullable File javaErrorFile) throws IOException {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(50);
        }
        return JvmCompilationUtils.compileJavaFiles(files, options, (File)javaErrorFile, (Assertions)JUnit4Assertions.INSTANCE);
    }

    public static boolean compileJavaFilesExternallyWithJava9(@NotNull Collection<File> files, @NotNull List<String> options) {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(51);
        }
        if (options == null) {
            KotlinTestUtils.$$$reportNull$$$0(52);
        }
        return JvmCompilationUtils.compileJavaFilesExternally(files, options, (File)KtTestUtil.getJdk9Home());
    }

    public static boolean compileJavaFilesExternally(@NotNull Collection<File> files, @NotNull List<String> options, @NotNull File jdkHome) {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(53);
        }
        if (options == null) {
            KotlinTestUtils.$$$reportNull$$$0(54);
        }
        if (jdkHome == null) {
            KotlinTestUtils.$$$reportNull$$$0(55);
        }
        return JvmCompilationUtils.compileJavaFilesExternally(files, options, (File)jdkHome);
    }

    public static String navigationMetadata(String testFile) {
        return testFile;
    }

    public static void runTest(@NotNull DoTest test2, @NotNull TestCase testCase, String testDataFile) throws Exception {
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(56);
        }
        if (testCase == null) {
            KotlinTestUtils.$$$reportNull$$$0(57);
        }
        KotlinTestUtils.runTestImpl(KotlinTestUtils.testWithCustomIgnoreDirective(test2, TargetBackend.ANY, "// IGNORE_BACKEND: "), testCase, testDataFile);
    }

    public static void runTest(@NotNull TestCase testCase, @NotNull Function0<Unit> test2) {
        if (testCase == null) {
            KotlinTestUtils.$$$reportNull$$$0(58);
        }
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(59);
        }
        MuteWithDatabaseKt.runTest(testCase, test2);
    }

    public static void runTestWithThrowable(@NotNull TestCase testCase, @NotNull RunnableWithThrowable test2) {
        if (testCase == null) {
            KotlinTestUtils.$$$reportNull$$$0(60);
        }
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(61);
        }
        MuteWithDatabaseKt.runTest(testCase, (Function0<Unit>)((Function0)() -> {
            try {
                test2.run();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(throwable);
            }
            return null;
        }));
    }

    public static void runTest(DoTest test2, TargetBackend targetBackend, String testDataFile) throws Exception {
        KotlinTestUtils.runTest0(test2, targetBackend, testDataFile);
    }

    public static void runTestWithCustomIgnoreDirective(DoTest test2, TargetBackend targetBackend, String testDataFile, String ignoreDirective) throws Exception {
        KotlinTestUtils.runTestImpl(KotlinTestUtils.testWithCustomIgnoreDirective(test2, targetBackend, ignoreDirective), null, testDataFile);
    }

    public static void runTest0(DoTest test2, TargetBackend targetBackend, String testDataFilePath) throws Exception {
        KotlinTestUtils.runTestImpl(KotlinTestUtils.testWithCustomIgnoreDirective(test2, targetBackend, "// IGNORE_BACKEND: "), null, testDataFilePath);
    }

    private static void runTestImpl(@NotNull DoTest test2, @Nullable TestCase testCase, String testDataFilePath) throws Exception {
        Function0<Unit> wrapWithMuteInDatabase;
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(62);
        }
        if (testCase != null && !KotlinTestUtils.isRunTestOverridden(testCase) && (wrapWithMuteInDatabase = MuteWithDatabaseKt.wrapWithMuteInDatabase(testCase, (Function0<Unit>)((Function0)() -> {
            try {
                test2.invoke(testDataFilePath);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return null;
        }))) != null) {
            wrapWithMuteInDatabase.invoke();
            return;
        }
        test2.invoke(testDataFilePath);
    }

    private static boolean isRunTestOverridden(TestCase testCase) {
        for (Class<?> type = testCase.getClass(); type != null; type = type.getSuperclass()) {
            for (Annotation annotation : type.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(WithMutedInDatabaseRunTest.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static DoTest testWithCustomIgnoreDirective(DoTest test2, TargetBackend targetBackend, String ignoreDirective) throws Exception {
        return filePath -> {
            File testDataFile = new File(filePath);
            boolean isIgnored = InTextDirectivesUtils.isIgnoredTarget((TargetBackend)targetBackend, (File)testDataFile, (String)ignoreDirective);
            if (DONT_IGNORE_TESTS_WORKING_ON_COMPATIBLE_BACKEND) {
                isIgnored &= InTextDirectivesUtils.isIgnoredTarget((TargetBackend)targetBackend.getCompatibleWith(), (File)testDataFile);
            }
            try {
                test2.invoke(filePath);
            }
            catch (Throwable e) {
                if (!isIgnored) {
                    // empty if block
                }
                if (RUN_IGNORED_TESTS_AS_REGULAR || !isIgnored) {
                    throw e;
                }
                if (PRINT_STACKTRACE_FOR_IGNORED_TESTS) {
                    e.printStackTrace();
                }
                return;
            }
            if (isIgnored) {
                throw new AssertionError((Object)String.format("Looks like this test can be unmuted. Remove \"%s%s\" directive.", ignoreDirective, targetBackend));
            }
        };
    }

    @Nullable
    public static String getTestDataFileName(@NotNull Class<?> testCaseClass, @NotNull String testName) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(63);
        }
        if (testName == null) {
            KotlinTestUtils.$$$reportNull$$$0(64);
        }
        try {
            Method method = testCaseClass.getDeclaredMethod(testName, new Class[0]);
            return KtTestUtil.getMethodMetadata((Method)method);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static KtFile loadJetFile(@NotNull Project project, @NotNull File ioFile) throws IOException {
        if (project == null) {
            KotlinTestUtils.$$$reportNull$$$0(65);
        }
        if (ioFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(66);
        }
        String text = FileUtil.loadFile((File)ioFile, (boolean)true);
        KtFile ktFile = KtPsiFactoryKt.KtPsiFactory((Project)project).createPhysicalFile(ioFile.getName(), text);
        if (ktFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(67);
        }
        return ktFile;
    }

    @NotNull
    public static List<KtFile> loadToJetFiles(@NotNull KotlinCoreEnvironment environment, @NotNull List<File> files) throws IOException {
        if (environment == null) {
            KotlinTestUtils.$$$reportNull$$$0(68);
        }
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(69);
        }
        ArrayList jetFiles = Lists.newArrayList();
        for (File file : files) {
            jetFiles.add(KotlinTestUtils.loadJetFile(environment.getProject(), file));
        }
        ArrayList arrayList = jetFiles;
        if (arrayList == null) {
            KotlinTestUtils.$$$reportNull$$$0(70);
        }
        return arrayList;
    }

    @NotNull
    public static ModuleDescriptorImpl createEmptyModule() {
        return KotlinTestUtils.createEmptyModule("<empty-for-test>");
    }

    @NotNull
    public static ModuleDescriptorImpl createEmptyModule(@NotNull String name) {
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(71);
        }
        return KotlinTestUtils.createEmptyModule(name, (KotlinBuiltIns)DefaultBuiltIns.getInstance());
    }

    @NotNull
    public static ModuleDescriptorImpl createEmptyModule(@NotNull String name, @NotNull KotlinBuiltIns builtIns) {
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(72);
        }
        if (builtIns == null) {
            KotlinTestUtils.$$$reportNull$$$0(73);
        }
        return new ModuleDescriptorImpl(Name.special((String)name), LockBasedStorageManager.NO_LOCKS, builtIns);
    }

    @NotNull
    public static File replaceExtension(@NotNull File file, @Nullable String newExtension) {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(74);
        }
        return new File(file.getParentFile(), FileUtil.getNameWithoutExtension((File)file) + (newExtension == null ? "" : "." + newExtension));
    }

    public static boolean isAllFilesPresentTest(String testName) {
        return testName.toLowerCase().startsWith("allfilespresentin");
    }

    public static boolean isMultiExtensionName(@NotNull String name) {
        int firstDotIndex;
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(75);
        }
        if ((firstDotIndex = name.indexOf(46)) == -1) {
            return false;
        }
        return name.indexOf(46, firstDotIndex + 1) != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 43: 
            case 46: 
            case 48: 
            case 67: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 43: 
            case 46: 
            case 48: 
            case 67: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 43: 
            case 46: 
            case 48: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/KotlinTestUtils";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKind";
                break;
            }
            case 4: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkKind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraClasspath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSource";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 23: 
            case 26: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sanitizer";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFiles";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktFiles";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directives";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
            case 56: 
            case 59: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 57: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCase";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 71: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/KotlinTestUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tmpDirForTest";
                break;
            }
            case 9: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newConfiguration";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDirectives";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommentInFile";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommentsInFile";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "loadJetFile";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "loadToJetFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 43: 
            case 46: 
            case 48: 
            case 67: 
            case 70: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentWithMockJdkAndIdeaAnnotations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newConfiguration";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "assertEqualsToFile";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "compileKotlinWithJava";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "parseDirectives";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommentedLines";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommentInFile";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommentsInFile";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaFiles";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaFilesExternallyWithJava9";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaFilesExternally";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "runTest";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "runTestWithThrowable";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "runTestImpl";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getTestDataFileName";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "loadJetFile";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "loadToJetFiles";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyModule";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "replaceExtension";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isMultiExtensionName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 43: 
            case 46: 
            case 48: 
            case 67: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DoTest {
        public void invoke(@NotNull String var1) throws Exception;
    }

    public static enum CommentType {
        ALL,
        LINE_COMMENT,
        BLOCK_COMMENT;

    }
}

