/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestResult;
import org.jetbrains.kotlin.test.IdeaSystemPropertiesForParallelRunConfigurator;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInnersForGradle;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInnersForJPS;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;

public class JUnit3RunnerWithInners
extends Runner
implements Filterable,
Sortable {
    private final Runner delegateRunner;

    public JUnit3RunnerWithInners(Class<?> klass) {
        this.delegateRunner = "true".equals(System.getProperty("use.jps")) ? new JUnit3RunnerWithInnersForJPS(klass) : new JUnit3RunnerWithInnersForGradle(klass);
    }

    public void run(RunNotifier notifier) {
        this.delegateRunner.run(notifier);
    }

    public Description getDescription() {
        return this.delegateRunner.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        ((Filterable)this.delegateRunner).filter(filter);
    }

    public void sort(Sorter sorter) {
        ((Sortable)this.delegateRunner).sort(sorter);
    }

    static boolean isTestMethod(Method method) {
        return method.getParameterTypes().length == 0 && method.getName().startsWith("test") && method.getReturnType().equals(Void.TYPE) && Modifier.isPublic(method.getModifiers());
    }

    static {
        IdeaSystemPropertiesForParallelRunConfigurator.setProperties();
    }

    static class FakeEmptyClassTest
    implements Test,
    Filterable {
        private final String className;

        FakeEmptyClassTest(Class<?> klass) {
            this.className = klass.getName();
        }

        public int countTestCases() {
            return 0;
        }

        public void run(TestResult result) {
            result.startTest((Test)this);
            result.endTest((Test)this);
        }

        public String toString() {
            return "Empty class with inners for " + this.className;
        }

        public void filter(Filter filter) throws NoTestsRemainException {
            throw new NoTestsRemainException();
        }
    }
}

