/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.AbstractResolvedCallsTest;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\u00042\u0006\u0010\u0016\u001a\u00020\u0013H\u0004J8\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u001e\u0010\u0019\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u00040\u0015H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/AbstractResolvedCallsTest;", "Lorg/jetbrains/kotlin/test/KotlinTestWithEnvironment;", "()V", "buildCachedCallAtIndex", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "jetFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "index", "", "createEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "doTest", "", "filePath", "", "extractCarets", "", "text", "renderOutput", "originalText", "resolvedCallsAt", "tests-common"})
public abstract class AbstractResolvedCallsTest
extends KotlinTestWithEnvironment {
    @Override
    @NotNull
    protected KotlinCoreEnvironment createEnvironment() {
        KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithMockJdk(ConfigurationKind.ALL);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"createEnvironmentWithMockJdk(ConfigurationKind.ALL)");
        return kotlinCoreEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    public final void doTest(@NotNull String filePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Pair<String, List<Integer>> pair = KtTestUtil.doLoadFile((File)new File(filePath));
        Intrinsics.checkNotNull((Object)pair);
        Pair<String, List<Integer>> originalText = pair;
        pair = this.extractCarets((String)originalText);
        String text = (String)pair.component1();
        List carets = (List)pair.component2();
        KotlinCoreEnvironment kotlinCoreEnvironment = this.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"environment");
        CompilerTestLanguageVersionSettingsKt.setupLanguageVersionSettingsForCompilerTests(originalText, kotlinCoreEnvironment);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        KtFile ktFile = new KtPsiFactory(project, false, 2, null).createFile(text);
        KotlinCoreEnvironment kotlinCoreEnvironment2 = this.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment2, (String)"environment");
        BindingContext bindingContext = JvmResolveUtil.analyze((KtFile)ktFile, (KotlinCoreEnvironment)kotlinCoreEnvironment2).getBindingContext();
        Iterable $this$map$iv = carets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiElement psiElement;
            ResolvedCall resolvedCall;
            void $this$doTest_u24lambda_u2d1_u24lambda_u2d0;
            void caret;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AbstractResolvedCallsTest abstractResolvedCallsTest = this;
            boolean bl2 = false;
            boolean bl3 = false;
            AbstractResolvedCallsTest abstractResolvedCallsTest2 = abstractResolvedCallsTest;
            Integer n2 = (int)caret;
            boolean bl4 = false;
            Pair<PsiElement, ResolvedCall<? extends CallableDescriptor>> pair2 = $this$doTest_u24lambda_u2d1_u24lambda_u2d0.buildCachedCallAtIndex(bindingContext, ktFile, (int)caret);
            PsiElement element = (PsiElement)pair2.component1();
            ResolvedCall cachedCall = (ResolvedCall)pair2.component2();
            ResolvedCall resolvedCall2 = resolvedCall = !(cachedCall instanceof VariableAsFunctionResolvedCall) ? cachedCall : (Intrinsics.areEqual((Object)"(", (Object)((psiElement = element) == null ? null : psiElement.getText())) ? ((VariableAsFunctionResolvedCall)cachedCall).getFunctionCall() : ((VariableAsFunctionResolvedCall)cachedCall).getVariableCall());
            Pair pair3 = TuplesKt.to((Object)n2, (Object)resolvedCall2);
            collection.add(pair3);
        }
        List resolvedCallsAt = (List)destination$iv$iv;
        String output = this.renderOutput((String)originalText, text, resolvedCallsAt);
        String resolvedCallInfoFileName = Intrinsics.stringPlus((String)FileUtil.getNameWithoutExtension((String)filePath), (Object)".txt");
        KotlinTestUtils.assertEqualsToFile(new File(resolvedCallInfoFileName), output);
    }

    @NotNull
    protected String renderOutput(@NotNull String originalText, @NotNull String text, @NotNull List<? extends Pair<Integer, ? extends ResolvedCall<?>>> resolvedCallsAt) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(resolvedCallsAt, (String)"resolvedCallsAt");
        return CollectionsKt.joinToString$default((Iterable)resolvedCallsAt, (CharSequence)"\n\n", (CharSequence)Intrinsics.stringPlus((String)originalText, (Object)"\n\n\n"), null, (int)0, null, (Function1)renderOutput.1.INSTANCE, (int)28, null);
    }

    @NotNull
    protected final Pair<String, List<Integer>> extractCarets(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String[] stringArray = new String[]{"<caret>"};
        List parts = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() < 2) {
            return TuplesKt.to((Object)text, (Object)CollectionsKt.emptyList());
        }
        boolean bl = false;
        List indices = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        boolean bl5 = false;
        StringBuilder $this$extractCarets_u24lambda_u2d3 = stringBuilder;
        boolean bl6 = false;
        Iterable $this$forEach$iv = CollectionsKt.dropLast((List)parts, (int)1);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String part = (String)element$iv;
            boolean bl7 = false;
            $this$extractCarets_u24lambda_u2d3.append(part);
            indices.add($this$extractCarets_u24lambda_u2d3.length());
        }
        $this$extractCarets_u24lambda_u2d3.append((String)CollectionsKt.last((List)parts));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String resultText = string;
        return TuplesKt.to((Object)resultText, (Object)indices);
    }

    @NotNull
    protected Pair<PsiElement, ResolvedCall<? extends CallableDescriptor>> buildCachedCallAtIndex(@NotNull BindingContext bindingContext, @NotNull KtFile jetFile, int index) {
        KtExpression expression;
        PsiElement psiElement;
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)jetFile, (String)"jetFile");
        PsiElement psiElement2 = jetFile.findElementAt(index);
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement $this$getStrictParentOfType$iv = element = (psiElement = psiElement2);
        boolean $i$f$getStrictParentOfType = false;
        KtExpression ktExpression = expression = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtExpression.class, (boolean)true);
        ResolvedCall cachedCall = ktExpression == null ? null : CallUtilKt.getParentResolvedCall((KtElement)((KtElement)ktExpression), (BindingContext)bindingContext, (boolean)false);
        return new Pair((Object)element, (Object)cachedCall);
    }
}

