/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ExpectedResolveData;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.test.TestFiles;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.util.KtTestUtil;

public abstract class ExtensibleResolveTestCase
extends KotlinTestWithEnvironment {
    private ExpectedResolveData expectedResolveData;

    @Override
    protected KotlinCoreEnvironment createEnvironment() {
        CompilerConfiguration configuration = KotlinTestUtils.newConfiguration(ConfigurationKind.JDK_ONLY, TestJdkKind.MOCK_JDK, new File[0]);
        configuration.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, (Object)true);
        return KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedResolveData = this.getExpectedResolveData();
    }

    @Override
    protected void tearDown() throws Exception {
        this.expectedResolveData = null;
        super.tearDown();
    }

    protected abstract ExpectedResolveData getExpectedResolveData();

    protected void doTest(@NonNls String filePath) throws Exception {
        File file = new File(filePath);
        String text = KtTestUtil.doLoadFile((File)file);
        List<KtFile> files = TestFiles.createTestFiles("file.kt", text, new TestFiles.TestFileFactoryNoModules<KtFile>(){

            @Override
            @NotNull
            public KtFile create(@NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
                if (fileName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (directives == null) {
                    1.$$$reportNull$$$0(2);
                }
                KtFile ktFile = ExtensibleResolveTestCase.this.expectedResolveData.createFileFromMarkedUpText(fileName, text);
                if (ktFile == null) {
                    1.$$$reportNull$$$0(3);
                }
                return ktFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "directives";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/resolve/ExtensibleResolveTestCase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/resolve/ExtensibleResolveTestCase$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        this.expectedResolveData.checkResult(ExpectedResolveData.analyze(files, this.getEnvironment()));
    }
}

