/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.openapi.Disposable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.jvm.compiler.AbstractCompileJavaAgainstKotlinTest;
import org.jetbrains.kotlin.jvm.compiler.AbstractLoadJavaTest;
import org.jetbrains.kotlin.jvm.compiler.LoadDescriptorUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TestCaseWithTmpdir;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparator;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparatorAdaptor;
import org.junit.Assert;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0004J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractCompileJavaAgainstKotlinTest;", "Lorg/jetbrains/kotlin/test/TestCaseWithTmpdir;", "()V", "compileKotlinWithJava", "", "javaFiles", "", "Ljava/io/File;", "ktFiles", "outDir", "disposable", "Lcom/intellij/openapi/Disposable;", "doTest", "", "ktFilePath", "", "useJavac", "doTestWithJavac", "doTestWithoutJavac", "updateConfiguration", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "tests-common"})
public abstract class AbstractCompileJavaAgainstKotlinTest
extends TestCaseWithTmpdir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final RecursiveDescriptorComparator.Configuration CONFIGURATION = AbstractLoadJavaTest.COMPARATOR_CONFIGURATION.withRenderer(DescriptorRenderer.Companion.withOptions((Function1)Companion.CONFIGURATION.1.INSTANCE));

    protected final void doTestWithJavac(@NotNull String ktFilePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ktFilePath, (String)"ktFilePath");
        this.doTest(ktFilePath, true);
    }

    protected final void doTestWithoutJavac(@NotNull String ktFilePath) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ktFilePath, (String)"ktFilePath");
        this.doTest(ktFilePath, false);
    }

    protected final void doTest(@NotNull String ktFilePath, boolean useJavac) throws IOException {
        boolean compiledSuccessfully2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)ktFilePath, (String)"ktFilePath");
        Assert.assertTrue((boolean)StringsKt.endsWith$default((String)ktFilePath, (String)".kt", (boolean)false, (int)2, null));
        File ktFile = new File(ktFilePath);
        CharSequence charSequence = ktFilePath;
        CharSequence charSequence2 = "\\.kt$";
        boolean bl2 = false;
        charSequence2 = new Regex(charSequence2);
        String string = ".java";
        boolean bl3 = false;
        File javaFile = new File(charSequence2.replaceFirst(charSequence, string));
        charSequence2 = ktFilePath;
        string = "\\.kt$";
        bl3 = false;
        string = new Regex(string);
        String string2 = ".javaerr.txt";
        boolean bl4 = false;
        File javaErrorFile = new File(string.replaceFirst(charSequence2, string2));
        File out = new File(this.tmpdir, "out");
        if (useJavac) {
            List list = CollectionsKt.listOf((Object)javaFile);
            List list2 = CollectionsKt.listOf((Object)ktFile);
            string2 = this.getTestRootDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"testRootDisposable");
            bl = this.compileKotlinWithJava(list, list2, out, (Disposable)string2);
        } else {
            bl = compiledSuccessfully2 = KotlinTestUtils.compileKotlinWithJava(CollectionsKt.listOf((Object)javaFile), CollectionsKt.listOf((Object)ktFile), out, this.getTestRootDisposable(), javaErrorFile, (Function1<CompilerConfiguration, Unit>)((Function1)new Function1<CompilerConfiguration, Unit>(this){

                public final void invoke(@NotNull CompilerConfiguration p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((AbstractCompileJavaAgainstKotlinTest)((Object)this.receiver)).updateConfiguration(p0);
                }

                @NotNull
                public final String getSignature() {
                    return "updateConfiguration(Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V";
                }

                @NotNull
                public final String getName() {
                    return "updateConfiguration";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(AbstractCompileJavaAgainstKotlinTest.class);
                }
            }));
        }
        if (!compiledSuccessfully2) {
            return;
        }
        File[] fileArray = new File[]{KtTestUtil.getAnnotationsJar(), out};
        CompilerConfiguration compilerConfiguration = KotlinTestUtils.newConfiguration(ConfigurationKind.ALL, TestJdkKind.FULL_JDK, fileArray);
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"newConfiguration(\n            ConfigurationKind.ALL, TestJdkKind.FULL_JDK,\n            KtTestUtil.getAnnotationsJar(), out)");
        CompilerConfiguration configuration = compilerConfiguration;
        configuration.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, (Object)true);
        fileArray = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"testRootDisposable");
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForTests((Disposable)fileArray, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        CompilerTestLanguageVersionSettingsKt.setupLanguageVersionSettingsForCompilerTests(FilesKt.readText$default((File)ktFile, null, (int)1, null), environment);
        AnalysisResult analysisResult = JvmResolveUtil.analyze((KotlinCoreEnvironment)environment);
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        FqName fqName = LoadDescriptorUtil.TEST_PACKAGE_FQNAME;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"TEST_PACKAGE_FQNAME");
        PackageViewDescriptor packageView = moduleDescriptor.getPackage(fqName);
        TestCaseWithTmpdir.assertFalse((String)Intrinsics.stringPlus((String)"Nothing found in package ", (Object)LoadDescriptorUtil.TEST_PACKAGE_FQNAME), (boolean)packageView.isEmpty());
        CharSequence charSequence3 = ktFilePath;
        String string3 = "\\.kt$";
        boolean bl5 = false;
        string3 = new Regex(string3);
        String string4 = ".txt";
        boolean bl6 = false;
        File expectedFile = new File(string3.replaceFirst(charSequence3, string4));
        RecursiveDescriptorComparatorAdaptor.validateAndCompareDescriptorWithFile((DeclarationDescriptor)packageView, CONFIGURATION, expectedFile);
    }

    public void updateConfiguration(@NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean compileKotlinWithJava(@NotNull List<? extends File> javaFiles, @NotNull List<? extends File> ktFiles, @NotNull File outDir, @NotNull Disposable disposable) throws IOException {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(javaFiles, (String)"javaFiles");
        Intrinsics.checkNotNullParameter(ktFiles, (String)"ktFiles");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Object object = KotlinTestUtils.createEnvironmentWithMockJdkAndIdeaAnnotations(disposable);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"createEnvironmentWithMockJdkAndIdeaAnnotations(disposable)");
        KotlinCoreEnvironment environment = object;
        CompilerTestLanguageVersionSettingsKt.setupLanguageVersionSettingsForMultifileCompilerTests(ktFiles, environment);
        environment.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, (Object)true);
        environment.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, (Object)true);
        environment.getConfiguration().put(JVMConfigurationKeys.OUTPUT_DIRECTORY, (Object)outDir);
        environment.getConfiguration().put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)MessageCollector.Companion.getNONE());
        this.updateConfiguration(environment.getConfiguration());
        KotlinCoreEnvironment.registerJavac$default((KotlinCoreEnvironment)environment, javaFiles, (List)CollectionsKt.listOf((Object)KotlinTestUtils.loadJetFile(environment.getProject(), (File)CollectionsKt.first(ktFiles))), null, null, null, (int)28, null);
        if (!ktFiles.isEmpty()) {
            LoadDescriptorUtil.compileKotlinToDirAndGetModule(ktFiles, outDir, environment);
        } else {
            boolean mkdirs = outDir.mkdirs();
            bl2 = false;
            if (_Assertions.ENABLED && !mkdirs) {
                boolean bl3 = false;
                String string = Intrinsics.stringPlus((String)"Not created: ", (Object)outDir);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        object = (Closeable)JavacWrapper.Companion.getInstance(environment.getProject());
        bl2 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            JavacWrapper it = (JavacWrapper)object;
            boolean bl5 = false;
            bl = JavacWrapper.compile$default((JavacWrapper)it, null, (int)1, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractCompileJavaAgainstKotlinTest$Companion;", "", "()V", "CONFIGURATION", "Lorg/jetbrains/kotlin/test/util/RecursiveDescriptorComparator$Configuration;", "kotlin.jvm.PlatformType", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

