/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.BaseDiagnosticsTest;
import org.jetbrains.kotlin.fir.AbstractFirDiagnosticsTest;
import org.jetbrains.kotlin.fir.FirResolveBenchKt;
import org.jetbrains.kotlin.fir.FirRuntimeException;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirTestUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessorKt;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\n0\bH\u0014J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J<\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0019\u001a\f\u0012\b\u0012\u00060\tR\u00020\n0\b2\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\b0\u001bH\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/AbstractFirOldFrontendDiagnosticsTest;", "Lorg/jetbrains/kotlin/fir/AbstractFirDiagnosticsTest;", "()V", "analyzeAndCheck", "", "testDataFile", "Ljava/io/File;", "files", "", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;", "checkFailureFile", "failure", "Lorg/jetbrains/kotlin/fir/FirRuntimeException;", "failureFile", "checkResultingFirFiles", "firFiles", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "createTestFileFromPath", "filePath", "", "prepareTestDataFile", "originalFilePath", "firTestDataFile", "runAnalysis", "testFiles", "firFilesPerSession", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "tests-common"})
public abstract class AbstractFirOldFrontendDiagnosticsTest
extends AbstractFirDiagnosticsTest {
    @Override
    @NotNull
    protected File createTestFileFromPath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String newPath = StringsKt.contains$default((CharSequence)FilesKt.readText$default((File)new File(filePath), null, (int)1, null), (CharSequence)"// FIR_IDENTICAL", (boolean)false, (int)2, null) ? filePath : StringsKt.replace$default((String)filePath, (String)".kt", (String)".fir.kt", (boolean)false, (int)4, null);
        File file = new File(newPath);
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        this.prepareTestDataFile(filePath, it);
        return file;
    }

    private final void prepareTestDataFile(String originalFilePath, File firTestDataFile) {
        if (!firTestDataFile.exists()) {
            KotlinTestUtils.assertEqualsToFile(firTestDataFile, FirTestUtilsKt.loadTestDataWithDiagnostics(new File(originalFilePath)));
        }
    }

    @Override
    protected void analyzeAndCheck(@NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> files) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BaseDiagnosticsTest.TestFile it = (BaseDiagnosticsTest.TestFile)element$iv;
                    boolean bl2 = false;
                    if (!it.directives.contains("FIR_IGNORE")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        super.analyzeAndCheck(testDataFile, files);
    }

    @Override
    protected void runAnalysis(@NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> testFiles, @NotNull Map<FirSession, ? extends List<? extends FirFile>> firFilesPerSession) {
        Object firFiles;
        Object object;
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        Intrinsics.checkNotNullParameter(firFilesPerSession, (String)"firFilesPerSession");
        try {
            Object object2 = firFilesPerSession;
            boolean bl = false;
            object = object2.entrySet().iterator();
            while (object.hasNext()) {
                Object object3 = object2 = (Map.Entry)object.next();
                boolean bl2 = false;
                FirSession session = (FirSession)object3.getKey();
                Object object4 = object2;
                boolean bl3 = false;
                firFiles = (List)object4.getValue();
                FirResolveBenchKt.doFirResolveTestBench$default((List)firFiles, FirTotalResolveProcessorKt.createAllCompilerResolveProcessors$default((FirSession)session, null, (boolean)false, (int)6, null), false, false, false, 24, null);
            }
            object = null;
        }
        catch (FirRuntimeException e) {
            object = e;
        }
        FirRuntimeException failure = object;
        String e = testDataFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)e, (String)"testDataFile.path");
        File failureFile = new File(StringsKt.replace$default((String)e, (String)".kt", (String)".fail", (boolean)false, (int)4, null));
        if (failure == null) {
            boolean needDump;
            List allFirFiles;
            block11: {
                boolean bl;
                allFirFiles = CollectionsKt.flatten((Iterable)firFilesPerSession.values());
                this.checkResultingFirFiles(allFirFiles, testDataFile);
                KtUsefulTestCase.assertFalse((String)"Test is good but there is expected exception", (boolean)failureFile.exists());
                this.checkDiagnostics(testDataFile, testFiles, allFirFiles);
                String session = testDataFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)session, (String)"testDataFile.absolutePath");
                if (StringsKt.endsWith$default((String)session, (String)".fir.kt", (boolean)false, (int)2, null)) {
                    firFiles = testDataFile.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)firFiles, (String)"testDataFile.absolutePath");
                    File oldFrontendTestDataFile = new File(StringsKt.replace$default((String)firFiles, (String)".fir.kt", (String)".kt", (boolean)false, (int)4, null));
                    FirTestUtilsKt.compareAndMergeFirFileAndOldFrontendFile$default(oldFrontendTestDataFile, testDataFile, false, 4, null);
                }
                Iterable $this$any$iv = testFiles;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        BaseDiagnosticsTest.TestFile it = (BaseDiagnosticsTest.TestFile)element$iv;
                        boolean bl4 = false;
                        if (!it.directives.contains("FIR_DUMP")) continue;
                        bl = true;
                        break block11;
                    }
                    bl = needDump = false;
                }
            }
            if (needDump) {
                this.checkFir(testDataFile, allFirFiles);
            }
            this.checkCfg(allFirFiles, testFiles, testDataFile);
        } else {
            if (!failureFile.exists()) {
                throw failure;
            }
            this.checkFailureFile(failure, failureFile);
        }
    }

    private final void checkFailureFile(FirRuntimeException failure, File failureFile) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$checkFailureFile_u24lambda_u2d3 = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$checkFailureFile_u24lambda_u2d3;
        Object object = failure.getMessage();
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        $this$checkFailureFile_u24lambda_u2d3.append("Cause: ");
        stringBuilder2 = $this$checkFailureFile_u24lambda_u2d3;
        object = failure.getCause();
        bl6 = false;
        StringBuilder stringBuilder5 = stringBuilder2.append(object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        stringBuilder4 = stringBuilder5;
        bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String failureMessage = string;
        KotlinTestUtils.assertEqualsToFile(failureFile, failureMessage);
    }

    protected void checkResultingFirFiles(@NotNull List<? extends FirFile> firFiles, @NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
    }
}

