/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.intellij.openapi.Disposable;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.BaseDiagnosticsTest;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.script.ScriptTestUtilKt;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.TestFiles;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 :*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005:\u0002:;B\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015H\u0004J/\u0010\u0017\u001a\u00028\u00012\b\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH$\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001aH\u0014JD\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u001a2$\u0010#\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0014\u0012\u00120%R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000$H\u0014J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00010\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u001aH\u0014J3\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010(\u001a\u00020\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00122\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H$\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020-2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u001e\u0010.\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010/\u001a\u000200H\u0014J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0014J\b\u00102\u001a\u00020\u0015H\u0014J\b\u00103\u001a\u00020\u0015H\u0014J\b\u00104\u001a\u00020-H\u0016J*\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\b2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u000608R\u0002090\u0012H\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/checkers/KotlinMultiFileTestWithJava;", "M", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;", "F", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "Lorg/jetbrains/kotlin/test/KotlinBaseTest;", "()V", "javaFilesDir", "Ljava/io/File;", "getJavaFilesDir", "()Ljava/io/File;", "setJavaFilesDir", "(Ljava/io/File;)V", "kotlinSourceRoot", "createEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "file", "files", "", "additionalClasspath", "usePsiClassFilesReading", "", "excludeNonTypeUseJetbrainsAnnotations", "createTestFile", "module", "fileName", "", "text", "directives", "Lorg/jetbrains/kotlin/test/Directives;", "(Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/test/Directives;)Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "createTestFileFromPath", "filePath", "createTestFiles", "expectedText", "modules", "", "Lorg/jetbrains/kotlin/checkers/KotlinMultiFileTestWithJava$ModuleAndDependencies;", "createTestFilesFromFile", "createTestModule", "name", "dependencies", "friends", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;", "doTest", "", "getClasspath", "getEnvironmentConfigFiles", "Lorg/jetbrains/kotlin/cli/jvm/compiler/EnvironmentConfigFiles;", "getExtraClasspath", "isJavaSourceRootNeeded", "isKotlinSourceRootNeeded", "setUp", "setupEnvironment", "environment", "testDataFile", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;", "Companion", "ModuleAndDependencies", "tests-common"})
public abstract class KotlinMultiFileTestWithJava<M extends KotlinBaseTest.TestModule, F extends KotlinBaseTest.TestFile>
extends KotlinBaseTest<F> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected File javaFilesDir;
    @Nullable
    private File kotlinSourceRoot;

    @NotNull
    protected final File getJavaFilesDir() {
        File file = this.javaFilesDir;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"javaFilesDir");
        throw null;
    }

    protected final void setJavaFilesDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.javaFilesDir = file;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        File file = KtTestUtil.tmpDir((String)"java-files");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tmpDir(\"java-files\")");
        this.setJavaFilesDir(file);
        if (this.isKotlinSourceRootNeeded()) {
            this.kotlinSourceRoot = KtTestUtil.tmpDir((String)"kotlin-src");
        }
    }

    @Override
    @NotNull
    protected List<F> createTestFilesFromFile(@NotNull File file, @NotNull String expectedText) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        return this.createTestFiles(file, expectedText, new HashMap());
    }

    @NotNull
    protected final KotlinCoreEnvironment createEnvironment(@NotNull File file, @NotNull List<? extends F> files, @Nullable File additionalClasspath, boolean usePsiClassFilesReading, boolean excludeNonTypeUseJetbrainsAnnotations) {
        String string;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        List defaultClasspath = this.getClasspath(file, excludeNonTypeUseJetbrainsAnnotations);
        CompilerConfiguration configuration = this.createConfiguration(this.extractConfigurationKind(files), this.getTestJdkKind(files), this.getBackend(), additionalClasspath == null ? defaultClasspath : CollectionsKt.plus((Collection)defaultClasspath, (Object)additionalClasspath), this.isJavaSourceRootNeeded() ? CollectionsKt.listOf((Object)this.getJavaFilesDir()) : CollectionsKt.emptyList(), files);
        if (KotlinMultiFileTestWithJava.Companion.isScriptingNeeded(file)) {
            ScriptTestUtilKt.loadScriptingPlugin((CompilerConfiguration)configuration);
        }
        if (this.isKotlinSourceRootNeeded()) {
            File file2 = this.kotlinSourceRoot;
            Intrinsics.checkNotNull((Object)file2);
            string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceRoot!!.path");
            ContentRootsKt.addKotlinSourceRoot$default((CompilerConfiguration)configuration, (String)string, (boolean)false, (int)2, null);
        }
        configuration.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, (Object)usePsiClassFilesReading);
        this.updateConfiguration(configuration);
        string = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testRootDisposable");
        return KotlinCoreEnvironment.Companion.createForTests((Disposable)string, configuration, this.getEnvironmentConfigFiles());
    }

    public static /* synthetic */ KotlinCoreEnvironment createEnvironment$default(KotlinMultiFileTestWithJava kotlinMultiFileTestWithJava, File file, List list, File file2, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createEnvironment");
        }
        if ((n & 4) != 0) {
            file2 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return kotlinMultiFileTestWithJava.createEnvironment(file, list, file2, bl, bl2);
    }

    protected boolean isJavaSourceRootNeeded() {
        return true;
    }

    protected void setupEnvironment(@NotNull KotlinCoreEnvironment environment, @NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.setupEnvironment(environment);
    }

    private final List<File> getClasspath(File file, boolean excludeNonTypeUseJetbrainsAnnotations) {
        List result = new ArrayList();
        if (!excludeNonTypeUseJetbrainsAnnotations) {
            File file2 = KtTestUtil.getAnnotationsJar();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAnnotationsJar()");
            result.add(file2);
        }
        result.addAll((Collection)this.getExtraClasspath());
        String fileText = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
        if (InTextDirectivesUtils.isDirectiveDefined((String)fileText, (String)"STDLIB_JDK8")) {
            File file3 = ForTestCompileRuntime.runtimeJarForTestsWithJdk8();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"runtimeJarForTestsWithJdk8()");
            result.add(file3);
        }
        return result;
    }

    @NotNull
    protected List<File> getExtraClasspath() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected EnvironmentConfigFiles getEnvironmentConfigFiles() {
        return EnvironmentConfigFiles.JVM_CONFIG_FILES;
    }

    protected boolean isKotlinSourceRootNeeded() {
        return false;
    }

    @NotNull
    protected File createTestFileFromPath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return new File(filePath);
    }

    @Override
    public void doTest(@NotNull String filePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = this.createTestFileFromPath(filePath);
        String expectedText = KtTestUtil.doLoadFile((File)file);
        if (InTextDirectivesUtils.isDirectiveDefined((String)expectedText, (String)"// SKIP_JAVAC")) {
            return;
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        super.doTest(string);
    }

    @Nullable
    protected abstract M createTestModule(@NotNull String var1, @NotNull List<String> var2, @NotNull List<String> var3);

    @NotNull
    protected abstract F createTestFile(@Nullable M var1, @NotNull String var2, @NotNull String var3, @NotNull Directives var4);

    @NotNull
    protected List<F> createTestFiles(@NotNull File file, @NotNull String expectedText, @NotNull Map<String, ModuleAndDependencies> modules) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)expectedText, (String)"expectedText");
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        List list = TestFiles.createTestFiles(file.getName(), expectedText, new TestFiles.TestFileFactory<M, F>(this, modules){
            final /* synthetic */ KotlinMultiFileTestWithJava<M, F> this$0;
            final /* synthetic */ Map<String, ModuleAndDependencies> $modules;
            {
                this.this$0 = $receiver;
                this.$modules = $modules;
            }

            @NotNull
            public F createFile(@Nullable M module2, @NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
                if (StringsKt.endsWith$default((String)fileName, (String)".java", (boolean)false, (int)2, null)) {
                    this.writeSourceFile(fileName, text, this.this$0.getJavaFilesDir());
                }
                if ((StringsKt.endsWith$default((String)fileName, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)fileName, (String)".kts", (boolean)false, (int)2, null)) && KotlinMultiFileTestWithJava.access$getKotlinSourceRoot$p(this.this$0) != null) {
                    File file = KotlinMultiFileTestWithJava.access$getKotlinSourceRoot$p(this.this$0);
                    Intrinsics.checkNotNull((Object)file);
                    this.writeSourceFile(fileName, text, file);
                }
                return this.this$0.createTestFile(module2, fileName, text, directives);
            }

            @Nullable
            public M createModule(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                Intrinsics.checkNotNullParameter(friends, (String)"friends");
                M module2 = this.this$0.createTestModule(name, dependencies, friends);
                ModuleAndDependencies oldValue = this.$modules.put(name, new ModuleAndDependencies(this.this$0, module2, dependencies, friends));
                boolean bl = oldValue == null;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Module " + name + " declared more than once";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                return module2;
            }

            private final void writeSourceFile(String fileName, String content2, File targetDir) {
                File tmpFile = new File(targetDir, fileName);
                KtTestUtil.mkdirs((File)tmpFile.getParentFile());
                FilesKt.writeText((File)tmpFile, (String)content2, (Charset)Charsets.UTF_8);
            }
        });
        Intrinsics.checkNotNullExpressionValue(list, (String)"protected open fun createTestFiles(\n        file: File,\n        expectedText: String,\n        modules: MutableMap<String?, ModuleAndDependencies>\n    ): List<F> {\n        return TestFiles.createTestFiles(file.name, expectedText, object : TestFileFactory<M, F> {\n            override fun createFile(\n                module: M?,\n                fileName: String,\n                text: String,\n                directives: Directives\n            ): F {\n                if (fileName.endsWith(\".java\")) {\n                    writeSourceFile(fileName, text, javaFilesDir)\n                }\n                if ((fileName.endsWith(\".kt\") || fileName.endsWith(\".kts\")) && kotlinSourceRoot != null) {\n                    writeSourceFile(fileName, text, kotlinSourceRoot!!)\n                }\n                return createTestFile(module, fileName, text, directives)\n            }\n\n            override fun createModule(name: String, dependencies: List<String>, friends: List<String>): M? {\n                val module = createTestModule(name, dependencies, friends)\n                val oldValue = modules.put(name, ModuleAndDependencies(module, dependencies, friends))\n                assert(oldValue == null) { \"Module $name declared more than once\" }\n                return module\n            }\n\n            private fun writeSourceFile(fileName: String, content: String, targetDir: File) {\n                val tmpFile = File(targetDir, fileName)\n                KtTestUtil.mkdirs(tmpFile.parentFile)\n                tmpFile.writeText(content, Charsets.UTF_8)\n            }\n        })\n    }");
        return list;
    }

    public static final /* synthetic */ File access$getKotlinSourceRoot$p(KotlinMultiFileTestWithJava $this) {
        return $this.kotlinSourceRoot;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B-\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0015\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/checkers/KotlinMultiFileTestWithJava$ModuleAndDependencies;", "", "module", "dependencies", "", "", "friends", "(Lorg/jetbrains/kotlin/checkers/KotlinMultiFileTestWithJava;Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;Ljava/util/List;Ljava/util/List;)V", "getDependencies", "()Ljava/util/List;", "getFriends", "getModule", "()Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;", "tests-common"})
    public static final class ModuleAndDependencies {
        @Nullable
        private final M module;
        @NotNull
        private final List<String> dependencies;
        @NotNull
        private final List<String> friends;
        final /* synthetic */ KotlinMultiFileTestWithJava<M, F> this$0;

        public ModuleAndDependencies(@NotNull M module2, @NotNull List<String> dependencies, List<String> friends) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            this.this$0 = this$0;
            this.module = module2;
            this.dependencies = dependencies;
            this.friends = friends;
        }

        @Nullable
        public final M getModule() {
            return this.module;
        }

        @NotNull
        public final List<String> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final List<String> getFriends() {
            return this.friends;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/checkers/KotlinMultiFileTestWithJava$Companion;", "", "()V", "isScriptingNeeded", "", "file", "Ljava/io/File;", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isScriptingNeeded(File file) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return StringsKt.endsWith$default((String)string, (String)KotlinParserDefinition.STD_SCRIPT_EXT, (boolean)false, (int)2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

