/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cfg.CFGraphToDotFilePrinter;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeLabel;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeUtil;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironmentManagement;

public abstract class AbstractPseudocodeTest
extends KotlinTestWithEnvironmentManagement {
    protected void doTestWithStdLib(String fileName) throws Exception {
        this.doTestWithEnvironment(fileName, this.createEnvironmentWithMockJdk(ConfigurationKind.NO_KOTLIN_REFLECT));
    }

    protected void doTest(String fileName) throws Exception {
        this.doTestWithEnvironment(fileName, this.createEnvironmentWithMockJdk(ConfigurationKind.JDK_ONLY));
    }

    private void doTestWithEnvironment(String fileName, KotlinCoreEnvironment environment) throws Exception {
        File file = new File(fileName);
        CompilerTestLanguageVersionSettingsKt.setupLanguageVersionSettingsForCompilerTests(FileUtil.loadFile((File)file, (boolean)true), environment);
        KtFile ktFile = KotlinTestUtils.loadJetFile(environment.getProject(), file);
        LinkedHashMultimap data = LinkedHashMultimap.create();
        AnalysisResult analysisResult = KotlinTestUtils.analyzeFile(ktFile, environment);
        List declarations = ktFile.getDeclarations();
        BindingContext bindingContext = analysisResult.getBindingContext();
        for (KtDeclaration declaration : declarations) {
            AbstractPseudocodeTest.addDeclaration((SetMultimap<KtElement, Pseudocode>)data, bindingContext, declaration);
            if (!(declaration instanceof KtDeclarationContainer)) continue;
            for (KtDeclaration member : ((KtDeclarationContainer)declaration).getDeclarations()) {
                if (!(member instanceof KtNamedFunction) && !(member instanceof KtSecondaryConstructor)) continue;
                AbstractPseudocodeTest.addDeclaration((SetMultimap<KtElement, Pseudocode>)data, bindingContext, member);
            }
        }
        try {
            this.processCFData(file, (SetMultimap<KtElement, Pseudocode>)data, bindingContext);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if ("true".equals(System.getProperty("kotlin.control.flow.test.dump.graphs"))) {
                CFGraphToDotFilePrinter.dumpDot(file, data.values());
            }
        }
    }

    private static void addDeclaration(SetMultimap<KtElement, Pseudocode> data, BindingContext bindingContext, KtDeclaration declaration) {
        Pseudocode pseudocode = PseudocodeUtil.generatePseudocode((KtDeclaration)declaration, (BindingContext)bindingContext);
        data.put((Object)declaration, (Object)pseudocode);
        for (LocalFunctionDeclarationInstruction instruction : pseudocode.getLocalDeclarations()) {
            Pseudocode localPseudocode = instruction.getBody();
            data.put((Object)localPseudocode.getCorrespondingElement(), (Object)localPseudocode);
        }
    }

    private void processCFData(File file, SetMultimap<KtElement, Pseudocode> data, BindingContext bindingContext) throws IOException {
        Collection pseudocodes = data.values();
        StringBuilder instructionDump = new StringBuilder();
        int i = 0;
        for (Pseudocode pseudocode : pseudocodes) {
            String label;
            boolean isAnonymousFunction;
            KtElement correspondingElement = pseudocode.getCorrespondingElement();
            assert (correspondingElement instanceof KtNamedDeclaration || correspondingElement instanceof KtPropertyAccessor) : "Unexpected element class is pseudocode: " + correspondingElement.getClass();
            boolean bl = isAnonymousFunction = correspondingElement instanceof KtFunctionLiteral || correspondingElement instanceof KtNamedFunction && correspondingElement.getName() == null;
            if (isAnonymousFunction) {
                label = "anonymous_" + i++;
            } else if (correspondingElement instanceof KtNamedDeclaration) {
                KtNamedDeclaration namedDeclaration = (KtNamedDeclaration)correspondingElement;
                label = namedDeclaration.getName();
            } else {
                String propertyName = ((KtProperty)correspondingElement.getParent()).getName();
                label = (((KtPropertyAccessor)correspondingElement).isGetter() ? "get" : "set") + "_" + propertyName;
            }
            if (pseudocode.isInlined()) {
                label = "inlined " + label;
            }
            instructionDump.append("== ").append(label).append(" ==\n");
            instructionDump.append(correspondingElement.getText());
            instructionDump.append("\n---------------------\n");
            this.dumpInstructions((PseudocodeImpl)pseudocode, instructionDump, bindingContext);
            instructionDump.append("=====================\n");
            this.checkPseudocode((PseudocodeImpl)pseudocode);
        }
        File expectedInstructionsFile = KotlinTestUtils.replaceExtension(file, this.getDataFileExtension());
        KotlinTestUtils.assertEqualsToFile(expectedInstructionsFile, instructionDump.toString());
    }

    protected String getDataFileExtension() {
        return "instructions";
    }

    protected void checkPseudocode(PseudocodeImpl pseudocode) {
    }

    private static String getIsDeadInstructionPrefix(@NotNull Instruction instruction, @NotNull Set<Instruction> remainedAfterPostProcessInstructions) {
        boolean isRemovedThroughPostProcess;
        if (instruction == null) {
            AbstractPseudocodeTest.$$$reportNull$$$0(0);
        }
        if (remainedAfterPostProcessInstructions == null) {
            AbstractPseudocodeTest.$$$reportNull$$$0(1);
        }
        boolean bl = isRemovedThroughPostProcess = !remainedAfterPostProcessInstructions.contains(instruction);
        assert (isRemovedThroughPostProcess == ((InstructionImpl)instruction).getMarkedAsDead());
        return isRemovedThroughPostProcess ? "-" : " ";
    }

    private static String getDepthInstructionPrefix(@NotNull Instruction instruction, @Nullable Instruction previous) {
        if (instruction == null) {
            AbstractPseudocodeTest.$$$reportNull$$$0(2);
        }
        Integer prevDepth = previous != null ? Integer.valueOf(previous.getBlockScope().getDepth()) : null;
        int depth = instruction.getBlockScope().getDepth();
        if (prevDepth == null || depth != prevDepth) {
            return String.format("%2d ", depth);
        }
        return "   ";
    }

    private static String formatInstruction(Instruction instruction, int maxLength, String prefix) {
        String[] parts = instruction.toString().split("\n");
        if (parts.length == 1) {
            return prefix + String.format("%1$-" + maxLength + "s", instruction);
        }
        StringBuilder sb = new StringBuilder();
        int partsLength = parts.length;
        for (int i = 0; i < partsLength; ++i) {
            String part = parts[i];
            sb.append(prefix).append(String.format("%1$-" + maxLength + "s", part));
            if (i >= partsLength - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    protected abstract void dumpInstructions(@NotNull PseudocodeImpl var1, @NotNull StringBuilder var2, @NotNull BindingContext var3);

    protected void dumpInstructions(@NotNull PseudocodeImpl pseudocode, @NotNull StringBuilder out, @NotNull Function3<Instruction, Instruction, Instruction, String> getInstructionData) {
        if (pseudocode == null) {
            AbstractPseudocodeTest.$$$reportNull$$$0(3);
        }
        if (out == null) {
            AbstractPseudocodeTest.$$$reportNull$$$0(4);
        }
        if (getInstructionData == null) {
            AbstractPseudocodeTest.$$$reportNull$$$0(5);
        }
        List instructions = pseudocode.getInstructionsIncludingDeadCode();
        HashSet remainedAfterPostProcessInstructions = Sets.newHashSet((Iterable)pseudocode.getInstructions());
        List labels = pseudocode.getLabels();
        int instructionColumnWidth = AbstractPseudocodeTest.countInstructionColumnWidth(instructions);
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction instruction = (Instruction)instructions.get(i);
            for (PseudocodeLabel label : labels) {
                if (label.getTargetInstructionIndex() != i) continue;
                out.append(label).append(":\n");
            }
            StringBuilder line = new StringBuilder();
            Instruction next = i == instructions.size() - 1 ? null : (Instruction)instructions.get(i + 1);
            Instruction prev = i == 0 ? null : (Instruction)instructions.get(i - 1);
            String prefix = AbstractPseudocodeTest.getIsDeadInstructionPrefix(instruction, remainedAfterPostProcessInstructions) + AbstractPseudocodeTest.getDepthInstructionPrefix(instruction, prev);
            line.append(AbstractPseudocodeTest.formatInstruction(instruction, instructionColumnWidth, prefix));
            line.append((String)getInstructionData.invoke((Object)instruction, (Object)next, (Object)prev));
            out.append(StringUtil.trimTrailing((String)line.toString()));
            out.append("\n");
        }
    }

    private static int countInstructionColumnWidth(List<Instruction> instructions) {
        int maxWidth = 0;
        for (Instruction instruction : instructions) {
            String instuctionText = instruction.toString();
            if (instuctionText.length() <= maxWidth) continue;
            String[] parts = instuctionText.split("\n");
            if (parts.length > 1) {
                for (String part : parts) {
                    if (part.length() <= maxWidth) continue;
                    maxWidth = part.length();
                }
                continue;
            }
            if (instuctionText.length() <= maxWidth) continue;
            maxWidth = instuctionText.length();
        }
        return maxWidth;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainedAfterPostProcessInstructions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pseudocode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getInstructionData";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/cfg/AbstractPseudocodeTest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIsDeadInstructionPrefix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDepthInstructionPrefix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "dumpInstructions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

