/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.generators.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.generators.MethodGenerator;
import org.jetbrains.kotlin.generators.TestGenerator;
import org.jetbrains.kotlin.generators.model.AnnotationModel;
import org.jetbrains.kotlin.generators.model.DelegatingTestClassModel;
import org.jetbrains.kotlin.generators.model.MethodModel;
import org.jetbrains.kotlin.generators.model.RunTestMethodModel;
import org.jetbrains.kotlin.generators.model.TestClassModel;
import org.jetbrains.kotlin.generators.model.TestEntityModel;
import org.jetbrains.kotlin.generators.util.GeneratorsFileUtil;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.Printer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0015\u001a\u00020\u0003H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nJ \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\nH\u0002J \u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\"\u001a\u00020\u001a\"\b\b\u0000\u0010#*\u00020!*\b\u0012\u0004\u0012\u0002H#0\u000e2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J,\u0010%\u001a\u00020\u001a\"\b\b\u0000\u0010#*\u00020!*\b\u0012\u0004\u0012\u0002H#0\u000e2\u0006\u0010$\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/generators/impl/TestGeneratorImplInstance;", "", "baseDir", "", "suiteTestClassFqName", "baseTestClassFqName", "testClassModels", "", "Lorg/jetbrains/kotlin/generators/model/TestClassModel;", "useJunit4", "", "methodGenerators", "", "Lorg/jetbrains/kotlin/generators/model/MethodModel$Kind;", "Lorg/jetbrains/kotlin/generators/MethodGenerator;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;ZLjava/util/Map;)V", "baseTestClassName", "baseTestClassPackage", "suiteClassName", "suiteClassPackage", "testSourceFilePath", "generate", "generateAndSave", "Lorg/jetbrains/kotlin/generators/TestGenerator$GenerationResult;", "dryRun", "generateTestClass", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "testClassModel", "isStatic", "generateTestMethod", "methodModel", "Lorg/jetbrains/kotlin/generators/model/MethodModel;", "hackyGenerateBody", "T", "method", "hackyGenerateSignature", "Companion", "tests-common"})
final class TestGeneratorImplInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<TestClassModel> testClassModels;
    private final boolean useJunit4;
    @NotNull
    private final Map<MethodModel.Kind, MethodGenerator<?>> methodGenerators;
    @NotNull
    private final String baseTestClassPackage;
    @NotNull
    private final String baseTestClassName;
    @NotNull
    private final String suiteClassPackage;
    @NotNull
    private final String suiteClassName;
    @NotNull
    private final String testSourceFilePath;
    @NotNull
    private static final HashSet<String> GENERATED_FILES = new HashSet();
    @NotNull
    private static final Class<JUnit3RunnerWithInners> RUNNER = JUnit3RunnerWithInners.class;
    @NotNull
    private static final Class<BlockJUnit4ClassRunner> JUNIT4_RUNNER = BlockJUnit4ClassRunner.class;

    public TestGeneratorImplInstance(@NotNull String baseDir, @NotNull String suiteTestClassFqName, @NotNull String baseTestClassFqName, @NotNull Collection<? extends TestClassModel> testClassModels, boolean useJunit4, @NotNull Map<MethodModel.Kind, ? extends MethodGenerator<?>> methodGenerators) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        Intrinsics.checkNotNullParameter((Object)suiteTestClassFqName, (String)"suiteTestClassFqName");
        Intrinsics.checkNotNullParameter((Object)baseTestClassFqName, (String)"baseTestClassFqName");
        Intrinsics.checkNotNullParameter(testClassModels, (String)"testClassModels");
        Intrinsics.checkNotNullParameter(methodGenerators, (String)"methodGenerators");
        this.testClassModels = testClassModels;
        this.useJunit4 = useJunit4;
        this.methodGenerators = methodGenerators;
        this.baseTestClassPackage = StringsKt.substringBeforeLast((String)baseTestClassFqName, (char)'.', (String)"");
        this.baseTestClassName = StringsKt.substringAfterLast((String)baseTestClassFqName, (char)'.', (String)baseTestClassFqName);
        this.suiteClassPackage = StringsKt.substringBeforeLast((String)suiteTestClassFqName, (char)'.', (String)this.baseTestClassPackage);
        this.suiteClassName = StringsKt.substringAfterLast((String)suiteTestClassFqName, (char)'.', (String)suiteTestClassFqName);
        this.testSourceFilePath = baseDir + '/' + StringsKt.replace$default((String)this.suiteClassPackage, (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + this.suiteClassName + ".java";
        if (!GENERATED_FILES.add(this.testSourceFilePath)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Same test file already generated in current session: ", (Object)this.testSourceFilePath));
        }
    }

    @NotNull
    public final TestGenerator.GenerationResult generateAndSave(boolean dryRun) throws IOException {
        String generatedCode = this.generate();
        File testSourceFile = new File(this.testSourceFilePath);
        boolean changed = GeneratorsFileUtil.INSTANCE.isFileContentChangedIgnoringLineSeparators(testSourceFile, generatedCode);
        if (!dryRun) {
            GeneratorsFileUtil.writeFileIfContentChanged$default((File)testSourceFile, (String)generatedCode, (boolean)false, (boolean)false, (int)8, null);
        }
        return new TestGenerator.GenerationResult(changed, this.testSourceFilePath);
    }

    /*
     * WARNING - void declaration
     */
    private final String generate() {
        void destination$iv;
        void $this$flatMapTo$iv;
        StringBuilder out = new StringBuilder();
        Printer p = new Printer((Appendable)out);
        String copyright = FilesKt.readText$default((File)new File("license/COPYRIGHT_HEADER.txt"), null, (int)1, null);
        Object object = new Object[]{copyright};
        p.println((Object[])object);
        p.println(new Object[0]);
        object = new Object[]{"package ", this.suiteClassPackage, ";"};
        p.println((Object[])object);
        p.println(new Object[0]);
        object = new Object[]{"import com.intellij.testFramework.TestDataPath;"};
        p.println((Object[])object);
        if (!this.useJunit4) {
            object = new Object[]{"import ", RUNNER.getCanonicalName(), ";"};
            p.println((Object[])object);
        }
        object = new Object[]{"import " + KotlinTestUtils.class.getCanonicalName() + ';'};
        p.println((Object[])object);
        object = new Object[]{"import " + KtTestUtil.class.getCanonicalName() + ';'};
        p.println((Object[])object);
        Object object2 = this.testClassModels;
        boolean bl = false;
        Object[] objectArray = (Object[])new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            TestClassModel classModel = (TestClassModel)element$iv;
            boolean bl2 = false;
            Iterable list$iv = classModel.getImports();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        for (Class clazz : (Set)destination$iv) {
            objectArray = new Object[]{"import " + clazz.getName() + ';'};
            p.println(objectArray);
        }
        if (!Intrinsics.areEqual((Object)this.suiteClassPackage, (Object)this.baseTestClassPackage)) {
            object = new Object[]{"import " + this.baseTestClassPackage + '.' + this.baseTestClassName + ';'};
            p.println((Object[])object);
        }
        object = new Object[]{"import " + TestMetadata.class.getCanonicalName() + ';'};
        p.println((Object[])object);
        object = new Object[]{"import " + RunWith.class.getCanonicalName() + ';'};
        p.println((Object[])object);
        if (this.useJunit4) {
            object = new Object[]{"import " + BlockJUnit4ClassRunner.class.getCanonicalName() + ';'};
            p.println((Object[])object);
            object = new Object[]{"import " + Test.class.getCanonicalName() + ';'};
            p.println((Object[])object);
        }
        p.println(new Object[0]);
        object = new Object[]{"import java.io.File;"};
        p.println((Object[])object);
        object = new Object[]{"import java.util.regex.Pattern;"};
        p.println((Object[])object);
        p.println(new Object[0]);
        object = new Object[]{"/** This class is generated by {@link ", "org.jetbrains.kotlin.generators.tests.TestsPackage", "}. DO NOT MODIFY MANUALLY */"};
        p.println((Object[])object);
        TestGeneratorImplInstance.Companion.generateSuppressAllWarnings(p);
        TestClassModel model = null;
        if (this.testClassModels.size() == 1) {
            object2 = (TestClassModel)CollectionsKt.single((Iterable)this.testClassModels);
            model = (TestClassModel)new DelegatingTestClassModel(this, (TestClassModel)object2){
                final /* synthetic */ TestGeneratorImplInstance this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                @NotNull
                public String getName() {
                    return TestGeneratorImplInstance.access$getSuiteClassName$p(this.this$0);
                }
            };
        } else {
            model = new TestClassModel(this){
                final /* synthetic */ TestGeneratorImplInstance this$0;
                {
                    this.this$0 = $receiver;
                }

                @NotNull
                public Collection<TestClassModel> getInnerTestClasses() {
                    return TestGeneratorImplInstance.access$getTestClassModels$p(this.this$0);
                }

                @NotNull
                public Collection<MethodModel> getMethods() {
                    return CollectionsKt.emptyList();
                }

                public boolean isEmpty() {
                    return false;
                }

                @NotNull
                public String getName() {
                    return TestGeneratorImplInstance.access$getSuiteClassName$p(this.this$0);
                }

                @Nullable
                public String getDataString() {
                    return null;
                }

                @Nullable
                public String getDataPathRoot() {
                    return null;
                }

                @NotNull
                public Collection<AnnotationModel> getAnnotations() {
                    return CollectionsKt.emptyList();
                }

                @NotNull
                public Set<Class<?>> getImports() {
                    return super.getImports();
                }
            };
        }
        this.generateTestClass(p, model, false);
        object2 = out.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"out.toString()");
        return object2;
    }

    private final void generateTestClass(Printer p, TestClassModel testClassModel, boolean isStatic) {
        String staticModifier = isStatic ? "static " : "";
        TestGeneratorImplInstance.Companion.generateMetadata(p, (TestEntityModel)testClassModel);
        TestGeneratorImplInstance.Companion.generateTestDataPath(p, testClassModel);
        TestGeneratorImplInstance.Companion.generateParameterAnnotations(p, testClassModel);
        Object[] objectArray = new Object[]{"@RunWith(", this.useJunit4 ? JUNIT4_RUNNER.getSimpleName() : RUNNER.getSimpleName(), ".class)"};
        p.println(objectArray);
        objectArray = new Object[]{"public " + staticModifier + "class ", testClassModel.getName(), " extends ", this.baseTestClassName, " {"};
        p.println(objectArray);
        p.pushIndent();
        Collection testMethods = testClassModel.getMethods();
        Collection innerTestClasses = testClassModel.getInnerTestClasses();
        boolean first = true;
        for (MethodModel methodModel : testMethods) {
            if (!methodModel.shouldBeGenerated()) continue;
            if (first) {
                first = false;
            } else {
                p.println(new Object[0]);
            }
            this.generateTestMethod(p, methodModel, this.useJunit4);
        }
        for (TestClassModel innerTestClass : innerTestClasses) {
            if (innerTestClass.isEmpty()) continue;
            if (first) {
                first = false;
            } else {
                p.println(new Object[0]);
            }
            this.generateTestClass(p, innerTestClass, true);
        }
        p.popIndent();
        Object[] objectArray2 = new Object[]{"}"};
        p.println(objectArray2);
    }

    private final void generateTestMethod(Printer p, MethodModel methodModel, boolean useJunit4) {
        if (useJunit4 && !(methodModel instanceof RunTestMethodModel)) {
            Object[] objectArray = new Object[]{"@Test"};
            p.println(objectArray);
        }
        MethodGenerator generator = (MethodGenerator)MapsKt.getValue(this.methodGenerators, (Object)methodModel.getKind());
        TestGeneratorImplInstance.Companion.generateMetadata(p, (TestEntityModel)methodModel);
        this.hackyGenerateSignature(generator, methodModel, p);
        Object[] objectArray = new Object[]{" {"};
        p.printWithNoIndent(objectArray);
        p.println(new Object[0]);
        p.pushIndent();
        this.hackyGenerateBody(generator, methodModel, p);
        p.popIndent();
        objectArray = new Object[]{"}"};
        p.println(objectArray);
    }

    private final <T extends MethodModel> void hackyGenerateBody(MethodGenerator<? super T> $this$hackyGenerateBody, MethodModel method, Printer p) {
        $this$hackyGenerateBody.generateBody(method, p);
    }

    private final <T extends MethodModel> void hackyGenerateSignature(MethodGenerator<? super T> $this$hackyGenerateSignature, MethodModel method, Printer p) {
        $this$hackyGenerateSignature.generateSignature(method, p);
    }

    public static final /* synthetic */ String access$getSuiteClassName$p(TestGeneratorImplInstance $this) {
        return $this.suiteClassName;
    }

    public static final /* synthetic */ Collection access$getTestClassModels$p(TestGeneratorImplInstance $this) {
        return $this.testClassModels;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/generators/impl/TestGeneratorImplInstance$Companion;", "", "()V", "GENERATED_FILES", "Ljava/util/HashSet;", "", "JUNIT4_RUNNER", "Ljava/lang/Class;", "Lorg/junit/runners/BlockJUnit4ClassRunner;", "RUNNER", "Lorg/jetbrains/kotlin/test/JUnit3RunnerWithInners;", "generateMetadata", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "testDataSource", "Lorg/jetbrains/kotlin/generators/model/TestEntityModel;", "generateParameterAnnotations", "testClassModel", "Lorg/jetbrains/kotlin/generators/model/TestClassModel;", "generateSuppressAllWarnings", "generateTestDataPath", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        private final void generateMetadata(Printer p, TestEntityModel testDataSource) {
            String dataString = testDataSource.getDataString();
            if (dataString != null) {
                Object[] objectArray = new Object[]{"@TestMetadata(\"", dataString, "\")"};
                p.println(objectArray);
            }
        }

        private final void generateTestDataPath(Printer p, TestClassModel testClassModel) {
            String dataPathRoot = testClassModel.getDataPathRoot();
            if (dataPathRoot != null) {
                Object[] objectArray = new Object[]{"@TestDataPath(\"", dataPathRoot, "\")"};
                p.println(objectArray);
            }
        }

        private final void generateParameterAnnotations(Printer p, TestClassModel testClassModel) {
            for (AnnotationModel annotationModel : testClassModel.getAnnotations()) {
                annotationModel.generate(p);
                p.println(new Object[0]);
            }
        }

        private final void generateSuppressAllWarnings(Printer p) {
            Object[] objectArray = new Object[]{"@SuppressWarnings(\"all\")"};
            p.println(objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

