/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.codegen.GenerationUtils;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.jvm.compiler.javac.JavacRegistrarForTests;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.MockLibraryUtilExt;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class LoadDescriptorUtil {
    @NotNull
    public static final FqName TEST_PACKAGE_FQNAME = FqName.topLevel((Name)Name.identifier((String)"test"));

    private LoadDescriptorUtil() {
    }

    @NotNull
    public static ModuleDescriptor compileKotlinToDirAndGetModule(@NotNull List<File> kotlinFiles, @NotNull File outDir, @NotNull KotlinCoreEnvironment environment) {
        if (kotlinFiles == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(0);
        }
        if (outDir == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(2);
        }
        GenerationState state = GenerationUtils.compileFiles(LoadDescriptorUtil.createKtFiles(kotlinFiles, environment), (KotlinCoreEnvironment)environment);
        OutputUtilsKt.writeAllTo((OutputFileCollection)state.getFactory(), (File)outDir);
        ModuleDescriptor moduleDescriptor = state.getModule();
        if (moduleDescriptor == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(3);
        }
        return moduleDescriptor;
    }

    @NotNull
    public static Pair<PackageViewDescriptor, BindingContext> loadTestPackageAndBindingContextFromJavaRoot(@NotNull File javaRoot, @NotNull Disposable disposable, @NotNull TestJdkKind testJdkKind, @NotNull ConfigurationKind configurationKind, boolean isBinaryRoot, boolean usePsiClassReading, boolean useJavacWrapper, boolean withForeignAnnotations, @Nullable LanguageVersionSettings explicitLanguageVersionSettings) {
        if (javaRoot == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(5);
        }
        if (testJdkKind == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(6);
        }
        if (configurationKind == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(7);
        }
        return LoadDescriptorUtil.loadTestPackageAndBindingContextFromJavaRoot(javaRoot, disposable, testJdkKind, configurationKind, isBinaryRoot, usePsiClassReading, useJavacWrapper, withForeignAnnotations, explicitLanguageVersionSettings, Collections.emptyList(), configuration -> {});
    }

    @NotNull
    public static Pair<PackageViewDescriptor, BindingContext> loadTestPackageAndBindingContextFromJavaRoot(@NotNull File javaRoot, @NotNull Disposable disposable, @NotNull TestJdkKind testJdkKind, @NotNull ConfigurationKind configurationKind, boolean isBinaryRoot, boolean usePsiClassReading, boolean useJavacWrapper, boolean withForeignAnnotations, @Nullable LanguageVersionSettings explicitLanguageVersionSettings, @NotNull List<File> additionalClasspath, @NotNull Consumer<KotlinCoreEnvironment> configureEnvironment) {
        if (javaRoot == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(8);
        }
        if (disposable == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(9);
        }
        if (testJdkKind == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(10);
        }
        if (configurationKind == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(11);
        }
        if (additionalClasspath == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(12);
        }
        if (configureEnvironment == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(13);
        }
        ArrayList<File> javaBinaryRoots = new ArrayList<File>();
        if (withForeignAnnotations) {
            javaBinaryRoots.add(MockLibraryUtilExt.compileJavaFilesLibraryToJar("third-party/jdk8-annotations", "foreign-annotations"));
        }
        javaBinaryRoots.add(KtTestUtil.getAnnotationsJar());
        javaBinaryRoots.add(ForTestCompileRuntime.jvmAnnotationsForTests());
        javaBinaryRoots.addAll(additionalClasspath);
        ArrayList<File> javaSourceRoots = new ArrayList<File>();
        javaSourceRoots.add(new File("compiler/testData/loadJava/include"));
        if (isBinaryRoot) {
            javaBinaryRoots.add(javaRoot);
        } else {
            javaSourceRoots.add(javaRoot);
        }
        CompilerConfiguration configuration = KotlinTestUtils.newConfiguration(configurationKind, testJdkKind, javaBinaryRoots, javaSourceRoots);
        configuration.put(JVMConfigurationKeys.USE_PSI_CLASS_FILES_READING, (Object)usePsiClassReading);
        configuration.put(JVMConfigurationKeys.USE_JAVAC, (Object)useJavacWrapper);
        if (explicitLanguageVersionSettings != null) {
            configuration.put(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, (Object)explicitLanguageVersionSettings);
        }
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForTests((Disposable)disposable, (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        configureEnvironment.accept(environment);
        if (useJavacWrapper) {
            JavacRegistrarForTests.INSTANCE.registerJavac(environment);
        }
        AnalysisResult analysisResult = JvmResolveUtil.analyze((KotlinCoreEnvironment)environment);
        PackageViewDescriptor packageView = analysisResult.getModuleDescriptor().getPackage(TEST_PACKAGE_FQNAME);
        Pair pair = Pair.create((Object)packageView, (Object)analysisResult.getBindingContext());
        if (pair == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(14);
        }
        return pair;
    }

    public static void compileJavaWithAnnotationsJar(@NotNull Collection<File> javaFiles, @NotNull File outDir, @NotNull List<String> additionalArgs, @Nullable File customJdkHomeForJavac, boolean useJetbrainsAnnotationsWithTypeUse) throws IOException {
        if (javaFiles == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(15);
        }
        if (outDir == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(16);
        }
        if (additionalArgs == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(17);
        }
        ArrayList<String> args2 = new ArrayList<String>(Arrays.asList("-sourcepath", "compiler/testData/loadJava/include", "-d", outDir.getPath()));
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.add(ForTestCompileRuntime.runtimeJarForTests());
        if (useJetbrainsAnnotationsWithTypeUse) {
            classpath.add(MockLibraryUtilExt.compileJavaFilesLibraryToJar("third-party/jdk8-annotations", "foreign-annotations"));
        }
        classpath.add(KtTestUtil.getAnnotationsJar());
        for (File test2 : javaFiles) {
            String content2 = FilesKt.readText((File)test2, (Charset)Charsets.UTF_8);
            args2.addAll(InTextDirectivesUtils.findListWithPrefixes((String)content2, (String[])new String[]{"JAVAC_OPTIONS:"}));
            if (!InTextDirectivesUtils.isDirectiveDefined((String)content2, (String)"JVM_ANNOTATIONS")) continue;
            classpath.add(ForTestCompileRuntime.jvmAnnotationsForTests());
        }
        args2.add("-classpath");
        args2.add(classpath.stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator)));
        args2.addAll(additionalArgs);
        if (customJdkHomeForJavac != null) {
            KotlinTestUtils.compileJavaFilesExternally(javaFiles, args2, customJdkHomeForJavac);
        } else {
            KotlinTestUtils.compileJavaFiles(javaFiles, args2);
        }
    }

    @NotNull
    private static List<KtFile> createKtFiles(@NotNull List<File> kotlinFiles, @NotNull KotlinCoreEnvironment environment) {
        if (kotlinFiles == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(18);
        }
        if (environment == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(19);
        }
        List list = CollectionsKt.map(kotlinFiles, kotlinFile -> {
            try {
                return KtTestUtil.createFile((String)kotlinFile.getName(), (String)FileUtil.loadFile((File)kotlinFile, (boolean)true), (Project)environment.getProject());
            }
            catch (IOException e) {
                throw ExceptionUtilsKt.rethrow((Throwable)e);
            }
        });
        if (list == null) {
            LoadDescriptorUtil.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlinFiles";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 2: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/jvm/compiler/LoadDescriptorUtil";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaRoot";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testJdkKind";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKind";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClasspath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configureEnvironment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/jvm/compiler/LoadDescriptorUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compileKotlinToDirAndGetModule";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestPackageAndBindingContextFromJavaRoot";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createKtFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compileKotlinToDirAndGetModule";
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadTestPackageAndBindingContextFromJavaRoot";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaWithAnnotationsJar";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createKtFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 14: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

