/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.jvm.compiler.AbstractWriteSignatureTest;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u000e2\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u0014\u0010\n\u001a\u00060\u000bR\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest;", "Lorg/jetbrains/kotlin/codegen/CodegenTestCase;", "()V", "doMultiFileTest", "", "wholeFile", "Ljava/io/File;", "files", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "parseExpectations", "Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$PackageExpectationsSuite;", "ktFile", "ClassExpectationsSuite", "Companion", "PackageExpectationsSuite", "SignatureExpectation", "tests-common"})
public abstract class AbstractWriteSignatureTest
extends CodegenTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex expectationRegex = new Regex("^// (class|method|field): *([^:]+)(::(.+))? *(//.*)?");
    @NotNull
    private static final Regex jvmSignatureRegex = new Regex("^// jvm signature: *(.+) *(//.*)?");
    @NotNull
    private static final Regex genericSignatureRegex = new Regex("^// generic signature: *(.+) *(//.*)?");

    @Override
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean isIgnored = InTextDirectivesUtils.isIgnoredTarget((TargetBackend)this.getBackend(), (File)wholeFile);
        this.compile(files);
        try {
            this.parseExpectations(wholeFile).check();
        }
        catch (Throwable e) {
            if (!isIgnored) {
                String string = this.classFileFactory.createText();
                boolean bl = false;
                System.out.println((Object)string);
            }
            throw e;
        }
    }

    private final PackageExpectationsSuite parseExpectations(File ktFile) {
        PackageExpectationsSuite expectations = new PackageExpectationsSuite();
        List lines = FilesKt.readLines$default((File)ktFile, null, (int)1, null);
        int lineNo = 0;
        while (lineNo < lines.size()) {
            block15: {
                String kind;
                block16: {
                    MatchResult genericSignatureMatch;
                    String line = (String)lines.get(lineNo);
                    MatchResult expectationMatch = Companion.matchExact(expectationRegex, line);
                    if (expectationMatch == null) break block15;
                    String string = expectationMatch.group(1);
                    Intrinsics.checkNotNull((Object)string);
                    kind = string;
                    String string2 = expectationMatch.group(2);
                    Intrinsics.checkNotNull((Object)string2);
                    String className = string2;
                    String memberName = expectationMatch.group(4);
                    if (Intrinsics.areEqual((Object)kind, (Object)"class") && memberName != null) {
                        throw new AssertionError((Object)(ktFile + ':' + (lineNo + 1) + ": use " + className + '$' + memberName + " to denote inner class"));
                    }
                    MatchResult jvmSignatureMatch = Companion.matchExact(jvmSignatureRegex, (String)lines.get(lineNo + 1));
                    MatchResult matchResult = Companion.matchExact(genericSignatureRegex, (String)lines.get(lineNo + 1));
                    MatchResult matchResult2 = genericSignatureMatch = matchResult == null ? Companion.matchExact(genericSignatureRegex, (String)lines.get(lineNo + 2)) : matchResult;
                    if (genericSignatureMatch == null) break block16;
                    MatchResult matchResult3 = jvmSignatureMatch;
                    String jvmSignature = matchResult3 == null ? null : matchResult3.group(1);
                    String genericSignature = genericSignatureMatch.group(1);
                    ClassExpectationsSuite classSuite = expectations.getOrCreateClassSuite(className);
                    switch (kind) {
                        case "class": {
                            Intrinsics.checkNotNullExpressionValue((Object)genericSignature, (String)"genericSignature");
                            classSuite.addClassExpectation(className, jvmSignature, genericSignature);
                            break;
                        }
                        case "field": {
                            Intrinsics.checkNotNullExpressionValue((Object)memberName, (String)"memberName");
                            Intrinsics.checkNotNullExpressionValue((Object)genericSignature, (String)"genericSignature");
                            classSuite.addFieldExpectation(className, memberName, jvmSignature, genericSignature);
                            break;
                        }
                        case "method": {
                            Intrinsics.checkNotNullExpressionValue((Object)memberName, (String)"memberName");
                            Intrinsics.checkNotNullExpressionValue((Object)genericSignature, (String)"genericSignature");
                            classSuite.addMethodExpectation(className, memberName, jvmSignature, genericSignature);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)(ktFile + ':' + (lineNo + 1) + ": unsupported expectation kind: " + kind));
                        }
                    }
                    lineNo += 3;
                    continue;
                }
                throw new AssertionError((Object)(ktFile + ':' + (lineNo + 1) + ": '" + kind + "' should be followed by 'jvm signature' and 'generic signature'"));
            }
            ++lineNo;
        }
        return expectations;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$SignatureExpectation;", "", "header", "", "name", "expectedJvmSignature", "expectedGenericSignature", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "expectedFormattedSignature", "getExpectedJvmSignature", "()Ljava/lang/String;", "getHeader", "jvmDescriptorToFormattedSignature", "", "getName", "accept", "", "actualJvmSignature", "actualGenericSignature", "check", "tests-common"})
    private static final class SignatureExpectation {
        @NotNull
        private final String header;
        @NotNull
        private final String name;
        @Nullable
        private final String expectedJvmSignature;
        @NotNull
        private final String expectedFormattedSignature;
        @NotNull
        private final Map<String, String> jvmDescriptorToFormattedSignature;

        public SignatureExpectation(@NotNull String header, @NotNull String name, @Nullable String expectedJvmSignature, @NotNull String expectedGenericSignature) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)expectedGenericSignature, (String)"expectedGenericSignature");
            this.header = header;
            this.name = name;
            this.expectedJvmSignature = expectedJvmSignature;
            this.expectedFormattedSignature = Companion.formatSignature(this.header, this.expectedJvmSignature, expectedGenericSignature);
            boolean bl = false;
            this.jvmDescriptorToFormattedSignature = new LinkedHashMap();
        }

        @NotNull
        public final String getHeader() {
            return this.header;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getExpectedJvmSignature() {
            return this.expectedJvmSignature;
        }

        public final void accept(@NotNull String name, @NotNull String actualJvmSignature, @NotNull String actualGenericSignature) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)actualJvmSignature, (String)"actualJvmSignature");
            Intrinsics.checkNotNullParameter((Object)actualGenericSignature, (String)"actualGenericSignature");
            if (Intrinsics.areEqual((Object)this.name, (Object)name)) {
                String string;
                Assert.assertFalse((boolean)this.jvmDescriptorToFormattedSignature.containsKey(actualJvmSignature));
                Map<String, String> map = this.jvmDescriptorToFormattedSignature;
                Companion companion = Companion;
                String string2 = this.header;
                String string3 = this.expectedJvmSignature;
                if (string3 == null) {
                    string = null;
                } else {
                    String string4 = string3;
                    boolean bl = false;
                    boolean bl2 = false;
                    String string5 = string4;
                    String string6 = string2;
                    Companion companion2 = companion;
                    boolean bl3 = false;
                    String string7 = actualJvmSignature;
                    companion = companion2;
                    string2 = string6;
                    string = string7;
                }
                string3 = companion.formatSignature(string2, string, actualGenericSignature);
                boolean bl = false;
                map.put(actualJvmSignature, string3);
            }
        }

        public final void check() {
            String string;
            if (this.expectedJvmSignature == null) {
                Assert.assertTrue((String)("Expected single declaration, but " + this.jvmDescriptorToFormattedSignature.keySet() + " found"), (this.jvmDescriptorToFormattedSignature.size() == 1 ? 1 : 0) != 0);
                string = (String)CollectionsKt.single((Iterable)this.jvmDescriptorToFormattedSignature.values());
            } else {
                String $this$sure$iv = this.jvmDescriptorToFormattedSignature.get(this.expectedJvmSignature);
                boolean $i$f$sure = false;
                String string2 = $this$sure$iv;
                if (string2 == null) {
                    String string3;
                    boolean bl = false;
                    String string4 = string3 = "Expected " + this.getExpectedJvmSignature() + " but only " + this.jvmDescriptorToFormattedSignature.keySet() + " found for " + this.getName();
                    throw new AssertionError((Object)string4);
                }
                string = string2;
            }
            String formattedActualSignature = string;
            Assert.assertEquals((Object)this.expectedFormattedSignature, (Object)formattedActualSignature);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$PackageExpectationsSuite;", "", "(Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest;)V", "classSuitesByClassName", "Ljava/util/LinkedHashMap;", "", "Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$ClassExpectationsSuite;", "Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest;", "check", "", "getOrCreateClassSuite", "className", "tests-common"})
    private final class PackageExpectationsSuite {
        @NotNull
        private final LinkedHashMap<String, ClassExpectationsSuite> classSuitesByClassName;

        public PackageExpectationsSuite() {
            Intrinsics.checkNotNullParameter((Object)((Object)AbstractWriteSignatureTest.this), (String)"this$0");
            this.classSuitesByClassName = new LinkedHashMap();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ClassExpectationsSuite getOrCreateClassSuite(@NotNull String className) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Map map = this.classSuitesByClassName;
            AbstractWriteSignatureTest abstractWriteSignatureTest = AbstractWriteSignatureTest.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(className);
            if (value$iv == null) {
                boolean bl = false;
                ClassExpectationsSuite answer$iv = abstractWriteSignatureTest.new ClassExpectationsSuite(className);
                $this$getOrPut$iv.put(className, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (ClassExpectationsSuite)object;
        }

        public final void check() {
            Object object = this.classSuitesByClassName;
            boolean bl = false;
            Assert.assertTrue((!object.isEmpty() ? 1 : 0) != 0);
            object = this.classSuitesByClassName.values();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classSuitesByClassName.values");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassExpectationsSuite it = (ClassExpectationsSuite)element$iv;
                boolean bl2 = false;
                it.check();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003J(\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003J(\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0011J\b\u0010\u0019\u001a\u00020\u0011H\u0002J \u0010\u001a\u001a\u00020\u00112\u000e\u0010\u001b\u001a\n0\u001cR\u00060\u0000R\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020\u00112\u000e\u0010\u001b\u001a\n0\u001cR\u00060\u0000R\u00020\u001d2\u0006\u0010!\u001a\u00020\u0003H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\t\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$ClassExpectationsSuite;", "", "className", "", "(Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest;Ljava/lang/String;)V", "classExpectations", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$SignatureExpectation;", "getClassExpectations", "()Ljava/util/ArrayList;", "getClassName", "()Ljava/lang/String;", "fieldExpectations", "getFieldExpectations", "methodExpectations", "getMethodExpectations", "addClassExpectation", "", "name", "jvmSignature", "genericSignature", "addFieldExpectation", "memberName", "addMethodExpectation", "check", "checkCollectedSignatures", "processClassFile", "checker", "Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$ClassExpectationsSuite$Checker;", "Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest;", "classData", "", "processPackageParts", "relativeClassFileName", "Checker", "tests-common"})
    private final class ClassExpectationsSuite {
        @NotNull
        private final String className;
        @NotNull
        private final ArrayList<SignatureExpectation> classExpectations;
        @NotNull
        private final ArrayList<SignatureExpectation> methodExpectations;
        @NotNull
        private final ArrayList<SignatureExpectation> fieldExpectations;

        public ClassExpectationsSuite(String className) {
            Intrinsics.checkNotNullParameter((Object)((Object)AbstractWriteSignatureTest.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.className = className;
            this.classExpectations = new ArrayList();
            this.methodExpectations = new ArrayList();
            this.fieldExpectations = new ArrayList();
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final ArrayList<SignatureExpectation> getClassExpectations() {
            return this.classExpectations;
        }

        @NotNull
        public final ArrayList<SignatureExpectation> getMethodExpectations() {
            return this.methodExpectations;
        }

        @NotNull
        public final ArrayList<SignatureExpectation> getFieldExpectations() {
            return this.fieldExpectations;
        }

        public final void check() {
            Checker checker = new Checker();
            String relativeClassFileName = Intrinsics.stringPlus((String)StringsKt.replace$default((String)this.className, (char)'.', (char)'/', (boolean)false, (int)4, null), (Object)".class");
            List list = AbstractWriteSignatureTest.this.classFileFactory.getCurrentOutput();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classFileFactory.currentOutput");
            Iterable $this$single$iv = list;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                OutputFile it = (OutputFile)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRelativePath(), (Object)relativeClassFileName)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            OutputFile outputFile = single$iv;
            this.processClassFile(checker, outputFile.asByteArray());
            if (StringsKt.endsWith$default((String)this.className, (String)"Package", (boolean)false, (int)2, null)) {
                this.processPackageParts(checker, relativeClassFileName);
            }
            this.checkCollectedSignatures();
        }

        /*
         * WARNING - void declaration
         */
        private final void processPackageParts(Checker checker, String relativeClassFileName) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            String partPrefix = StringsKt.replace$default((String)relativeClassFileName, (String)".class", (String)"$", (boolean)false, (int)4, null);
            List list = AbstractWriteSignatureTest.this.classFileFactory.getCurrentOutput();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classFileFactory.currentOutput");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OutputFile it = (OutputFile)element$iv$iv;
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getRelativePath(), (String)partPrefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it.getRelativePath(), (String)".class", (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                OutputFile packageFacadeFile = (OutputFile)element$iv;
                boolean bl = false;
                this.processClassFile(checker, packageFacadeFile.asByteArray());
            }
        }

        private final void checkCollectedSignatures() {
            Iterable $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.classExpectations, (Iterable)this.methodExpectations), (Iterable)this.fieldExpectations);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SignatureExpectation p0 = (SignatureExpectation)element$iv;
                boolean bl = false;
                p0.check();
            }
        }

        private final void processClassFile(Checker checker, byte[] classData) {
            new ClassReader(classData).accept((ClassVisitor)checker, 7);
        }

        public final void addClassExpectation(@NotNull String name, @Nullable String jvmSignature, @NotNull String genericSignature) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)genericSignature, (String)"genericSignature");
            this.classExpectations.add(new SignatureExpectation(Intrinsics.stringPlus((String)"class: ", (Object)name), name, jvmSignature, genericSignature));
        }

        public final void addFieldExpectation(@NotNull String className, @NotNull String memberName, @Nullable String jvmSignature, @NotNull String genericSignature) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
            Intrinsics.checkNotNullParameter((Object)genericSignature, (String)"genericSignature");
            this.fieldExpectations.add(new SignatureExpectation("field: " + className + "::" + memberName, memberName, jvmSignature, genericSignature));
        }

        public final void addMethodExpectation(@NotNull String className, @NotNull String memberName, @Nullable String jvmSignature, @NotNull String genericSignature) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
            Intrinsics.checkNotNullParameter((Object)genericSignature, (String)"genericSignature");
            this.methodExpectations.add(new SignatureExpectation("method: " + className + "::" + memberName, memberName, jvmSignature, genericSignature));
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0010\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ6\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016JC\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0010\u0010\u0016\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$ClassExpectationsSuite$Checker;", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "(Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$ClassExpectationsSuite;)V", "visit", "", "version", "", "access", "name", "", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitField", "Lorg/jetbrains/org/objectweb/asm/FieldVisitor;", "desc", "value", "", "visitMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "exceptions", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "tests-common"})
        private final class Checker
        extends ClassVisitor {
            public Checker() {
                Intrinsics.checkNotNullParameter((Object)ClassExpectationsSuite.this, (String)"this$0");
                super(524288);
            }

            public void visit(int version, int access, @NotNull String name, @Nullable String signature, @Nullable String superName, @Nullable String[] interfaces) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Iterable $this$forEach$iv = ClassExpectationsSuite.this.getClassExpectations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SignatureExpectation it = (SignatureExpectation)element$iv;
                    boolean bl = false;
                    String string = signature;
                    it.accept(name, name, string == null ? "null" : string);
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            @Nullable
            public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                Iterable $this$forEach$iv = ClassExpectationsSuite.this.getMethodExpectations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SignatureExpectation it = (SignatureExpectation)element$iv;
                    boolean bl = false;
                    String string = signature;
                    it.accept(name, desc, string == null ? "null" : string);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            @Nullable
            public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
                Iterable $this$forEach$iv = ClassExpectationsSuite.this.getFieldExpectations();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SignatureExpectation it = (SignatureExpectation)element$iv;
                    boolean bl = false;
                    String string = signature;
                    it.accept(name, desc, string == null ? "null" : string);
                }
                return super.visitField(access, name, desc, signature, value);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\fJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00042\u0006\u0010\u0012\u001a\u00020\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractWriteSignatureTest$Companion;", "", "()V", "expectationRegex", "Lkotlin/text/Regex;", "getExpectationRegex", "()Lkotlin/text/Regex;", "genericSignatureRegex", "getGenericSignatureRegex", "jvmSignatureRegex", "getJvmSignatureRegex", "formatSignature", "", "header", "jvmSignature", "genericSignature", "matchExact", "Ljava/util/regex/MatchResult;", "input", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String formatSignature(@NotNull String header, @Nullable String jvmSignature, @NotNull String genericSignature) {
            String string;
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)genericSignature, (String)"genericSignature");
            Object[] objectArray = new String[3];
            objectArray[0] = header;
            Object[] objectArray2 = objectArray;
            int n = 1;
            String string2 = jvmSignature;
            if (string2 == null) {
                string = null;
            } else {
                void it;
                String string3 = string2;
                boolean bl = false;
                boolean bl2 = false;
                String string4 = string3;
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                boolean bl3 = false;
                String string5 = Intrinsics.stringPlus((String)"jvm signature: ", (Object)it);
                objectArray2 = objectArray3;
                n = n2;
                string = string5;
            }
            objectArray2[n] = string;
            objectArray[2] = Intrinsics.stringPlus((String)"generic signature: ", (Object)genericSignature);
            return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, (Function1)formatSignature.2.INSTANCE, (int)30, null);
        }

        @NotNull
        public final Regex getExpectationRegex() {
            return expectationRegex;
        }

        @NotNull
        public final Regex getJvmSignatureRegex() {
            return jvmSignatureRegex;
        }

        @NotNull
        public final Regex getGenericSignatureRegex() {
            return genericSignatureRegex;
        }

        @Nullable
        public final MatchResult matchExact(@NotNull Regex $this$matchExact, @NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)$this$matchExact, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Matcher matcher = $this$matchExact.toPattern().matcher(input);
            return matcher.matches() ? matcher.toMatchResult() : (MatchResult)null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

