/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.Pair;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.script.ScriptTestUtilKt;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public abstract class AbstractScriptCodegenTest
extends CodegenTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.createEnvironmentWithMockJdkAndIdeaAnnotations(ConfigurationKind.JDK_ONLY, new File[0]);
    }

    @Override
    protected void updateConfiguration(@NotNull CompilerConfiguration configuration) {
        if (configuration == null) {
            AbstractScriptCodegenTest.$$$reportNull$$$0(0);
        }
        super.updateConfiguration(configuration);
        ScriptTestUtilKt.loadScriptingPlugin((CompilerConfiguration)configuration);
    }

    @Override
    protected void doTest(@NotNull String filename) {
        if (filename == null) {
            AbstractScriptCodegenTest.$$$reportNull$$$0(1);
        }
        this.loadFileByFullPath(filename);
        try {
            FqName fqName = this.myFiles.getPsiFile().getScript().getFqName();
            Class<?> scriptClass = this.generateClass(fqName.asString());
            Constructor constructor = AbstractScriptCodegenTest.getTheOnlyConstructor(scriptClass);
            Object scriptInstance = constructor.newInstance(this.myFiles.getScriptParameterValues().toArray());
            AbstractScriptCodegenTest.assertFalse((String)"expecting at least one expectation", (boolean)this.myFiles.getExpectedValues().isEmpty());
            for (Pair nameValue : this.myFiles.getExpectedValues()) {
                String fieldName = (String)nameValue.first;
                String expectedValue = (String)nameValue.second;
                if (expectedValue.equals("<nofield>")) {
                    try {
                        scriptClass.getDeclaredField(fieldName);
                        AbstractScriptCodegenTest.fail((String)("must have no field " + fieldName));
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
                Field field = scriptClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object result = field.get(scriptInstance);
                String resultString = result != null ? result.toString() : "null";
                AbstractScriptCodegenTest.assertEquals((String)("comparing field " + fieldName), (String)expectedValue, (String)resultString);
            }
        }
        catch (Throwable e) {
            this.printReport(new File(filename));
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    @NotNull
    private static Constructor getTheOnlyConstructor(@NotNull Class<?> clazz) {
        Constructor<?>[] constructors;
        if (clazz == null) {
            AbstractScriptCodegenTest.$$$reportNull$$$0(2);
        }
        if ((constructors = clazz.getConstructors()).length != 1) {
            throw new IllegalArgumentException("Script class should have one constructor: " + clazz);
        }
        Constructor<?> constructor = constructors[0];
        if (constructor == null) {
            AbstractScriptCodegenTest.$$$reportNull$$$0(3);
        }
        return constructor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AbstractScriptCodegenTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AbstractScriptCodegenTest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheOnlyConstructor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyConstructor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

