/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.testFramework;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.application.Application;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.testFramework.TestApplicationUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0007R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/testFramework/MockComponentManagerCreationTracer;", "", "()V", "creationTraceMap", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/mock/MockComponentManager;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "diagnoseDisposedButNotClearedApplication", "", "app", "Lcom/intellij/openapi/application/Application;", "onCreate", "manager", "onGetComponentInstance", "tests-common"})
public final class MockComponentManagerCreationTracer {
    @NotNull
    public static final MockComponentManagerCreationTracer INSTANCE = new MockComponentManagerCreationTracer();
    @NotNull
    private static final ConcurrentMap<MockComponentManager, Throwable> creationTraceMap;

    private MockComponentManagerCreationTracer() {
    }

    @JvmStatic
    public static final void onCreate(@NotNull MockComponentManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Map map = creationTraceMap;
        Exception exception = new Exception("Creation trace");
        boolean bl = false;
        map.put(manager, exception);
    }

    @JvmStatic
    public static final void onGetComponentInstance(@NotNull MockComponentManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (manager.isDisposed()) {
            Throwable throwable = (Throwable)creationTraceMap.get(manager);
            if (throwable == null) {
                return;
            }
            Throwable trace = throwable;
            trace.printStackTrace(System.err);
        }
    }

    @JvmStatic
    public static final void diagnoseDisposedButNotClearedApplication(@NotNull Application app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        if (app instanceof MockComponentManager) {
            TestApplicationUtilKt.resetApplicationToNull();
            throw new IllegalStateException("Some test disposed, but forgot to clear MockApplication", (Throwable)creationTraceMap.get(app));
        }
    }

    static {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap<MockComponentManager, Throwable>()");
        creationTraceMap = concurrentMap;
    }
}

