/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.testFramework;

import com.intellij.core.CoreASTFactory;
import com.intellij.ide.util.AppPropertiesComponentImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.test.testFramework.KtPlatformLiteFixture;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.test.testFramework.MockProjectEx;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;

public abstract class KtParsingTestCase
extends KtPlatformLiteFixture {
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create((String)"HARD_REF_TO_DOCUMENT_KEY");
    protected String myFilePrefix;
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager myPsiManager;
    private PsiFileFactoryImpl myFileFactory;
    protected Language myLanguage;
    private final ParserDefinition[] myDefinitions;
    private final boolean myLowercaseFirstLetter;

    protected KtParsingTestCase(@NonNls @NotNull String dataPath, @NotNull String fileExt, ParserDefinition ... definitions) {
        if (dataPath == null) {
            KtParsingTestCase.$$$reportNull$$$0(0);
        }
        if (fileExt == null) {
            KtParsingTestCase.$$$reportNull$$$0(1);
        }
        if (definitions == null) {
            KtParsingTestCase.$$$reportNull$$$0(2);
        }
        this(dataPath, fileExt, false, definitions);
    }

    protected KtParsingTestCase(@NonNls @NotNull String dataPath, @NotNull String fileExt, boolean lowercaseFirstLetter, ParserDefinition ... definitions) {
        if (dataPath == null) {
            KtParsingTestCase.$$$reportNull$$$0(3);
        }
        if (fileExt == null) {
            KtParsingTestCase.$$$reportNull$$$0(4);
        }
        if (definitions == null) {
            KtParsingTestCase.$$$reportNull$$$0(5);
        }
        this.myFilePrefix = "";
        this.myDefinitions = definitions;
        this.myFullDataPath = this.getTestDataPath() + "/" + dataPath;
        this.myFileExt = fileExt;
        this.myLowercaseFirstLetter = lowercaseFirstLetter;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initApplication();
        ComponentAdapter component = KtParsingTestCase.getApplication().getPicoContainer().getComponentAdapter((Object)ProgressManager.class.getName());
        Extensions.registerAreaClass((String)"IDEA_PROJECT", null);
        this.myProject = new MockProjectEx(this.getTestRootDisposable());
        this.myPsiManager = new MockPsiManager((Project)this.myProject);
        this.myFileFactory = new PsiFileFactoryImpl((PsiManager)this.myPsiManager);
        MutablePicoContainer appContainer = KtParsingTestCase.getApplication().getPicoContainer();
        final MockEditorFactory editorFactory = new MockEditorFactory();
        MockFileTypeManager mockFileTypeManager = new MockFileTypeManager((FileType)KotlinFileType.INSTANCE);
        MockFileDocumentManagerImpl mockFileDocumentManager = new MockFileDocumentManagerImpl((Function)new Function<CharSequence, Document>(){

            public Document fun(CharSequence charSequence) {
                return editorFactory.createDocument(charSequence);
            }
        }, HARD_REF_TO_DOCUMENT_KEY);
        this.registerApplicationService(PropertiesComponent.class, new AppPropertiesComponentImpl());
        this.registerApplicationService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        this.registerApplicationService(DefaultASTFactory.class, new CoreASTFactory());
        this.registerApplicationService(SchemeManagerFactory.class, new MockSchemeManagerFactory());
        this.registerApplicationService(FileTypeManager.class, mockFileTypeManager);
        this.registerApplicationService(FileDocumentManager.class, mockFileDocumentManager);
        this.registerApplicationService(ProgressManager.class, new CoreProgressManager());
        KtParsingTestCase.registerComponentInstance(appContainer, FileTypeRegistry.class, mockFileTypeManager);
        KtParsingTestCase.registerComponentInstance(appContainer, FileTypeManager.class, mockFileTypeManager);
        KtParsingTestCase.registerComponentInstance(appContainer, EditorFactory.class, editorFactory);
        KtParsingTestCase.registerComponentInstance(appContainer, FileDocumentManager.class, mockFileDocumentManager);
        KtParsingTestCase.registerComponentInstance(appContainer, PsiDocumentManager.class, new MockPsiDocumentManager());
        this.myProject.registerService(CachedValuesManager.class, new CachedValuesManagerImpl((Project)this.myProject, (CachedValuesFactory)new PsiCachedValuesFactory((PsiManager)this.myPsiManager)));
        this.myProject.registerService(PsiManager.class, this.myPsiManager);
        this.myProject.registerService(TreeAspect.class, new TreeAspect());
        this.registerExtensionPoint(FileTypeFactory.FILE_TYPE_FACTORY_EP, FileTypeFactory.class);
        this.registerExtensionPoint(MetaLanguage.EP_NAME, MetaLanguage.class);
        for (ParserDefinition definition : this.myDefinitions) {
            this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, definition.getFileNodeType().getLanguage(), (Object)definition);
        }
        if (this.myDefinitions.length > 0) {
            this.configureFromParserDefinition(this.myDefinitions[0], this.myFileExt);
        }
        PomModelImpl pomModel = new PomModelImpl((Project)this.myProject);
        this.myProject.registerService(PomModel.class, pomModel);
    }

    public void configureFromParserDefinition(ParserDefinition definition, String extension) {
        this.myLanguage = definition.getFileNodeType().getLanguage();
        this.myFileExt = extension;
        this.addExplicitExtension((LanguageExtension)LanguageParserDefinitions.INSTANCE, this.myLanguage, (Object)definition);
        KtParsingTestCase.registerComponentInstance(KtParsingTestCase.getApplication().getPicoContainer(), FileTypeManager.class, new MockFileTypeManager((FileType)new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected <T> void addExplicitExtension(final LanguageExtension<T> instance, final Language language, final T object) {
        instance.addExplicitExtension(language, object);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                instance.removeExplicitExtension(language, object);
            }
        });
    }

    @Override
    protected <T> void registerExtensionPoint(final ExtensionPointName<T> extensionPointName, Class<T> aClass) {
        super.registerExtensionPoint(extensionPointName, aClass);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                Extensions.getRootArea().unregisterExtensionPoint(extensionPointName.getName());
            }
        });
    }

    protected <T> void registerApplicationService(final Class<T> aClass, T object) {
        KtParsingTestCase.getApplication().registerService(aClass, object);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                KtPlatformLiteFixture.getApplication().getPicoContainer().unregisterComponent((Object)aClass.getName());
            }
        });
    }

    public MockProjectEx getProject() {
        return this.myProject;
    }

    public MockPsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.myFile = null;
        this.myProject = null;
        this.myPsiManager = null;
    }

    protected String getTestDataPath() {
        return PathManager.getHomePath();
    }

    @NotNull
    public final String getTestName() {
        String string = this.getTestName(this.myLowercaseFirstLetter);
        if (string == null) {
            KtParsingTestCase.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void doTest(boolean checkResult2) {
        String name = this.getTestName();
        try {
            String text = this.loadFile(name + "." + this.myFileExt);
            this.myFile = this.createPsiFile(name, text);
            KtParsingTestCase.ensureParsed(this.myFile);
            KtParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)text, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
            KtParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)text, (Object)LoadTextUtil.loadText((VirtualFile)this.myFile.getVirtualFile()));
            KtParsingTestCase.assertEquals((String)"doc text mismatch", (String)text, (String)this.myFile.getViewProvider().getDocument().getText());
            KtParsingTestCase.assertEquals((String)"psi text mismatch", (String)text, (String)this.myFile.getText());
            KtParsingTestCase.ensureCorrectReparse(this.myFile);
            if (checkResult2) {
                this.checkResult(name, this.myFile);
            } else {
                KtParsingTestCase.toParseTreeText((PsiElement)this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doTest(String suffix) throws IOException {
        String name = this.getTestName();
        String text = this.loadFile(name + "." + this.myFileExt);
        this.myFile = this.createPsiFile(name, text);
        KtParsingTestCase.ensureParsed(this.myFile);
        KtParsingTestCase.assertEquals((String)text, (String)this.myFile.getText());
        this.checkResult(name + suffix, this.myFile);
    }

    protected void doCodeTest(String code) throws IOException {
        String name = this.getTestName();
        this.myFile = this.createPsiFile("a", code);
        KtParsingTestCase.ensureParsed(this.myFile);
        KtParsingTestCase.assertEquals((String)code, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + name, this.myFile);
    }

    protected PsiFile createPsiFile(String name, String text) {
        return this.createFile(name + "." + this.myFileExt, text);
    }

    protected PsiFile createFile(@NonNls String name, String text) {
        LightVirtualFile virtualFile = new LightVirtualFile(name, this.myLanguage, (CharSequence)text);
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        return this.createFile(virtualFile);
    }

    protected PsiFile createFile(LightVirtualFile virtualFile) {
        return this.myFileFactory.trySetupPsiForFile(virtualFile, this.myLanguage, true, false);
    }

    protected void checkResult(@NonNls String targetDataName, PsiFile file) throws IOException {
        KtParsingTestCase.doCheckResult(this.myFullDataPath, file, this.checkAllPsiRoots(), targetDataName, this.skipSpaces(), this.includeRanges());
    }

    public static void doCheckResult(String testDataDir, PsiFile file, boolean checkAllPsiRoots, String targetDataName, boolean skipSpaces, boolean printRanges) throws IOException {
        FileViewProvider provider = file.getViewProvider();
        Set languages = provider.getLanguages();
        if (!checkAllPsiRoots || languages.size() == 1) {
            KtParsingTestCase.doCheckResult(testDataDir, targetDataName + ".txt", KtParsingTestCase.toParseTreeText((PsiElement)file, skipSpaces, printRanges).trim());
            return;
        }
        for (Language language : languages) {
            PsiFile root = provider.getPsi(language);
            String expectedName = targetDataName + "." + language.getID() + ".txt";
            KtParsingTestCase.doCheckResult(testDataDir, expectedName, KtParsingTestCase.toParseTreeText((PsiElement)root, skipSpaces, printRanges).trim());
        }
    }

    protected void checkResult(String actual2) throws IOException {
        String name = this.getTestName();
        KtParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + name + ".txt", actual2);
    }

    protected void checkResult(@NonNls String targetDataName, String actual2) throws IOException {
        KtParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, actual2);
    }

    public static void doCheckResult(String fullPath, String targetDataName, String actual2) throws IOException {
        String expectedFileName = fullPath + File.separatorChar + targetDataName;
        KtUsefulTestCase.assertSameLinesWithFile(expectedFileName, actual2);
    }

    protected static String toParseTreeText(PsiElement file, boolean skipSpaces, boolean printRanges) {
        return DebugUtil.psiToString((PsiElement)file, (boolean)skipSpaces, (boolean)printRanges);
    }

    protected String loadFile(@NonNls String name) throws IOException {
        return KtParsingTestCase.loadFileDefault(this.myFullDataPath, name);
    }

    public static String loadFileDefault(String dir, String name) throws IOException {
        return FileUtil.loadFile((File)new File(dir, name), (String)"UTF-8", (boolean)true).trim();
    }

    public static void ensureParsed(PsiFile file) {
        file.accept(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile file) {
        if (file == null) {
            KtParsingTestCase.$$$reportNull$$$0(7);
        }
        String psiToStringDefault = DebugUtil.psiToString((PsiElement)file, (boolean)false, (boolean)false);
        String fileText = file.getText();
        DiffLog diffLog = new BlockSupportImpl().reparseRange(file, file.getNode(), TextRange.allOf((String)fileText), (CharSequence)fileText, (ProgressIndicator)new EmptyProgressIndicator(), (CharSequence)fileText);
        diffLog.performActualPsiChange(file);
        TestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString((PsiElement)file, (boolean)false, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/testFramework/KtParsingTestCase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/testFramework/KtParsingTestCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectReparse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

