/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.annotation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.AnnotationArgumentsRenderingPolicy;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.lazy.descriptors.PackageDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

public abstract class AbstractAnnotationDescriptorResolveTest
extends KotlinTestWithEnvironment {
    private static final DescriptorRenderer WITH_ANNOTATION_ARGUMENT_TYPES = DescriptorRenderer.Companion.withOptions(options -> {
        options.setVerbose(true);
        options.setAnnotationArgumentsRenderingPolicy(AnnotationArgumentsRenderingPolicy.UNLESS_EMPTY);
        options.setClassifierNamePolicy((ClassifierNamePolicy)ClassifierNamePolicy.SHORT.INSTANCE);
        options.setModifiers(DescriptorRendererModifier.ALL);
        return Unit.INSTANCE;
    });
    private static final String PATH = "compiler/testData/resolveAnnotations/testFile.kt";
    private static final FqName PACKAGE = new FqName("test");
    protected AnalysisResult analysisResult;

    protected BindingContext getContext() {
        return this.analysisResult.getBindingContext();
    }

    @Override
    protected KotlinCoreEnvironment createEnvironment() {
        return KotlinTestUtils.createEnvironmentWithMockJdkAndIdeaAnnotations(this.getTestRootDisposable());
    }

    protected void doTest(@NotNull String content2, @NotNull String expectedAnnotation) {
        if (content2 == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(0);
        }
        if (expectedAnnotation == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(1);
        }
        this.checkAnnotationOnAllExceptLocalDeclarations(content2, expectedAnnotation);
        this.checkAnnotationOnLocalDeclarations(expectedAnnotation);
    }

    protected void checkAnnotationOnAllExceptLocalDeclarations(String content2, String expectedAnnotation) {
        KtFile testFile = this.getFile(content2);
        PackageFragmentDescriptor testPackage = this.getPackage(testFile);
        this.checkAnnotationsOnFile(expectedAnnotation, testFile);
        ClassDescriptor myClass = AbstractAnnotationDescriptorResolveTest.getClassDescriptor(testPackage, "MyClass");
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)myClass);
        ClassDescriptor companionObjectDescriptor = myClass.getCompanionObjectDescriptor();
        assert (companionObjectDescriptor != null) : "Cannot find companion object for class " + myClass.getName();
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)companionObjectDescriptor);
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)AbstractAnnotationDescriptorResolveTest.getInnerClassDescriptor(myClass, "InnerClass"));
        FunctionDescriptor foo = AbstractAnnotationDescriptorResolveTest.getFunctionDescriptor(myClass, "foo");
        AbstractAnnotationDescriptorResolveTest.checkAnnotationsOnFunction(expectedAnnotation, foo);
        SimpleFunctionDescriptor anonymousFun = this.getAnonymousFunDescriptor();
        if (anonymousFun instanceof AnonymousFunctionDescriptor) {
            for (ValueParameterDescriptor descriptor : anonymousFun.getValueParameters()) {
                List destructuringVariables = ValueParameterDescriptorImpl.getDestructuringVariablesOrNull((ValueParameterDescriptor)descriptor);
                if (destructuringVariables == null) continue;
                for (VariableDescriptor entry : destructuringVariables) {
                    AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)entry);
                }
            }
        }
        PropertyDescriptor prop = AbstractAnnotationDescriptorResolveTest.getPropertyDescriptor(myClass, "prop");
        AbstractAnnotationDescriptorResolveTest.checkAnnotationsOnProperty(expectedAnnotation, prop);
        FunctionDescriptor topFoo = AbstractAnnotationDescriptorResolveTest.getFunctionDescriptor(testPackage, "topFoo");
        AbstractAnnotationDescriptorResolveTest.checkAnnotationsOnFunction(expectedAnnotation, topFoo);
        PropertyDescriptor topProp = AbstractAnnotationDescriptorResolveTest.getPropertyDescriptor(testPackage, "topProp", true);
        AbstractAnnotationDescriptorResolveTest.checkAnnotationsOnProperty(expectedAnnotation, topProp);
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)AbstractAnnotationDescriptorResolveTest.getClassDescriptor(testPackage, "MyObject"));
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)AbstractAnnotationDescriptorResolveTest.getConstructorParameterDescriptor(myClass, "consProp"));
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)AbstractAnnotationDescriptorResolveTest.getConstructorParameterDescriptor(myClass, "param"));
    }

    private void checkAnnotationsOnFile(String expectedAnnotation, KtFile file) {
        String actualAnnotation = StringUtil.join((Collection)file.getAnnotationEntries(), annotationEntry -> {
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)this.getContext().get((ReadOnlySlice)BindingContext.ANNOTATION, annotationEntry);
            AbstractAnnotationDescriptorResolveTest.assertNotNull((Object)annotationDescriptor);
            KtAnnotationUseSiteTarget target = annotationEntry.getUseSiteTarget();
            if (target != null) {
                return WITH_ANNOTATION_ARGUMENT_TYPES.renderAnnotation(annotationDescriptor, target.getAnnotationUseSiteTarget());
            }
            return WITH_ANNOTATION_ARGUMENT_TYPES.renderAnnotation(annotationDescriptor, null);
        }, (String)" ");
        String expectedAnnotationWithTarget = "@" + AnnotationUseSiteTarget.FILE.getRenderName() + ":" + expectedAnnotation.substring(1);
        AbstractAnnotationDescriptorResolveTest.assertEquals((String)expectedAnnotationWithTarget, (String)actualAnnotation);
    }

    private void checkAnnotationOnLocalDeclarations(String expectedAnnotation) {
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)this.getLocalClassDescriptor("LocalClass"));
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)this.getLocalObjectDescriptor("LocalObject"));
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)this.getLocalFunDescriptor("localFun"));
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)AbstractAnnotationDescriptorResolveTest.getLocalVarDescriptor(this.getContext(), "localVar"));
    }

    private static void checkAnnotationsOnProperty(String expectedAnnotation, PropertyDescriptor prop) {
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)prop);
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)prop.getGetter());
        PropertySetterDescriptor propSetter = prop.getSetter();
        AbstractAnnotationDescriptorResolveTest.assertNotNull((Object)propSetter);
        AbstractAnnotationDescriptorResolveTest.checkAnnotationsOnFunction(expectedAnnotation, (FunctionDescriptor)propSetter);
    }

    private static void checkAnnotationsOnFunction(String expectedAnnotation, FunctionDescriptor foo) {
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)foo);
        AbstractAnnotationDescriptorResolveTest.checkDescriptor(expectedAnnotation, (DeclarationDescriptor)AbstractAnnotationDescriptorResolveTest.getFunctionParameterDescriptor(foo, "param"));
    }

    @NotNull
    protected static FunctionDescriptor getFunctionDescriptor(@NotNull PackageFragmentDescriptor packageView, @NotNull String name) {
        if (packageView == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(2);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(3);
        }
        Name functionName = Name.identifier((String)name);
        MemberScope memberScope = packageView.getMemberScope();
        Collection functions = memberScope.getContributedFunctions(functionName, (LookupLocation)NoLookupLocation.FROM_TEST);
        assert (functions.size() == 1) : "Failed to find function " + functionName + " in class." + packageView.getName();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)functions.iterator().next();
        if (functionDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(4);
        }
        return functionDescriptor;
    }

    @NotNull
    private static FunctionDescriptor getFunctionDescriptor(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(5);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(6);
        }
        Name functionName = Name.identifier((String)name);
        MemberScope memberScope = classDescriptor.getMemberScope(Collections.emptyList());
        Collection functions = memberScope.getContributedFunctions(functionName, (LookupLocation)NoLookupLocation.FROM_TEST);
        assert (functions.size() == 1) : "Failed to find function " + functionName + " in class." + classDescriptor.getName();
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)functions.iterator().next();
        if (functionDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(7);
        }
        return functionDescriptor;
    }

    @Nullable
    protected static PropertyDescriptor getPropertyDescriptor(@NotNull PackageFragmentDescriptor packageView, @NotNull String name, boolean failOnMissing) {
        if (packageView == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(8);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(9);
        }
        Name propertyName = Name.identifier((String)name);
        MemberScope memberScope = packageView.getMemberScope();
        Collection properties = memberScope.getContributedVariables(propertyName, (LookupLocation)NoLookupLocation.FROM_TEST);
        if (properties.isEmpty()) {
            for (DeclarationDescriptor descriptor : DescriptorUtils.getAllDescriptors((MemberScope)memberScope)) {
                Collection classProperties;
                if (!(descriptor instanceof ClassDescriptor) || (classProperties = ((ClassDescriptor)descriptor).getMemberScope(Collections.emptyList()).getContributedVariables(propertyName, (LookupLocation)NoLookupLocation.FROM_TEST)).isEmpty()) continue;
                properties = classProperties;
                break;
            }
        }
        if (failOnMissing) {
            assert (properties.size() == 1) : "Failed to find property " + propertyName + " in class " + packageView.getName();
        } else if (properties.size() != 1) {
            return null;
        }
        return (PropertyDescriptor)properties.iterator().next();
    }

    @NotNull
    private static PropertyDescriptor getPropertyDescriptor(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(10);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(11);
        }
        Name propertyName = Name.identifier((String)name);
        MemberScope memberScope = classDescriptor.getMemberScope(Collections.emptyList());
        Collection properties = memberScope.getContributedVariables(propertyName, (LookupLocation)NoLookupLocation.FROM_TEST);
        assert (properties.size() == 1) : "Failed to find property " + propertyName + " in class " + classDescriptor.getName();
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)properties.iterator().next();
        if (propertyDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(12);
        }
        return propertyDescriptor;
    }

    @NotNull
    protected static ClassDescriptor getClassDescriptor(@NotNull PackageFragmentDescriptor packageView, @NotNull String name) {
        if (packageView == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(13);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(14);
        }
        Name className = Name.identifier((String)name);
        ClassifierDescriptor aClass = packageView.getMemberScope().getContributedClassifier(className, (LookupLocation)NoLookupLocation.FROM_TEST);
        AbstractAnnotationDescriptorResolveTest.assertNotNull((String)("Failed to find class: " + packageView.getName() + "." + className), (Object)aClass);
        assert (aClass instanceof ClassDescriptor) : "Not a class: " + aClass;
        ClassDescriptor classDescriptor = (ClassDescriptor)aClass;
        if (classDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(15);
        }
        return classDescriptor;
    }

    @NotNull
    private static ClassDescriptor getInnerClassDescriptor(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(16);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(17);
        }
        Name propertyName = Name.identifier((String)name);
        MemberScope memberScope = classDescriptor.getMemberScope(Collections.emptyList());
        ClassifierDescriptor innerClass = memberScope.getContributedClassifier(propertyName, (LookupLocation)NoLookupLocation.FROM_TEST);
        assert (innerClass instanceof ClassDescriptor) : "Failed to find inner class " + propertyName + " in class " + classDescriptor.getName();
        ClassDescriptor classDescriptor2 = (ClassDescriptor)innerClass;
        if (classDescriptor2 == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(18);
        }
        return classDescriptor2;
    }

    @NotNull
    private ClassDescriptor getLocalClassDescriptor(@NotNull String name) {
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(19);
        }
        for (ClassDescriptor descriptor : this.getContext().getSliceContents((ReadOnlySlice)BindingContext.CLASS).values()) {
            if (!descriptor.getName().asString().equals(name)) continue;
            ClassDescriptor classDescriptor = descriptor;
            if (classDescriptor == null) {
                AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(20);
            }
            return classDescriptor;
        }
        AbstractAnnotationDescriptorResolveTest.fail((String)("Failed to find local class " + name));
        if (null == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(21);
        }
        return null;
    }

    @NotNull
    private ClassDescriptor getLocalObjectDescriptor(@NotNull String name) {
        ClassDescriptor localClassDescriptor;
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(22);
        }
        if (DescriptorUtils.isNonCompanionObject((DeclarationDescriptor)(localClassDescriptor = this.getLocalClassDescriptor(name)))) {
            ClassDescriptor classDescriptor = localClassDescriptor;
            if (classDescriptor == null) {
                AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(23);
            }
            return classDescriptor;
        }
        AbstractAnnotationDescriptorResolveTest.fail((String)("Failed to find local object " + name));
        if (null == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(24);
        }
        return null;
    }

    @NotNull
    private SimpleFunctionDescriptor getLocalFunDescriptor(@NotNull String name) {
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(25);
        }
        for (SimpleFunctionDescriptor descriptor : this.getContext().getSliceContents((ReadOnlySlice)BindingContext.FUNCTION).values()) {
            if (!descriptor.getName().asString().equals(name)) continue;
            SimpleFunctionDescriptor simpleFunctionDescriptor = descriptor;
            if (simpleFunctionDescriptor == null) {
                AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(26);
            }
            return simpleFunctionDescriptor;
        }
        AbstractAnnotationDescriptorResolveTest.fail((String)("Failed to find local fun " + name));
        if (null == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(27);
        }
        return null;
    }

    @NotNull
    protected static VariableDescriptor getLocalVarDescriptor(@NotNull BindingContext context, @NotNull String name) {
        if (context == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(28);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(29);
        }
        for (VariableDescriptor descriptor : context.getSliceContents((ReadOnlySlice)BindingContext.VARIABLE).values()) {
            if (!descriptor.getName().asString().equals(name)) continue;
            VariableDescriptor variableDescriptor = descriptor;
            if (variableDescriptor == null) {
                AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(30);
            }
            return variableDescriptor;
        }
        AbstractAnnotationDescriptorResolveTest.fail((String)("Failed to find local variable " + name));
        if (null == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(31);
        }
        return null;
    }

    @NotNull
    private SimpleFunctionDescriptor getAnonymousFunDescriptor() {
        for (SimpleFunctionDescriptor descriptor : this.getContext().getSliceContents((ReadOnlySlice)BindingContext.FUNCTION).values()) {
            if (!(descriptor instanceof AnonymousFunctionDescriptor)) continue;
            SimpleFunctionDescriptor simpleFunctionDescriptor = descriptor;
            if (simpleFunctionDescriptor == null) {
                AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(32);
            }
            return simpleFunctionDescriptor;
        }
        AbstractAnnotationDescriptorResolveTest.fail((String)"Failed to find anonymous fun");
        if (null == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(33);
        }
        return null;
    }

    @NotNull
    private static ValueParameterDescriptor getConstructorParameterDescriptor(@NotNull ClassDescriptor classDescriptor, @NotNull String name) {
        if (classDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(34);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(35);
        }
        ConstructorDescriptor constructorDescriptor = AbstractAnnotationDescriptorResolveTest.getConstructorDescriptor(classDescriptor);
        ValueParameterDescriptor parameter = AbstractAnnotationDescriptorResolveTest.findValueParameter(constructorDescriptor.getValueParameters(), name);
        AbstractAnnotationDescriptorResolveTest.assertNotNull((String)("Cannot find constructor parameter with name " + name), (Object)parameter);
        ValueParameterDescriptor valueParameterDescriptor = parameter;
        if (valueParameterDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(36);
        }
        return valueParameterDescriptor;
    }

    @NotNull
    private static ConstructorDescriptor getConstructorDescriptor(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(37);
        }
        Collection constructors = classDescriptor.getConstructors();
        assert (constructors.size() == 1);
        ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)constructors.iterator().next();
        if (constructorDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(38);
        }
        return constructorDescriptor;
    }

    private static ValueParameterDescriptor findValueParameter(List<ValueParameterDescriptor> parameters, String name) {
        for (ValueParameterDescriptor parameter : parameters) {
            if (!parameter.getName().asString().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @NotNull
    private static ValueParameterDescriptor getFunctionParameterDescriptor(@NotNull FunctionDescriptor functionDescriptor, @NotNull String name) {
        if (functionDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(39);
        }
        if (name == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(40);
        }
        ValueParameterDescriptor parameter = AbstractAnnotationDescriptorResolveTest.findValueParameter(functionDescriptor.getValueParameters(), name);
        AbstractAnnotationDescriptorResolveTest.assertNotNull((String)("Cannot find function parameter with name " + name), (Object)parameter);
        ValueParameterDescriptor valueParameterDescriptor = parameter;
        if (valueParameterDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(41);
        }
        return valueParameterDescriptor;
    }

    @NotNull
    protected KtFile getFile(@NotNull String content2) {
        if (content2 == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(42);
        }
        KtFile ktFile = KtTestUtil.createFile((String)"dummy.kt", (String)content2, (Project)this.getProject());
        this.analysisResult = KotlinTestUtils.analyzeFile(ktFile, this.getEnvironment());
        KtFile ktFile2 = ktFile;
        if (ktFile2 == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(43);
        }
        return ktFile2;
    }

    @NotNull
    protected PackageFragmentDescriptor getPackage(@NotNull KtFile ktFile) {
        if (ktFile == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(44);
        }
        PackageFragmentDescriptor packageFragment = PackageDescriptorUtilKt.findPackageFragmentForFile((ModuleDescriptor)this.analysisResult.getModuleDescriptor(), (KtFile)ktFile);
        AbstractAnnotationDescriptorResolveTest.assertNotNull((String)("Failed to find package: " + PACKAGE), (Object)packageFragment);
        PackageFragmentDescriptor packageFragmentDescriptor = packageFragment;
        if (packageFragmentDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(45);
        }
        return packageFragmentDescriptor;
    }

    @NotNull
    protected PackageFragmentDescriptor getPackage(@NotNull String content2) {
        if (content2 == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(46);
        }
        PackageFragmentDescriptor packageFragmentDescriptor = this.getPackage(this.getFile(content2));
        if (packageFragmentDescriptor == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(47);
        }
        return packageFragmentDescriptor;
    }

    protected static String getContent(@NotNull String annotationText) throws IOException {
        if (annotationText == null) {
            AbstractAnnotationDescriptorResolveTest.$$$reportNull$$$0(48);
        }
        File file = new File(PATH);
        return KtTestUtil.doLoadFile((File)file).replaceAll("ANNOTATION", annotationText);
    }

    public static String renderAnnotations(Annotations annotations) {
        return StringUtil.join((Iterable)annotations, annotation -> WITH_ANNOTATION_ARGUMENT_TYPES.renderAnnotation(annotation, null), (String)" ");
    }

    private static void checkDescriptor(String expectedAnnotation, DeclarationDescriptor member) {
        String actual2 = AbstractAnnotationDescriptorResolveTest.renderAnnotations(member.getAnnotations());
        AbstractAnnotationDescriptorResolveTest.assertEquals((String)("Failed to resolve annotation descriptor for " + member.toString()), (String)expectedAnnotation, (String)actual2);
    }

    @Override
    public void tearDown() throws Exception {
        this.analysisResult = null;
        super.tearDown();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedAnnotation";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageView";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 29: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/annotation/AbstractAnnotationDescriptorResolveTest";
                break;
            }
            case 5: 
            case 10: 
            case 16: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktFile";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/annotation/AbstractAnnotationDescriptorResolveTest";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyDescriptor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassDescriptor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInnerClassDescriptor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalClassDescriptor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalObjectDescriptor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalFunDescriptor";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalVarDescriptor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousFunDescriptor";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorParameterDescriptor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorDescriptor";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionParameterDescriptor";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 45: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDescriptor";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInnerClassDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClassDescriptor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLocalObjectDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getLocalFunDescriptor";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLocalVarDescriptor";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorParameterDescriptor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorDescriptor";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParameterDescriptor";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getPackage";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

