/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.flags;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Opcodes;

public abstract class AbstractWriteFlagsTest
extends CodegenTestCase {
    private static final Map<Integer, String> FLAG_TO_STRING;

    @Override
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> files) throws Exception {
        if (wholeFile == null) {
            AbstractWriteFlagsTest.$$$reportNull$$$0(0);
        }
        if (files == null) {
            AbstractWriteFlagsTest.$$$reportNull$$$0(1);
        }
        List<KotlinBaseTest.TestFile> testFiles = files;
        this.compile(testFiles);
        String fileText = FileUtil.loadFile((File)wholeFile, (boolean)true);
        List<TestedObject> testedObjects = AbstractWriteFlagsTest.parseExpectedTestedObject(fileText);
        for (TestedObject testedObject : testedObjects) {
            int actual2;
            int expected;
            String className = null;
            for (OutputFile outputFile : this.classFileFactory.asList()) {
                String filePath = outputFile.getRelativePath();
                if ((!testedObject.isFullContainingClassName || !filePath.equals(testedObject.containingClass + ".class")) && (testedObject.isFullContainingClassName || !filePath.startsWith(testedObject.containingClass))) continue;
                className = filePath;
            }
            AbstractWriteFlagsTest.assertNotNull((String)("Couldn't find a class file with name " + testedObject.containingClass), className);
            OutputFile outputFile = this.classFileFactory.get(className);
            AbstractWriteFlagsTest.assertNotNull((Object)outputFile);
            ClassReader cr = new ClassReader(outputFile.asByteArray());
            TestClassVisitor classVisitor = AbstractWriteFlagsTest.getClassVisitor(testedObject, false);
            cr.accept((ClassVisitor)classVisitor, 1);
            if (!classVisitor.isExists()) {
                classVisitor = AbstractWriteFlagsTest.getClassVisitor(testedObject, true);
                cr.accept((ClassVisitor)classVisitor, 1);
            }
            boolean isObjectExists = Boolean.valueOf(InTextDirectivesUtils.findStringWithPrefixes((String)testedObject.textData, (String[])new String[]{"// ABSENT: "})) == false;
            AbstractWriteFlagsTest.assertEquals((String)("Wrong object existence state: " + testedObject), (boolean)isObjectExists, (boolean)classVisitor.isExists());
            if (!isObjectExists || (expected = AbstractWriteFlagsTest.getExpectedFlags(testedObject.textData)) == (actual2 = classVisitor.getAccess())) continue;
            AbstractWriteFlagsTest.assertEquals((String)("Wrong access flag for " + testedObject + " \n" + outputFile.asText()), (String)AbstractWriteFlagsTest.flagsToText(expected), (String)AbstractWriteFlagsTest.flagsToText(actual2));
        }
    }

    private static List<TestedObject> parseExpectedTestedObject(String testDescription) {
        String[] testObjectData = testDescription.substring(testDescription.indexOf("// TESTED_OBJECT_KIND")).split("\n\n");
        ArrayList<TestedObject> objects = new ArrayList<TestedObject>();
        for (String testData : testObjectData) {
            if (testData.isEmpty()) continue;
            TestedObject testObject = new TestedObject();
            testObject.textData = testData;
            List testedObjects = InTextDirectivesUtils.findListWithPrefixes((String)testData, (String[])new String[]{"// TESTED_OBJECTS: "});
            AbstractWriteFlagsTest.assertFalse((String)"Cannot find TESTED_OBJECTS instruction", (boolean)testedObjects.isEmpty());
            testObject.containingClass = (String)testedObjects.get(0);
            if (testedObjects.size() == 1) {
                testObject.name = (String)testedObjects.get(0);
            } else if (testedObjects.size() == 2) {
                testObject.name = (String)testedObjects.get(1);
            } else if (testedObjects.size() == 3) {
                testObject.name = (String)testedObjects.get(1);
                testObject.signature = (String)testedObjects.get(2);
            } else {
                throw new IllegalArgumentException("TESTED_OBJECTS instruction must contain one (for class), two or three (for function and property) values");
            }
            testObject.kind = InTextDirectivesUtils.findStringWithPrefixes((String)testData, (String[])new String[]{"// TESTED_OBJECT_KIND: "});
            List isFullName = InTextDirectivesUtils.findListWithPrefixes((String)testData, (String[])new String[]{"// IS_FULL_CONTAINING_CLASS_NAME: "});
            if (isFullName.size() == 1) {
                testObject.isFullContainingClassName = Boolean.parseBoolean((String)isFullName.get(0));
            }
            objects.add(testObject);
        }
        AbstractWriteFlagsTest.assertFalse((String)"Test description not present!", (boolean)objects.isEmpty());
        return objects;
    }

    private static TestClassVisitor getClassVisitor(@NotNull TestedObject object, boolean allowSynthetic) {
        if (object == null) {
            AbstractWriteFlagsTest.$$$reportNull$$$0(2);
        }
        switch (object.kind) {
            case "class": {
                return new ClassFlagsVisitor();
            }
            case "function": {
                return new FunctionFlagsVisitor(object.name, object.signature, allowSynthetic);
            }
            case "property": {
                return new PropertyFlagsVisitor(object.name, object.signature);
            }
            case "innerClass": {
                return new InnerClassFlagsVisitor(object.name);
            }
        }
        throw new IllegalArgumentException("Value of TESTED_OBJECT_KIND is incorrect: " + object.kind);
    }

    private static String flagsToText(int flags) {
        StringBuilder sb = new StringBuilder();
        sb.append(flags).append(" = ").append(String.format("0x%04x", flags)).append("\n");
        for (int flag = 1; flag > 0; flag <<= 1) {
            if ((flags & flag) == 0) continue;
            String string = FLAG_TO_STRING.get(flag);
            sb.append(string == null ? "unknown (" + flag + ")" : string).append("\n");
        }
        return sb.toString();
    }

    private static int getExpectedFlags(String text) {
        int expectedAccess = 0;
        List flags = InTextDirectivesUtils.findListWithPrefixes((String)text, (String[])new String[]{"// FLAGS: "});
        for (String flag : flags) {
            try {
                Field field = Opcodes.class.getDeclaredField(flag);
                expectedAccess |= field.getInt(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IllegalArgumentException("Cannot find " + flag + " field in Opcodes class", e);
            }
        }
        return expectedAccess;
    }

    static {
        HashMap<Integer, String> flagToString = new HashMap<Integer, String>();
        try {
            for (Field field : Opcodes.class.getDeclaredFields()) {
                String name = field.getName();
                if (!Modifier.isStatic(field.getModifiers()) || !name.startsWith("ACC_")) continue;
                int value = field.getInt(null);
                String previous = (String)flagToString.get(value);
                flagToString.put(value, previous == null ? name : previous + "/" + name);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
        FLAG_TO_STRING = Collections.unmodifiableMap(flagToString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/flags/AbstractWriteFlagsTest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doMultiFileTest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getClassVisitor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InnerClassFlagsVisitor
    extends TestClassVisitor {
        private int access = 0;
        private final String innerClassName;

        public InnerClassFlagsVisitor(String name) {
            this.innerClassName = name;
        }

        public void visitInnerClass(@NotNull String innerClassInternalName, String outerClassInternalName, String name, int access) {
            if (innerClassInternalName == null) {
                InnerClassFlagsVisitor.$$$reportNull$$$0(0);
            }
            if (this.innerClassName.equals(name)) {
                this.access = access;
                this.isExists = true;
            }
        }

        @Override
        public int getAccess() {
            return this.access;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "innerClassInternalName", "org/jetbrains/kotlin/codegen/flags/AbstractWriteFlagsTest$InnerClassFlagsVisitor", "visitInnerClass"));
        }
    }

    private static class PropertyFlagsVisitor
    extends TestClassVisitor {
        private int access;
        private final String propertyName;
        private final String propertySignature;

        public PropertyFlagsVisitor(@NotNull String name, @Nullable String signature) {
            if (name == null) {
                PropertyFlagsVisitor.$$$reportNull$$$0(0);
            }
            this.access = 0;
            this.propertyName = name;
            this.propertySignature = signature;
        }

        public FieldVisitor visitField(int access, @NotNull String name, @NotNull String desc, String signature, Object value) {
            if (name == null) {
                PropertyFlagsVisitor.$$$reportNull$$$0(1);
            }
            if (desc == null) {
                PropertyFlagsVisitor.$$$reportNull$$$0(2);
            }
            if (name.equals(this.propertyName) && (this.propertySignature == null || this.propertySignature.equals(desc))) {
                this.access = access;
                this.isExists = true;
            }
            return null;
        }

        @Override
        public int getAccess() {
            return this.access;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/flags/AbstractWriteFlagsTest$PropertyFlagsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FunctionFlagsVisitor
    extends TestClassVisitor {
        private int access;
        private final String funName;
        private final String funSignature;
        private final boolean allowSynthetic;

        public FunctionFlagsVisitor(@NotNull String name, @Nullable String signature, boolean allowSynthetic) {
            if (name == null) {
                FunctionFlagsVisitor.$$$reportNull$$$0(0);
            }
            this.access = 0;
            this.funName = name;
            this.funSignature = signature;
            this.allowSynthetic = allowSynthetic;
        }

        public MethodVisitor visitMethod(int access, @NotNull String name, @NotNull String desc, String signature, String[] exceptions) {
            if (name == null) {
                FunctionFlagsVisitor.$$$reportNull$$$0(1);
            }
            if (desc == null) {
                FunctionFlagsVisitor.$$$reportNull$$$0(2);
            }
            if (name.equals(this.funName) && (this.funSignature == null || this.funSignature.equals(desc))) {
                if (!this.allowSynthetic && (access & 0x1000) != 0) {
                    return null;
                }
                this.access = access;
                this.isExists = true;
            }
            return null;
        }

        @Override
        public int getAccess() {
            return this.access;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/codegen/flags/AbstractWriteFlagsTest$FunctionFlagsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClassFlagsVisitor
    extends TestClassVisitor {
        private int access = 0;

        private ClassFlagsVisitor() {
        }

        public void visit(int version, int access, @NotNull String name, String signature, String superName, String[] interfaces) {
            if (name == null) {
                ClassFlagsVisitor.$$$reportNull$$$0(0);
            }
            this.access = access;
            this.isExists = true;
        }

        @Override
        public int getAccess() {
            return this.access;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/flags/AbstractWriteFlagsTest$ClassFlagsVisitor", "visit"));
        }
    }

    protected static abstract class TestClassVisitor
    extends ClassVisitor {
        protected boolean isExists;

        public TestClassVisitor() {
            super(524288);
        }

        public abstract int getAccess();

        public boolean isExists() {
            return this.isExists;
        }
    }

    private static class TestedObject {
        public String name;
        public String containingClass = "";
        public boolean isFullContainingClassName = true;
        public String kind;
        public String textData;
        public String signature;

        private TestedObject() {
        }

        public String toString() {
            return "Class = " + this.containingClass + ", name = " + this.name + ", kind = " + this.kind + (this.signature != null ? ", signature = " + this.signature : "");
        }
    }
}

