/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.defaultConstructor;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;

public abstract class AbstractDefaultArgumentsReflectionTest
extends CodegenTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createEnvironmentWithMockJdkAndIdeaAnnotations(ConfigurationKind.JDK_ONLY, new File[0]);
    }

    @Override
    protected void doTest(@NotNull String path) throws IOException {
        if (path == null) {
            AbstractDefaultArgumentsReflectionTest.$$$reportNull$$$0(0);
        }
        this.loadFileByFullPath(path);
        File file = new File(path);
        String fileText = FileUtil.loadFile((File)file, (boolean)true);
        String className = AbstractDefaultArgumentsReflectionTest.loadInstructionValue(fileText, "CLASS");
        boolean hasDefaultConstructor = AbstractDefaultArgumentsReflectionTest.loadInstructionValue(fileText, "HAS_DEFAULT_CONSTRUCTOR").equals("true");
        Class<?> aClass = this.generateClass(className);
        AbstractDefaultArgumentsReflectionTest.assertNotNull((String)("Cannot find class with name " + className), aClass);
        try {
            Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
            if (!hasDefaultConstructor) {
                System.out.println(this.generateToText());
                throw new AssertionError((Object)("Default constructor was found but it wasn't expected: " + constructor));
            }
        }
        catch (NoSuchMethodException e) {
            if (hasDefaultConstructor) {
                this.printReport(file);
                throw new AssertionError((Object)"Cannot find default constructor");
            }
        }
        catch (Throwable e) {
            this.printReport(file);
            throw new RuntimeException(e);
        }
    }

    private static String loadInstructionValue(String fileContent, String instructionName) {
        List testedClass = InTextDirectivesUtils.findListWithPrefixes((String)fileContent, (String[])new String[]{"// " + instructionName + ": "});
        AbstractDefaultArgumentsReflectionTest.assertTrue((String)("Cannot find " + instructionName + " instruction"), (!testedClass.isEmpty() ? 1 : 0) != 0);
        AbstractDefaultArgumentsReflectionTest.assertTrue((String)(instructionName + " instruction must have only one element"), (testedClass.size() == 1 ? 1 : 0) != 0);
        return (String)testedClass.get(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/kotlin/codegen/defaultConstructor/AbstractDefaultArgumentsReflectionTest", "doTest"));
    }
}

