/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.modules.ModuleBuilder;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.codegen.GenerationUtils;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.jvm.compiler.AbstractCompileKotlinAgainstJavaTest;
import org.jetbrains.kotlin.jvm.compiler.AbstractLoadJavaTest;
import org.jetbrains.kotlin.jvm.compiler.LoadDescriptorUtil;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TestCaseWithTmpdir;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparator;
import org.junit.Assert;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractCompileKotlinAgainstJavaTest;", "Lorg/jetbrains/kotlin/test/TestCaseWithTmpdir;", "()V", "compileKotlinWithJava", "", "javaFiles", "", "Ljava/io/File;", "kotlinFiles", "outDir", "disposable", "Lcom/intellij/openapi/Disposable;", "aptMode", "doTest", "", "ktFilePath", "", "doTestWithAPT", "doTestWithoutAPT", "updateConfiguration", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "tests-common"})
public abstract class AbstractCompileKotlinAgainstJavaTest
extends TestCaseWithTmpdir {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final RecursiveDescriptorComparator.Configuration CONFIGURATION = AbstractLoadJavaTest.COMPARATOR_CONFIGURATION.withRenderer(DescriptorRenderer.Companion.withOptions((Function1)Companion.CONFIGURATION.1.INSTANCE));

    protected final void doTestWithoutAPT(@NotNull String ktFilePath) {
        Intrinsics.checkNotNullParameter((Object)ktFilePath, (String)"ktFilePath");
        this.doTest(ktFilePath, false);
    }

    protected final void doTestWithAPT(@NotNull String ktFilePath) {
        Intrinsics.checkNotNullParameter((Object)ktFilePath, (String)"ktFilePath");
        this.doTest(ktFilePath, true);
    }

    private final void doTest(String ktFilePath, boolean aptMode) {
        Assert.assertTrue((boolean)StringsKt.endsWith$default((String)ktFilePath, (String)".kt", (boolean)false, (int)2, null));
        File ktFile = new File(ktFilePath);
        CharSequence charSequence = ktFilePath;
        String string = "\\.kt$";
        boolean bl = false;
        string = new Regex(string);
        String string2 = ".java";
        boolean bl2 = false;
        File javaFile = new File(string.replaceFirst(charSequence, string2));
        File out = new File(this.tmpdir, "out");
        List list = CollectionsKt.listOf((Object)javaFile);
        List list2 = CollectionsKt.listOf((Object)ktFile);
        string2 = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"testRootDisposable");
        boolean compiledSuccessfully2 = this.compileKotlinWithJava(list, list2, out, (Disposable)string2, aptMode);
        if (!compiledSuccessfully2) {
            return;
        }
        Disposable disposable = this.getTestRootDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"testRootDisposable");
        Disposable disposable2 = disposable;
        File[] fileArray = new File[]{KotlinTestUtils.getAnnotationsJar(), out};
        disposable = KotlinTestUtils.newConfiguration(ConfigurationKind.ALL, TestJdkKind.MOCK_JDK, fileArray);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newConfiguration(ConfigurationKind.ALL, TestJdkKind.MOCK_JDK, getAnnotationsJar(), out)");
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForTests(disposable2, (CompilerConfiguration)disposable, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        environment.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, (Object)true);
        environment.getConfiguration().put(JVMConfigurationKeys.OUTPUT_DIRECTORY, (Object)out);
        KotlinCoreEnvironment.registerJavac$default((KotlinCoreEnvironment)environment, (List)CollectionsKt.emptyList(), null, null, (List)CollectionsKt.listOf((Object)KotlinTestUtils.findMockJdkRtJar()), null, (int)22, null);
        AnalysisResult analysisResult = JvmResolveUtil.analyze(environment);
        ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
        FqName fqName = LoadDescriptorUtil.TEST_PACKAGE_FQNAME;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"TEST_PACKAGE_FQNAME");
        PackageViewDescriptor packageView = moduleDescriptor.getPackage(fqName);
        TestCaseWithTmpdir.assertFalse((String)Intrinsics.stringPlus((String)"Nothing found in package ", (Object)LoadDescriptorUtil.TEST_PACKAGE_FQNAME), (boolean)packageView.isEmpty());
        CharSequence charSequence2 = ktFilePath;
        String string3 = "\\.kt$";
        boolean bl3 = false;
        string3 = new Regex(string3);
        String string4 = ".txt";
        boolean bl4 = false;
        File expectedFile = new File(string3.replaceFirst(charSequence2, string4));
        RecursiveDescriptorComparator.validateAndCompareDescriptorWithFile((DeclarationDescriptor)packageView, CONFIGURATION, expectedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean compileKotlinWithJava(@NotNull List<? extends File> javaFiles, @NotNull List<? extends File> kotlinFiles, @NotNull File outDir, @NotNull Disposable disposable, boolean aptMode) {
        boolean bl;
        String[] stringArray;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(javaFiles, (String)"javaFiles");
        Intrinsics.checkNotNullParameter(kotlinFiles, (String)"kotlinFiles");
        Intrinsics.checkNotNullParameter((Object)outDir, (String)"outDir");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        KotlinCoreEnvironment kotlinCoreEnvironment = KotlinTestUtils.createEnvironmentWithMockJdkAndIdeaAnnotations(disposable);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"createEnvironmentWithMockJdkAndIdeaAnnotations(disposable)");
        KotlinCoreEnvironment environment = kotlinCoreEnvironment;
        this.updateConfiguration(environment.getConfiguration());
        environment.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, (Object)true);
        environment.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, (Object)true);
        Object $this$map$iv = (String[])kotlinFiles;
        boolean $i$f$map = false;
        String[] stringArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void kotlinFile;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            KtFile ktFile = KotlinTestUtils.createFile(kotlinFile.getName(), FileUtil.loadFile((File)kotlinFile, (boolean)true), environment.getProject());
            collection.add(ktFile);
        }
        List ktFiles = (List)destination$iv$iv;
        if (aptMode) {
            stringArray = new String[]{};
        } else {
            $this$map$iv = new String[]{"-proc:none"};
            stringArray = $this$map$iv;
        }
        KotlinCoreEnvironment.registerJavac$default((KotlinCoreEnvironment)environment, javaFiles, (List)ktFiles, (String[])stringArray, (List)CollectionsKt.listOf((Object)KotlinTestUtils.findMockJdkRtJar()), null, (int)16, null);
        ModuleVisibilityManager moduleVisibilityManager = ModuleVisibilityManager.SERVICE.getInstance((Project)environment.getProject());
        $this$map$iv = this.tmpdir.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"tmpdir.absolutePath");
        moduleVisibilityManager.addModule((Module)new ModuleBuilder("module for test", (String)$this$map$iv, "test"));
        $this$map$iv = kotlinFiles;
        boolean bl3 = false;
        if (!$this$map$iv.isEmpty()) {
            GenerationUtils.compileFilesTo(ktFiles, environment, outDir);
        } else {
            boolean mkdirs = outDir.mkdirs();
            bl3 = false;
            if (_Assertions.ENABLED && !mkdirs) {
                boolean bl4 = false;
                String string = Intrinsics.stringPlus((String)"Not created: ", (Object)outDir);
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
        Closeable closeable = (Closeable)JavacWrapper.Companion.getInstance(environment.getProject());
        bl3 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            JavacWrapper it = (JavacWrapper)closeable;
            boolean bl6 = false;
            bl = it.compile(outDir);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bl;
    }

    public void updateConfiguration(@NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/jvm/compiler/AbstractCompileKotlinAgainstJavaTest$Companion;", "", "()V", "CONFIGURATION", "Lorg/jetbrains/kotlin/test/util/RecursiveDescriptorComparator$Configuration;", "kotlin.jvm.PlatformType", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

