/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.forTestCompile;

import java.io.File;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public class ForTestCompileRuntime {
    private static volatile SoftReference<ClassLoader> reflectJarClassLoader = new SoftReference<Object>(null);
    private static volatile SoftReference<ClassLoader> runtimeJarClassLoader = new SoftReference<Object>(null);

    @NotNull
    public static File runtimeJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-stdlib.jar"));
    }

    @NotNull
    public static File runtimeJarForTestsWithJdk8() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-stdlib-jdk8.jar"));
    }

    @NotNull
    public static File minimalRuntimeJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlin-stdlib-minimal-for-test.jar"));
    }

    @NotNull
    public static File kotlinTestJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-test.jar"));
    }

    @NotNull
    public static File kotlinTestJUnitJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-test-junit.jar"));
    }

    @NotNull
    public static File kotlinTestJsJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-test-js.jar"));
    }

    @NotNull
    public static File reflectJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-reflect.jar"));
    }

    @NotNull
    public static File scriptRuntimeJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-script-runtime.jar"));
    }

    @NotNull
    public static File runtimeSourcesJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-stdlib-sources.jar"));
    }

    @NotNull
    public static File stdlibMavenSourcesJarForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/maven/kotlin-stdlib-sources.jar"));
    }

    @NotNull
    public static File stdlibCommonForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/common/kotlin-stdlib-common.jar"));
    }

    @NotNull
    public static File stdlibCommonSourcesForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/common/kotlin-stdlib-common-sources.jar"));
    }

    @NotNull
    public static File stdlibJsForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-stdlib-js.jar"));
    }

    @NotNull
    public static File jetbrainsAnnotationsForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/annotations-13.0.jar"));
    }

    @NotNull
    public static File jvmAnnotationsForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-annotations-jvm.jar"));
    }

    @NotNull
    public static File androidAnnotationsForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-annotations-android.jar"));
    }

    @NotNull
    public static File coroutinesCompatForTests() {
        return ForTestCompileRuntime.assertExists(new File("dist/kotlinc/lib/kotlin-coroutines-experimental-compat.jar"));
    }

    @NotNull
    private static File assertExists(@NotNull File file) {
        if (file == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(0);
        }
        if (!file.exists()) {
            throw new IllegalStateException(file + " does not exist. Run 'gradlew dist'");
        }
        File file2 = file;
        if (file2 == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @NotNull
    public static synchronized ClassLoader runtimeAndReflectJarClassLoader() {
        ClassLoader loader = reflectJarClassLoader.get();
        if (loader == null) {
            loader = ForTestCompileRuntime.createClassLoader(ForTestCompileRuntime.runtimeJarForTests(), ForTestCompileRuntime.reflectJarForTests(), ForTestCompileRuntime.scriptRuntimeJarForTests(), ForTestCompileRuntime.kotlinTestJarForTests());
            reflectJarClassLoader = new SoftReference<ClassLoader>(loader);
        }
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(2);
        }
        return classLoader;
    }

    @NotNull
    public static synchronized ClassLoader runtimeJarClassLoader() {
        ClassLoader loader = runtimeJarClassLoader.get();
        if (loader == null) {
            loader = ForTestCompileRuntime.createClassLoader(ForTestCompileRuntime.runtimeJarForTests(), ForTestCompileRuntime.scriptRuntimeJarForTests(), ForTestCompileRuntime.kotlinTestJarForTests());
            runtimeJarClassLoader = new SoftReference<ClassLoader>(loader);
        }
        ClassLoader classLoader = loader;
        if (classLoader == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(3);
        }
        return classLoader;
    }

    @NotNull
    private static ClassLoader createClassLoader(File ... files) {
        if (files == null) {
            ForTestCompileRuntime.$$$reportNull$$$0(4);
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(2);
            for (File file : files) {
                urls.add(file.toURI().toURL());
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        }
        catch (MalformedURLException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/forTestCompile/ForTestCompileRuntime";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/forTestCompile/ForTestCompileRuntime";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "assertExists";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeAndReflectJarClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "runtimeJarClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertExists";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createClassLoader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

