/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.AbstractDiagnosticsTest;
import org.jetbrains.kotlin.checkers.AbstractJspecifyAnnotationsTest;
import org.jetbrains.kotlin.checkers.BaseDiagnosticsTest;
import org.jetbrains.kotlin.checkers.DiagnosedRange;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.test.MockLibraryUtil;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J8\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J8\u0010\u0011\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J\"\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\b2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00160\u000bH\u0014J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\"\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00160\u000bH\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/checkers/AbstractJspecifyAnnotationsTest;", "Lorg/jetbrains/kotlin/checkers/AbstractDiagnosticsTest;", "()V", "checkDiagnostics", "", "actualText", "", "testDataFile", "Ljava/io/File;", "checkIfAllDiagnosticsByJspecifyMarksArePresent", "diagnosedRanges", "", "Lorg/jetbrains/kotlin/checkers/DiagnosedRange;", "lineIndexesByRanges", "Ljava/util/TreeMap;", "", "textLines", "checkIfAllJspecifyMarksByDiagnosticsArePresent", "doMultiFileTest", "wholeFile", "files", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;", "doTest", "filePath", "getExpectedDescriptorFile", "getJspecifyMarkRegex", "Lkotlin/text/Regex;", "jspecifyMark", "makeJavaClassesPublicAndSeparatedByFiles", "javaCode", "Companion", "tests-common"})
public abstract class AbstractJspecifyAnnotationsTest
extends AbstractDiagnosticsTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String JSPECIFY_JAVA_SOURCES_PATH = "compiler/testData/foreignAnnotationsJava8/tests/jspecify/java";
    @NotNull
    public static final String MAIN_KT_FILE_DIRECTIVE = "// FILE: main.kt\n";
    private static final Pattern originalKtFileRegex = Pattern.compile("// ORIGINAL_KT_FILE: (.*?\\.kts?)\\n");
    private static final Pattern javaSourcesPathRegex = Pattern.compile("// JAVA_SOURCES: (.*?(?:\\.java)?)\\n");
    @NotNull
    private static final Map<DiagnosticFactory2<KtElement, KotlinType, KotlinType>, String> diagnosticsToJspecifyMarksMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS, (Object)"jspecify_nullness_mismatch"));
    @NotNull
    private static final Regex importSectionRegex = new Regex("((?:import .*?;\\n)+)");
    @NotNull
    private static final Regex classOrInterfaceRegex = new Regex("(class|interface)");
    @NotNull
    private static final Regex publicClassOrInterfaceRegex = new Regex("public (class|interface)");
    @NotNull
    private static final Regex classShapeRegex = new Regex("(\\n@DefaultNonNull)?\\npublic (class|interface) (\\w+)(<[^>]+>)?");

    @Override
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<BaseDiagnosticsTest.TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        super.doMultiFileTest(wholeFile, files, MockLibraryUtil.compileJavaFilesLibraryToJar$default("third-party/jdk8-annotations", "foreign-annotations", false, null, null, 28, null), false, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doTest(@NotNull String filePath) {
        void $this$doTest_u24lambda_u2d3;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String ktSourceCode = FilesKt.readText$default((File)new File(filePath), null, (int)1, null);
        Matcher matcher = javaSourcesPathRegex.matcher(ktSourceCode);
        boolean bl = false;
        boolean bl2 = false;
        Matcher it = matcher;
        boolean $i$a$-also-AbstractJspecifyAnnotationsTest$doTest$javaSourcesFilename$22 = false;
        it.find();
        String string = matcher.group(1);
        if (string == null) {
            throw new Exception("Java sources' path not found");
        }
        String javaSourcesFilename = string;
        File javaSourcesFile = new File(Intrinsics.stringPlus((String)"compiler/testData/foreignAnnotationsJava8/tests/jspecify/java/", (Object)javaSourcesFilename));
        bl = false;
        bl2 = false;
        CharSequence charSequence = new StringBuilder();
        boolean bl3 = false;
        $i$a$-also-AbstractJspecifyAnnotationsTest$doTest$javaSourcesFilename$22 = false;
        StringBuilder $this$doTest_u24lambda_u2d2 = charSequence;
        boolean bl4 = false;
        Object object = $this$doTest_u24lambda_u2d2;
        String string2 = Intrinsics.stringPlus((String)"// ORIGINAL_KT_FILE: ", (Object)filePath);
        boolean bl5 = false;
        StringBuilder stringBuilder = ((StringBuilder)object).append(string2);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        CharSequence charSequence2 = stringBuilder;
        boolean bl6 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)charSequence2).append('\n'), (String)"append('\\n')");
        if (StringsKt.endsWith$default((String)javaSourcesFilename, (String)".java", (boolean)false, (int)2, null)) {
            object = $this$doTest_u24lambda_u2d2;
            string2 = this.makeJavaClassesPublicAndSeparatedByFiles(FilesKt.readText$default((File)javaSourcesFile, null, (int)1, null));
            bl5 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)object).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            charSequence2 = stringBuilder2;
            bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)charSequence2).append('\n'), (String)"append('\\n')");
        } else {
            boolean bl7 = javaSourcesFile.isDirectory();
            boolean bl8 = false;
            if (_Assertions.ENABLED && !bl7) {
                boolean bl9 = false;
                String string3 = "Specified Java sources should be a file with `java` extension or directory";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            for (File javaFile : SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)javaSourcesFile)), (Function1)doTest.mergedSourceCode.1.2.INSTANCE)) {
                StringBuilder stringBuilder3 = $this$doTest_u24lambda_u2d2;
                charSequence2 = Intrinsics.stringPlus((String)"// FILE: ", (Object)javaFile.getName());
                bl6 = false;
                StringBuilder stringBuilder4 = stringBuilder3.append((String)charSequence2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringBuilder stringBuilder5 = stringBuilder4;
                boolean bl10 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
                stringBuilder3 = $this$doTest_u24lambda_u2d2;
                charSequence2 = this.makeJavaClassesPublicAndSeparatedByFiles(FilesKt.readText$default((File)javaFile, null, (int)1, null));
                bl6 = false;
                StringBuilder stringBuilder6 = stringBuilder3.append((String)charSequence2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                stringBuilder5 = stringBuilder6;
                bl10 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            }
        }
        object = $this$doTest_u24lambda_u2d2;
        String string4 = Intrinsics.stringPlus((String)MAIN_KT_FILE_DIRECTIVE, (Object)ktSourceCode);
        bl5 = false;
        StringBuilder stringBuilder7 = ((StringBuilder)object).append(string4);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        charSequence2 = stringBuilder7;
        bl6 = false;
        Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)charSequence2).append('\n'), (String)"append('\\n')");
        String string5 = charSequence.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply(builderAction).toString()");
        String mergedSourceCode2 = string5;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Object object2 = null;
        charSequence = null;
        $i$a$-also-AbstractJspecifyAnnotationsTest$doTest$javaSourcesFilename$22 = false;
        Path path = Files.createTempFile((String)object2, (String)charSequence, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempFile(prefix, suffix, *attributes)");
        object2 = path;
        boolean bl11 = false;
        boolean bl12 = false;
        Object $i$a$-also-AbstractJspecifyAnnotationsTest$doTest$javaSourcesFilename$22 = object2;
        AbstractJspecifyAnnotationsTest abstractJspecifyAnnotationsTest = this;
        boolean bl13 = false;
        PathsKt.writeText$default((Path)$this$doTest_u24lambda_u2d3, (CharSequence)mergedSourceCode2, null, (OpenOption[])new OpenOption[0], (int)2, null);
        Unit unit = Unit.INSTANCE;
        super.doTest(object2.toString());
    }

    private final String makeJavaClassesPublicAndSeparatedByFiles(String javaCode) {
        String string;
        CharSequence charSequence;
        MatchResult importSectionMatch = Regex.find$default((Regex)importSectionRegex, (CharSequence)javaCode, (int)0, (int)2, null);
        if (importSectionMatch != null) {
            StringBuilder stringBuilder = new StringBuilder().append('\n');
            charSequence = importSectionMatch.getGroups().get(1);
            Intrinsics.checkNotNull((Object)charSequence);
            string = stringBuilder.append(charSequence.getValue()).append('\n').toString();
        } else {
            string = "";
        }
        String importSection = string;
        charSequence = javaCode;
        Regex regex = importSectionRegex;
        String string2 = "";
        boolean bl = false;
        charSequence = regex.replace(charSequence, string2);
        regex = publicClassOrInterfaceRegex;
        string2 = "$1";
        bl = false;
        charSequence = regex.replace(charSequence, string2);
        regex = classOrInterfaceRegex;
        string2 = "public $1";
        bl = false;
        charSequence = regex.replace(charSequence, string2);
        regex = classShapeRegex;
        string2 = "\n// FILE: $3.java" + importSection + "$1\npublic $2 $3$4";
        bl = false;
        return regex.replace(charSequence, string2);
    }

    private final Regex getJspecifyMarkRegex(String jspecifyMark) {
        return new Regex("^\\s*// " + jspecifyMark + '$');
    }

    private final void checkIfAllJspecifyMarksByDiagnosticsArePresent(List<DiagnosedRange> diagnosedRanges, TreeMap<Integer, Integer> lineIndexesByRanges, List<String> textLines) {
        for (DiagnosedRange diagnosticRange : diagnosedRanges) {
            Integer lineIndex = lineIndexesByRanges.floorEntry(diagnosticRange.getStart()).getValue();
            for (TextDiagnostic diagnostic : diagnosticRange.getDiagnostics()) {
                Map<DiagnosticFactory2<KtElement, KotlinType, KotlinType>, String> map = Companion.getDiagnosticsToJspecifyMarksMap();
                String string = diagnostic.getName();
                boolean bl = false;
                String string2 = map.get(string);
                if (string2 == null) continue;
                String requiredJspecifyMark = string2;
                Integer n = lineIndex;
                boolean bl2 = false;
                bl2 = n == null || n != 0;
                boolean bl3 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl4 = false;
                    String string3 = AbstractJspecifyAnnotationsTest.checkIfAllJspecifyMarksByDiagnosticsArePresent$getErrorMessage(requiredJspecifyMark, diagnostic, 0);
                    throw (Throwable)((Object)new AssertionError((Object)string3));
                }
                String previousLine = textLines.get(lineIndex - 1);
                bl3 = this.getJspecifyMarkRegex(requiredJspecifyMark).matches((CharSequence)previousLine);
                boolean bl5 = false;
                if (!_Assertions.ENABLED || bl3) continue;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)lineIndex, (String)"lineIndex");
                String string4 = AbstractJspecifyAnnotationsTest.checkIfAllJspecifyMarksByDiagnosticsArePresent$getErrorMessage(requiredJspecifyMark, diagnostic, lineIndex);
                throw (Throwable)((Object)new AssertionError((Object)string4));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIfAllDiagnosticsByJspecifyMarksArePresent(List<DiagnosedRange> diagnosedRanges, TreeMap<Integer, Integer> lineIndexesByRanges, List<String> textLines) {
        Object object = Companion.getDiagnosticsToJspecifyMarksMap();
        boolean bl = false;
        Iterator<Map.Entry<DiagnosticFactory2<KtElement, KotlinType, KotlinType>, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapIndexedNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string;
            String it;
            DiagnosedRange diagnostics;
            void $this$filterTo$iv$iv;
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            DiagnosticFactory2 diagnostic = (DiagnosticFactory2)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String jspecifyMark = (String)object3.getValue();
            Iterable $this$filter$iv = diagnosedRanges;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                diagnostics = (DiagnosedRange)element$iv$iv;
                boolean bl4 = false;
                Iterable $this$map$iv2 = diagnostics.getDiagnostics();
                boolean bl5 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    TextDiagnostic textDiagnostic = (TextDiagnostic)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl52 = false;
                    string = it.getName();
                    collection.add(string);
                }
                if (!((List)destination$iv$iv2).contains(diagnostic.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                diagnostics = (DiagnosedRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                Integer n = it2.getStart();
                collection.add(n);
            }
            List diagnosticRanges = (List)destination$iv$iv;
            Iterable $this$mapIndexedNotNull$iv = textLines;
            boolean $i$f$mapIndexedNotNull = false;
            destination$iv$iv = $this$mapIndexedNotNull$iv;
            Object destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo22 = false;
            void $this$forEachIndexed$iv$iv$iv22 = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed22 = false;
            int index$iv$iv$iv = 0;
            for (Object t : $this$forEachIndexed$iv$iv$iv22) {
                Integer n;
                void element$iv$iv;
                int $this$mapTo$iv$iv2 = index$iv$iv$iv++;
                boolean destination$iv$iv2 = false;
                if ($this$mapTo$iv$iv2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object $i$f$mapTo2 = t;
                int index$iv$iv = $this$mapTo$iv$iv2;
                boolean bl7 = false;
                it = (String)element$iv$iv;
                int index = index$iv$iv;
                boolean bl8 = false;
                string = Regex.find$default((Regex)this.getJspecifyMarkRegex(jspecifyMark), (CharSequence)it, (int)0, (int)2, null);
                if (string == null) {
                    n = null;
                } else {
                    String string2 = string;
                    boolean bl6 = false;
                    boolean bl9 = false;
                    String it3 = string2;
                    boolean bl11 = false;
                    n = index;
                }
                if (n == null) continue;
                Integer n2 = n;
                boolean bl10 = false;
                boolean bl11 = false;
                Integer it$iv$iv = n2;
                boolean bl14 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List lineIndexesWithJspecifyMarks = (List)destination$iv$iv3;
            Iterator iterator2 = lineIndexesWithJspecifyMarks.iterator();
            while (iterator2.hasNext()) {
                boolean bl12;
                String errorMessage;
                block14: {
                    Object object4;
                    int lineIndex;
                    block13: {
                        lineIndex = ((Number)iterator2.next()).intValue();
                        Iterable<Map.Entry<Integer, Integer>> $i$f$mapIndexedNotNullTo22 = lineIndexesByRanges.entrySet();
                        Intrinsics.checkNotNullExpressionValue($i$f$mapIndexedNotNullTo22, (String)"lineIndexesByRanges.entries");
                        $i$f$mapIndexedNotNullTo22 = $i$f$mapIndexedNotNullTo22;
                        boolean $this$forEachIndexed$iv$iv$iv22 = false;
                        Iterable<Map.Entry<Integer, Integer>> $i$f$forEachIndexed22 = $i$f$mapIndexedNotNullTo22;
                        index$iv$iv$iv = 0;
                        for (Object object5 : $i$f$forEachIndexed22) {
                            Integer index;
                            Map.Entry $dstr$_u24__u24$index = (Map.Entry)object5;
                            boolean bl16 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)$dstr$_u24__u24$index, (String)"(_, index)");
                            Map.Entry n3 = $dstr$_u24__u24$index;
                            boolean bl13 = false;
                            Integer n = index = (Integer)n3.getValue();
                            int n4 = lineIndex + 1;
                            if (!(n != null && n == n4)) continue;
                            object4 = object5;
                            break block13;
                        }
                        object4 = null;
                    }
                    destination$iv$iv3 = (Map.Entry)object4;
                    Integer lineStartPosition = destination$iv$iv3 == null ? null : (Integer)destination$iv$iv3.getKey();
                    errorMessage = "Diagnostic '" + diagnostic + "' not found for jspecify mark '" + jspecifyMark + "' at " + (lineIndex + 1) + " line";
                    KtUsefulTestCase.assertNotNull((String)errorMessage, (Object)lineStartPosition);
                    Intrinsics.checkNotNull((Object)lineStartPosition);
                    int lineEndPosition = lineStartPosition + textLines.get(lineIndex).length();
                    Iterable $this$any$iv = diagnosticRanges;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl12 = false;
                    } else {
                        for (Object object6 : $this$any$iv) {
                            int it4 = ((Number)object6).intValue();
                            boolean bl18 = false;
                            boolean bl14 = lineStartPosition <= it4 ? it4 <= lineEndPosition : false;
                            if (!bl14) continue;
                            bl12 = true;
                            break block14;
                        }
                        bl12 = false;
                    }
                }
                boolean isCorrespondingDiagnosticPresent = bl12;
                KtUsefulTestCase.assertTrue((String)errorMessage, (boolean)isCorrespondingDiagnosticPresent);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void checkDiagnostics(@NotNull String actualText, @NotNull File testDataFile) {
        void $this$scanIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)actualText, (String)"actualText");
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Matcher matcher = originalKtFileRegex.matcher(actualText);
        boolean bl = false;
        boolean bl2 = false;
        Matcher it = matcher;
        boolean bl3 = false;
        it.find();
        String string = matcher.group(1);
        if (string == null) {
            throw new Exception("Path for original kt file in the merged file not found");
        }
        String mergedTestFilePath = string;
        String textWithDiagnostics = StringsKt.removeSuffix((String)StringsKt.substringAfter$default((String)actualText, (String)MAIN_KT_FILE_DIRECTIVE, null, (int)2, null), (CharSequence)"\n");
        bl = false;
        List diagnosedRanges = new ArrayList();
        String textWithoutDiagnostics = CheckerTestUtil.parseDiagnosedRanges$default((CheckerTestUtil)CheckerTestUtil.INSTANCE, (String)textWithDiagnostics, (List)diagnosedRanges, null, (int)4, null);
        List textLines = StringsKt.lines((CharSequence)textWithoutDiagnostics);
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        boolean bl4 = false;
        boolean bl5 = false;
        TreeMap<Integer, Integer> $this$checkDiagnostics_u24lambda_u2d15 = treeMap;
        boolean bl6 = false;
        Iterable iterable = textLines;
        Integer initial$iv = 0;
        boolean $i$f$scanIndexed = false;
        void $this$runningFoldIndexed$iv$iv = $this$scanIndexed$iv;
        boolean $i$f$runningFoldIndexed = false;
        int estimatedSize$iv$iv = CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningFoldIndexed$iv$iv, (int)9);
        if (estimatedSize$iv$iv == 0) {
            CollectionsKt.listOf((Object)initial$iv);
        } else {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(estimatedSize$iv$iv + 1);
            boolean bl7 = false;
            boolean bl8 = false;
            ArrayList<Integer> $this$apply$iv$iv = arrayList;
            boolean bl9 = false;
            $this$apply$iv$iv.add(initial$iv);
            ArrayList<Integer> result$iv$iv = arrayList;
            int index$iv$iv = 0;
            Integer accumulator$iv$iv = initial$iv;
            for (Object element$iv$iv : $this$runningFoldIndexed$iv$iv) {
                void line;
                void position;
                int n = index$iv$iv++;
                String string2 = (String)element$iv$iv;
                int n2 = ((Number)accumulator$iv$iv).intValue();
                int index = n;
                boolean bl10 = false;
                $this$checkDiagnostics_u24lambda_u2d15.put((int)position, index);
                accumulator$iv$iv = (int)(position + line.length() + true);
                result$iv$iv.add(accumulator$iv$iv);
            }
        }
        TreeMap<Integer, Integer> lineIndexesByRanges = treeMap;
        this.checkIfAllJspecifyMarksByDiagnosticsArePresent(diagnosedRanges, lineIndexesByRanges, textLines);
        this.checkIfAllDiagnosticsByJspecifyMarksArePresent(diagnosedRanges, lineIndexesByRanges, textLines);
        super.checkDiagnostics(textWithDiagnostics, new File(mergedTestFilePath));
    }

    @Override
    @NotNull
    protected File getExpectedDescriptorFile(@NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Matcher matcher = originalKtFileRegex.matcher(FilesKt.readText$default((File)testDataFile, null, (int)1, null));
        boolean bl = false;
        boolean bl2 = false;
        Matcher it = matcher;
        boolean bl3 = false;
        it.find();
        String string = matcher.group(1);
        if (string == null) {
            throw new Exception("Path for original kt file in the merged file isn't found");
        }
        String originalKtFilePath = string;
        return new File(Intrinsics.stringPlus((String)FileUtil.getNameWithoutExtension((String)originalKtFilePath), (Object)".txt"));
    }

    private static final String checkIfAllJspecifyMarksByDiagnosticsArePresent$getErrorMessage(String $requiredJspecifyMark, TextDiagnostic $diagnostic, int lineIndex) {
        return "Jspecify mark '" + $requiredJspecifyMark + "' not found for diagnostic '" + $diagnostic + "' at " + (lineIndex + 1) + " line.\nIt should be located at the previous line as a comment.";
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000Ry\u0010\t\u001aj\u0012`\u0012^\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r*.\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000b0\u000b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \r*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \r*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/checkers/AbstractJspecifyAnnotationsTest$Companion;", "", "()V", "JSPECIFY_JAVA_SOURCES_PATH", "", "MAIN_KT_FILE_DIRECTIVE", "classOrInterfaceRegex", "Lkotlin/text/Regex;", "classShapeRegex", "diagnosticsToJspecifyMarksMap", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory2;", "Lorg/jetbrains/kotlin/psi/KtElement;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getDiagnosticsToJspecifyMarksMap", "()Ljava/util/Map;", "importSectionRegex", "javaSourcesPathRegex", "Ljava/util/regex/Pattern;", "originalKtFileRegex", "publicClassOrInterfaceRegex", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<DiagnosticFactory2<KtElement, KotlinType, KotlinType>, String> getDiagnosticsToJspecifyMarksMap() {
            return diagnosticsToJspecifyMarksMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

