/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.AbstractPseudocodeTest;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionImpl;
import org.jetbrains.kotlin.resolve.BindingContext;

public abstract class AbstractControlFlowTest
extends AbstractPseudocodeTest {
    @Override
    protected void dumpInstructions(@NotNull PseudocodeImpl pseudocode, @NotNull StringBuilder out, @NotNull BindingContext bindingContext) {
        if (pseudocode == null) {
            AbstractControlFlowTest.$$$reportNull$$$0(0);
        }
        if (out == null) {
            AbstractControlFlowTest.$$$reportNull$$$0(1);
        }
        if (bindingContext == null) {
            AbstractControlFlowTest.$$$reportNull$$$0(2);
        }
        int nextInstructionsColumnWidth = AbstractControlFlowTest.countNextInstructionsColumnWidth(pseudocode.getInstructionsIncludingDeadCode());
        this.dumpInstructions(pseudocode, out, (Function3<Instruction, Instruction, Instruction, String>)((Function3)(instruction, next, prev) -> {
            Collection previousInstructions;
            StringBuilder result = new StringBuilder();
            Collection nextInstructions = instruction.getNextInstructions();
            if (!AbstractControlFlowTest.sameContents(next, nextInstructions)) {
                result.append("    NEXT:").append(String.format("%1$-" + nextInstructionsColumnWidth + "s", AbstractControlFlowTest.formatInstructionList(nextInstructions)));
            }
            if (!AbstractControlFlowTest.sameContents(prev, previousInstructions = instruction.getPreviousInstructions())) {
                result.append("    PREV:").append(AbstractControlFlowTest.formatInstructionList(previousInstructions));
            }
            return result.toString();
        }));
    }

    private static String formatInstructionList(Collection<Instruction> instructions) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<Instruction> iterator = instructions.iterator();
        while (iterator.hasNext()) {
            Instruction instruction = iterator.next();
            String instructionText = instruction.toString();
            String[] parts = instructionText.split("\n");
            if (parts.length > 1) {
                StringBuilder instructionSb = new StringBuilder();
                for (String part : parts) {
                    instructionSb.append(part.trim()).append(' ');
                }
                if (instructionSb.toString().length() > 30) {
                    sb.append(instructionSb.substring(0, 28)).append("..)");
                } else {
                    sb.append((CharSequence)instructionSb);
                }
            } else {
                sb.append(instruction);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private static int countNextInstructionsColumnWidth(List<Instruction> instructions) {
        int maxWidth = 0;
        for (Instruction instruction : instructions) {
            String instructionListText = AbstractControlFlowTest.formatInstructionList(instruction.getNextInstructions());
            if (instructionListText.length() <= maxWidth) continue;
            maxWidth = instructionListText.length();
        }
        return maxWidth;
    }

    private static boolean sameContents(@Nullable Instruction natural, Collection<Instruction> actual2) {
        if (natural == null) {
            return actual2.isEmpty();
        }
        return Collections.singleton(natural).equals(new HashSet<Instruction>(actual2));
    }

    @Override
    protected void checkPseudocode(PseudocodeImpl pseudocode) {
        List instructions = pseudocode.getInstructionsIncludingDeadCode();
        for (Instruction instruction : instructions) {
            if (((InstructionImpl)instruction).getMarkedAsDead()) continue;
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                AbstractControlFlowTest.assertTrue((String)("instruction '" + instruction + "' has '" + nextInstruction + "' among next instructions list, but not vice versa"), (boolean)nextInstruction.getPreviousInstructions().contains(instruction));
            }
            for (Instruction prevInstruction : instruction.getPreviousInstructions()) {
                AbstractControlFlowTest.assertTrue((String)("instruction '" + instruction + "' has '" + prevInstruction + "' among previous instructions list, but not vice versa"), (boolean)prevInstruction.getNextInstructions().contains(instruction));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pseudocode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "out";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "bindingContext";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/cfg/AbstractControlFlowTest";
        objectArray[2] = "dumpInstructions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

