/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.GCInfo;
import org.jetbrains.kotlin.fir.VMCounters;
import org.jetbrains.kotlin.fir.VMCountersKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0011\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/VMCounters;", "", "userTime", "", "cpuTime", "gcInfo", "", "", "Lorg/jetbrains/kotlin/fir/GCInfo;", "(JJLjava/util/Map;)V", "getCpuTime", "()J", "getGcInfo", "()Ljava/util/Map;", "getUserTime", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "minus", "toString", "tests-common"})
public final class VMCounters {
    private final long userTime;
    private final long cpuTime;
    @NotNull
    private final Map<String, GCInfo> gcInfo;

    public VMCounters(long userTime, long cpuTime, @NotNull Map<String, GCInfo> gcInfo) {
        Intrinsics.checkNotNullParameter(gcInfo, (String)"gcInfo");
        this.userTime = userTime;
        this.cpuTime = cpuTime;
        this.gcInfo = gcInfo;
    }

    public final long getUserTime() {
        return this.userTime;
    }

    public final long getCpuTime() {
        return this.cpuTime;
    }

    @NotNull
    public final Map<String, GCInfo> getGcInfo() {
        return this.gcInfo;
    }

    @NotNull
    public final VMCounters minus(@NotNull VMCounters other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new VMCounters(this.userTime - other.userTime, this.cpuTime - other.cpuTime, VMCountersKt.access$merge(this.gcInfo, other.gcInfo, minus.1.INSTANCE));
    }

    public final long component1() {
        return this.userTime;
    }

    public final long component2() {
        return this.cpuTime;
    }

    @NotNull
    public final Map<String, GCInfo> component3() {
        return this.gcInfo;
    }

    @NotNull
    public final VMCounters copy(long userTime, long cpuTime, @NotNull Map<String, GCInfo> gcInfo) {
        Intrinsics.checkNotNullParameter(gcInfo, (String)"gcInfo");
        return new VMCounters(userTime, cpuTime, gcInfo);
    }

    public static /* synthetic */ VMCounters copy$default(VMCounters vMCounters, long l, long l2, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            l = vMCounters.userTime;
        }
        if ((n & 2) != 0) {
            l2 = vMCounters.cpuTime;
        }
        if ((n & 4) != 0) {
            map = vMCounters.gcInfo;
        }
        return vMCounters.copy(l, l2, map);
    }

    @NotNull
    public String toString() {
        return "VMCounters(userTime=" + this.userTime + ", cpuTime=" + this.cpuTime + ", gcInfo=" + this.gcInfo + ')';
    }

    public int hashCode() {
        int result = Long.hashCode(this.userTime);
        result = result * 31 + Long.hashCode(this.cpuTime);
        result = result * 31 + ((Object)this.gcInfo).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VMCounters)) {
            return false;
        }
        VMCounters vMCounters = (VMCounters)other;
        if (this.userTime != vMCounters.userTime) {
            return false;
        }
        if (this.cpuTime != vMCounters.cpuTime) {
            return false;
        }
        return Intrinsics.areEqual(this.gcInfo, vMCounters.gcInfo);
    }
}

