/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.junit.Assert;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u001e\u0010\n\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/AbstractBytecodeTextTest;", "Lorg/jetbrains/kotlin/codegen/CodegenTestCase;", "()V", "doMultiFileTest", "", "wholeFile", "Ljava/io/File;", "files", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "doTestMultiFile", "reportProblems", "", "readExpectedOccurrences", "Lorg/jetbrains/kotlin/codegen/AbstractBytecodeTextTest$OccurrenceInfo;", "filename", "", "Companion", "OccurrenceInfo", "tests-common"})
public abstract class AbstractBytecodeTextTest
extends CodegenTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern AT_OUTPUT_FILE_PATTERN = Pattern.compile("^\\s*//\\s*@(.*):$");
    private static final Pattern EXPECTED_OCCURRENCES_PATTERN = Pattern.compile("^\\s*//\\s*(\\d+)\\s*(.*)$");
    @NotNull
    private static final String JVM_TEMPLATES = "// JVM_TEMPLATES";
    @NotNull
    private static final String JVM_IR_TEMPLATES = "// JVM_IR_TEMPLATES";

    @Override
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        boolean isIgnored = InTextDirectivesUtils.isIgnoredTarget(this.getBackend(), wholeFile);
        TestJdkKind testJdkKind = this.getTestJdkKind(files);
        Object $this$toTypedArray$iv = (File[])CollectionsKt.listOfNotNull((Object)this.writeJavaFiles(files));
        boolean $i$f$toTypedArray = false;
        File[] thisCollection$iv = $this$toTypedArray$iv;
        File[] fileArray = thisCollection$iv.toArray(new File[0]);
        if (fileArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        File[] fileArray2 = fileArray;
        $this$toTypedArray$iv = new File[fileArray2.length];
        System.arraycopy(fileArray2, 0, $this$toTypedArray$iv, 0, fileArray2.length);
        this.createEnvironmentWithMockJdkAndIdeaAnnotations(ConfigurationKind.ALL, files, testJdkKind, (File)$this$toTypedArray$iv);
        this.loadMultiFiles(files);
        if (AbstractBytecodeTextTest.Companion.isMultiFileTest(files) && !InTextDirectivesUtils.isDirectiveDefined(FilesKt.readText$default((File)wholeFile, null, (int)1, null), "TREAT_AS_ONE_FILE")) {
            this.doTestMultiFile(files, !isIgnored);
        } else {
            $this$toTypedArray$iv = wholeFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)$this$toTypedArray$iv, (String)"wholeFile.path");
            List<OccurrenceInfo> expected = this.readExpectedOccurrences((String)$this$toTypedArray$iv);
            Object object = this.generateToText("helpers/");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"generateToText(\"helpers/\")");
            String actual2 = object;
            object = this.getBackend();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"backend");
            Companion.checkGeneratedTextAgainstExpectedOccurrences(actual2, expected, (TargetBackend)((Object)object), !isIgnored);
        }
    }

    private final void doTestMultiFile(List<? extends KotlinBaseTest.TestFile> files, boolean reportProblems) {
        LinkedHashMap expectedOccurrencesByOutputFile = new LinkedHashMap();
        for (KotlinBaseTest.TestFile map : files) {
            AbstractBytecodeTextTest.Companion.readExpectedOccurrencesForMultiFileTest(map, expectedOccurrencesByOutputFile);
        }
        Map<String, String> map = this.generateEachFileToText();
        Intrinsics.checkNotNullExpressionValue(map, (String)"generateEachFileToText()");
        Map<String, String> generated = map;
        for (String expectedOutputFile : expectedOccurrencesByOutputFile.keySet()) {
            Object object;
            Intrinsics.checkNotNullExpressionValue((Object)expectedOutputFile, (String)"expectedOutputFile");
            AbstractBytecodeTextTest.Companion.assertTextWasGenerated(expectedOutputFile, generated);
            String string = generated.get(expectedOutputFile);
            Intrinsics.checkNotNull((Object)string);
            String generatedText = string;
            List list = (List)expectedOccurrencesByOutputFile.get(expectedOutputFile);
            Intrinsics.checkNotNull((Object)list);
            List expectedOccurrences = object = list;
            object = this.getBackend();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"backend");
            Companion.checkGeneratedTextAgainstExpectedOccurrences(generatedText, expectedOccurrences, (TargetBackend)((Object)object), reportProblems);
        }
    }

    @NotNull
    protected final List<OccurrenceInfo> readExpectedOccurrences(@NotNull String filename) {
        List list;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        ArrayList<OccurrenceInfo> result = new ArrayList<OccurrenceInfo>();
        List $this$dropLastWhile$iv = FilesKt.readLines$default((File)new File(filename), null, (int)1, null);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                CharSequence p0 = (CharSequence)iterator$iv.previous();
                boolean bl = false;
                CharSequence charSequence = p0;
                boolean bl2 = false;
                if (charSequence.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        List lines = list;
        TargetBackend backend = TargetBackend.ANY;
        for (String line : lines) {
            Matcher matcher;
            if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_TEMPLATES, (boolean)false, (int)2, null)) {
                backend = TargetBackend.JVM;
            } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)JVM_IR_TEMPLATES, (boolean)false, (int)2, null)) {
                backend = TargetBackend.JVM_IR;
            }
            if (!(matcher = EXPECTED_OCCURRENCES_PATTERN.matcher(line)).matches()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher");
            result.add(AbstractBytecodeTextTest.Companion.parseOccurrenceInfo(matcher, backend));
        }
        return result;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005J\b\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/codegen/AbstractBytecodeTextTest$OccurrenceInfo;", "", "numberOfOccurrences", "", "needle", "", "backend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "(ILjava/lang/String;Lorg/jetbrains/kotlin/test/TargetBackend;)V", "getBackend", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "getActualOccurrence", "text", "toString", "tests-common"})
    public static final class OccurrenceInfo {
        private final int numberOfOccurrences;
        @NotNull
        private final String needle;
        @NotNull
        private final TargetBackend backend;

        public OccurrenceInfo(int numberOfOccurrences, @NotNull String needle, @NotNull TargetBackend backend) {
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
            this.numberOfOccurrences = numberOfOccurrences;
            this.needle = needle;
            this.backend = backend;
        }

        @NotNull
        public final TargetBackend getBackend() {
            return this.backend;
        }

        @Nullable
        public final String getActualOccurrence(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int actualCount = StringUtil.findMatches((String)text, (Pattern)Pattern.compile('(' + this.needle + ')')).size();
            return "" + actualCount + ' ' + this.needle;
        }

        @NotNull
        public String toString() {
            return "" + this.numberOfOccurrences + ' ' + this.needle;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J,\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J*\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001a2\u0018\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\"H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/codegen/AbstractBytecodeTextTest$Companion;", "", "()V", "AT_OUTPUT_FILE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "EXPECTED_OCCURRENCES_PATTERN", "JVM_IR_TEMPLATES", "", "JVM_TEMPLATES", "assertTextWasGenerated", "", "expectedOutputFile", "generated", "", "checkGeneratedTextAgainstExpectedOccurrences", "text", "expectedOccurrences", "", "Lorg/jetbrains/kotlin/codegen/AbstractBytecodeTextTest$OccurrenceInfo;", "currentBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "reportProblems", "", "isMultiFileTest", "files", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "parseOccurrenceInfo", "matcher", "Ljava/util/regex/Matcher;", "backend", "readExpectedOccurrencesForMultiFileTest", "file", "occurrenceMap", "", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isMultiFileTest(List<? extends KotlinBaseTest.TestFile> files) {
            int kotlinFiles = 0;
            for (KotlinBaseTest.TestFile testFile : files) {
                if (!StringsKt.endsWith$default((String)testFile.name, (String)".kt", (boolean)false, (int)2, null)) continue;
                int n = kotlinFiles;
                kotlinFiles = n + 1;
            }
            return kotlinFiles > 1;
        }

        public final void checkGeneratedTextAgainstExpectedOccurrences(@NotNull String text, @NotNull List<OccurrenceInfo> expectedOccurrences, @NotNull TargetBackend currentBackend, boolean reportProblems) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(expectedOccurrences, (String)"expectedOccurrences");
            Intrinsics.checkNotNullParameter((Object)((Object)currentBackend), (String)"currentBackend");
            StringBuilder expected = new StringBuilder();
            StringBuilder actual2 = new StringBuilder();
            TargetBackend lastBackend = TargetBackend.ANY;
            for (OccurrenceInfo info : expectedOccurrences) {
                if (lastBackend != info.getBackend()) {
                    String string;
                    Object object = info.getBackend();
                    int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
                    switch (n) {
                        case 1: {
                            string = AbstractBytecodeTextTest.JVM_TEMPLATES;
                            break;
                        }
                        case 2: {
                            string = AbstractBytecodeTextTest.JVM_IR_TEMPLATES;
                            break;
                        }
                        default: {
                            String string2 = Intrinsics.stringPlus((String)"Common part should be first one: ", (Object)CollectionsKt.joinToString$default((Iterable)expectedOccurrences, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                    }
                    object = string;
                    n = 0;
                    boolean bl = false;
                    Object it = object;
                    boolean bl2 = false;
                    actual2.append('\n' + (String)it + '\n');
                    expected.append('\n' + (String)it + '\n');
                    lastBackend = info.getBackend();
                }
                expected.append(info).append("\n");
                if (info.getBackend() == TargetBackend.ANY || info.getBackend() == currentBackend) {
                    actual2.append(info.getActualOccurrence(text)).append("\n");
                    continue;
                }
                actual2.append(info).append("\n");
            }
            try {
                Assert.assertEquals((String)text, (Object)expected.toString(), (Object)actual2.toString());
            }
            catch (Throwable e) {
                if (reportProblems) {
                    boolean bl = false;
                    System.out.println((Object)text);
                }
                throw e;
            }
        }

        private final void assertTextWasGenerated(String expectedOutputFile, Map<String, String> generated) {
            if (!generated.containsKey(expectedOutputFile)) {
                StringBuilder failMessage = new StringBuilder();
                failMessage.append("Missing output file ").append(expectedOutputFile).append(", got ").append(generated.size()).append(": ");
                for (String generatedFile : generated.keySet()) {
                    failMessage.append(generatedFile).append(" ");
                }
                Assert.fail((String)failMessage.toString());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void readExpectedOccurrencesForMultiFileTest(KotlinBaseTest.TestFile file, Map<String, List<OccurrenceInfo>> occurrenceMap) {
            void $this$toTypedArray$iv;
            List list;
            Object object;
            Collection $this$dropLastWhile$iv;
            List currentOccurrenceInfos = null;
            TargetBackend backend = TargetBackend.ANY;
            Object object2 = file.content;
            String string = "\n";
            int n = 0;
            string = new Regex(string);
            n = 0;
            boolean bl = false;
            object2 = string.split((CharSequence)object2, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    object = it;
                    boolean bl3 = false;
                    if (object.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray2 = stringArray;
            int n2 = 0;
            int n3 = stringArray2.length;
            while (n2 < n3) {
                Matcher expectedOccurrencesMatcher;
                String line = stringArray2[n2];
                ++n2;
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)AbstractBytecodeTextTest.JVM_TEMPLATES, (boolean)false, (int)2, null)) {
                    backend = TargetBackend.JVM;
                } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)AbstractBytecodeTextTest.JVM_IR_TEMPLATES, (boolean)false, (int)2, null)) {
                    backend = TargetBackend.JVM_IR;
                }
                Matcher atOutputFileMatcher = AT_OUTPUT_FILE_PATTERN.matcher(line);
                if (atOutputFileMatcher.matches()) {
                    String outputFileName = atOutputFileMatcher.group(1);
                    if (occurrenceMap.containsKey(outputFileName)) {
                        throw new AssertionError((Object)(file.name + ": Expected occurrences for output file " + outputFileName + " were already provided"));
                    }
                    currentOccurrenceInfos = new ArrayList();
                    object = occurrenceMap;
                    Intrinsics.checkNotNullExpressionValue((Object)outputFileName, (String)"outputFileName");
                    String string2 = outputFileName;
                    boolean bl4 = false;
                    object.put(string2, currentOccurrenceInfos);
                }
                if (!(expectedOccurrencesMatcher = EXPECTED_OCCURRENCES_PATTERN.matcher(line)).matches()) continue;
                if (currentOccurrenceInfos == null) {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)file.name, (Object)": Should specify output file with '// @<OUTPUT_FILE_NAME>:' before expectations"));
                }
                Intrinsics.checkNotNullExpressionValue((Object)expectedOccurrencesMatcher, (String)"expectedOccurrencesMatcher");
                OccurrenceInfo occurrenceInfo = this.parseOccurrenceInfo(expectedOccurrencesMatcher, backend);
                currentOccurrenceInfos.add(occurrenceInfo);
            }
        }

        private final OccurrenceInfo parseOccurrenceInfo(Matcher matcher, TargetBackend backend) {
            int numberOfOccurrences = Integer.parseInt(matcher.group(1));
            String needle = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)needle, (String)"needle");
            return new OccurrenceInfo(numberOfOccurrences, needle, backend);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TargetBackend.values().length];
                nArray[TargetBackend.JVM.ordinal()] = 1;
                nArray[TargetBackend.JVM_IR.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

