/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.junit.internal.MethodSorter;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;

public class JUnit3RunnerWithInnersForJPS
extends Runner
implements Filterable,
Sortable {
    private static final Set<Class> requestedRunners = new HashSet<Class>();
    private JUnit38ClassRunner delegateRunner;
    private final Class<?> klass;
    private boolean isFakeTest = false;

    public JUnit3RunnerWithInnersForJPS(Class<?> klass) {
        this.klass = klass;
        requestedRunners.add(klass);
        JUnit3RunnerWithInnersForJPS.ensureCompilerExtensionFilesExists();
    }

    public void run(RunNotifier notifier) {
        this.initialize();
        this.delegateRunner.run(notifier);
    }

    public Description getDescription() {
        this.initialize();
        return this.isFakeTest ? Description.EMPTY : this.delegateRunner.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.initialize();
        this.delegateRunner.filter(filter);
    }

    public void sort(Sorter sorter) {
        this.initialize();
        this.delegateRunner.sort(sorter);
    }

    protected void initialize() {
        if (this.delegateRunner != null) {
            return;
        }
        this.delegateRunner = new JUnit38ClassRunner(this.getCollectedTests());
    }

    private static void ensureCompilerExtensionFilesExists() {
        JUnit3RunnerWithInnersForJPS.copyCompilerResourceFile("compiler.xml");
        JUnit3RunnerWithInnersForJPS.copyCompilerResourceFile("core.xml");
    }

    private static void copyCompilerResourceFile(String fileName) {
        String compilerXmlSourcePath = "compiler/cli/cli-common/resources/META-INF/extensions/" + fileName;
        String jpsTargetDirectory = "out/production/kotlin.idea.main";
        String pillTargetDirectory = "out/production/idea.main";
        String baseDir = Files.exists(Paths.get(jpsTargetDirectory, new String[0]), new LinkOption[0]) ? jpsTargetDirectory : pillTargetDirectory;
        String compilerXmlTargetPath = baseDir + "/META-INF/extensions/" + fileName;
        try {
            Path targetPath = Paths.get(compilerXmlTargetPath, new String[0]);
            Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            Files.copy(Paths.get(compilerXmlSourcePath, new String[0]), targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Test getCollectedTests() {
        List<Class> innerClasses = JUnit3RunnerWithInnersForJPS.collectDeclaredClasses(this.klass, false);
        Set<Class> unprocessedInnerClasses = JUnit3RunnerWithInnersForJPS.unprocessedClasses(innerClasses);
        if (unprocessedInnerClasses.isEmpty()) {
            if (!innerClasses.isEmpty() && !JUnit3RunnerWithInnersForJPS.hasTestMethods(this.klass)) {
                this.isFakeTest = true;
                return new JUnit3RunnerWithInners.FakeEmptyClassTest(this.klass);
            }
            return new TestSuite(this.klass.asSubclass(TestCase.class));
        }
        if (unprocessedInnerClasses.size() == innerClasses.size()) {
            return JUnit3RunnerWithInnersForJPS.createTreeTestSuite(this.klass);
        }
        return new TestSuite(this.klass.asSubclass(TestCase.class));
    }

    private static Test createTreeTestSuite(Class root) {
        LinkedHashSet<Class> classes = new LinkedHashSet<Class>(JUnit3RunnerWithInnersForJPS.collectDeclaredClasses(root, true));
        HashMap<Class, TestSuite> classSuites = new HashMap<Class, TestSuite>();
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class aClass;
            classSuites.put(aClass, JUnit3RunnerWithInnersForJPS.hasTestMethods(aClass = (Class)iterator.next()) ? new TestSuite(aClass) : new TestSuite(aClass.getCanonicalName()));
        }
        for (Class aClass : classes) {
            if (aClass.getEnclosingClass() == null || !classes.contains(aClass.getEnclosingClass())) continue;
            ((TestSuite)classSuites.get(aClass.getEnclosingClass())).addTest((Test)classSuites.get(aClass));
        }
        return (Test)classSuites.get(root);
    }

    private static Set<Class> unprocessedClasses(Collection<Class> classes) {
        LinkedHashSet<Class> result = new LinkedHashSet<Class>();
        for (Class aClass : classes) {
            if (requestedRunners.contains(aClass)) continue;
            result.add(aClass);
        }
        return result;
    }

    private static List<Class> collectDeclaredClasses(Class klass, boolean withItself) {
        ArrayList<Class> result = new ArrayList<Class>();
        if (withItself) {
            result.add(klass);
        }
        for (Class<?> aClass : klass.getDeclaredClasses()) {
            result.addAll(JUnit3RunnerWithInnersForJPS.collectDeclaredClasses(aClass, true));
        }
        return result;
    }

    private static boolean hasTestMethods(Class klass) {
        Class currentClass = klass;
        while (Test.class.isAssignableFrom(currentClass)) {
            for (Method each : MethodSorter.getDeclaredMethods((Class)currentClass)) {
                if (!JUnit3RunnerWithInners.isTestMethod(each)) continue;
                return true;
            }
            currentClass = currentClass.getSuperclass();
        }
        return false;
    }
}

