/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.junit.internal.MethodSorter;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;

class JUnit3RunnerWithInnersForGradle
extends Runner
implements Filterable,
Sortable {
    private final JUnit38ClassRunner delegateRunner;

    public JUnit3RunnerWithInnersForGradle(Class<?> klass) {
        final String className = klass.getName();
        Object test2 = new TestSuite(klass.asSubclass(TestCase.class));
        if (!JUnit3RunnerWithInnersForGradle.hasOwnTestMethods(klass)) {
            for (Class<?> declaredClass : klass.getDeclaredClasses()) {
                if (!TestCase.class.isAssignableFrom(declaredClass)) continue;
                test2 = new JUnit3RunnerWithInners.FakeEmptyClassTest(klass);
                break;
            }
        }
        this.delegateRunner = new JUnit38ClassRunner((Test)test2){

            public void filter(Filter filter) throws NoTestsRemainException {
                String classPatternString = JUnit3RunnerWithInnersForGradle.getGradleClassPattern(filter);
                if (classPatternString != null && Pattern.compile(classPatternString + "\\$.*").matcher(className).matches()) {
                    return;
                }
                super.filter(filter);
            }
        };
    }

    public void run(RunNotifier notifier) {
        this.delegateRunner.run(notifier);
    }

    public Description getDescription() {
        return this.delegateRunner.getDescription();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.delegateRunner.filter(filter);
    }

    public void sort(Sorter sorter) {
        this.delegateRunner.sort(sorter);
    }

    private static boolean hasOwnTestMethods(Class klass) {
        for (Method each : MethodSorter.getDeclaredMethods((Class)klass)) {
            if (!JUnit3RunnerWithInners.isTestMethod(each)) continue;
            return true;
        }
        return false;
    }

    private static String getGradleClassPattern(Filter filter) {
        try {
            Pattern pattern;
            Field includePatternsField;
            Class<?> filterClass = filter.getClass();
            if (!"org.gradle.api.internal.tasks.testing.junit.JUnitTestClassExecutor$MethodNameFilter".equals(filterClass.getName())) {
                return null;
            }
            Field matcherField = filterClass.getDeclaredField("matcher");
            matcherField.setAccessible(true);
            Object testSelectionMatcher = matcherField.get(filter);
            Class<?> testSelectionMatcherClass = testSelectionMatcher.getClass();
            if (!"org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher".equals(testSelectionMatcherClass.getName())) {
                return null;
            }
            try {
                includePatternsField = testSelectionMatcherClass.getDeclaredField("includePatterns");
            }
            catch (NoSuchFieldException exception) {
                includePatternsField = testSelectionMatcherClass.getDeclaredField("buildScriptIncludePatterns");
            }
            includePatternsField.setAccessible(true);
            ArrayList includePatterns = (ArrayList)includePatternsField.get(testSelectionMatcher);
            if (includePatterns.size() != 1) {
                return null;
            }
            Object patternStorage = includePatterns.get(0);
            if (patternStorage instanceof Pattern) {
                pattern = (Pattern)patternStorage;
            } else {
                try {
                    Field patternField = patternStorage.getClass().getDeclaredField("pattern");
                    patternField.setAccessible(true);
                    pattern = (Pattern)patternField.get(patternStorage);
                }
                catch (NoSuchFieldException exception) {
                    return null;
                }
            }
            String patternStr = pattern.pattern();
            if (patternStr.endsWith("*")) {
                return null;
            }
            return patternStr;
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

