/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.junit.Assert;

public final class InTextDirectivesUtils {
    private static final String DIRECTIVES_FILE_NAME = "directives.txt";
    public static final String IGNORE_BACKEND_DIRECTIVE_PREFIX = "// IGNORE_BACKEND: ";

    private InTextDirectivesUtils() {
    }

    @Nullable
    public static Integer getPrefixedInt(String fileText, String prefix) {
        String[] strings = InTextDirectivesUtils.findArrayWithPrefixes(fileText, prefix);
        if (strings.length > 0) {
            assert (strings.length == 1);
            return Integer.parseInt(strings[0]);
        }
        return null;
    }

    @Nullable
    public static Boolean getPrefixedBoolean(String fileText, String prefix) {
        String[] strings = InTextDirectivesUtils.findArrayWithPrefixes(fileText, prefix);
        if (strings.length > 0) {
            assert (strings.length == 1);
            return Boolean.parseBoolean(strings[0]);
        }
        return null;
    }

    @NotNull
    public static String[] findArrayWithPrefixes(@NotNull String fileText, String ... prefixes) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(0);
        }
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(1);
        }
        String[] stringArray = ArrayUtil.toStringArray(InTextDirectivesUtils.findListWithPrefixes(fileText, prefixes));
        if (stringArray == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(2);
        }
        return stringArray;
    }

    @NotNull
    public static List<String> findListWithPrefixes(@NotNull String fileText, String ... prefixes) {
        if (fileText == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(3);
        }
        if (prefixes == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : InTextDirectivesUtils.findLinesWithPrefixesRemoved(fileText, prefixes)) {
            InTextDirectivesUtils.splitValues(result, line);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public static List<String> splitValues(List<String> result, String line) {
        String unquoted = StringUtil.unquoteString((String)line);
        if (!unquoted.equals(line)) {
            result.add(unquoted);
        } else {
            String[] variants;
            for (String variant : variants = line.split(",")) {
                result.add(variant.trim());
            }
        }
        return result;
    }

    public static boolean isDirectiveDefined(String fileText, String directive) {
        return !InTextDirectivesUtils.findListWithPrefixes(fileText, directive).isEmpty();
    }

    @Nullable
    public static String findStringWithPrefixes(String fileText, String ... prefixes) {
        List<String> strings = InTextDirectivesUtils.findListWithPrefixes(fileText, prefixes);
        if (strings.isEmpty()) {
            return null;
        }
        if (strings.size() != 1) {
            throw new IllegalStateException("There is more than one string with given prefixes " + Arrays.toString(prefixes) + ":\n" + StringUtil.join(strings, (String)"\n") + "\nUse findListWithPrefixes() instead.");
        }
        return strings.get(0);
    }

    @NotNull
    public static List<String> findLinesWithPrefixesRemoved(String fileText, String ... prefixes) {
        return InTextDirectivesUtils.findLinesWithPrefixesRemoved(fileText, true, true, prefixes);
    }

    @NotNull
    public static List<String> findLinesWithPrefixesRemoved(String fileText, boolean trim, boolean strict, String ... prefixes) {
        if (prefixes.length == 0) {
            throw new IllegalArgumentException("Please specify the prefixes to check");
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> cleanedPrefixes = InTextDirectivesUtils.cleanDirectivesFromComments(Arrays.asList(prefixes));
        block0: for (String line : InTextDirectivesUtils.fileNonEmptyCommentedLines(fileText)) {
            for (String prefix : cleanedPrefixes) {
                if (!line.startsWith(prefix)) continue;
                String noPrefixLine = line.substring(prefix.length());
                if (noPrefixLine.isEmpty() || Character.isWhitespace(noPrefixLine.charAt(0)) || Character.isWhitespace(prefix.charAt(prefix.length() - 1))) {
                    result.add(trim ? noPrefixLine.trim() : StringUtil.trimTrailing((String)StringsKt.drop((String)noPrefixLine, (int)1)));
                    continue block0;
                }
                if (strict) {
                    throw new AssertionError((Object)("Line starts with prefix \"" + prefix + "\", but doesn't have space symbol after it: " + line));
                }
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public static void assertHasUnknownPrefixes(String fileText, Collection<String> knownPrefixes) {
        HashSet<String> prefixes = new HashSet<String>();
        for (String line : InTextDirectivesUtils.fileNonEmptyCommentedLines(fileText)) {
            String prefix = InTextDirectivesUtils.probableDirective(line);
            if (prefix == null) continue;
            prefixes.add(prefix);
        }
        prefixes.removeAll(InTextDirectivesUtils.cleanDirectivesFromComments(knownPrefixes));
        Assert.assertTrue((String)("File contains some unexpected directives" + prefixes), (boolean)prefixes.isEmpty());
    }

    private static String probableDirective(String line) {
        String[] arr = line.split(" ", 2);
        String firstWord = arr[0];
        if (firstWord.length() > 1 && StringUtil.toUpperCase((String)firstWord).equals(firstWord)) {
            return firstWord;
        }
        return null;
    }

    private static List<String> cleanDirectivesFromComments(Collection<String> prefixes) {
        ArrayList resultPrefixes = Lists.newArrayList();
        for (String prefix : prefixes) {
            if (prefix.startsWith("//") || prefix.startsWith("##")) {
                resultPrefixes.add(StringUtil.trimLeading((String)prefix.substring(2)));
                continue;
            }
            resultPrefixes.add(prefix);
        }
        return resultPrefixes;
    }

    @NotNull
    private static List<String> fileNonEmptyCommentedLines(String fileText) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(fileText));){
            String line;
            while ((line = reader.readLine()) != null) {
                String uncommentedLine;
                if (!(line = line.trim()).startsWith("//") && !line.startsWith("##") || (uncommentedLine = line.substring(2).trim()).isEmpty()) continue;
                result.add(uncommentedLine);
            }
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            InTextDirectivesUtils.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static String textWithDirectives(File file) {
        try {
            String fileText;
            if (file.isDirectory()) {
                File directivesFile = new File(file, DIRECTIVES_FILE_NAME);
                if (!directivesFile.exists()) {
                    return "";
                }
                fileText = FileUtil.loadFile((File)directivesFile);
            } else {
                fileText = FileUtil.loadFile((File)file);
            }
            return fileText;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCompatibleTarget(TargetBackend targetBackend, File file) {
        if (targetBackend == TargetBackend.ANY) {
            return true;
        }
        List<String> doNotTarget = InTextDirectivesUtils.findLinesWithPrefixesRemoved(InTextDirectivesUtils.textWithDirectives(file), "// DONT_TARGET_EXACT_BACKEND: ");
        if (doNotTarget.contains(targetBackend.name())) {
            return false;
        }
        List<String> backends = InTextDirectivesUtils.findLinesWithPrefixesRemoved(InTextDirectivesUtils.textWithDirectives(file), "// TARGET_BACKEND: ");
        return InTextDirectivesUtils.isCompatibleTargetExceptAny(targetBackend, backends);
    }

    private static boolean isCompatibleTargetExceptAny(TargetBackend targetBackend, List<String> backends) {
        if (targetBackend == TargetBackend.ANY) {
            return false;
        }
        return backends.isEmpty() || backends.contains(targetBackend.name()) || InTextDirectivesUtils.isCompatibleTargetExceptAny(targetBackend.getCompatibleWith(), backends);
    }

    public static boolean isIgnoredTarget(TargetBackend targetBackend, File file, String ignoreBackendDirectivePrefix) {
        List<String> ignoredBackends = InTextDirectivesUtils.findListWithPrefixes(InTextDirectivesUtils.textWithDirectives(file), ignoreBackendDirectivePrefix);
        return ignoredBackends.contains(targetBackend.name());
    }

    public static boolean isIgnoredTarget(TargetBackend targetBackend, File file) {
        return InTextDirectivesUtils.isIgnoredTarget(targetBackend, file, IGNORE_BACKEND_DIRECTIVE_PREFIX);
    }

    public static boolean dontRunGeneratedCode(TargetBackend targetBackend, File file) {
        List<String> backends = InTextDirectivesUtils.findListWithPrefixes(InTextDirectivesUtils.textWithDirectives(file), "// DONT_RUN_GENERATED_CODE: ");
        return backends.contains(targetBackend.name());
    }

    public static boolean isPassingTarget(TargetBackend targetBackend, File file) {
        return InTextDirectivesUtils.isCompatibleTarget(targetBackend, file) && !InTextDirectivesUtils.isIgnoredTarget(targetBackend, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/InTextDirectivesUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/InTextDirectivesUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findArrayWithPrefixes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findListWithPrefixes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findLinesWithPrefixesRemoved";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fileNonEmptyCommentedLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findArrayWithPrefixes";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findListWithPrefixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

