/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorEquivalenceForOverrides;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.junit.Assert;

public abstract class ExpectedResolveData {
    protected static final String STANDARD_PREFIX = "kotlin::";
    private final Map<String, Position> declarationToPosition = new HashMap<String, Position>();
    private final Map<Position, String> positionToReference = new HashMap<Position, String>();
    private final Map<Position, String> positionToType = new HashMap<Position, String>();
    private final Map<String, DeclarationDescriptor> nameToDescriptor;
    private final Map<String, PsiElement> nameToPsiElement;

    public ExpectedResolveData(Map<String, DeclarationDescriptor> nameToDescriptor, Map<String, PsiElement> nameToPsiElement) {
        this.nameToDescriptor = nameToDescriptor;
        this.nameToPsiElement = nameToPsiElement;
    }

    public final KtFile createFileFromMarkedUpText(String fileName, String text) {
        Matcher matcher;
        HashMap<String, Integer> declarationToIntPosition = new HashMap<String, Integer>();
        HashMap<Integer, String> intPositionToReference = new HashMap<Integer, String>();
        HashMap<Integer, String> intPositionToType = new HashMap<Integer, String>();
        Pattern pattern = Pattern.compile("(~[^~]+~)|(`[^`]+`)");
        while ((matcher = pattern.matcher(text)).find()) {
            String group = matcher.group();
            String name = group.substring(1, group.length() - 1);
            int start = matcher.start();
            if (group.startsWith("~")) {
                if (declarationToIntPosition.put(name, start) != null) {
                    throw new IllegalArgumentException("Redeclaration: " + name);
                }
            } else if (group.startsWith("`")) {
                if (name.startsWith(":")) {
                    intPositionToType.put(start - 1, name.substring(1));
                } else {
                    intPositionToReference.put(start, name);
                }
            } else {
                throw new IllegalStateException();
            }
            text = text.substring(0, start) + text.substring(matcher.end());
        }
        KtFile ktFile = this.createKtFile(fileName, text);
        for (Map.Entry entry : intPositionToType.entrySet()) {
            this.positionToType.put(new Position(ktFile, (Integer)entry.getKey()), (String)entry.getValue());
        }
        for (Map.Entry entry : declarationToIntPosition.entrySet()) {
            this.declarationToPosition.put((String)entry.getKey(), new Position(ktFile, (Integer)entry.getValue()));
        }
        for (Map.Entry entry : intPositionToReference.entrySet()) {
            this.positionToReference.put(new Position(ktFile, (Integer)entry.getKey()), (String)entry.getValue());
        }
        return ktFile;
    }

    protected abstract KtFile createKtFile(String var1, String var2);

    protected static AnalysisResult analyze(List<KtFile> files, KotlinCoreEnvironment environment) {
        if (files.isEmpty()) {
            throw new AssertionError((Object)"Suspicious: no files");
        }
        return JvmResolveUtil.analyze(files, environment);
    }

    public final void checkResult(@NotNull AnalysisResult result) {
        Position position;
        PsiElement element;
        if (result == null) {
            ExpectedResolveData.$$$reportNull$$$0(0);
        }
        BindingContext bindingContext = result.getBindingContext();
        ModuleDescriptor module2 = result.getModuleDescriptor();
        HashSet<PsiElement> unresolvedReferences = new HashSet<PsiElement>();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            if (!Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains((Object)diagnostic.getFactory())) continue;
            unresolvedReferences.add(diagnostic.getPsiElement());
        }
        HashMap<String, PsiFile> nameToDeclaration = new HashMap<String, PsiFile>();
        HashMap<PsiFile, String> declarationToName = new HashMap<PsiFile, String>();
        for (Map.Entry<String, Position> entry : this.declarationToPosition.entrySet()) {
            PsiFile ancestorOfType;
            String name = entry.getKey();
            Position position2 = entry.getValue();
            element = position2.getElement();
            if (name.equals("file")) {
                ancestorOfType = element.getContainingFile();
            } else {
                ancestorOfType = (PsiElement)ExpectedResolveData.getAncestorOfType(KtDeclaration.class, element);
                if (ancestorOfType == null) {
                    KtPackageDirective directive = ExpectedResolveData.getAncestorOfType(KtPackageDirective.class, element);
                    assert (directive != null) : "Not a declaration: " + name;
                    ancestorOfType = element;
                }
            }
            nameToDeclaration.put(name, ancestorOfType);
            declarationToName.put(ancestorOfType, name);
        }
        for (Map.Entry<Object, Object> entry : this.positionToReference.entrySet()) {
            PsiElement actual2;
            position = (Position)entry.getKey();
            String name = (String)entry.getValue();
            element = position.getElement();
            KtReferenceExpression referenceExpression = (KtReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, KtReferenceExpression.class);
            DeclarationDescriptor referenceTarget = (DeclarationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)referenceExpression);
            if ("!".equals(name)) {
                Assert.assertTrue((String)("Must have been unresolved: " + ExpectedResolveData.renderReferenceInContext(referenceExpression) + " but was resolved to " + ExpectedResolveData.renderNullableDescriptor(referenceTarget)), (boolean)unresolvedReferences.contains(referenceExpression));
                Assert.assertTrue((String)String.format("Reference =%s= has a reference target =%s= but expected to be unresolved", ExpectedResolveData.renderReferenceInContext(referenceExpression), ExpectedResolveData.renderNullableDescriptor(referenceTarget)), (referenceTarget == null ? 1 : 0) != 0);
                continue;
            }
            if ("!!".equals(name)) {
                Assert.assertTrue((String)("Must have been resolved to multiple descriptors: " + ExpectedResolveData.renderReferenceInContext(referenceExpression) + " but was resolved to " + ExpectedResolveData.renderNullableDescriptor(referenceTarget)), (bindingContext.get((ReadOnlySlice)BindingContext.AMBIGUOUS_REFERENCE_TARGET, (Object)referenceExpression) != null ? 1 : 0) != 0);
                continue;
            }
            if ("!null".equals(name)) {
                Assert.assertTrue((String)("Must have been resolved to null: " + ExpectedResolveData.renderReferenceInContext(referenceExpression) + " but was resolved to " + ExpectedResolveData.renderNullableDescriptor(referenceTarget)), (referenceTarget == null ? 1 : 0) != 0);
                continue;
            }
            if ("!error".equals(name)) {
                Assert.assertTrue((String)("Must have been resolved to error: " + ExpectedResolveData.renderReferenceInContext(referenceExpression) + " but was resolved to " + ExpectedResolveData.renderNullableDescriptor(referenceTarget)), (boolean)ErrorUtils.isError((DeclarationDescriptor)referenceTarget));
                continue;
            }
            PsiElement expected = (PsiElement)nameToDeclaration.get(name);
            if (expected == null) {
                expected = this.nameToPsiElement.get(name);
            }
            KtReferenceExpression reference = ExpectedResolveData.getAncestorOfType(KtReferenceExpression.class, element);
            if (expected == null && name.startsWith(STANDARD_PREFIX)) {
                DeclarationDescriptor expectedDescriptor = this.nameToDescriptor.get(name);
                KtTypeReference typeReference = ExpectedResolveData.getAncestorOfType(KtTypeReference.class, element);
                if (expectedDescriptor != null) {
                    DeclarationDescriptor actual3 = (DeclarationDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)reference);
                    ExpectedResolveData.assertDescriptorsEqual("Expected: " + name, expectedDescriptor.getOriginal(), actual3 == null ? null : actual3.getOriginal());
                    continue;
                }
                KotlinType actualType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
                Assert.assertNotNull((String)("Type " + name + " not resolved for reference " + name), (Object)actualType);
                ClassDescriptor expectedClass = ExpectedResolveData.getBuiltinClass(module2, name.substring(STANDARD_PREFIX.length()));
                ExpectedResolveData.assertTypeConstructorEquals("Type resolution mismatch: ", expectedClass.getTypeConstructor(), actualType.getConstructor());
                continue;
            }
            assert (expected != null) : "No declaration for " + name;
            if (referenceTarget instanceof PackageViewDescriptor) {
                FqName expectedFqName;
                KtPackageDirective expectedDirective = (KtPackageDirective)PsiTreeUtil.getParentOfType((PsiElement)expected, KtPackageDirective.class);
                if (expectedDirective != null) {
                    expectedFqName = expectedDirective.getFqName();
                } else if (expected instanceof PsiQualifiedNamedElement) {
                    String qualifiedName = ((PsiQualifiedNamedElement)expected).getQualifiedName();
                    assert (qualifiedName != null) : "No qualified name for " + name;
                    expectedFqName = new FqName(qualifiedName);
                } else {
                    throw new IllegalStateException(expected.getClass().getName() + " name=" + name);
                }
                Assert.assertEquals((Object)expectedFqName, (Object)((PackageViewDescriptor)referenceTarget).getFqName());
                continue;
            }
            PsiElement psiElement = actual2 = referenceTarget == null ? (PsiElement)bindingContext.get((ReadOnlySlice)BindingContext.LABEL_TARGET, (Object)referenceExpression) : DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)referenceTarget);
            if (actual2 instanceof KtSimpleNameExpression) {
                actual2 = ((KtSimpleNameExpression)actual2).getIdentifier();
            }
            String actualName = null;
            if (actual2 != null && (actualName = (String)declarationToName.get(actual2)) == null) {
                actualName = actual2.toString();
            }
            Assert.assertNotNull((String)element.getText(), (Object)reference);
            Assert.assertEquals((String)("Reference `" + name + "`" + ExpectedResolveData.renderReferenceInContext(reference) + " is resolved into " + actualName + "."), (Object)expected, (Object)actual2);
        }
        for (Map.Entry<Object, Object> entry : this.positionToType.entrySet()) {
            TypeConstructor expectedTypeConstructor;
            position = (Position)entry.getKey();
            String typeName = (String)entry.getValue();
            element = position.getElement();
            KtExpression expression = ExpectedResolveData.getAncestorOfType(KtExpression.class, element);
            KotlinType expressionType = bindingContext.getType(expression);
            if (typeName.startsWith(STANDARD_PREFIX)) {
                String name = typeName.substring(STANDARD_PREFIX.length());
                expectedTypeConstructor = ExpectedResolveData.getBuiltinClass(module2, name).getTypeConstructor();
            } else {
                Position declarationPosition = this.declarationToPosition.get(typeName);
                Assert.assertNotNull((String)("Undeclared: " + typeName), (Object)declarationPosition);
                PsiElement declElement = declarationPosition.getElement();
                Assert.assertNotNull((Object)declarationPosition);
                KtDeclaration declaration = ExpectedResolveData.getAncestorOfType(KtDeclaration.class, declElement);
                Assert.assertNotNull((Object)declaration);
                if (declaration instanceof KtClass) {
                    ClassDescriptor classDescriptor = (ClassDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.CLASS, (Object)declaration);
                    expectedTypeConstructor = classDescriptor.getTypeConstructor();
                } else if (declaration instanceof KtTypeParameter) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.TYPE_PARAMETER, (Object)((KtTypeParameter)declaration));
                    expectedTypeConstructor = typeParameterDescriptor.getTypeConstructor();
                } else {
                    Assert.fail((String)("Unsupported declaration: " + declaration));
                    return;
                }
            }
            Assert.assertNotNull((String)(expression.getText() + " type is null"), (Object)expressionType);
            ExpectedResolveData.assertTypeConstructorEquals("At " + position + ": ", expectedTypeConstructor, expressionType.getConstructor());
        }
    }

    private static void assertTypeConstructorEquals(String message, TypeConstructor expected, TypeConstructor actual2) {
        ExpectedResolveData.assertDescriptorsEqual(message, (DeclarationDescriptor)expected.getDeclarationDescriptor(), (DeclarationDescriptor)actual2.getDeclarationDescriptor());
    }

    private static void assertDescriptorsEqual(String message, DeclarationDescriptor expected, DeclarationDescriptor actual2) {
        if (DescriptorEquivalenceForOverrides.INSTANCE.areEquivalent(expected, actual2, true, true)) {
            return;
        }
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail((String)(formatted + "expected same:<" + expected + "> was not:<" + actual2 + ">"));
    }

    @NotNull
    private static ClassDescriptor getBuiltinClass(@NotNull ModuleDescriptor module2, @NotNull String nameOrFqName) {
        if (module2 == null) {
            ExpectedResolveData.$$$reportNull$$$0(1);
        }
        if (nameOrFqName == null) {
            ExpectedResolveData.$$$reportNull$$$0(2);
        }
        FqName fqName = nameOrFqName.contains(".") ? new FqName(nameOrFqName) : StandardNames.BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier((String)nameOrFqName));
        ClassDescriptor expectedClass = DescriptorUtilKt.resolveClassByFqName((ModuleDescriptor)module2, (FqName)fqName, (LookupLocation)NoLookupLocation.FROM_TEST);
        Assert.assertNotNull((String)("Expected class not found: " + nameOrFqName), (Object)expectedClass);
        ClassDescriptor classDescriptor = expectedClass;
        if (classDescriptor == null) {
            ExpectedResolveData.$$$reportNull$$$0(3);
        }
        return classDescriptor;
    }

    private static String renderReferenceInContext(KtReferenceExpression referenceExpression) {
        PsiElement parent;
        KtReferenceExpression statement = referenceExpression;
        while ((parent = statement.getParent()) instanceof KtExpression && !(parent instanceof KtBlockExpression)) {
            statement = (KtExpression)parent;
        }
        KtDeclaration declaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, KtDeclaration.class);
        return referenceExpression.getText() + " at " + PsiDiagnosticUtils.atLocation((KtExpression)referenceExpression) + " in " + statement.getText() + (declaration == null ? "" : " in " + declaration.getText());
    }

    private static <T> T getAncestorOfType(Class<T> type, PsiElement element) {
        while (element != null && !type.isInstance(element)) {
            element = element.getParent();
        }
        PsiElement result = element;
        return (T)result;
    }

    @NotNull
    private static String renderNullableDescriptor(@Nullable DeclarationDescriptor d) {
        String string = d == null ? "<null>" : DescriptorRenderer.FQ_NAMES_IN_TYPES.render(d);
        if (string == null) {
            ExpectedResolveData.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameOrFqName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/ExpectedResolveData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/ExpectedResolveData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "renderNullableDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinClass";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Position {
        private final PsiElement element;

        private Position(KtFile file, int offset) {
            this.element = file.findElementAt(offset);
        }

        public PsiElement getElement() {
            return this.element;
        }

        public String toString() {
            return PsiDiagnosticUtils.atLocation((PsiElement)this.element);
        }
    }
}

