/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.AbstractIrGeneratorTestCase;
import org.jetbrains.kotlin.ir.AbstractIrTextTestCase;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.ObsoleteDescriptorBasedAPI;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerDesc;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;
import org.jetbrains.kotlin.ir.util.FakeOverridesStrategy;
import org.jetbrains.kotlin.ir.util.IdSignatureComposer;
import org.jetbrains.kotlin.ir.util.KotlinLikeDumpOptions;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.scripting.compiler.plugin.JsScriptEvaluationExtensionKt;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \"2\u00020\u0001:\u0005\"#$%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0004J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase;", "Lorg/jetbrains/kotlin/ir/AbstractIrGeneratorTestCase;", "()V", "buildFragmentAndTestIt", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "wholeFile", "Ljava/io/File;", "testFiles", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "configureTestSpecific", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "doTest", "doTestIrFileAgainstExpectations", "dir", "testFile", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "doTestIrModuleDependencies", "irModule", "getExpectedTextFileName", "", "name", "parseExpectations", "Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$Expectations;", "verify", "generateExternalClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "externalClassFqn", "Companion", "Expectations", "IrTreeFileLabel", "IrVerifier", "RegexpInText", "tests-common"})
public abstract class AbstractIrTextTestCase
extends AbstractIrGeneratorTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex EXPECTED_OCCURRENCES_PATTERN = new Regex("^\\s*//\\s*(\\d+)\\s*(.*)$");
    @NotNull
    private static final Regex IR_FILE_TXT_PATTERN = new Regex("// IR_FILE: (.*)$");
    @NotNull
    private static final Regex DUMP_EXTERNAL_CLASS = new Regex("// DUMP_EXTERNAL_CLASS (.*)");
    @NotNull
    private static final Regex EXTERNAL_FILE_PATTERN = new Regex("// EXTERNAL_FILE");

    @Override
    protected void doTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> testFiles) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        IrModuleFragment irModule = this.buildFragmentAndTestIt(wholeFile, testFiles);
        this.doTestIrModuleDependencies(wholeFile, irModule);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final IrModuleFragment buildFragmentAndTestIt(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> testFiles) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        File dir = wholeFile.getParentFile();
        boolean ignoreErrors = AbstractIrGeneratorTestCase.Companion.shouldIgnoreErrors$tests_common(wholeFile);
        IrModuleFragment irModule = this.generateIrModule(ignoreErrors);
        Iterable $this$filter$iv = testFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinBaseTest.TestFile it = (KotlinBaseTest.TestFile)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.endsWith$default((String)it.name, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it.name, (String)".kts", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ktFiles = (List)destination$iv$iv;
        for (Pair pair : CollectionsKt.zip((Iterable)ktFiles, (Iterable)irModule.getFiles())) {
            KotlinBaseTest.TestFile testFile = (KotlinBaseTest.TestFile)pair.component1();
            IrFile irFile = (IrFile)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
            this.doTestIrFileAgainstExpectations(dir, testFile, irFile);
        }
        return irModule;
    }

    /*
     * WARNING - void declaration
     */
    private final void doTestIrModuleDependencies(File wholeFile, IrModuleFragment irModule) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        String wholeText = FilesKt.readText$default((File)wholeFile, null, (int)1, null);
        JsManglerDesc mangler = JsManglerDesc.INSTANCE;
        IdSignatureDescriptor signaturer = new IdSignatureDescriptor((KotlinMangler.DescriptorMangler)mangler);
        DeclarationStubGenerator stubGenerator = new DeclarationStubGenerator(irModule.getDescriptor(), new SymbolTable((IdSignatureComposer)signaturer, (IrFactory)IrFactoryImpl.INSTANCE, null, 4, null), CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)this.myEnvironment.getConfiguration()), null, 8, null);
        String path = wholeFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        String replacedPath = StringsKt.replace$default((String)path, (String)".kt", (String)"__", (boolean)false, (int)4, null);
        File[] fileArray = wholeFile.getParentFile().listFiles();
        if (fileArray == null) {
            return;
        }
        File[] filesInDir = fileArray;
        File[] fileArray2 = filesInDir;
        boolean bl = false;
        Collection collection = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Collection collection2 = $this$forEach$iv$iv;
        int n = ((void)collection2).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv;
            void element$iv = element$iv$iv = collection2[i];
            boolean bl2 = false;
            void it = element$iv;
            boolean bl3 = false;
            String string2 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
            if ((StringsKt.startsWith$default((String)string2, (String)replacedPath, (boolean)false, (int)2, null) ? it.getPath() : null) == null) continue;
            string = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it$iv = string;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        List externalFilePaths = (List)destination$iv;
        for (String externalClassFqn : Companion.parseDumpExternalClasses$tests_common(wholeText)) {
            String classDump = DumpIrTreeKt.dump$default((IrElement)((IrElement)this.generateExternalClass(stubGenerator, irModule.getDescriptor(), externalClassFqn)), (boolean)false, (int)1, null);
            String expectedFilePath = StringsKt.replace$default((String)path, (String)".kt", (String)("__" + externalClassFqn + ".txt"), (boolean)false, (int)4, null);
            File expectedFile = new File(expectedFilePath);
            collection2 = externalFilePaths;
            n = 0;
            collection2.remove(expectedFilePath);
            KotlinTestUtils.assertEqualsToFile(expectedFile, classDump);
        }
        KtUsefulTestCase.assertEmpty(Intrinsics.stringPlus((String)"The following external dump files were not built: ", (Object)externalFilePaths), externalFilePaths);
    }

    private final IrClass generateExternalClass(DeclarationStubGenerator $this$generateExternalClass, ModuleDescriptor descriptor, String externalClassFqn) {
        ClassId classId = ClassId.topLevel((FqName)new FqName(externalClassFqn));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(externalClassFqn))");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)descriptor, (ClassId)classId);
        if (classDescriptor == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Can't find a class in external dependencies: ", (Object)externalClassFqn));
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return (IrClass)$this$generateExternalClass.generateMemberStub((DeclarationDescriptor)classDescriptor2);
    }

    @Override
    protected void configureTestSpecific(@NotNull CompilerConfiguration configuration, @NotNull List<? extends KotlinBaseTest.TestFile> testFiles) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
            Iterable $this$any$iv = testFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinBaseTest.TestFile it = (KotlinBaseTest.TestFile)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it.name, (String)".kts", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            JsScriptEvaluationExtensionKt.loadScriptConfiguration((CompilerConfiguration)configuration);
            K2JsIrCompilerKt.loadPluginsForTests((CompilerConfiguration)configuration);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doTestIrFileAgainstExpectations(File dir, KotlinBaseTest.TestFile testFile, IrFile irFile) {
        if (Companion.isExternalFile$tests_common(testFile)) {
            return;
        }
        Expectations expectations = this.parseExpectations(dir, testFile);
        String irFileDump = DumpIrTreeKt.dump((IrElement)((IrElement)irFile), (boolean)true);
        StringBuilder expected = new StringBuilder();
        StringBuilder actual2 = new StringBuilder();
        for (RegexpInText expectation : expectations.getRegexps()) {
            expected.append(expectation.getNumberOfOccurrences()).append(" ").append(expectation.getNeedle()).append("\n");
            int actualCount = StringUtil.findMatches((String)irFileDump, (Pattern)Pattern.compile('(' + expectation.getNeedle() + ')')).size();
            actual2.append(actualCount).append(" ").append(expectation.getNeedle()).append("\n");
        }
        for (IrTreeFileLabel irTreeFileLabel : expectations.getIrTreeFileLabels()) {
            void p1;
            void p0;
            String actualTrees = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)irTreeFileLabel.getLineNumber(), (boolean)true);
            KotlinTestUtils.assertEqualsToFile(irTreeFileLabel.getExpectedTextFile(), actualTrees);
            this.verify(irFile);
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)irFile;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid((IrElement)$this$deepCopyWithSymbols_u24default$iv, (IrElementVisitorVoid)((IrElementVisitorVoid)symbolRemapper$iv));
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper((SymbolRemapper)symbolRemapper$iv);
            TypeRemapper typeRemapper = (TypeRemapper)typeRemapper$iv;
            SymbolRemapper symbolRemapper = (SymbolRemapper)symbolRemapper$iv;
            IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)p1);
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irElement.transform((IrElementTransformer)deepCopyIrTreeWithSymbols, null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            }
            IrFile irFileCopy = (IrFile)((IrElement)((IrFile)irElement2));
            String copiedTrees = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFileCopy, (int)irTreeFileLabel.getLineNumber(), (boolean)true);
            TestCase.assertEquals((String)"IR dump mismatch after deep copy with symbols", (String)actualTrees, (String)copiedTrees);
            this.verify(irFileCopy);
            String kotlinLikeDump = DumpKotlinLikeKt.dumpKotlinLike((IrElement)((IrElement)irFile), (KotlinLikeDumpOptions)new KotlinLikeDumpOptions(false, false, false, false, null, FakeOverridesStrategy.NONE, 25, null));
            File file = FileUtilsKt.withReplacedExtensionOrNull((File)irTreeFileLabel.getExpectedTextFile(), (String)".txt", (String)".kt.txt");
            Intrinsics.checkNotNull((Object)file);
            File kotlinLikeDumpExpectedFile = file;
            KotlinTestUtils.assertEqualsToFile(kotlinLikeDumpExpectedFile, kotlinLikeDump);
        }
        try {
            TestCase.assertEquals((String)irFileDump, (String)expected.toString(), (String)actual2.toString());
        }
        catch (Throwable e) {
            boolean bl = false;
            System.out.println((Object)irFileDump);
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    private final void verify(IrFile irFile) {
        new IrVerifier().verifyWithAssert(irFile);
    }

    @NotNull
    protected String getExpectedTextFileName(@NotNull KotlinBaseTest.TestFile testFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)".kts", (String)".txt", (boolean)false, (int)4, null), (String)".kt", (String)".txt", (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String getExpectedTextFileName$default(AbstractIrTextTestCase abstractIrTextTestCase, KotlinBaseTest.TestFile testFile, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getExpectedTextFileName");
        }
        if ((n & 2) != 0) {
            string = testFile.name;
        }
        return abstractIrTextTestCase.getExpectedTextFileName(testFile, string);
    }

    /*
     * WARNING - void declaration
     */
    private final Expectations parseExpectations(File dir, KotlinBaseTest.TestFile testFile) {
        void $this$mapNotNullTo$iv$iv$iv;
        void $this$matchLinesWith$iv;
        boolean bl;
        MatchResult matchResult;
        void $this$mapNotNullTo$iv$iv$iv2;
        Companion $this$matchLinesWith$iv2;
        Companion companion = Companion;
        String string = testFile.content;
        Object regex$iv = EXPECTED_OCCURRENCES_PATTERN;
        boolean $i$f$matchLinesWith = false;
        Iterable $this$mapNotNull$iv$iv = StringsKt.lines((CharSequence)((CharSequence)((Object)$this$matchLinesWith$iv2)));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv$iv;
        Iterable<RegexpInText> destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RegexpInText regexpInText;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it$iv = (String)element$iv$iv$iv;
            boolean bl3 = false;
            MatchResult matchResult2 = regex$iv.matchEntire((CharSequence)it$iv);
            if (matchResult2 == null) {
                regexpInText = null;
            } else {
                matchResult = matchResult2;
                boolean bl4 = false;
                bl = false;
                MatchResult it = matchResult;
                boolean bl5 = false;
                String string2 = (String)it.getGroupValues().get(2);
                boolean bl6 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                regexpInText = new RegexpInText((String)it.getGroupValues().get(1), ((Object)StringsKt.trim((CharSequence)string3)).toString());
            }
            if (regexpInText == null) continue;
            RegexpInText regexpInText2 = regexpInText;
            boolean bl7 = false;
            boolean bl8 = false;
            RegexpInText it$iv$iv$iv = regexpInText2;
            boolean bl9 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        List regexps = (List)destination$iv$iv$iv;
        $this$matchLinesWith$iv2 = Companion;
        regex$iv = testFile.content;
        Regex regex$iv2 = IR_FILE_TXT_PATTERN;
        boolean $i$f$matchLinesWith2 = false;
        Iterable $this$mapNotNull$iv$iv2 = StringsKt.lines((CharSequence)((CharSequence)$this$matchLinesWith$iv));
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv$iv = $this$mapNotNull$iv$iv2;
        Collection destination$iv$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv$iv2 = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            IrTreeFileLabel irTreeFileLabel;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
            boolean bl10 = false;
            String it$iv = (String)element$iv$iv$iv;
            boolean bl11 = false;
            matchResult = regex$iv2.matchEntire((CharSequence)it$iv);
            if (matchResult == null) {
                irTreeFileLabel = null;
            } else {
                MatchResult matchResult3 = matchResult;
                bl = false;
                boolean bl12 = false;
                MatchResult it = matchResult3;
                boolean bl13 = false;
                String string4 = (String)it.getGroupValues().get(1);
                boolean bl14 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String fileName = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                File file = new File(dir, this.getExpectedTextFileName(testFile, fileName));
                irTreeFileLabel = new IrTreeFileLabel(file, 0);
            }
            if (irTreeFileLabel == null) continue;
            IrTreeFileLabel irTreeFileLabel2 = irTreeFileLabel;
            boolean bl15 = false;
            boolean bl16 = false;
            IrTreeFileLabel it$iv$iv$iv = irTreeFileLabel2;
            boolean bl17 = false;
            destination$iv$iv$iv2.add(it$iv$iv$iv);
        }
        List treeFiles = (List)destination$iv$iv$iv2;
        if (treeFiles.isEmpty()) {
            File file = new File(dir, AbstractIrTextTestCase.getExpectedTextFileName$default(this, testFile, null, 2, null));
            treeFiles = CollectionsKt.listOf((Object)new IrTreeFileLabel(file, 0));
        }
        return new Expectations(regexps, treeFiles);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00ab\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0003J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\bH\u0002J\u001f\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0#H\u0082\bJ\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0013H\u0016J\u0010\u00100\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00172\u0006\u0010,\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00172\u0006\u0010,\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00172\u0006\u0010,\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00172\u0006\u0010,\u001a\u00020=H\u0016J\u001c\u0010>\u001a\u00020\u0017*\u00020\u00142\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u0013H\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$IrVerifier;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "()V", "elementsAreUniqueChecker", "org/jetbrains/kotlin/ir/AbstractIrTextTestCase$IrVerifier$elementsAreUniqueChecker$1", "Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$IrVerifier$elementsAreUniqueChecker$1;", "errors", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "errorsAsMessage", "getErrorsAsMessage", "()Ljava/lang/String;", "hasErrors", "", "getHasErrors", "()Z", "symbolForDeclaration", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lkotlin/collections/HashMap;", "checkTypeParameters", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParametersContainer;", "expectedTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "error", "message", "require", "condition", "Lkotlin/Function0;", "verifyWithAssert", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitDeclarationReference", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitElement", "element", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitLocalDelegatedPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "visitProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitPropertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "checkBinding", "kind", "irElement", "tests-common"})
    private static final class IrVerifier
    implements IrElementVisitorVoid {
        @NotNull
        private final ArrayList<String> errors = new ArrayList();
        @NotNull
        private final HashMap<IrElement, IrSymbol> symbolForDeclaration = new HashMap();
        @NotNull
        private final elementsAreUniqueChecker.1 elementsAreUniqueChecker = new IrElementVisitorVoid(this){
            @NotNull
            private final HashSet<IrElement> elements;
            final /* synthetic */ IrVerifier this$0;
            {
                this.this$0 = $receiver;
                this.elements = new HashSet<E>();
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVerifier irVerifier = this.this$0;
                boolean condition$iv = this.elements.add(element);
                boolean $i$f$require = false;
                if (!condition$iv) {
                    void this_$iv;
                    ArrayList arrayList = IrVerifier.access$getErrors$p((IrVerifier)this_$iv);
                    boolean bl = false;
                    String string = Intrinsics.stringPlus((String)"Non-unique element: ", (Object)RenderIrElementKt.render((IrElement)element));
                    arrayList.add(string);
                }
                IrElementVisitorVoidKt.acceptChildrenVoid((IrElement)element, (IrElementVisitorVoid)this);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression) {
                IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression, (Void)data);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
            }

            public void visitBlock(@NotNull IrBlock expression) {
                IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression);
            }

            public void visitBlock(@NotNull IrBlock expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression, (Void)data);
            }

            public void visitBlockBody(@NotNull IrBlockBody body) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body);
            }

            public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body, (Void)data);
            }

            public void visitBody(@NotNull IrBody body) {
                IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body);
            }

            public void visitBody(@NotNull IrBody body, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body, (Void)data);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
            }

            public void visitCall(@NotNull IrCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression);
            }

            public void visitCall(@NotNull IrCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression, (Void)data);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression, (Void)data);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
            }

            public void visitClass(@NotNull IrClass declaration) {
                IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration);
            }

            public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
            }

            public void visitClassReference(@NotNull IrClassReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression);
            }

            public void visitClassReference(@NotNull IrClassReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression, (Void)data);
            }

            public void visitComposite(@NotNull IrComposite expression) {
                IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression);
            }

            public void visitComposite(@NotNull IrComposite expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression, (Void)data);
            }

            public void visitConstructor(@NotNull IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
            }

            public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression, (Void)data);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression, (Void)data);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression, (Void)data);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression, (Void)data);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression, (Void)data);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression, (Void)data);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression, (Void)data);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression, (Void)data);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression, (Void)data);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression, (Void)data);
            }

            public void visitExpression(@NotNull IrExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression);
            }

            public void visitExpression(@NotNull IrExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression, (Void)data);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body, (Void)data);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
            }

            public void visitField(@NotNull IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration);
            }

            public void visitField(@NotNull IrField declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression, (Void)data);
            }

            public void visitFile(@NotNull IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
            }

            public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
            }

            public void visitFunction(@NotNull IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration);
            }

            public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression, (Void)data);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression, (Void)data);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression, (Void)data);
            }

            public void visitGetClass(@NotNull IrGetClass expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression);
            }

            public void visitGetClass(@NotNull IrGetClass expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression, (Void)data);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression, (Void)data);
            }

            public void visitGetField(@NotNull IrGetField expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression);
            }

            public void visitGetField(@NotNull IrGetField expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression, (Void)data);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression, (Void)data);
            }

            public void visitGetValue(@NotNull IrGetValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression);
            }

            public void visitGetValue(@NotNull IrGetValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression, (Void)data);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression, (Void)data);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression, (Void)data);
            }

            public void visitLoop(@NotNull IrLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
            }

            public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression, (Void)data);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
            }

            public void visitProperty(@NotNull IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration);
            }

            public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression, (Void)data);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression, (Void)data);
            }

            public void visitReturn(@NotNull IrReturn expression) {
                IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression);
            }

            public void visitReturn(@NotNull IrReturn expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression, (Void)data);
            }

            public void visitScript(@NotNull IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
            }

            public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
            }

            public void visitSetField(@NotNull IrSetField expression) {
                IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression);
            }

            public void visitSetField(@NotNull IrSetField expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression, (Void)data);
            }

            public void visitSetValue(@NotNull IrSetValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression);
            }

            public void visitSetValue(@NotNull IrSetValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression, (Void)data);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression, (Void)data);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression, (Void)data);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression, (Void)data);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression, (Void)data);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body, (Void)data);
            }

            public void visitThrow(@NotNull IrThrow expression) {
                IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression);
            }

            public void visitThrow(@NotNull IrThrow expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression, (Void)data);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression, (Void)data);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression, (Void)data);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
            }

            public void visitVararg(@NotNull IrVararg expression) {
                IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression);
            }

            public void visitVararg(@NotNull IrVararg expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression, (Void)data);
            }

            public void visitVariable(@NotNull IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration);
            }

            public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression);
            }

            public void visitWhen(@NotNull IrWhen expression) {
                IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression);
            }

            public void visitWhen(@NotNull IrWhen expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression, (Void)data);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
            }
        };

        public final boolean getHasErrors() {
            Collection collection = this.errors;
            boolean bl = false;
            return !collection.isEmpty();
        }

        @NotNull
        public final String getErrorsAsMessage() {
            return CollectionsKt.joinToString$default((Iterable)this.errors, (CharSequence)"\n", (CharSequence)"IR verifier errors:\n", null, (int)0, null, null, (int)60, null);
        }

        private final void error(String message) {
            this.errors.add(message);
        }

        private final void require(boolean condition, Function0<String> message) {
            boolean $i$f$require = false;
            if (!condition) {
                this.errors.add(message.invoke());
            }
        }

        public final void verifyWithAssert(@NotNull IrFile irFile) {
            Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
            IrElementVisitorVoidKt.acceptChildrenVoid((IrElement)((IrElement)irFile), (IrElementVisitorVoid)this);
            IrElementVisitorVoidKt.acceptChildrenVoid((IrElement)((IrElement)irFile), (IrElementVisitorVoid)this.elementsAreUniqueChecker);
            TestCase.assertFalse((String)(this.getErrorsAsMessage() + "\n\n\n" + DumpIrTreeKt.dump$default((IrElement)((IrElement)irFile), (boolean)false, (int)1, null)), (boolean)this.getHasErrors());
        }

        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IrElementVisitorVoidKt.acceptChildrenVoid((IrElement)element, (IrElementVisitorVoid)this);
        }

        /*
         * WARNING - void declaration
         */
        public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
            IrDeclarationParent parent;
            DeclarationDescriptor containingDeclarationDescriptor;
            String string;
            ArrayList arrayList;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (declaration instanceof IrSymbolOwner) {
                this.checkBinding(((IrSymbolOwner)declaration).getSymbol(), "decl", (IrElement)declaration);
                IrVerifier irVerifier = this;
                boolean condition$iv = Intrinsics.areEqual((Object)((IrSymbolOwner)declaration).getSymbol().getOwner(), (Object)declaration);
                boolean $i$f$require = false;
                if (!condition$iv) {
                    void this_$iv;
                    arrayList = ((IrVerifier)this_$iv).errors;
                    boolean bl = false;
                    string = Intrinsics.stringPlus((String)"Symbol is not bound to declaration: ", (Object)RenderIrElementKt.render((IrElement)((IrElement)declaration)));
                    arrayList.add(string);
                }
            }
            if ((containingDeclarationDescriptor = declaration.getDescriptor().getContainingDeclaration()) != null && (parent = declaration.getParent()) instanceof IrDeclaration) {
                IrVerifier $i$f$require = this;
                boolean condition$iv = Intrinsics.areEqual((Object)((IrDeclaration)parent).getDescriptor(), (Object)containingDeclarationDescriptor);
                boolean $i$f$require2 = false;
                if (!condition$iv) {
                    void this_$iv;
                    arrayList = ((IrVerifier)this_$iv).errors;
                    boolean bl = false;
                    string = "In declaration " + declaration.getDescriptor() + ": Mismatching parent descriptor (" + ((IrDeclaration)parent).getDescriptor() + ") and containing declaration descriptor (" + containingDeclarationDescriptor + ')';
                    arrayList.add(string);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void visitProperty(@NotNull IrProperty declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.visitDeclaration((IrDeclarationBase)declaration);
            IrVerifier irVerifier = this;
            boolean condition$iv = Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) == declaration.isFakeOverride();
            boolean $i$f$require = false;
            if (!condition$iv) {
                void this_$iv;
                ArrayList arrayList = ((IrVerifier)this_$iv).errors;
                boolean bl = false;
                String string = RenderIrElementKt.render((IrElement)((IrElement)declaration)) + ": origin: " + declaration.getOrigin() + "; isFakeOverride: " + declaration.isFakeOverride();
                arrayList.add(string);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void visitFunction(@NotNull IrFunction declaration) {
            void $this$mapTo$iv$iv;
            String string;
            Collection<String> collection;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.visitDeclaration((IrDeclarationBase)declaration);
            FunctionDescriptor functionDescriptor = declaration.getDescriptor();
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)functionDescriptor;
            IrTypeParametersContainer irTypeParametersContainer = (IrTypeParametersContainer)declaration;
            List list = functionDescriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"functionDescriptor.typeParameters");
            this.checkTypeParameters(declarationDescriptor, irTypeParametersContainer, list);
            ReceiverParameterDescriptor expectedDispatchReceiver = functionDescriptor.getDispatchReceiverParameter();
            Object object = declaration.getDispatchReceiverParameter();
            ParameterDescriptor actualDispatchReceiver = object == null ? null : object.getDescriptor();
            object = this;
            boolean condition$iv = Intrinsics.areEqual((Object)expectedDispatchReceiver, (Object)actualDispatchReceiver);
            boolean $i$f$require22 = false;
            if (!condition$iv) {
                void this_$iv;
                collection = ((IrVerifier)this_$iv).errors;
                boolean bl = false;
                string = functionDescriptor + ": Dispatch receiver parameter mismatch: expected " + expectedDispatchReceiver + ", actual " + actualDispatchReceiver;
                ((ArrayList)collection).add(string);
            }
            ReceiverParameterDescriptor expectedExtensionReceiver = functionDescriptor.getExtensionReceiverParameter();
            Object $i$f$require22 = declaration.getExtensionReceiverParameter();
            ParameterDescriptor actualExtensionReceiver = $i$f$require22 == null ? null : $i$f$require22.getDescriptor();
            $i$f$require22 = this;
            boolean condition$iv2 = Intrinsics.areEqual((Object)expectedExtensionReceiver, (Object)actualExtensionReceiver);
            boolean $i$f$require = false;
            if (!condition$iv2) {
                void this_$iv;
                collection = ((IrVerifier)this_$iv).errors;
                boolean bl = false;
                string = functionDescriptor + ": Extension receiver parameter mismatch: expected " + expectedExtensionReceiver + ", actual " + actualExtensionReceiver;
                ((ArrayList)collection).add(string);
            }
            Iterable $this$map$iv = declaration.getValueParameters();
            boolean $i$f$map22 = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                string = it.getDescriptor();
                collection.add(string);
            }
            List declaredValueParameters = (List)destination$iv$iv;
            List $i$f$map22 = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"functionDescriptor.valueParameters");
            List actualValueParameters = $i$f$map22;
            if (declaredValueParameters.size() != actualValueParameters.size()) {
                this.error(functionDescriptor + ": Value parameters mismatch: " + declaredValueParameters + " != " + actualValueParameters);
            } else {
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)declaredValueParameters, (Iterable)actualValueParameters);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void this_$iv;
                    Pair $dstr$declaredValueParameter$actualValueParameter = (Pair)element$iv;
                    boolean bl3 = false;
                    ParameterDescriptor declaredValueParameter = (ParameterDescriptor)$dstr$declaredValueParameter$actualValueParameter.component1();
                    ValueParameterDescriptor actualValueParameter = (ValueParameterDescriptor)$dstr$declaredValueParameter$actualValueParameter.component2();
                    IrVerifier irVerifier = this;
                    boolean condition$iv3 = Intrinsics.areEqual((Object)declaredValueParameter, (Object)actualValueParameter);
                    boolean $i$f$require3 = false;
                    if (condition$iv3) continue;
                    ArrayList arrayList = ((IrVerifier)this_$iv).errors;
                    boolean bl4 = false;
                    String string2 = functionDescriptor + ": Value parameters mismatch: " + declaredValueParameter + " != " + actualValueParameter;
                    arrayList.add(string2);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.visitFunction((IrFunction)declaration);
            IrVerifier irVerifier = this;
            boolean condition$iv = Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE) == declaration.isFakeOverride();
            boolean $i$f$require = false;
            if (!condition$iv) {
                void this_$iv;
                ArrayList arrayList = ((IrVerifier)this_$iv).errors;
                boolean bl = false;
                String string = RenderIrElementKt.render((IrElement)((IrElement)declaration)) + ": origin: " + declaration.getOrigin() + "; isFakeOverride: " + declaration.isFakeOverride();
                arrayList.add(string);
            }
        }

        public void visitDeclarationReference(@NotNull IrDeclarationReference expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.checkBinding(expression.getSymbol(), "ref", (IrElement)expression);
        }

        public void visitFunctionReference(@NotNull IrFunctionReference expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.checkBinding(expression.getSymbol(), "ref", (IrElement)expression);
        }

        public void visitPropertyReference(@NotNull IrPropertyReference expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            IrFieldSymbol irFieldSymbol = expression.getField();
            if (irFieldSymbol != null) {
                this.checkBinding((IrSymbol)irFieldSymbol, "field", (IrElement)expression);
            }
            irFieldSymbol = expression.getGetter();
            if (irFieldSymbol != null) {
                this.checkBinding((IrSymbol)irFieldSymbol, "getter", (IrElement)expression);
            }
            irFieldSymbol = expression.getSetter();
            if (irFieldSymbol != null) {
                this.checkBinding((IrSymbol)irFieldSymbol, "setter", (IrElement)expression);
            }
        }

        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.checkBinding((IrSymbol)expression.getDelegate(), "delegate", (IrElement)expression);
            this.checkBinding((IrSymbol)expression.getGetter(), "getter", (IrElement)expression);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = expression.getSetter();
            if (irSimpleFunctionSymbol != null) {
                this.checkBinding((IrSymbol)irSimpleFunctionSymbol, "setter", (IrElement)expression);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkBinding(IrSymbol $this$checkBinding, String kind, IrElement irElement) {
            IrSymbol otherSymbol;
            Object object;
            void $this$getOrPut$iv;
            if (!$this$checkBinding.isBound()) {
                this.error($this$checkBinding.getClass().getSimpleName() + " descriptor is unbound @" + kind + ' ' + RenderIrElementKt.render((IrElement)irElement));
            } else {
                IrDeclaration irDeclaration;
                IrSymbolOwner irSymbolOwner = $this$checkBinding.getOwner();
                IrDeclaration irDeclaration2 = irDeclaration = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
                if (irDeclaration != null) {
                    try {
                        irDeclaration.getParent();
                    }
                    catch (Throwable e) {
                        this.error(Intrinsics.stringPlus((String)"Referenced declaration has no parent: ", (Object)RenderIrElementKt.render((IrElement)((IrElement)irDeclaration))));
                    }
                }
            }
            Map e = this.symbolForDeclaration;
            IrSymbolOwner key$iv = $this$checkBinding.getOwner();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                IrSymbol answer$iv = $this$checkBinding;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            if (!Intrinsics.areEqual((Object)$this$checkBinding, (Object)(otherSymbol = (IrSymbol)object))) {
                this.error("Multiple symbols for descriptor of @" + kind + ' ' + RenderIrElementKt.render((IrElement)irElement));
            }
        }

        public void visitClass(@NotNull IrClass declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            this.visitDeclaration((IrDeclarationBase)declaration);
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)declaration.getDescriptor();
            IrTypeParametersContainer irTypeParametersContainer = (IrTypeParametersContainer)declaration;
            List list = declaration.getDescriptor().getDeclaredTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"declaration.descriptor.declaredTypeParameters");
            this.checkTypeParameters(declarationDescriptor, irTypeParametersContainer, list);
        }

        /*
         * WARNING - void declaration
         */
        @ObsoleteDescriptorBasedAPI
        private final void checkTypeParameters(DeclarationDescriptor descriptor, IrTypeParametersContainer declaration, List<? extends TypeParameterDescriptor> expectedTypeParameters) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = declaration.getTypeParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                TypeParameterDescriptor typeParameterDescriptor = it.getDescriptor();
                collection.add(typeParameterDescriptor);
            }
            List declaredTypeParameters = (List)destination$iv$iv;
            if (declaredTypeParameters.size() != expectedTypeParameters.size()) {
                this.error(descriptor + ": Type parameters mismatch: " + declaredTypeParameters + " != " + expectedTypeParameters);
            } else {
                Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)declaredTypeParameters, (Iterable)expectedTypeParameters);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void this_$iv;
                    Pair $dstr$declaredTypeParameter$expectedTypeParameter = (Pair)element$iv;
                    boolean bl = false;
                    TypeParameterDescriptor declaredTypeParameter = (TypeParameterDescriptor)$dstr$declaredTypeParameter$expectedTypeParameter.component1();
                    TypeParameterDescriptor expectedTypeParameter = (TypeParameterDescriptor)$dstr$declaredTypeParameter$expectedTypeParameter.component2();
                    IrVerifier bl2 = this;
                    boolean condition$iv = Intrinsics.areEqual((Object)declaredTypeParameter, (Object)expectedTypeParameter);
                    boolean $i$f$require = false;
                    if (condition$iv) continue;
                    ArrayList arrayList = ((IrVerifier)this_$iv).errors;
                    boolean bl3 = false;
                    String string = descriptor + ": Type parameters mismatch: " + declaredTypeParameter + " != " + expectedTypeParameter;
                    arrayList.add(string);
                }
            }
        }

        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.checkBinding((IrSymbol)expression.getTypeOperandClassifier(), "type operand", (IrElement)expression);
        }

        public <T> void visitConst(@NotNull IrConst<T> expression) {
            IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression);
        }

        public <T> void visitConst(@NotNull IrConst<T> expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression, (Void)data);
        }

        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
        }

        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
        }

        public void visitBlock(@NotNull IrBlock expression) {
            IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression);
        }

        public void visitBlock(@NotNull IrBlock expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression, (Void)data);
        }

        public void visitBlockBody(@NotNull IrBlockBody body) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body);
        }

        public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body, (Void)data);
        }

        public void visitBody(@NotNull IrBody body) {
            IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body);
        }

        public void visitBody(@NotNull IrBody body, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body, (Void)data);
        }

        public void visitBranch(@NotNull IrBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
        }

        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
        }

        public void visitBreak(@NotNull IrBreak jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump);
        }

        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
        }

        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
        }

        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
        }

        public void visitCall(@NotNull IrCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression);
        }

        public void visitCall(@NotNull IrCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression, (Void)data);
        }

        public void visitCallableReference(@NotNull IrCallableReference<?> expression) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression);
        }

        public void visitCallableReference(@NotNull IrCallableReference<?> expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression, (Void)data);
        }

        public void visitCatch(@NotNull IrCatch aCatch) {
            IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
        }

        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
        }

        public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
        }

        public void visitClassReference(@NotNull IrClassReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression);
        }

        public void visitClassReference(@NotNull IrClassReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression, (Void)data);
        }

        public void visitComposite(@NotNull IrComposite expression) {
            IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression);
        }

        public void visitComposite(@NotNull IrComposite expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression, (Void)data);
        }

        public void visitConstructor(@NotNull IrConstructor declaration) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
        }

        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
        }

        public void visitConstructorCall(@NotNull IrConstructorCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression);
        }

        public void visitConstructorCall(@NotNull IrConstructorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression, (Void)data);
        }

        public void visitContainerExpression(@NotNull IrContainerExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression);
        }

        public void visitContainerExpression(@NotNull IrContainerExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression, (Void)data);
        }

        public void visitContinue(@NotNull IrContinue jump) {
            IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump);
        }

        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
        }

        public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
        }

        public void visitDeclarationReference(@NotNull IrDeclarationReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression, (Void)data);
        }

        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression);
        }

        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression, (Void)data);
        }

        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop);
        }

        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
        }

        public void visitDynamicExpression(@NotNull IrDynamicExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression);
        }

        public void visitDynamicExpression(@NotNull IrDynamicExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression, (Void)data);
        }

        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression);
        }

        public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression, (Void)data);
        }

        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression);
        }

        public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression, (Void)data);
        }

        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
        }

        public void visitElseBranch(@NotNull IrElseBranch branch) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
        }

        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
        }

        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression);
        }

        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression, (Void)data);
        }

        public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
        }

        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
        }

        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression);
        }

        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression, (Void)data);
        }

        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
        }

        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
        }

        public void visitErrorExpression(@NotNull IrErrorExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression);
        }

        public void visitErrorExpression(@NotNull IrErrorExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression, (Void)data);
        }

        public void visitExpression(@NotNull IrExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression);
        }

        public void visitExpression(@NotNull IrExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression, (Void)data);
        }

        public void visitExpressionBody(@NotNull IrExpressionBody body) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body);
        }

        public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body, (Void)data);
        }

        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
        }

        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
        }

        public void visitField(@NotNull IrField declaration) {
            IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration);
        }

        public void visitField(@NotNull IrField declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
        }

        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression);
        }

        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression, (Void)data);
        }

        public void visitFile(@NotNull IrFile declaration) {
            IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
        }

        public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
        }

        public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
        }

        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression);
        }

        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression, (Void)data);
        }

        public void visitFunctionExpression(@NotNull IrFunctionExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression);
        }

        public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression, (Void)data);
        }

        public void visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression, (Void)data);
        }

        public void visitGetClass(@NotNull IrGetClass expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression);
        }

        public void visitGetClass(@NotNull IrGetClass expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression, (Void)data);
        }

        public void visitGetEnumValue(@NotNull IrGetEnumValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression);
        }

        public void visitGetEnumValue(@NotNull IrGetEnumValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression, (Void)data);
        }

        public void visitGetField(@NotNull IrGetField expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression);
        }

        public void visitGetField(@NotNull IrGetField expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression, (Void)data);
        }

        public void visitGetObjectValue(@NotNull IrGetObjectValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression);
        }

        public void visitGetObjectValue(@NotNull IrGetObjectValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression, (Void)data);
        }

        public void visitGetValue(@NotNull IrGetValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression);
        }

        public void visitGetValue(@NotNull IrGetValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression, (Void)data);
        }

        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression);
        }

        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression, (Void)data);
        }

        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
        }

        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
        }

        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression, (Void)data);
        }

        public void visitLoop(@NotNull IrLoop loop) {
            IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
        }

        public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
        }

        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression);
        }

        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression, (Void)data);
        }

        public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
        }

        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
        }

        public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
        }

        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
        }

        public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
        }

        public void visitPropertyReference(@NotNull IrPropertyReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression, (Void)data);
        }

        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression);
        }

        public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression, (Void)data);
        }

        public void visitReturn(@NotNull IrReturn expression) {
            IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression);
        }

        public void visitReturn(@NotNull IrReturn expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression, (Void)data);
        }

        public void visitScript(@NotNull IrScript declaration) {
            IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
        }

        public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
        }

        public void visitSetField(@NotNull IrSetField expression) {
            IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression);
        }

        public void visitSetField(@NotNull IrSetField expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression, (Void)data);
        }

        public void visitSetValue(@NotNull IrSetValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression);
        }

        public void visitSetValue(@NotNull IrSetValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression, (Void)data);
        }

        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
        }

        public void visitSingletonReference(@NotNull IrGetSingletonValue expression) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression);
        }

        public void visitSingletonReference(@NotNull IrGetSingletonValue expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression, (Void)data);
        }

        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
        }

        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
        }

        public void visitStringConcatenation(@NotNull IrStringConcatenation expression) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression);
        }

        public void visitStringConcatenation(@NotNull IrStringConcatenation expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression, (Void)data);
        }

        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression);
        }

        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression, (Void)data);
        }

        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression);
        }

        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression, (Void)data);
        }

        public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body);
        }

        public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body, (Void)data);
        }

        public void visitThrow(@NotNull IrThrow expression) {
            IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression);
        }

        public void visitThrow(@NotNull IrThrow expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression, (Void)data);
        }

        public void visitTry(@NotNull IrTry aTry) {
            IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry);
        }

        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
        }

        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration);
        }

        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
        }

        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression, (Void)data);
        }

        public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
        }

        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
        }

        public void visitValueAccess(@NotNull IrValueAccessExpression expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression, (Void)data);
        }

        public void visitValueParameter(@NotNull IrValueParameter declaration) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
        }

        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
        }

        public void visitVararg(@NotNull IrVararg expression) {
            IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression);
        }

        public void visitVararg(@NotNull IrVararg expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression, (Void)data);
        }

        public void visitVariable(@NotNull IrVariable declaration) {
            IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration);
        }

        public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
        }

        public void visitVariableAccess(@NotNull IrValueAccessExpression expression) {
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression);
        }

        public void visitWhen(@NotNull IrWhen expression) {
            IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression);
        }

        public void visitWhen(@NotNull IrWhen expression, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression, (Void)data);
        }

        public void visitWhileLoop(@NotNull IrWhileLoop loop) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop);
        }

        public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$Expectations;", "", "regexps", "", "Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$RegexpInText;", "irTreeFileLabels", "Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$IrTreeFileLabel;", "(Ljava/util/List;Ljava/util/List;)V", "getIrTreeFileLabels", "()Ljava/util/List;", "getRegexps", "tests-common"})
    public static final class Expectations {
        @NotNull
        private final List<RegexpInText> regexps;
        @NotNull
        private final List<IrTreeFileLabel> irTreeFileLabels;

        public Expectations(@NotNull List<RegexpInText> regexps, @NotNull List<IrTreeFileLabel> irTreeFileLabels) {
            Intrinsics.checkNotNullParameter(regexps, (String)"regexps");
            Intrinsics.checkNotNullParameter(irTreeFileLabels, (String)"irTreeFileLabels");
            this.regexps = regexps;
            this.irTreeFileLabels = irTreeFileLabels;
        }

        @NotNull
        public final List<RegexpInText> getRegexps() {
            return this.regexps;
        }

        @NotNull
        public final List<IrTreeFileLabel> getIrTreeFileLabels() {
            return this.irTreeFileLabels;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$RegexpInText;", "", "countStr", "", "needle", "(Ljava/lang/String;Ljava/lang/String;)V", "numberOfOccurrences", "", "(ILjava/lang/String;)V", "getNeedle", "()Ljava/lang/String;", "getNumberOfOccurrences", "()I", "tests-common"})
    public static final class RegexpInText {
        private final int numberOfOccurrences;
        @NotNull
        private final String needle;

        public RegexpInText(int numberOfOccurrences, @NotNull String needle) {
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            this.numberOfOccurrences = numberOfOccurrences;
            this.needle = needle;
        }

        public final int getNumberOfOccurrences() {
            return this.numberOfOccurrences;
        }

        @NotNull
        public final String getNeedle() {
            return this.needle;
        }

        public RegexpInText(@NotNull String countStr, @NotNull String needle) {
            Intrinsics.checkNotNullParameter((Object)countStr, (String)"countStr");
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            Integer n = Integer.valueOf(countStr);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(countStr)");
            this(((Number)n).intValue(), needle);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$IrTreeFileLabel;", "", "expectedTextFile", "Ljava/io/File;", "lineNumber", "", "(Ljava/io/File;I)V", "getExpectedTextFile", "()Ljava/io/File;", "getLineNumber", "()I", "tests-common"})
    public static final class IrTreeFileLabel {
        @NotNull
        private final File expectedTextFile;
        private final int lineNumber;

        public IrTreeFileLabel(@NotNull File expectedTextFile, int lineNumber) {
            Intrinsics.checkNotNullParameter((Object)expectedTextFile, (String)"expectedTextFile");
            this.expectedTextFile = expectedTextFile;
            this.lineNumber = lineNumber;
        }

        @NotNull
        public final File getExpectedTextFile() {
            return this.expectedTextFile;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\fJ\u0011\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J5\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\t\"\u0004\b\u0000\u0010\u0012*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u00120\u0015H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$Companion;", "", "()V", "DUMP_EXTERNAL_CLASS", "Lkotlin/text/Regex;", "EXPECTED_OCCURRENCES_PATTERN", "EXTERNAL_FILE_PATTERN", "IR_FILE_TXT_PATTERN", "parseDumpExternalClasses", "", "", "text", "parseDumpExternalClasses$tests_common", "isExternalFile", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "isExternalFile$tests_common", "matchLinesWith", "T", "regex", "ifMatched", "Lkotlin/Function1;", "Lkotlin/text/MatchResult;", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<T> matchLinesWith(String $this$matchLinesWith, Regex regex, Function1<? super MatchResult, ? extends T> ifMatched) {
            void $this$mapNotNullTo$iv$iv;
            boolean $i$f$matchLinesWith = false;
            Iterable $this$mapNotNull$iv = StringsKt.lines((CharSequence)$this$matchLinesWith);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                MatchResult matchResult = regex.matchEntire((CharSequence)it);
                if (matchResult == null) {
                    object = null;
                } else {
                    MatchResult matchResult2 = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    object = ifMatched.invoke((Object)matchResult2);
                }
                if (object == null) continue;
                Object object2 = object;
                boolean bl5 = false;
                boolean bl6 = false;
                Object it$iv$iv = object2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> parseDumpExternalClasses$tests_common(@NotNull String text) {
            void $this$mapNotNullTo$iv$iv$iv;
            void $this$matchLinesWith$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Companion companion = this;
            String string = text;
            Regex regex$iv = DUMP_EXTERNAL_CLASS;
            boolean $i$f$matchLinesWith = false;
            Iterable $this$mapNotNull$iv$iv = StringsKt.lines((CharSequence)((CharSequence)$this$matchLinesWith$iv));
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string2;
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it$iv = (String)element$iv$iv$iv;
                boolean bl2 = false;
                MatchResult matchResult = regex$iv.matchEntire((CharSequence)it$iv);
                if (matchResult == null) {
                    string2 = null;
                } else {
                    MatchResult matchResult2 = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    MatchResult it = matchResult2;
                    boolean bl5 = false;
                    string2 = (String)it.getGroupValues().get(1);
                }
                if (string2 == null) continue;
                String string3 = string2;
                boolean bl6 = false;
                boolean bl7 = false;
                String it$iv$iv$iv = string3;
                boolean bl8 = false;
                destination$iv$iv$iv.add(it$iv$iv$iv);
            }
            return (List)destination$iv$iv$iv;
        }

        public final boolean isExternalFile$tests_common(@NotNull KotlinBaseTest.TestFile $this$isExternalFile) {
            Intrinsics.checkNotNullParameter((Object)$this$isExternalFile, (String)"<this>");
            return EXTERNAL_FILE_PATTERN.containsMatchIn((CharSequence)$this$isExternalFile.content);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

