/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.checkers.BaseDiagnosticsTest;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory1;
import org.jetbrains.kotlin.checkers.utils.TypeOfCall;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.fir.AbstractFirBaseDiagnosticsTest;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirPsiSourceElement;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirRenderer;
import org.jetbrains.kotlin.fir.FirResolveBenchKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.RenderingForDebugInfoKt;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.FirDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticFactory1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnosticWithParameters1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirLightDiagnosticWithParameters1;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirPsiDiagnosticWithParameters1;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeKind;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FirControlFlowGraphRenderVisitor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessorKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 >2\u00020\u0001:\u0002=>B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u001e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0014\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J0\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00102\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000e0\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0014J\u001c\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ4\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\n2\u0006\u0010\u001a\u001a\u00020\u000b2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001cH\u0004J,\u0010 \u001a\u0018\u0012\u0004\u0012\u00020\u000b\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\n0!2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0004J@\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f\u0018\u00010#2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001cH\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J6\u0010-\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f\u0018\u00010#2\u0006\u0010%\u001a\u00020.2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001cJ\u001e\u0010/\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u000101H\u0002J<\u00102\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000e0\n2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u00020,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0!H\u0014JJ\u00104\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001f\u0018\u00010#*\u0002052\u0006\u0010%\u001a\u00020&2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001c2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001f07H\u0002J\u0012\u00108\u001a\u0004\u0018\u000109*\u0006\u0012\u0002\b\u000301H\u0002J\u0016\u0010:\u001a\u00020\u001f*\u00020;2\b\u0010<\u001a\u0004\u0018\u00010;H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/fir/AbstractFirDiagnosticsTest;", "Lorg/jetbrains/kotlin/fir/AbstractFirBaseDiagnosticsTest;", "()V", "pluginPhasesEnabled", "", "getPluginPhasesEnabled", "()Z", "checkCfg", "", "allFirFiles", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "testFiles", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;", "testDataFile", "Ljava/io/File;", "checkCfgDump", "firFiles", "checkCfgDumpNotExists", "checkCfgEdgeConsistency", "checkDiagnostics", "file", "checkFir", "collectDebugInfoDiagnostics", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnostic;", "firFile", "diagnosedRangesToDiagnosticNames", "", "Lkotlin/ranges/IntRange;", "", "", "collectDiagnostics", "", "createCallDiagnosticIfExpected", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/FirDiagnosticWithParameters1;", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "reference", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "createCollector", "Lorg/jetbrains/kotlin/fir/analysis/collectors/AbstractDiagnosticCollector;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "createExpressionTypeDiagnosticIfExpected", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getTypeOfCall", "resolvedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "runAnalysis", "firFilesPerSession", "createDebugInfoDiagnostic", "Lorg/jetbrains/kotlin/checkers/diagnostics/factories/DebugInfoDiagnosticFactory1;", "argument", "Lkotlin/Function0;", "fqNameUnsafe", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "renderAsString", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "originalTypeRef", "CfgConsistencyChecker", "Companion", "tests-common"})
public abstract class AbstractFirDiagnosticsTest
extends AbstractFirBaseDiagnosticsTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DUMP_CFG_DIRECTIVE = "DUMP_CFG";
    @NotNull
    public static final String COMMON_COROUTINES_DIRECTIVE = "COMMON_COROUTINES_TEST";
    @NotNull
    private static final Set<FirSourceElementKind> allowedKindsForDebugInfo;

    protected boolean getPluginPhasesEnabled() {
        return false;
    }

    @Override
    protected void runAnalysis(@NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> testFiles, @NotNull Map<FirSession, ? extends List<? extends FirFile>> firFilesPerSession) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        Intrinsics.checkNotNullParameter(firFilesPerSession, (String)"firFilesPerSession");
        Object object = firFilesPerSession;
        boolean bl = false;
        Iterator<Map.Entry<FirSession, ? extends List<? extends FirFile>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            FirSession session = (FirSession)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            List firFiles = (List)object3.getValue();
            FirResolveBenchKt.doFirResolveTestBench$default(firFiles, FirTotalResolveProcessorKt.createAllCompilerResolveProcessors$default((FirSession)session, null, (boolean)this.getPluginPhasesEnabled(), (int)2, null), false, false, false, 24, null);
        }
        List allFirFiles = CollectionsKt.flatten((Iterable)firFilesPerSession.values());
        this.checkDiagnostics(testDataFile, testFiles, allFirFiles);
        this.checkFir(testDataFile, allFirFiles);
        this.checkCfg(allFirFiles, testFiles, testDataFile);
    }

    protected final void checkCfg(@NotNull List<? extends FirFile> allFirFiles, @NotNull List<BaseDiagnosticsTest.TestFile> testFiles, @NotNull File testDataFile) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(allFirFiles, (String)"allFirFiles");
            Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            this.checkCfgEdgeConsistency(allFirFiles);
            Iterable $this$any$iv = testFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BaseDiagnosticsTest.TestFile it = (BaseDiagnosticsTest.TestFile)element$iv;
                    boolean bl2 = false;
                    if (!Companion.getWithDumpCfgDirective(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.checkCfgDump(testDataFile, allFirFiles);
        } else {
            this.checkCfgDumpNotExists(testDataFile);
        }
    }

    public final void checkFir(@NotNull File testDataFile, @NotNull List<? extends FirFile> firFiles) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
        CharSequence charSequence = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$checkFir_u24lambda_u2d2 = charSequence;
        boolean bl3 = false;
        Iterable $this$forEach$iv = firFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl4 = false;
            it.accept((FirVisitor)new FirRenderer($this$checkFir_u24lambda_u2d2, null, 2, null), null);
        }
        String string = charSequence.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply { firFiles.forEach { it.accept(FirRenderer(this), null) } }.toString()");
        String firFileDump = string;
        charSequence = testDataFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"testDataFile.absolutePath");
        String expectedPath = StringsKt.replace$default((String)charSequence, (String)".kt", (String)".txt", (boolean)false, (int)4, null);
        KotlinTestUtils.assertEqualsToFile(new File(expectedPath), firFileDump);
    }

    protected void checkDiagnostics(@NotNull File file, @NotNull List<BaseDiagnosticsTest.TestFile> testFiles, @NotNull List<? extends FirFile> firFiles) {
        boolean bl;
        String actualText;
        block8: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
            Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
            Map<FirFile, List<FirDiagnostic<?>>> diagnostics = this.collectDiagnostics(firFiles);
            StringBuilder actualTextBuilder = new StringBuilder();
            for (BaseDiagnosticsTest.TestFile testFile : testFiles) {
                Object v0;
                block7: {
                    Iterable $this$firstOrNull$iv = firFiles;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirFile it = (FirFile)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)FirSourceElementKt.getPsi((FirElement)((FirElement)it)), (Object)testFile.getKtFile())) continue;
                        v0 = element$iv;
                        break block7;
                    }
                    v0 = null;
                }
                FirFile firFile = v0;
                if (firFile != null) {
                    List<FirDiagnostic<?>> debugInfoDiagnostics = this.collectDebugInfoDiagnostics(firFile, testFile.getDiagnosedRangesToDiagnosticNames());
                    this.getActualText(testFile, CollectionsKt.plus((Collection)((Collection)MapsKt.getValue(diagnostics, (Object)firFile)), (Iterable)debugInfoDiagnostics), actualTextBuilder);
                    continue;
                }
                actualTextBuilder.append(testFile.getExpectedText());
            }
            String string = actualTextBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"actualTextBuilder.toString()");
            actualText = string;
            Iterable iterable = testFiles;
            boolean $i$f$any = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : iterable) {
                    BaseDiagnosticsTest.TestFile it = (BaseDiagnosticsTest.TestFile)element$iv;
                    boolean bl3 = false;
                    if (!Companion.getWithCommonCoroutinesDirective(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            actualText = StringsKt.replace$default((String)actualText, (String)this.coroutinesPackage, (String)"COROUTINES_PACKAGE", (boolean)false, (int)4, null);
        }
        KotlinTestUtils.assertEqualsToFile(file, actualText);
    }

    @NotNull
    protected final List<FirDiagnostic<?>> collectDebugInfoDiagnostics(@NotNull FirFile firFile, @NotNull Map<IntRange, Set<String>> diagnosedRangesToDiagnosticNames) {
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter(diagnosedRangesToDiagnosticNames, (String)"diagnosedRangesToDiagnosticNames");
        boolean bl = false;
        List result = new ArrayList();
        FirDefaultVisitorVoid firDefaultVisitorVoid = new FirDefaultVisitorVoid(result, this, diagnosedRangesToDiagnosticNames){
            final /* synthetic */ List<FirDiagnostic<?>> $result;
            final /* synthetic */ AbstractFirDiagnosticsTest this$0;
            final /* synthetic */ Map<IntRange, Set<String>> $diagnosedRangesToDiagnosticNames;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                this.$diagnosedRangesToDiagnosticNames = $diagnosedRangesToDiagnosticNames;
            }

            public void visitElement(@NotNull FirElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof FirExpression) {
                    org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)this.$result, this.this$0.createExpressionTypeDiagnosticIfExpected((FirExpression)element, this.$diagnosedRangesToDiagnosticNames));
                }
                element.acceptChildren((FirVisitorVoid)this);
            }

            public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
                Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
                org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)this.$result, (Object)AbstractFirDiagnosticsTest.access$createCallDiagnosticIfExpected(this.this$0, (FirElement)functionCall, functionCall.getCalleeReference(), this.$diagnosedRangesToDiagnosticNames));
                super.visitFunctionCall(functionCall);
            }
        };
        boolean bl2 = false;
        boolean bl3 = false;
        FirVisitorVoid p0 = (FirVisitorVoid)firDefaultVisitorVoid;
        boolean bl4 = false;
        firFile.accept(p0);
        return result;
    }

    @Nullable
    public final FirDiagnosticWithParameters1<FirSourceElement, String> createExpressionTypeDiagnosticIfExpected(@NotNull FirExpression element, @NotNull Map<IntRange, Set<String>> diagnosedRangesToDiagnosticNames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(diagnosedRangesToDiagnosticNames, (String)"diagnosedRangesToDiagnosticNames");
        return this.createDebugInfoDiagnostic(DebugInfoDiagnosticFactory1.Companion.getEXPRESSION_TYPE(), (FirElement)element, diagnosedRangesToDiagnosticNames, (Function0<String>)((Function0)new Function0<String>(this, element){
            final /* synthetic */ AbstractFirDiagnosticsTest this$0;
            final /* synthetic */ FirExpression $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(0);
            }

            @NotNull
            public final String invoke() {
                FirExpression firExpression = this.$element;
                FirExpressionWithSmartcast firExpressionWithSmartcast = firExpression instanceof FirExpressionWithSmartcast ? (FirExpressionWithSmartcast)firExpression : null;
                return AbstractFirDiagnosticsTest.access$renderAsString(this.this$0, this.$element.getTypeRef(), firExpressionWithSmartcast == null ? null : firExpressionWithSmartcast.getOriginalType());
            }
        }));
    }

    private final String renderAsString(FirTypeRef $this$renderAsString, FirTypeRef originalTypeRef) {
        String string;
        String string2;
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$coneTypeSafe$iv = $this$renderAsString;
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) == null) {
            return "Type is unknown";
        }
        ConeKotlinType type = coneKotlinType;
        String rendered = RenderingForDebugInfoKt.renderForDebugInfo(type);
        firResolvedTypeRef = originalTypeRef;
        if (firResolvedTypeRef == null) {
            string2 = null;
        } else {
            ConeKotlinType coneKotlinType3;
            FirResolvedTypeRef $this$coneTypeSafe$iv2 = firResolvedTypeRef;
            boolean $i$f$coneTypeSafe2 = false;
            boolean bl2 = false;
            FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv2 instanceof FirResolvedTypeRef ? $this$coneTypeSafe$iv2 : null;
            ConeKotlinType coneKotlinType4 = firResolvedTypeRef2 == null ? null : firResolvedTypeRef2.getType();
            if (!(coneKotlinType4 instanceof ConeKotlinType)) {
                coneKotlinType4 = null;
            }
            string2 = string = (coneKotlinType3 = coneKotlinType4) == null ? null : RenderingForDebugInfoKt.renderForDebugInfo(coneKotlinType3);
        }
        if (string == null) {
            return rendered;
        }
        String originalTypeRendered = string;
        return rendered + " & " + originalTypeRendered;
    }

    private final FirDiagnosticWithParameters1<FirSourceElement, String> createCallDiagnosticIfExpected(FirElement element, FirNamedReference reference, Map<IntRange, Set<String>> diagnosedRangesToDiagnosticNames) {
        return this.createDebugInfoDiagnostic(DebugInfoDiagnosticFactory1.Companion.getCALL(), element, diagnosedRangesToDiagnosticNames, (Function0<String>)((Function0)new Function0<String>(reference, this){
            final /* synthetic */ FirNamedReference $reference;
            final /* synthetic */ AbstractFirDiagnosticsTest this$0;
            {
                this.$reference = $reference;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                FirNamedReference firNamedReference = this.$reference;
                FirResolvedNamedReference firResolvedNamedReference = firNamedReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firNamedReference : null;
                AbstractFirBasedSymbol resolvedSymbol = firResolvedNamedReference == null ? null : firResolvedNamedReference.getResolvedSymbol();
                firNamedReference = resolvedSymbol;
                FqNameUnsafe fqName = firNamedReference == null ? null : AbstractFirDiagnosticsTest.access$fqNameUnsafe(this.this$0, (AbstractFirBasedSymbol)firNamedReference);
                return Renderers.INSTANCE.renderCallInfo(fqName, AbstractFirDiagnosticsTest.access$getTypeOfCall(this.this$0, this.$reference, resolvedSymbol));
            }
        }));
    }

    private final FirDiagnosticWithParameters1<FirSourceElement, String> createDebugInfoDiagnostic(DebugInfoDiagnosticFactory1 $this$createDebugInfoDiagnostic, FirElement element, Map<IntRange, Set<String>> diagnosedRangesToDiagnosticNames, Function0<String> argument) {
        FirDiagnosticWithParameters1 firDiagnosticWithParameters1;
        FirSourceElement firSourceElement = element.getSource();
        if (firSourceElement == null) {
            return null;
        }
        FirSourceElement sourceElement = firSourceElement;
        FirSourceElementKind sourceKind = sourceElement.getKind();
        if (!(allowedKindsForDebugInfo.contains(sourceKind) || Intrinsics.areEqual((Object)sourceKind, (Object)FirFakeSourceElementKind.ImplicitReturn.INSTANCE) && Intrinsics.areEqual((Object)sourceElement.getElementType(), (Object)KtNodeTypes.RETURN))) {
            return null;
        }
        if (Intrinsics.areEqual((Object)sourceElement.getElementType(), (Object)KtNodeTypes.LAMBDA_ARGUMENT) || Intrinsics.areEqual((Object)sourceElement.getElementType(), (Object)KtNodeTypes.BLOCK)) {
            return null;
        }
        Set<String> set = $this$createDebugInfoDiagnostic.getName();
        if (set == null) {
            return null;
        }
        String name = set;
        set = diagnosedRangesToDiagnosticNames.get(new IntRange(sourceElement.getStartOffset(), sourceElement.getEndOffset()));
        if (!Intrinsics.areEqual((Object)(set == null ? null : Boolean.valueOf(set.contains(name))), (Object)true)) {
            return null;
        }
        String argumentText = (String)argument.invoke();
        FirSourceElement firSourceElement2 = sourceElement;
        if (firSourceElement2 instanceof FirPsiSourceElement) {
            firDiagnosticWithParameters1 = (FirDiagnosticWithParameters1)new FirPsiDiagnosticWithParameters1((FirPsiSourceElement)sourceElement, (Object)argumentText, $this$createDebugInfoDiagnostic.getSeverity(), new FirDiagnosticFactory1(name, $this$createDebugInfoDiagnostic.getSeverity(), null, 4, null));
        } else if (firSourceElement2 instanceof FirLightSourceElement) {
            firDiagnosticWithParameters1 = (FirDiagnosticWithParameters1)new FirLightDiagnosticWithParameters1((FirLightSourceElement)sourceElement, (Object)argumentText, $this$createDebugInfoDiagnostic.getSeverity(), new FirDiagnosticFactory1(name, $this$createDebugInfoDiagnostic.getSeverity(), null, 4, null));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firDiagnosticWithParameters1;
    }

    private final FqNameUnsafe fqNameUnsafe(AbstractFirBasedSymbol<?> $this$fqNameUnsafe) {
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = $this$fqNameUnsafe;
        return abstractFirBasedSymbol instanceof FirClassLikeSymbol ? ((FirClassLikeSymbol)$this$fqNameUnsafe).getClassId().asSingleFqName().toUnsafe() : (abstractFirBasedSymbol instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$fqNameUnsafe).getCallableId().asFqNameForDebugInfo().toUnsafe() : null);
    }

    private final String getTypeOfCall(FirNamedReference reference, AbstractFirBasedSymbol<?> resolvedSymbol) {
        String string;
        CallableId callableId;
        FirFunctionSymbol firFunctionSymbol;
        if (resolvedSymbol == null) {
            return TypeOfCall.UNRESOLVED.getNameToRender();
        }
        FirFunctionSymbol firFunctionSymbol2 = firFunctionSymbol = resolvedSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)resolvedSymbol : null;
        if (Intrinsics.areEqual(firFunctionSymbol == null ? null : ((callableId = firFunctionSymbol.getCallableId()) == null ? null : callableId.getCallableName()), (Object)OperatorNameConventions.INVOKE) && !Intrinsics.areEqual((Object)reference.getName(), (Object)OperatorNameConventions.INVOKE)) {
            return TypeOfCall.VARIABLE_THROUGH_INVOKE.getNameToRender();
        }
        FirSymbolOwner fir = resolvedSymbol.getFir();
        if (fir instanceof FirProperty) {
            string = TypeOfCall.PROPERTY_GETTER.getNameToRender();
        } else if (fir instanceof FirFunction) {
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$getTypeOfCall_u24lambda_u2d5 = stringBuilder;
            boolean bl5 = false;
            if (fir instanceof FirCallableMemberDeclaration) {
                if (((FirCallableMemberDeclaration)fir).getStatus().isInline()) {
                    $this$getTypeOfCall_u24lambda_u2d5.append("inline ");
                }
                if (((FirCallableMemberDeclaration)fir).getStatus().isInfix()) {
                    $this$getTypeOfCall_u24lambda_u2d5.append("infix ");
                }
                if (((FirCallableMemberDeclaration)fir).getStatus().isOperator()) {
                    $this$getTypeOfCall_u24lambda_u2d5.append("operator ");
                }
                if (((FirFunction)fir).getReceiverTypeRef() != null) {
                    $this$getTypeOfCall_u24lambda_u2d5.append("extension ");
                }
            }
            $this$getTypeOfCall_u24lambda_u2d5.append(TypeOfCall.FUNCTION.getNameToRender());
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string = TypeOfCall.OTHER.getNameToRender();
        }
        return string;
    }

    @NotNull
    protected final Map<FirFile, List<FirDiagnostic<?>>> collectDiagnostics(@NotNull List<? extends FirFile> firFiles) {
        Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
        boolean bl = false;
        Map collectors = new LinkedHashMap();
        boolean bl2 = false;
        Map result = new LinkedHashMap();
        for (FirFile firFile : firFiles) {
            FirSession session = firFile.getSession();
            Object object = collectors.computeIfAbsent(session, (Function)new Function<FirSession, AbstractDiagnosticCollector>(this, session){
                final /* synthetic */ AbstractFirDiagnosticsTest this$0;
                final /* synthetic */ FirSession $session;
                {
                    this.this$0 = $receiver;
                    this.$session = $session;
                }

                @NotNull
                public final AbstractDiagnosticCollector apply(@NotNull FirSession it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return AbstractFirDiagnosticsTest.access$createCollector(this.this$0, this.$session);
                }
            });
            Intrinsics.checkNotNullExpressionValue(object, (String)"protected fun collectDiagnostics(firFiles: List<FirFile>): Map<FirFile, List<FirDiagnostic<*>>> {\n        val collectors = mutableMapOf<FirSession, AbstractDiagnosticCollector>()\n        val result = mutableMapOf<FirFile, List<FirDiagnostic<*>>>()\n        for (firFile in firFiles) {\n            val session = firFile.session\n            val collector = collectors.computeIfAbsent(session) { createCollector(session) }\n            result[firFile] = collector.collectDiagnostics(firFile).toList()\n        }\n        return result\n    }");
            AbstractDiagnosticCollector collector2 = (AbstractDiagnosticCollector)object;
            object = result;
            List list = CollectionsKt.toList((Iterable)collector2.collectDiagnostics(firFile));
            boolean bl3 = false;
            object.put((FirFile)firFile, (List)list);
        }
        return result;
    }

    private final AbstractDiagnosticCollector createCollector(FirSession session) {
        return (AbstractDiagnosticCollector)FirDiagnosticsCollector.INSTANCE.create(session);
    }

    private final void checkCfgDump(File testDataFile, List<? extends FirFile> firFiles) {
        StringBuilder builder = new StringBuilder();
        ((FirFile)CollectionsKt.first(firFiles)).accept((FirVisitor)new FirControlFlowGraphRenderVisitor(builder), null);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        String dotCfgDump = string;
        KotlinTestUtils.assertEqualsToFile(Companion.getCfgDumpFile(testDataFile), dotCfgDump);
    }

    private final void checkCfgEdgeConsistency(List<? extends FirFile> firFiles) {
        Iterable $this$forEach$iv = firFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            it.accept((FirVisitorVoid)CfgConsistencyChecker.INSTANCE);
        }
    }

    private final void checkCfgDumpNotExists(File testDataFile) {
        File cfgDumpFile = Companion.getCfgDumpFile(testDataFile);
        if (cfgDumpFile.exists()) {
            String message = StringsKt.trimIndent((String)("\n                Directive `!DUMP_CFG` is missing, but file with cfg dump is present.\n                Please remove " + cfgDumpFile.getPath() + " or add `!DUMP_CFG` to test\n            "));
            AssertionsKt.fail((String)message);
            throw null;
        }
    }

    public static final /* synthetic */ FirDiagnosticWithParameters1 access$createCallDiagnosticIfExpected(AbstractFirDiagnosticsTest $this, FirElement element, FirNamedReference reference, Map diagnosedRangesToDiagnosticNames) {
        return $this.createCallDiagnosticIfExpected(element, reference, diagnosedRangesToDiagnosticNames);
    }

    public static final /* synthetic */ String access$renderAsString(AbstractFirDiagnosticsTest $this, FirTypeRef $receiver, FirTypeRef originalTypeRef) {
        return $this.renderAsString($receiver, originalTypeRef);
    }

    public static final /* synthetic */ FqNameUnsafe access$fqNameUnsafe(AbstractFirDiagnosticsTest $this, AbstractFirBasedSymbol $receiver) {
        return $this.fqNameUnsafe($receiver);
    }

    public static final /* synthetic */ String access$getTypeOfCall(AbstractFirDiagnosticsTest $this, FirNamedReference reference, AbstractFirBasedSymbol resolvedSymbol) {
        return $this.getTypeOfCall(reference, resolvedSymbol);
    }

    public static final /* synthetic */ AbstractDiagnosticCollector access$createCollector(AbstractFirDiagnosticsTest $this, FirSession session) {
        return $this.createCollector(session);
    }

    static {
        Object[] objectArray = new FirSourceElementKind[]{(FirSourceElementKind)FirRealSourceElementKind.INSTANCE, (FirSourceElementKind)FirFakeSourceElementKind.DesugaredCompoundAssignment.INSTANCE};
        allowedKindsForDebugInfo = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\u00020\n*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00020\u000e*\u00060\u000fR\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\u00020\u000e*\u00060\u000fR\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/AbstractFirDiagnosticsTest$Companion;", "", "()V", "COMMON_COROUTINES_DIRECTIVE", "", "DUMP_CFG_DIRECTIVE", "allowedKindsForDebugInfo", "", "Lorg/jetbrains/kotlin/fir/FirSourceElementKind;", "cfgDumpFile", "Ljava/io/File;", "getCfgDumpFile", "(Ljava/io/File;)Ljava/io/File;", "withCommonCoroutinesDirective", "", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;", "getWithCommonCoroutinesDirective", "(Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;)Z", "withDumpCfgDirective", "getWithDumpCfgDirective", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getWithDumpCfgDirective(@NotNull BaseDiagnosticsTest.TestFile $this$withDumpCfgDirective) {
            Intrinsics.checkNotNullParameter((Object)$this$withDumpCfgDirective, (String)"<this>");
            return $this$withDumpCfgDirective.directives.contains(AbstractFirDiagnosticsTest.DUMP_CFG_DIRECTIVE);
        }

        public final boolean getWithCommonCoroutinesDirective(@NotNull BaseDiagnosticsTest.TestFile $this$withCommonCoroutinesDirective) {
            Intrinsics.checkNotNullParameter((Object)$this$withCommonCoroutinesDirective, (String)"<this>");
            return $this$withCommonCoroutinesDirective.directives.contains(AbstractFirDiagnosticsTest.COMMON_COROUTINES_DIRECTIVE);
        }

        @NotNull
        public final File getCfgDumpFile(@NotNull File $this$cfgDumpFile) {
            Intrinsics.checkNotNullParameter((Object)$this$cfgDumpFile, (String)"<this>");
            String string = $this$cfgDumpFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"absolutePath");
            return new File(StringsKt.replace$default((String)string, (String)".kt", (String)".dot", (boolean)false, (int)4, null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/AbstractFirDiagnosticsTest$CfgConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "()V", "cfgKinds", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeKind;", "checkConsistency", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "checkEdge", "from", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "to", "checkOrder", "visitControlFlowGraphReference", "controlFlowGraphReference", "Lorg/jetbrains/kotlin/fir/references/FirControlFlowGraphReference;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "tests-common"})
    private static final class CfgConsistencyChecker
    extends FirVisitorVoid {
        @NotNull
        public static final CfgConsistencyChecker INSTANCE = new CfgConsistencyChecker();
        @NotNull
        private static final List<EdgeKind> cfgKinds;

        private CfgConsistencyChecker() {
        }

        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren((FirVisitorVoid)this);
        }

        public void visitControlFlowGraphReference(@NotNull FirControlFlowGraphReference controlFlowGraphReference) {
            ControlFlowGraph controlFlowGraph;
            Intrinsics.checkNotNullParameter((Object)controlFlowGraphReference, (String)"controlFlowGraphReference");
            FirControlFlowGraphReferenceImpl firControlFlowGraphReferenceImpl = controlFlowGraphReference instanceof FirControlFlowGraphReferenceImpl ? (FirControlFlowGraphReferenceImpl)controlFlowGraphReference : null;
            ControlFlowGraph controlFlowGraph2 = controlFlowGraph = firControlFlowGraphReferenceImpl == null ? null : firControlFlowGraphReferenceImpl.getControlFlowGraph();
            if (controlFlowGraph == null) {
                return;
            }
            ControlFlowGraph graph = controlFlowGraph;
            KtUsefulTestCase.assertEquals((Object)ControlFlowGraph.State.Completed, (Object)graph.getState());
            this.checkConsistency(graph);
            this.checkOrder(graph);
        }

        private final void checkConsistency(ControlFlowGraph graph) {
            for (CFGNode node : graph.getNodes()) {
                for (CFGNode to : node.getFollowingNodes()) {
                    this.checkEdge(node, to);
                }
                for (CFGNode from : node.getPreviousNodes()) {
                    this.checkEdge(from, node);
                }
                if (node.getFollowingNodes().isEmpty() && node.getPreviousNodes().isEmpty()) {
                    throw new AssertionError((Object)Intrinsics.stringPlus((String)"Unconnected CFG node: ", (Object)node));
                }
            }
        }

        private final void checkEdge(CFGNode<?> from, CFGNode<?> to) {
            CFGNode[] cFGNodeArray = new CFGNode[]{to};
            KtUsefulTestCase.assertContainsElements((Collection)from.getFollowingNodes(), cFGNodeArray);
            cFGNodeArray = new CFGNode[]{from};
            KtUsefulTestCase.assertContainsElements((Collection)to.getPreviousNodes(), cFGNodeArray);
            EdgeKind fromKind = ((Edge)MapsKt.getValue((Map)from.getOutgoingEdges(), to)).getKind();
            EdgeKind toKind = ((Edge)MapsKt.getValue((Map)to.getIncomingEdges(), from)).getKind();
            TestCase.assertEquals((Object)fromKind, (Object)toKind);
            if (from.isDead() && to.isDead()) {
                EdgeKind[] edgeKindArray = new EdgeKind[]{toKind};
                KtUsefulTestCase.assertContainsElements((Collection)cfgKinds, edgeKindArray);
            }
        }

        private final void checkOrder(ControlFlowGraph graph) {
            boolean bl = false;
            Set visited = new LinkedHashSet();
            for (CFGNode node : graph.getNodes()) {
                for (CFGNode previousNode : node.getPreviousNodes()) {
                    if (!Intrinsics.areEqual((Object)previousNode.getOwner(), (Object)graph) || ((Edge)MapsKt.getValue((Map)node.getIncomingEdges(), (Object)previousNode)).getKind().isBack()) continue;
                    KtUsefulTestCase.assertTrue((boolean)visited.contains(previousNode));
                }
                Collection collection = visited;
                boolean bl2 = false;
                collection.add(node);
            }
        }

        static {
            Object[] objectArray = new EdgeKind[]{EdgeKind.DeadForward, EdgeKind.CfgForward, EdgeKind.DeadBackward, EdgeKind.CfgBackward};
            cfgKinds = CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

