/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.command.dexer.Main;
import com.android.dx.dex.DexOptions;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.cf.CfTranslator;
import com.android.dx.dex.file.DexFile;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.junit.Assert;

public class DxChecker {
    public static final boolean RUN_DX_CHECKER = true;
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("[\\s]+at .*");

    private DxChecker() {
    }

    public static void check(ClassFileFactory outputFiles) {
        Main.Arguments arguments = new Main.Arguments();
        String[] array = new String[]{"testArgs"};
        arguments.parse(array);
        for (OutputFile file : ClassFileUtilsKt.getClassFiles((ClassFileFactory)outputFiles)) {
            try {
                byte[] bytes = file.asByteArray();
                if (!DxChecker.isJava6Class(bytes)) continue;
                DxChecker.checkFileWithDx(bytes, file.getRelativePath(), arguments);
            }
            catch (Throwable e) {
                Assert.fail((String)DxChecker.generateExceptionMessage(e));
            }
        }
    }

    private static boolean isJava6Class(byte[] bytes) throws IOException {
        try (DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));){
            int header = stream.readInt();
            if (-889275714 != header) {
                throw new IOException("Invalid header class header: " + header);
            }
            int minor = stream.readUnsignedShort();
            int major = stream.readUnsignedShort();
            boolean bl = major == 50;
            return bl;
        }
    }

    public static void checkFileWithDx(byte[] bytes, @NotNull String relativePath) {
        if (relativePath == null) {
            DxChecker.$$$reportNull$$$0(0);
        }
        Main.Arguments arguments = new Main.Arguments();
        String[] array = new String[]{"testArgs"};
        arguments.parse(array);
        DxChecker.checkFileWithDx(bytes, relativePath, arguments);
    }

    private static void checkFileWithDx(byte[] bytes, @NotNull String relativePath, @NotNull Main.Arguments arguments) {
        if (relativePath == null) {
            DxChecker.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            DxChecker.$$$reportNull$$$0(2);
        }
        DirectClassFile cf = new DirectClassFile(bytes, relativePath, true);
        cf.setAttributeFactory((AttributeFactory)StdAttributeFactory.THE_ONE);
        CfTranslator.translate((DirectClassFile)cf, (byte[])bytes, (CfOptions)arguments.cfOptions, (DexOptions)arguments.dexOptions, (DexFile)new DexFile(arguments.dexOptions));
    }

    private static String generateExceptionMessage(Throwable e) {
        StringWriter writer = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(writer);){
            e.printStackTrace(printWriter);
            String stackTrace = writer.toString();
            Matcher matcher = STACK_TRACE_PATTERN.matcher(stackTrace);
            String string = matcher.replaceAll("");
            return string;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "relativePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "arguments";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/codegen/DxChecker";
        objectArray[2] = "checkFileWithDx";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

