/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ExceptionType;
import org.jetbrains.kotlin.TestExceptionsComparator;
import org.jetbrains.kotlin.TestsCompilerError;
import org.jetbrains.kotlin.TestsCompiletimeError;
import org.jetbrains.kotlin.TestsError;
import org.jetbrains.kotlin.TestsExceptionType;
import org.jetbrains.kotlin.TestsInfrastructureError;
import org.jetbrains.kotlin.TestsRuntimeError;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.junit.Assert;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015JT\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u0018\u00010\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015J\u0012\u0010\u0019\u001a\u00020\u00112\b\u0010\t\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/TestExceptionsComparator;", "", "wholeFile", "Ljava/io/File;", "(Ljava/io/File;)V", "filePathPrefix", "", "analyze", "Ljava/util/regex/Matcher;", "e", "", "getExceptionInfo", "Lorg/jetbrains/kotlin/TestsError;", "exceptionByCases", "", "", "run", "", "expectedException", "Lorg/jetbrains/kotlin/TestsExceptionType;", "runnable", "Lkotlin/Function0;", "", "computeExceptionPoint", "Lkotlin/Function1;", "validateExistingExceptionFiles", "Companion", "tests-common"})
public final class TestExceptionsComparator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String filePathPrefix;
    @NotNull
    private static final String EXCEPTIONS_FILE_PREFIX = "exceptions";
    @NotNull
    private static final Map<ExceptionType, Pattern> exceptionMessagePatterns = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)ExceptionType.ANALYZING_EXPRESSION), (Object)Pattern.compile("Exception while analyzing expression at \\((?<lineNumber>\\d+),(?<symbolNumber>\\d+)\\) in /(?<filename>.*?)$")));
    private static final String ls = System.lineSeparator();
    @NotNull
    private static final String BYTECODE_ADDRESS = "\\d{7}";
    @NotNull
    private static final Regex bytecodeAddressRegex = new Regex("\\d{7}");
    @NotNull
    private static final Regex bytecodeAddressListRegex = new Regex("Bytecode:\\s+(\\d{7}:\\s*([0-9a-f]{4}\\s+)+\\s+)+");

    public TestExceptionsComparator(@NotNull File wholeFile) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        this.filePathPrefix = wholeFile.getParent() + '/' + FilesKt.getNameWithoutExtension((File)wholeFile) + ".exceptions";
    }

    private final Matcher analyze(Throwable e) {
        Object object = exceptionMessagePatterns;
        boolean bl = false;
        Iterator<Map.Entry<ExceptionType, Pattern>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Pattern pattern;
            Matcher matches;
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String string = e.getMessage();
            if (string == null || !(matches = (pattern = (Pattern)object2.getValue()).matcher(string)).find()) continue;
            return matches;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String getExceptionInfo(TestsError e, Set<Integer> exceptionByCases) {
        String string;
        Object object;
        boolean bl;
        Object object2;
        Set<Integer> set = exceptionByCases;
        if (set == null) {
            object2 = "";
        } else {
            Set<Integer> set2 = set;
            bl = false;
            boolean bl2 = false;
            Set<Integer> $this$getExceptionInfo_u24lambda_u2d0 = set2;
            boolean bl3 = false;
            object = "CASES: " + CollectionsKt.joinToString$default((Iterable)$this$getExceptionInfo_u24lambda_u2d0, null, null, null, (int)0, null, null, (int)63, null) + ls;
            object2 = object == null ? "" : object;
        }
        String casesAsString = object2;
        set = e;
        if (set instanceof TestsRuntimeError) {
            String string2;
            object = e.getOriginal().getCause();
            object = object == null ? e.getOriginal() : object;
            boolean bl4 = false;
            bl = false;
            Throwable $this$getExceptionInfo_u24lambda_u2d2 = object;
            boolean bl5 = false;
            StringBuilder stringBuilder = new StringBuilder().append(casesAsString).append($this$getExceptionInfo_u24lambda_u2d2);
            StackTraceElement stackTraceElement = $this$getExceptionInfo_u24lambda_u2d2.getStackTrace()[0];
            if (stackTraceElement == null) {
                string2 = null;
            } else {
                void it;
                StackTraceElement stackTraceElement2 = stackTraceElement;
                boolean bl6 = false;
                boolean bl7 = false;
                StackTraceElement stackTraceElement3 = stackTraceElement2;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl8 = false;
                String string3 = Intrinsics.stringPlus((String)ls, (Object)it);
                stringBuilder = stringBuilder2;
                string2 = string3;
            }
            String exceptionText = stringBuilder.append((Object)string2).toString();
            string = TestExceptionsComparator.Companion.unifyPlatformDependentOfException(exceptionText);
        } else if ((set instanceof TestsCompilerError ? true : set instanceof TestsCompiletimeError) ? true : set instanceof TestsInfrastructureError) {
            object = e.getOriginal().getCause();
            string = Intrinsics.stringPlus((String)casesAsString, (Object)(object == null ? e.getOriginal() : object));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExistingExceptionFiles(TestsError e) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ArraysKt.toMutableSet((Object[])TestsExceptionType.values());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestsExceptionType it = (TestsExceptionType)((Object)element$iv$iv);
            boolean bl = false;
            TestsError testsError = e;
            if (!(it != (testsError == null ? null : testsError.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List postfixesOfFilesToCheck = (List)destination$iv$iv;
        Iterable $this$forEach$iv = postfixesOfFilesToCheck;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TestsExceptionType it = (TestsExceptionType)((Object)element$iv);
            boolean bl = false;
            if (!new File(this.filePathPrefix + '.' + it.getPostfix() + ".txt").exists()) continue;
            Assert.fail((String)("No " + (Object)((Object)it) + ", but file " + this.filePathPrefix + '.' + it.getPostfix() + ".txt exists."));
        }
    }

    public final void run(@Nullable TestsExceptionType expectedException, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean bl = false;
        this.run(expectedException, MapsKt.emptyMap(), null, runnable);
    }

    /*
     * WARNING - void declaration
     */
    public final void run(@Nullable TestsExceptionType expectedException, @NotNull Map<Integer, ? extends TestsExceptionType> exceptionByCases, @Nullable Function1<? super Matcher, ? extends Set<Integer>> computeExceptionPoint, @NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(exceptionByCases, (String)"exceptionByCases");
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        try {
            runnable.invoke();
        }
        catch (TestsError e) {
            Set casesWithExpectedException;
            Set set;
            Set set2;
            Matcher analyzeResult = this.analyze(e.getOriginal());
            Object object = computeExceptionPoint;
            Set set3 = set2 = object == null ? null : (Set)object.invoke((Object)analyzeResult);
            if (set2 == null) {
                set = null;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = set2;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    int it = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(exceptionByCases.get(it) == e.getType())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = (List)destination$iv$iv;
                set = casesWithExpectedException = CollectionsKt.toSet((Iterable)((Iterable)object));
            }
            if (casesWithExpectedException == null && e.getType() != expectedException) {
                throw e;
            }
            File exceptionsFile = new File(this.filePathPrefix + '.' + e.getType().getPostfix() + ".txt");
            try {
                KotlinTestUtils.assertEqualsToFile(exceptionsFile, this.getExceptionInfo(e, casesWithExpectedException));
            }
            catch (AssertionError t) {
                e.getOriginal().printStackTrace();
                throw t;
            }
            e.getOriginal().printStackTrace();
            this.validateExistingExceptionFiles(e);
            return;
        }
        this.validateExistingExceptionFiles(null);
    }

    public static final /* synthetic */ Regex access$getBytecodeAddressRegex$cp() {
        return bytecodeAddressRegex;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/TestExceptionsComparator$Companion;", "", "()V", "BYTECODE_ADDRESS", "", "EXCEPTIONS_FILE_PREFIX", "bytecodeAddressListRegex", "Lkotlin/text/Regex;", "bytecodeAddressRegex", "exceptionMessagePatterns", "", "Lorg/jetbrains/kotlin/ExceptionType;", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ls", "unifyPlatformDependentOfException", "exceptionText", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        private final String unifyPlatformDependentOfException(String exceptionText) {
            CharSequence charSequence = exceptionText;
            Regex regex = bytecodeAddressListRegex;
            Function1 function1 = unifyPlatformDependentOfException.1.INSTANCE;
            boolean bl = false;
            return regex.replace(charSequence, function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

