/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import junit.framework.TestCase;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettings;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.jvm.compiler.LoadDescriptorUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.MuteWithDatabaseKt;
import org.jetbrains.kotlin.test.MuteWithFileKt;
import org.jetbrains.kotlin.test.RunnableWithThrowable;
import org.jetbrains.kotlin.test.TagsTestDataUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestFiles;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.WithMutedInDatabaseRunTest;
import org.jetbrains.kotlin.test.util.JetTestUtilsKt;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.junit.Assert;

public class KotlinTestUtils {
    public static String TEST_MODULE_NAME = "test-module";
    public static final String TEST_GENERATOR_NAME = "org.jetbrains.kotlin.generators.tests.TestsPackage";
    private static final String PLEASE_REGENERATE_TESTS = "Please regenerate tests (GenerateTests.kt)";
    private static final boolean RUN_IGNORED_TESTS_AS_REGULAR = Boolean.getBoolean("org.jetbrains.kotlin.run.ignored.tests.as.regular");
    private static final boolean PRINT_STACKTRACE_FOR_IGNORED_TESTS = Boolean.getBoolean("org.jetbrains.kotlin.print.stacktrace.for.ignored.tests");
    private static final boolean DONT_IGNORE_TESTS_WORKING_ON_COMPATIBLE_BACKEND = Boolean.getBoolean("org.jetbrains.kotlin.dont.ignore.tests.working.on.compatible.backend");
    private static final boolean AUTOMATICALLY_UNMUTE_PASSED_TESTS = false;
    private static final boolean AUTOMATICALLY_MUTE_FAILED_TESTS = false;
    private static final List<File> filesToDelete = new ArrayList<File>();
    private static final Pattern DIRECTIVE_PATTERN = Pattern.compile("^//\\s*[!]?([A-Z_]+)(:[ \\t]*(.*))?$", 8);
    private static String homeDir = KotlinTestUtils.computeHomeDirectory();

    private KotlinTestUtils() {
    }

    @NotNull
    public static AnalysisResult analyzeFile(@NotNull KtFile file, @NotNull KotlinCoreEnvironment environment) {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            KotlinTestUtils.$$$reportNull$$$0(1);
        }
        AnalysisResult analysisResult = JvmResolveUtil.analyze(file, environment);
        if (analysisResult == null) {
            KotlinTestUtils.$$$reportNull$$$0(2);
        }
        return analysisResult;
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithMockJdkAndIdeaAnnotations(Disposable disposable) {
        return KotlinTestUtils.createEnvironmentWithMockJdkAndIdeaAnnotations(disposable, ConfigurationKind.ALL);
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithMockJdkAndIdeaAnnotations(Disposable disposable, @NotNull ConfigurationKind configurationKind) {
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(3);
        }
        return KotlinTestUtils.createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea(disposable, configurationKind, TestJdkKind.MOCK_JDK);
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea(@NotNull Disposable disposable, @NotNull ConfigurationKind configurationKind, @NotNull TestJdkKind jdkKind) {
        if (disposable == null) {
            KotlinTestUtils.$$$reportNull$$$0(4);
        }
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(5);
        }
        if (jdkKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(6);
        }
        KotlinCoreEnvironment kotlinCoreEnvironment = KotlinCoreEnvironment.createForTests((Disposable)disposable, (CompilerConfiguration)KotlinTestUtils.newConfiguration(configurationKind, jdkKind, KotlinTestUtils.getAnnotationsJar()), (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        if (kotlinCoreEnvironment == null) {
            KotlinTestUtils.$$$reportNull$$$0(7);
        }
        return kotlinCoreEnvironment;
    }

    @NotNull
    public static KotlinCoreEnvironment createEnvironmentWithFullJdkAndIdeaAnnotations(Disposable disposable) {
        return KotlinTestUtils.createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea(disposable, ConfigurationKind.ALL, TestJdkKind.FULL_JDK);
    }

    @NotNull
    public static String getTestDataPathBase() {
        String string = KotlinTestUtils.getHomeDirectory() + "/compiler/testData";
        if (string == null) {
            KotlinTestUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getHomeDirectory() {
        String string = homeDir;
        if (string == null) {
            KotlinTestUtils.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String computeHomeDirectory() {
        String userDir = System.getProperty("user.dir");
        File dir = new File(userDir == null ? "." : userDir);
        String string = FileUtil.toCanonicalPath((String)dir.getAbsolutePath());
        if (string == null) {
            KotlinTestUtils.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static File findMockJdkRtJar() {
        return new File(KotlinTestUtils.getHomeDirectory(), "compiler/testData/mockJDK/jre/lib/rt.jar");
    }

    public static File findMockJdkRtModified() {
        return new File(KotlinTestUtils.getHomeDirectory(), "compiler/testData/mockJDKModified/rt.jar");
    }

    public static File findAndroidApiJar() {
        File androidJarFile;
        String androidJarProp = System.getProperty("android.jar");
        File file = androidJarFile = androidJarProp == null ? null : new File(androidJarProp);
        if (androidJarFile == null || !androidJarFile.isFile()) {
            throw new RuntimeException("Unable to get a valid path from 'android.jar' property (" + androidJarProp + "), please point it to the 'android.jar' file location");
        }
        return androidJarFile;
    }

    @NotNull
    public static File findAndroidSdk() {
        File androidSdkDir;
        String androidSdkProp = System.getProperty("android.sdk");
        File file = androidSdkDir = androidSdkProp == null ? null : new File(androidSdkProp);
        if (androidSdkDir == null || !androidSdkDir.isDirectory()) {
            throw new RuntimeException("Unable to get a valid path from 'android.sdk' property (" + androidSdkProp + "), please point it to the android SDK location");
        }
        File file2 = androidSdkDir;
        if (file2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(11);
        }
        return file2;
    }

    public static String getAndroidSdkSystemIndependentPath() {
        return PathUtil.toSystemIndependentName((String)KotlinTestUtils.findAndroidSdk().getAbsolutePath());
    }

    public static File getAnnotationsJar() {
        return new File(KotlinTestUtils.getHomeDirectory(), "compiler/testData/mockJDK/jre/lib/annotations.jar");
    }

    public static void mkdirs(@NotNull File file) {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(12);
        }
        if (file.isDirectory()) {
            return;
        }
        if (!file.mkdirs()) {
            if (file.exists()) {
                throw new IllegalStateException("Failed to create " + file + ": file exists and not a directory");
            }
            throw new IllegalStateException("Failed to create " + file);
        }
    }

    @NotNull
    public static File tmpDirForTest(@NotNull String testClassName, @NotNull String testName) throws IOException {
        if (testClassName == null) {
            KotlinTestUtils.$$$reportNull$$$0(13);
        }
        if (testName == null) {
            KotlinTestUtils.$$$reportNull$$$0(14);
        }
        File file = KotlinTestUtils.normalizeFile(FileUtil.createTempDirectory((String)testClassName, (String)testName, (boolean)false));
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(15);
        }
        return file;
    }

    @NotNull
    public static File tmpDirForTest(TestCase test2) throws IOException {
        return KotlinTestUtils.tmpDirForTest(test2.getClass().getSimpleName(), test2.getName());
    }

    @NotNull
    public static File tmpDir(String name) throws IOException {
        File file = KotlinTestUtils.normalizeFile(FileUtil.createTempDirectory((String)name, (String)"", (boolean)false));
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public static File tmpDirForReusableFolder(String name) throws IOException {
        File file = KotlinTestUtils.normalizeFile(FileUtil.createTempDirectory((File)new File(System.getProperty("java.io.tmpdir")), (String)name, (String)"", (boolean)true));
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(17);
        }
        return file;
    }

    private static File normalizeFile(File file) throws IOException {
        return file.getCanonicalFile();
    }

    private static void deleteOnShutdown(File file) {
        if (filesToDelete.isEmpty()) {
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                for (File victim : filesToDelete) {
                    FileUtil.delete((File)victim);
                }
            });
        }
        filesToDelete.add(file);
    }

    @NotNull
    public static KtFile createFile(@NotNull @NonNls String name, @NotNull String text, @NotNull Project project) {
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(18);
        }
        if (text == null) {
            KotlinTestUtils.$$$reportNull$$$0(19);
        }
        if (project == null) {
            KotlinTestUtils.$$$reportNull$$$0(20);
        }
        String shortName = name.substring(name.lastIndexOf(47) + 1);
        shortName = shortName.substring(shortName.lastIndexOf(92) + 1);
        LightVirtualFile virtualFile = new LightVirtualFile(shortName, (Language)KotlinLanguage.INSTANCE, (CharSequence)StringUtilRt.convertLineSeparators((String)text));
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiFileFactoryImpl factory = (PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project);
        KtFile ktFile = (KtFile)factory.trySetupPsiForFile(virtualFile, (Language)KotlinLanguage.INSTANCE, true, false);
        if (ktFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(21);
        }
        return ktFile;
    }

    public static String doLoadFile(String myFullDataPath, String name) throws IOException {
        String fullName = myFullDataPath + File.separatorChar + name;
        return KotlinTestUtils.doLoadFile(new File(fullName));
    }

    public static String doLoadFile(@NotNull File file) throws IOException {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(22);
        }
        try {
            return FileUtil.loadFile((File)file, (String)"UTF-8", (boolean)true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String messageWithFullPath = file.getAbsolutePath() + " (No such file or directory)";
            throw new IOException("Ensure you have your 'Working Directory' configured correctly as the root Kotlin project directory in your test configuration\n\t" + messageWithFullPath, fileNotFoundException);
        }
    }

    public static String getFilePath(File file) {
        return FileUtil.toSystemIndependentName((String)file.getPath());
    }

    @NotNull
    public static CompilerConfiguration newConfiguration() {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)TEST_MODULE_NAME);
        if ("true".equals(System.getProperty("kotlin.ni"))) {
            CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration, (LanguageVersionSettings)new CompilerTestLanguageVersionSettings(Collections.emptyMap(), LanguageVersionSettingsImpl.DEFAULT.getApiVersion(), LanguageVersionSettingsImpl.DEFAULT.getLanguageVersion(), Collections.emptyMap()));
        }
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)new MessageCollector(){

            public void clear() {
            }

            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
                if (severity == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (severity == CompilerMessageSeverity.ERROR) {
                    String prefix = location == null ? "" : "(" + location.getPath() + ":" + location.getLine() + ":" + location.getColumn() + ") ";
                    throw new AssertionError((Object)(prefix + message));
                }
            }

            public boolean hasErrors() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "severity";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/test/KotlinTestUtils$1";
                objectArray[2] = "report";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CompilerConfiguration compilerConfiguration = configuration;
        if (compilerConfiguration == null) {
            KotlinTestUtils.$$$reportNull$$$0(23);
        }
        return compilerConfiguration;
    }

    @NotNull
    public static CompilerConfiguration newConfiguration(@NotNull ConfigurationKind configurationKind, @NotNull TestJdkKind jdkKind, File ... extraClasspath) {
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(24);
        }
        if (jdkKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(25);
        }
        if (extraClasspath == null) {
            KotlinTestUtils.$$$reportNull$$$0(26);
        }
        return KotlinTestUtils.newConfiguration(configurationKind, jdkKind, Arrays.asList(extraClasspath), Collections.emptyList());
    }

    @NotNull
    public static CompilerConfiguration newConfiguration(@NotNull ConfigurationKind configurationKind, @NotNull TestJdkKind jdkKind, @NotNull List<File> classpath, @NotNull List<File> javaSource) {
        if (configurationKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(27);
        }
        if (jdkKind == null) {
            KotlinTestUtils.$$$reportNull$$$0(28);
        }
        if (classpath == null) {
            KotlinTestUtils.$$$reportNull$$$0(29);
        }
        if (javaSource == null) {
            KotlinTestUtils.$$$reportNull$$$0(30);
        }
        CompilerConfiguration configuration = KotlinTestUtils.newConfiguration();
        JvmContentRootsKt.addJavaSourceRoots((CompilerConfiguration)configuration, javaSource);
        if (jdkKind == TestJdkKind.MOCK_JDK) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)KotlinTestUtils.findMockJdkRtJar());
            configuration.put(JVMConfigurationKeys.NO_JDK, (Object)true);
        } else if (jdkKind == TestJdkKind.MODIFIED_MOCK_JDK) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)KotlinTestUtils.findMockJdkRtModified());
            configuration.put(JVMConfigurationKeys.NO_JDK, (Object)true);
        } else if (jdkKind == TestJdkKind.ANDROID_API) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)KotlinTestUtils.findAndroidApiJar());
            configuration.put(JVMConfigurationKeys.NO_JDK, (Object)true);
        } else if (jdkKind == TestJdkKind.FULL_JDK_6) {
            String jdk6 = System.getenv("JDK_16");
            assert (jdk6 != null) : "Environment variable JDK_16 is not set";
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)new File(jdk6));
        } else if (jdkKind == TestJdkKind.FULL_JDK_9) {
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)KotlinTestUtils.getJdk9Home());
        } else if (jdkKind == TestJdkKind.FULL_JDK_15) {
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)KotlinTestUtils.getJdk15Home());
        } else if (SystemInfo.IS_AT_LEAST_JAVA9) {
            configuration.put(JVMConfigurationKeys.JDK_HOME, (Object)new File(System.getProperty("java.home")));
        }
        if (configurationKind.getWithRuntime()) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.runtimeJarForTests());
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.scriptRuntimeJarForTests());
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.kotlinTestJarForTests());
        } else if (configurationKind.getWithMockRuntime()) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.minimalRuntimeJarForTests());
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.scriptRuntimeJarForTests());
        }
        if (configurationKind.getWithReflection()) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.reflectJarForTests());
        }
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)configuration, classpath);
        CompilerConfiguration compilerConfiguration = configuration;
        if (compilerConfiguration == null) {
            KotlinTestUtils.$$$reportNull$$$0(31);
        }
        return compilerConfiguration;
    }

    @NotNull
    public static File getJdk9Home() {
        String jdk9 = System.getenv("JDK_9");
        if (jdk9 == null && (jdk9 = System.getenv("JDK_19")) == null) {
            throw new AssertionError((Object)"Environment variable JDK_9 is not set!");
        }
        return new File(jdk9);
    }

    @Nullable
    public static File getJdk11Home() {
        String jdk11 = System.getenv("JDK_11");
        if (jdk11 == null) {
            return null;
        }
        return new File(jdk11);
    }

    @NotNull
    public static File getJdk15Home() {
        String jdk15 = System.getenv("JDK_15");
        if (jdk15 == null) {
            jdk15 = System.getenv("JDK_15_0");
        }
        if (jdk15 == null) {
            throw new AssertionError((Object)"Environment variable JDK_15 is not set!");
        }
        return new File(jdk15);
    }

    public static void resolveAllKotlinFiles(KotlinCoreEnvironment environment) throws IOException {
        List roots = ContentRootsKt.getKotlinSourceRoots((CompilerConfiguration)environment.getConfiguration());
        if (roots.isEmpty()) {
            return;
        }
        ArrayList<KtFile> ktFiles = new ArrayList<KtFile>();
        for (KotlinSourceRoot root : roots) {
            File file = new File(root.getPath());
            if (file.isFile()) {
                ktFiles.add(KotlinTestUtils.loadJetFile(environment.getProject(), file));
                continue;
            }
            for (File childFile : file.listFiles()) {
                if (!childFile.getName().endsWith(".kt") && !childFile.getName().endsWith(".kts")) continue;
                ktFiles.add(KotlinTestUtils.loadJetFile(environment.getProject(), childFile));
            }
        }
        JvmResolveUtil.analyze(ktFiles, environment);
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull Editor editor) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(32);
        }
        if (editor == null) {
            KotlinTestUtils.$$$reportNull$$$0(33);
        }
        KotlinTestUtils.assertEqualsToFile(expectedFile, editor, true);
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull Editor editor, Boolean enableSelectionTags) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(34);
        }
        if (editor == null) {
            KotlinTestUtils.$$$reportNull$$$0(35);
        }
        Caret caret = editor.getCaretModel().getCurrentCaret();
        ArrayList tags = Lists.newArrayList((Object[])new TagsTestDataUtil.TagInfo[]{new TagsTestDataUtil.TagInfo<String>(caret.getOffset(), true, "caret")});
        if (enableSelectionTags.booleanValue()) {
            int selectionStart = caret.getSelectionStart();
            int selectionEnd = caret.getSelectionEnd();
            tags.add(new TagsTestDataUtil.TagInfo<String>(selectionStart, true, "selection"));
            tags.add(new TagsTestDataUtil.TagInfo<String>(selectionEnd, false, "selection"));
        }
        String afterText = TagsTestDataUtil.insertTagsInText(tags, editor.getDocument().getText(), t -> null);
        KotlinTestUtils.assertEqualsToFile(expectedFile, afterText);
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual2) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(36);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(37);
        }
        KotlinTestUtils.assertEqualsToFile(expectedFile, actual2, (Function1<String, String>)((Function1)s -> s));
    }

    public static void assertEqualsToFile(@NotNull String message, @NotNull File expectedFile, @NotNull String actual2) {
        if (message == null) {
            KotlinTestUtils.$$$reportNull$$$0(38);
        }
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(39);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(40);
        }
        KotlinTestUtils.assertEqualsToFile(message, expectedFile, actual2, (Function1<String, String>)((Function1)s -> s));
    }

    public static void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual2, @NotNull Function1<String, String> sanitizer) {
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(41);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(42);
        }
        if (sanitizer == null) {
            KotlinTestUtils.$$$reportNull$$$0(43);
        }
        KotlinTestUtils.assertEqualsToFile("Actual data differs from file content", expectedFile, actual2, sanitizer);
    }

    public static void assertEqualsToFile(@NotNull String message, @NotNull File expectedFile, @NotNull String actual2, @NotNull Function1<String, String> sanitizer) {
        if (message == null) {
            KotlinTestUtils.$$$reportNull$$$0(44);
        }
        if (expectedFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(45);
        }
        if (actual2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(46);
        }
        if (sanitizer == null) {
            KotlinTestUtils.$$$reportNull$$$0(47);
        }
        try {
            String expected;
            String expectedText;
            String actualText = JetTestUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF(StringUtil.convertLineSeparators((String)actual2.trim()));
            if (!expectedFile.exists()) {
                FileUtil.writeToFile((File)expectedFile, (String)actualText);
                Assert.fail((String)("Expected data file did not exist. Generating: " + expectedFile));
            }
            if (!Comparing.equal((String)((String)sanitizer.invoke((Object)(expectedText = JetTestUtilsKt.trimTrailingWhitespacesAndAddNewlineAtEOF(StringUtil.convertLineSeparators((String)(expected = FileUtil.loadFile((File)expectedFile, (String)"UTF-8", (boolean)true)).trim()))))), (String)((String)sanitizer.invoke((Object)actualText)))) {
                throw new FileComparisonFailure(message + ": " + expectedFile.getName(), expected, actual2, expectedFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    public static boolean compileKotlinWithJava(@NotNull List<File> javaFiles, @NotNull List<File> ktFiles, @NotNull File outDir, @NotNull Disposable disposable, @Nullable File javaErrorFile) throws IOException {
        if (javaFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(48);
        }
        if (ktFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(49);
        }
        if (outDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(50);
        }
        if (disposable == null) {
            KotlinTestUtils.$$$reportNull$$$0(51);
        }
        return KotlinTestUtils.compileKotlinWithJava(javaFiles, ktFiles, outDir, disposable, javaErrorFile, null);
    }

    public static boolean compileKotlinWithJava(@NotNull List<File> javaFiles, @NotNull List<File> ktFiles, @NotNull File outDir, @NotNull Disposable disposable, @Nullable File javaErrorFile, @Nullable Function1<CompilerConfiguration, Unit> updateConfiguration) throws IOException {
        if (javaFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(52);
        }
        if (ktFiles == null) {
            KotlinTestUtils.$$$reportNull$$$0(53);
        }
        if (outDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(54);
        }
        if (disposable == null) {
            KotlinTestUtils.$$$reportNull$$$0(55);
        }
        if (!ktFiles.isEmpty()) {
            KotlinCoreEnvironment environment = KotlinTestUtils.createEnvironmentWithFullJdkAndIdeaAnnotations(disposable);
            CompilerTestLanguageVersionSettingsKt.setupLanguageVersionSettingsForMultifileCompilerTests(ktFiles, environment);
            if (updateConfiguration != null) {
                updateConfiguration.invoke((Object)environment.getConfiguration());
            }
            LoadDescriptorUtil.compileKotlinToDirAndGetModule(ktFiles, outDir, environment);
        } else {
            boolean mkdirs = outDir.mkdirs();
            assert (mkdirs) : "Not created: " + outDir;
        }
        if (javaFiles.isEmpty()) {
            return true;
        }
        return KotlinTestUtils.compileJavaFiles(javaFiles, Arrays.asList("-classpath", outDir.getPath() + File.pathSeparator + ForTestCompileRuntime.runtimeJarForTests(), "-d", outDir.getPath()), javaErrorFile);
    }

    @NotNull
    public static Directives parseDirectives(String expectedText) {
        return KotlinTestUtils.parseDirectives(expectedText, new Directives());
    }

    @NotNull
    public static Directives parseDirectives(String expectedText, @NotNull Directives directives) {
        if (directives == null) {
            KotlinTestUtils.$$$reportNull$$$0(56);
        }
        Matcher directiveMatcher = DIRECTIVE_PATTERN.matcher(expectedText);
        while (directiveMatcher.find()) {
            String name = directiveMatcher.group(1);
            String value = directiveMatcher.group(3);
            directives.put(name, value);
        }
        Directives directives2 = directives;
        if (directives2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(57);
        }
        return directives2;
    }

    public static List<String> loadBeforeAfterText(String filePath) {
        String content2;
        try {
            content2 = FileUtil.loadFile((File)new File(filePath), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<String> files = TestFiles.createTestFiles("", content2, new TestFiles.TestFileFactoryNoModules<String>(){

            @Override
            @NotNull
            public String create(@NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
                if (fileName == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (directives == null) {
                    2.$$$reportNull$$$0(2);
                }
                int firstLineEnd = text.indexOf(10);
                String string = StringUtil.trimTrailing((String)text.substring(firstLineEnd + 1));
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "directives";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/test/KotlinTestUtils$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/test/KotlinTestUtils$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, "");
        Assert.assertTrue((String)"Exactly two files expected: ", (files.size() == 2 ? 1 : 0) != 0);
        return files;
    }

    public static String getLastCommentedLines(@NotNull Document document) {
        if (document == null) {
            KotlinTestUtils.$$$reportNull$$$0(58);
        }
        ArrayList<CharSequence> resultLines = new ArrayList<CharSequence>();
        for (int i = document.getLineCount() - 1; i >= 0; --i) {
            int lineStart = document.getLineStartOffset(i);
            int lineEnd = document.getLineEndOffset(i);
            if (document.getCharsSequence().subSequence(lineStart, lineEnd).toString().trim().isEmpty()) continue;
            if (!"//".equals(document.getCharsSequence().subSequence(lineStart, lineStart + 2).toString())) break;
            resultLines.add(document.getCharsSequence().subSequence(lineStart + 2, lineEnd));
        }
        Collections.reverse(resultLines);
        StringBuilder result = new StringBuilder();
        for (CharSequence line : resultLines) {
            result.append(line).append("\n");
        }
        result.delete(result.length() - 1, result.length());
        return result.toString();
    }

    @NotNull
    public static String getLastCommentInFile(@NotNull KtFile file) {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(59);
        }
        String string = (String)CollectionsKt.first(KotlinTestUtils.getLastCommentsInFile(file, CommentType.ALL, true));
        if (string == null) {
            KotlinTestUtils.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public static List<String> getLastCommentsInFile(@NotNull KtFile file, CommentType commentType, boolean assertMustExist) {
        PsiElement lastChild;
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(61);
        }
        if ((lastChild = file.getLastChild()) != null && lastChild.getNode().getElementType().equals(KtTokens.WHITE_SPACE)) {
            lastChild = lastChild.getPrevSibling();
        }
        assert (lastChild != null);
        ArrayList<String> comments = new ArrayList<String>();
        while (true) {
            if (lastChild.getNode().getElementType().equals(KtTokens.BLOCK_COMMENT)) {
                if (commentType == CommentType.ALL || commentType == CommentType.BLOCK_COMMENT) {
                    String lastChildText = lastChild.getText();
                    comments.add(lastChildText.substring(2, lastChildText.length() - 2).trim());
                }
            } else {
                if (!lastChild.getNode().getElementType().equals(KtTokens.EOL_COMMENT)) break;
                if (commentType == CommentType.ALL || commentType == CommentType.LINE_COMMENT) {
                    comments.add(lastChild.getText().substring(2).trim());
                }
            }
            lastChild = lastChild.getPrevSibling();
        }
        if (comments.isEmpty() && assertMustExist) {
            throw new AssertionError((Object)String.format("Test file '%s' should end in a comment of type %s; last node was: %s", new Object[]{file.getName(), commentType, lastChild}));
        }
        ArrayList<String> arrayList = comments;
        if (arrayList == null) {
            KotlinTestUtils.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    public static boolean compileJavaFiles(@NotNull Collection<File> files, List<String> options) throws IOException {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(63);
        }
        return KotlinTestUtils.compileJavaFiles(files, options, null);
    }

    private static boolean compileJavaFiles(@NotNull Collection<File> files, List<String> options, @Nullable File javaErrorFile) throws IOException {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(64);
        }
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector<JavaFileObject> diagnosticCollector = new DiagnosticCollector<JavaFileObject>();
        try (StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(diagnosticCollector, Locale.ENGLISH, Charset.forName("utf-8"));){
            Iterable<? extends JavaFileObject> javaFileObjectsFromFiles = fileManager.getJavaFileObjectsFromFiles(files);
            JavaCompiler.CompilationTask task = javaCompiler.getTask(new StringWriter(), fileManager, diagnosticCollector, options, null, javaFileObjectsFromFiles);
            Boolean success = task.call();
            if (javaErrorFile == null || !javaErrorFile.exists()) {
                Assert.assertTrue((String)KotlinTestUtils.errorsToString(diagnosticCollector, true), (boolean)success);
            } else {
                KotlinTestUtils.assertEqualsToFile(javaErrorFile, KotlinTestUtils.errorsToString(diagnosticCollector, false));
            }
            boolean bl = success;
            return bl;
        }
    }

    public static boolean compileJavaFilesExternallyWithJava9(@NotNull Collection<File> files, @NotNull List<String> options) {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(65);
        }
        if (options == null) {
            KotlinTestUtils.$$$reportNull$$$0(66);
        }
        return KotlinTestUtils.compileJavaFilesExternally(files, options, KotlinTestUtils.getJdk9Home());
    }

    public static boolean compileJavaFilesExternally(@NotNull Collection<File> files, @NotNull List<String> options, @NotNull File jdkHome) {
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(67);
        }
        if (options == null) {
            KotlinTestUtils.$$$reportNull$$$0(68);
        }
        if (jdkHome == null) {
            KotlinTestUtils.$$$reportNull$$$0(69);
        }
        ArrayList<String> command2 = new ArrayList<String>();
        command2.add(new File(jdkHome, "bin/javac").getPath());
        command2.addAll(options);
        for (File file : files) {
            command2.add(file.getPath());
        }
        try {
            Process process = new ProcessBuilder(new String[0]).command(command2).inheritIO().start();
            process.waitFor();
            return process.exitValue() == 0;
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    @NotNull
    private static String errorsToString(@NotNull DiagnosticCollector<JavaFileObject> diagnosticCollector, boolean humanReadable) {
        if (diagnosticCollector == null) {
            KotlinTestUtils.$$$reportNull$$$0(70);
        }
        StringBuilder builder = new StringBuilder();
        for (Diagnostic<JavaFileObject> diagnostic : diagnosticCollector.getDiagnostics()) {
            if (diagnostic.getKind() != Diagnostic.Kind.ERROR) continue;
            if (humanReadable) {
                builder.append(diagnostic).append("\n");
                continue;
            }
            builder.append(new File(diagnostic.getSource().toUri()).getName()).append(":").append(diagnostic.getLineNumber()).append(":").append(diagnostic.getColumnNumber()).append(":").append(diagnostic.getCode()).append("\n");
        }
        String string = builder.toString();
        if (string == null) {
            KotlinTestUtils.$$$reportNull$$$0(71);
        }
        return string;
    }

    public static String navigationMetadata(String testFile) {
        return testFile;
    }

    public static void runTest(@NotNull DoTest test2, @NotNull TestCase testCase, String testDataFile) throws Exception {
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(72);
        }
        if (testCase == null) {
            KotlinTestUtils.$$$reportNull$$$0(73);
        }
        KotlinTestUtils.runTestImpl(KotlinTestUtils.testWithCustomIgnoreDirective(test2, TargetBackend.ANY, "// IGNORE_BACKEND: "), testCase, testDataFile);
    }

    public static void runTest(@NotNull TestCase testCase, @NotNull Function0<Unit> test2) {
        if (testCase == null) {
            KotlinTestUtils.$$$reportNull$$$0(74);
        }
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(75);
        }
        MuteWithDatabaseKt.runTest(testCase, test2);
    }

    public static void runTestWithThrowable(@NotNull TestCase testCase, @NotNull RunnableWithThrowable test2) {
        if (testCase == null) {
            KotlinTestUtils.$$$reportNull$$$0(76);
        }
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(77);
        }
        MuteWithDatabaseKt.runTest(testCase, (Function0<Unit>)((Function0)() -> {
            try {
                test2.run();
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(throwable);
            }
            return null;
        }));
    }

    public static void runTest(DoTest test2, TargetBackend targetBackend, String testDataFile) throws Exception {
        KotlinTestUtils.runTest0(test2, targetBackend, testDataFile);
    }

    public static void runTestWithCustomIgnoreDirective(DoTest test2, TargetBackend targetBackend, String testDataFile, String ignoreDirective) throws Exception {
        KotlinTestUtils.runTestImpl(KotlinTestUtils.testWithCustomIgnoreDirective(test2, targetBackend, ignoreDirective), null, testDataFile);
    }

    public static void runTest0(DoTest test2, TargetBackend targetBackend, String testDataFilePath) throws Exception {
        KotlinTestUtils.runTestImpl(KotlinTestUtils.testWithCustomIgnoreDirective(test2, targetBackend, "// IGNORE_BACKEND: "), null, testDataFilePath);
    }

    private static void runTestImpl(@NotNull DoTest test2, @Nullable TestCase testCase, String testDataFilePath) throws Exception {
        Function0<Unit> wrapWithMuteInDatabase2;
        if (test2 == null) {
            KotlinTestUtils.$$$reportNull$$$0(78);
        }
        if (testCase != null && !KotlinTestUtils.isRunTestOverridden(testCase) && (wrapWithMuteInDatabase2 = MuteWithDatabaseKt.wrapWithMuteInDatabase(testCase, (Function0<Unit>)((Function0)() -> {
            try {
                test2.invoke(testDataFilePath);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return null;
        }))) != null) {
            wrapWithMuteInDatabase2.invoke();
            return;
        }
        MuteWithFileKt.testWithMuteInFile(test2, testCase).invoke(testDataFilePath);
    }

    private static boolean isRunTestOverridden(TestCase testCase) {
        for (Class<?> type = testCase.getClass(); type != null; type = type.getSuperclass()) {
            for (Annotation annotation : type.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(WithMutedInDatabaseRunTest.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static DoTest testWithCustomIgnoreDirective(DoTest test2, TargetBackend targetBackend, String ignoreDirective) throws Exception {
        return filePath -> {
            File testDataFile = new File(filePath);
            boolean isIgnored = InTextDirectivesUtils.isIgnoredTarget(targetBackend, testDataFile, ignoreDirective);
            if (DONT_IGNORE_TESTS_WORKING_ON_COMPATIBLE_BACKEND) {
                isIgnored &= InTextDirectivesUtils.isIgnoredTarget(targetBackend.getCompatibleWith(), testDataFile);
            }
            try {
                test2.invoke(filePath);
            }
            catch (Throwable e) {
                if (!isIgnored) {
                    // empty if block
                }
                if (RUN_IGNORED_TESTS_AS_REGULAR || !isIgnored) {
                    throw e;
                }
                if (PRINT_STACKTRACE_FOR_IGNORED_TESTS) {
                    e.printStackTrace();
                }
                return;
            }
            if (isIgnored) {
                throw new AssertionError((Object)"Looks like this test can be unmuted. Remove IGNORE_BACKEND directive.");
            }
        };
    }

    public static String getTestsRoot(@NotNull Class<?> testCaseClass) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(79);
        }
        TestMetadata testClassMetadata = testCaseClass.getAnnotation(TestMetadata.class);
        Assert.assertNotNull((String)("No metadata for class: " + testCaseClass), (Object)testClassMetadata);
        return testClassMetadata.value();
    }

    @Nullable
    public static String getTestDataFileName(@NotNull Class<?> testCaseClass, @NotNull String testName) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(80);
        }
        if (testName == null) {
            KotlinTestUtils.$$$reportNull$$$0(81);
        }
        try {
            Method method = testCaseClass.getDeclaredMethod(testName, new Class[0]);
            return KotlinTestUtils.getMethodMetadata(method);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertAllTestsPresentByMetadataWithExcluded(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludedPattern, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(82);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(83);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(84);
        }
        if (excludeDirs == null) {
            KotlinTestUtils.$$$reportNull$$$0(85);
        }
        KotlinTestUtils.assertAllTestsPresentByMetadataWithExcluded(testCaseClass, testDataDir, filenamePattern, excludedPattern, TargetBackend.ANY, recursive, excludeDirs);
    }

    public static void assertAllTestsPresentByMetadata(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(86);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(87);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(88);
        }
        if (excludeDirs == null) {
            KotlinTestUtils.$$$reportNull$$$0(89);
        }
        KotlinTestUtils.assertAllTestsPresentByMetadata(testCaseClass, testDataDir, filenamePattern, TargetBackend.ANY, recursive, excludeDirs);
    }

    public static void assertAllTestsPresentByMetadataWithExcluded(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludedPattern, @NotNull TargetBackend targetBackend, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(90);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(91);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(92);
        }
        if (targetBackend == null) {
            KotlinTestUtils.$$$reportNull$$$0(93);
        }
        if (excludeDirs == null) {
            KotlinTestUtils.$$$reportNull$$$0(94);
        }
        File rootFile = new File(KotlinTestUtils.getTestsRoot(testCaseClass));
        Set<String> filePaths = KotlinTestUtils.collectPathsMetadata(testCaseClass);
        Set exclude = SetsKt.setOf((Object[])excludeDirs);
        File[] files = testDataDir.listFiles();
        if (files != null) {
            for (File file : files) {
                boolean excluded;
                if (file.isDirectory()) {
                    if (!recursive || !KotlinTestUtils.containsTestData(file, filenamePattern, excludedPattern) || exclude.contains(file.getName())) continue;
                    KotlinTestUtils.assertTestClassPresentByMetadata(testCaseClass, file);
                    continue;
                }
                boolean bl = excluded = excludedPattern != null && excludedPattern.matcher(file.getName()).matches();
                if (excluded || !filenamePattern.matcher(file.getName()).matches() || !InTextDirectivesUtils.isCompatibleTarget(targetBackend, file)) continue;
                KotlinTestUtils.assertFilePathPresent(file, rootFile, filePaths);
            }
        }
    }

    public static void assertAllTestsPresentByMetadata(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @NotNull TargetBackend targetBackend, boolean recursive, String ... excludeDirs) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(95);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(96);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(97);
        }
        if (targetBackend == null) {
            KotlinTestUtils.$$$reportNull$$$0(98);
        }
        if (excludeDirs == null) {
            KotlinTestUtils.$$$reportNull$$$0(99);
        }
        KotlinTestUtils.assertAllTestsPresentByMetadataWithExcluded(testCaseClass, testDataDir, filenamePattern, null, targetBackend, recursive, excludeDirs);
    }

    public static void assertAllTestsPresentInSingleGeneratedClass(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(100);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(101);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(102);
        }
        KotlinTestUtils.assertAllTestsPresentInSingleGeneratedClass(testCaseClass, testDataDir, filenamePattern, TargetBackend.ANY);
    }

    public static void assertAllTestsPresentInSingleGeneratedClassWithExcluded(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludePattern) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(103);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(104);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(105);
        }
        KotlinTestUtils.assertAllTestsPresentInSingleGeneratedClass(testCaseClass, testDataDir, filenamePattern, excludePattern, TargetBackend.ANY);
    }

    public static void assertAllTestsPresentInSingleGeneratedClass(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @NotNull TargetBackend targetBackend) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(106);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(107);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(108);
        }
        if (targetBackend == null) {
            KotlinTestUtils.$$$reportNull$$$0(109);
        }
        KotlinTestUtils.assertAllTestsPresentInSingleGeneratedClass(testCaseClass, testDataDir, filenamePattern, null, targetBackend);
    }

    public static void assertAllTestsPresentInSingleGeneratedClass(@NotNull Class<?> testCaseClass, @NotNull File testDataDir, @NotNull Pattern filenamePattern, @Nullable Pattern excludePattern, @NotNull TargetBackend targetBackend) {
        if (testCaseClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(110);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(111);
        }
        if (filenamePattern == null) {
            KotlinTestUtils.$$$reportNull$$$0(112);
        }
        if (targetBackend == null) {
            KotlinTestUtils.$$$reportNull$$$0(113);
        }
        File rootFile = new File(KotlinTestUtils.getTestsRoot(testCaseClass));
        Set<String> filePaths = KotlinTestUtils.collectPathsMetadata(testCaseClass);
        FileUtil.processFilesRecursively((File)testDataDir, file -> {
            boolean excluded;
            boolean bl = excluded = excludePattern != null && excludePattern.matcher(file.getName()).matches();
            if (file.isFile() && !excluded && filenamePattern.matcher(file.getName()).matches() && InTextDirectivesUtils.isCompatibleTarget(targetBackend, file)) {
                KotlinTestUtils.assertFilePathPresent(file, rootFile, filePaths);
            }
            return true;
        });
    }

    private static void assertFilePathPresent(File file, File rootFile, Set<String> filePaths) {
        String relativePath;
        String path = FileUtil.getRelativePath((File)rootFile, (File)file);
        if (path != null && !filePaths.contains(relativePath = KotlinTestUtils.nameToCompare(path))) {
            Assert.fail((String)("Test data file missing from the generated test class: " + file + "\n" + PLEASE_REGENERATE_TESTS));
        }
    }

    private static Set<String> collectPathsMetadata(Class<?> testCaseClass) {
        return new HashSet<String>(ContainerUtil.map(KotlinTestUtils.collectMethodsMetadata(testCaseClass), KotlinTestUtils::nameToCompare));
    }

    @Nullable
    private static String getMethodMetadata(Method method) {
        TestMetadata testMetadata = method.getAnnotation(TestMetadata.class);
        return testMetadata != null ? testMetadata.value() : null;
    }

    private static Set<String> collectMethodsMetadata(Class<?> testCaseClass) {
        HashSet<String> filePaths = new HashSet<String>();
        for (Method method : testCaseClass.getDeclaredMethods()) {
            String path = KotlinTestUtils.getMethodMetadata(method);
            if (path == null) continue;
            filePaths.add(path);
        }
        return filePaths;
    }

    private static boolean containsTestData(File dir, Pattern filenamePattern, @Nullable Pattern excludedPattern) {
        File[] files = dir.listFiles();
        assert (files != null);
        for (File file : files) {
            boolean excluded;
            if (file.isDirectory()) {
                if (!KotlinTestUtils.containsTestData(file, filenamePattern, excludedPattern)) continue;
                return true;
            }
            boolean bl = excluded = excludedPattern != null && excludedPattern.matcher(file.getName()).matches();
            if (excluded || !filenamePattern.matcher(file.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    private static void assertTestClassPresentByMetadata(@NotNull Class<?> outerClass, @NotNull File testDataDir) {
        if (outerClass == null) {
            KotlinTestUtils.$$$reportNull$$$0(114);
        }
        if (testDataDir == null) {
            KotlinTestUtils.$$$reportNull$$$0(115);
        }
        for (Class<?> nestedClass : outerClass.getDeclaredClasses()) {
            TestMetadata testMetadata = nestedClass.getAnnotation(TestMetadata.class);
            if (testMetadata == null || !testMetadata.value().equals(KotlinTestUtils.getFilePath(testDataDir))) continue;
            return;
        }
        Assert.fail((String)("Test data directory missing from the generated test class: " + testDataDir + "\n" + PLEASE_REGENERATE_TESTS));
    }

    @NotNull
    public static KtFile loadJetFile(@NotNull Project project, @NotNull File ioFile) throws IOException {
        if (project == null) {
            KotlinTestUtils.$$$reportNull$$$0(116);
        }
        if (ioFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(117);
        }
        String text = FileUtil.loadFile((File)ioFile, (boolean)true);
        KtFile ktFile = KtPsiFactoryKt.KtPsiFactory((Project)project).createPhysicalFile(ioFile.getName(), text);
        if (ktFile == null) {
            KotlinTestUtils.$$$reportNull$$$0(118);
        }
        return ktFile;
    }

    @NotNull
    public static List<KtFile> loadToJetFiles(@NotNull KotlinCoreEnvironment environment, @NotNull List<File> files) throws IOException {
        if (environment == null) {
            KotlinTestUtils.$$$reportNull$$$0(119);
        }
        if (files == null) {
            KotlinTestUtils.$$$reportNull$$$0(120);
        }
        ArrayList jetFiles = Lists.newArrayList();
        for (File file : files) {
            jetFiles.add(KotlinTestUtils.loadJetFile(environment.getProject(), file));
        }
        ArrayList arrayList = jetFiles;
        if (arrayList == null) {
            KotlinTestUtils.$$$reportNull$$$0(121);
        }
        return arrayList;
    }

    @NotNull
    public static ModuleDescriptorImpl createEmptyModule() {
        return KotlinTestUtils.createEmptyModule("<empty-for-test>");
    }

    @NotNull
    public static ModuleDescriptorImpl createEmptyModule(@NotNull String name) {
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(122);
        }
        return KotlinTestUtils.createEmptyModule(name, (KotlinBuiltIns)DefaultBuiltIns.getInstance());
    }

    @NotNull
    public static ModuleDescriptorImpl createEmptyModule(@NotNull String name, @NotNull KotlinBuiltIns builtIns) {
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(123);
        }
        if (builtIns == null) {
            KotlinTestUtils.$$$reportNull$$$0(124);
        }
        return new ModuleDescriptorImpl(Name.special((String)name), LockBasedStorageManager.NO_LOCKS, builtIns);
    }

    @NotNull
    public static File replaceExtension(@NotNull File file, @Nullable String newExtension) {
        if (file == null) {
            KotlinTestUtils.$$$reportNull$$$0(125);
        }
        return new File(file.getParentFile(), FileUtil.getNameWithoutExtension((File)file) + (newExtension == null ? "" : "." + newExtension));
    }

    public static boolean isAllFilesPresentTest(String testName) {
        return testName.toLowerCase().startsWith("allfilespresentin");
    }

    public static String nameToCompare(@NotNull String name) {
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(126);
        }
        return (SystemInfo.isFileSystemCaseSensitive ? name : name.toLowerCase()).replace('\\', '/');
    }

    public static boolean isMultiExtensionName(@NotNull String name) {
        int firstDotIndex;
        if (name == null) {
            KotlinTestUtils.$$$reportNull$$$0(127);
        }
        if ((firstDotIndex = name.indexOf(46)) == -1) {
            return false;
        }
        return name.indexOf(46, firstDotIndex + 1) != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 31: 
            case 57: 
            case 60: 
            case 62: 
            case 71: 
            case 118: 
            case 121: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 31: 
            case 57: 
            case 60: 
            case 62: 
            case 71: 
            case 118: 
            case 121: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 31: 
            case 57: 
            case 60: 
            case 62: 
            case 71: 
            case 118: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/KotlinTestUtils";
                break;
            }
            case 3: 
            case 5: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKind";
                break;
            }
            case 4: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkKind";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
            case 14: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 18: 
            case 122: 
            case 123: 
            case 126: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraClasspath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classpath";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSource";
                break;
            }
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFile";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 37: 
            case 40: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sanitizer";
                break;
            }
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFiles";
                break;
            }
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktFiles";
                break;
            }
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directives";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkHome";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticCollector";
                break;
            }
            case 72: 
            case 75: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 73: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCase";
                break;
            }
            case 79: 
            case 80: 
            case 82: 
            case 86: 
            case 90: 
            case 95: 
            case 100: 
            case 103: 
            case 106: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClass";
                break;
            }
            case 83: 
            case 87: 
            case 91: 
            case 96: 
            case 101: 
            case 104: 
            case 107: 
            case 111: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataDir";
                break;
            }
            case 84: 
            case 88: 
            case 92: 
            case 97: 
            case 102: 
            case 105: 
            case 108: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filenamePattern";
                break;
            }
            case 85: 
            case 89: 
            case 94: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeDirs";
                break;
            }
            case 93: 
            case 98: 
            case 109: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBackend";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioFile";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builtIns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/KotlinTestUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPathBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHomeDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndroidSdk";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "tmpDirForTest";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "tmpDir";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "tmpDirForReusableFolder";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 23: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "newConfiguration";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDirectives";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommentInFile";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastCommentsInFile";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "errorsToString";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "loadJetFile";
                break;
            }
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "loadToJetFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyzeFile";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 31: 
            case 57: 
            case 60: 
            case 62: 
            case 71: 
            case 118: 
            case 121: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentWithMockJdkAndIdeaAnnotations";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentWithJdkAndNullabilityAnnotationsFromIdea";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mkdirs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tmpDirForTest";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doLoadFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "newConfiguration";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "assertEqualsToFile";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "compileKotlinWithJava";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "parseDirectives";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommentedLines";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommentInFile";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommentsInFile";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaFiles";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaFilesExternallyWithJava9";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaFilesExternally";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "errorsToString";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "runTest";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "runTestWithThrowable";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "runTestImpl";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getTestsRoot";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getTestDataFileName";
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentByMetadataWithExcluded";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentByMetadata";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentInSingleGeneratedClass";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "assertAllTestsPresentInSingleGeneratedClassWithExcluded";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "assertTestClassPresentByMetadata";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "loadJetFile";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "loadToJetFiles";
                break;
            }
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyModule";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "replaceExtension";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "nameToCompare";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isMultiExtensionName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 31: 
            case 57: 
            case 60: 
            case 62: 
            case 71: 
            case 118: 
            case 121: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DoTest {
        public void invoke(@NotNull String var1) throws Exception;
    }

    public static enum CommentType {
        ALL,
        LINE_COMMENT,
        BLOCK_COMMENT;

    }
}

