/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0003H\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0007H\u0000\u00a8\u0006\b"}, d2={"getText", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "Lorg/jetbrains/kotlin/resolve/calls/model/ArgumentMapping;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/Receiver;", "renderToText", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "tests-common"})
public final class AbstractResolvedCallsTestKt {
    @NotNull
    public static final String getText(@Nullable Receiver $this$getText) {
        String string;
        Receiver receiver = $this$getText;
        if (receiver instanceof ExpressionReceiver) {
            string = ((ExpressionReceiver)$this$getText).getExpression().getText() + " {" + ((ExpressionReceiver)$this$getText).getType() + '}';
        } else if (receiver instanceof ImplicitClassReceiver) {
            string = "Class{" + ((ImplicitClassReceiver)$this$getText).getType() + '}';
        } else if (receiver instanceof ExtensionReceiver) {
            StringBuilder stringBuilder = new StringBuilder().append(((ExtensionReceiver)$this$getText).getType()).append("Ext{");
            CallableDescriptor callableDescriptor = ((ExtensionReceiver)$this$getText).getDeclarationDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"declarationDescriptor");
            string = stringBuilder.append(AbstractResolvedCallsTestKt.getText((DeclarationDescriptor)callableDescriptor)).append('}').toString();
        } else {
            string = receiver == null ? "NO_RECEIVER" : $this$getText.toString();
        }
        return string;
    }

    @NotNull
    public static final String getText(@NotNull ValueArgument $this$getText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        Object object = $this$getText.getArgumentExpression();
        String string2 = string = object == null ? null : object.getText();
        return string == null ? "" : ((object = StringsKt.replace$default((String)string, (String)"\n", (String)" ", (boolean)false, (int)4, null)) == null ? "" : object);
    }

    @NotNull
    public static final String getText(@NotNull ArgumentMapping $this$getText) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        ArgumentMapping argumentMapping = $this$getText;
        if (argumentMapping instanceof ArgumentMatch) {
            KotlinType kotlinType = ((ArgumentMatch)$this$getText).getValueParameter().getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"valueParameter.type");
            String parameterType = DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(kotlinType);
            string = ((ArgumentMatch)$this$getText).getStatus().name() + "  " + ((ArgumentMatch)$this$getText).getValueParameter().getName() + " : " + parameterType + " =";
        } else {
            string = "ARGUMENT UNMAPPED: ";
        }
        return string;
    }

    @NotNull
    public static final String getText(@NotNull DeclarationDescriptor $this$getText) {
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        DeclarationDescriptor declarationDescriptor = $this$getText;
        return declarationDescriptor instanceof ReceiverParameterDescriptor ? Intrinsics.stringPlus((String)AbstractResolvedCallsTestKt.getText((Receiver)((ReceiverParameterDescriptor)$this$getText).getValue()), (Object)"::this") : DescriptorRenderer.COMPACT_WITH_SHORT_TYPES.render($this$getText);
    }

    @NotNull
    public static final String renderToText(@NotNull ResolvedCall<?> $this$renderToText) {
        Intrinsics.checkNotNullParameter($this$renderToText, (String)"<this>");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$renderToText_u24lambda_u2d0 = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$renderToText_u24lambda_u2d0;
        String string = "Resolved call:";
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringBuilder stringBuilder4 = stringBuilder3;
        boolean bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$renderToText_u24lambda_u2d0;
        boolean bl8 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        if (!Intrinsics.areEqual((Object)$this$renderToText.getCandidateDescriptor(), (Object)$this$renderToText.getResultingDescriptor())) {
            stringBuilder2 = $this$renderToText_u24lambda_u2d0;
            Object object = $this$renderToText.getCandidateDescriptor();
            Intrinsics.checkNotNull((Object)object);
            object = Intrinsics.stringPlus((String)"Candidate descriptor: ", (Object)AbstractResolvedCallsTestKt.getText((DeclarationDescriptor)object));
            bl6 = false;
            StringBuilder stringBuilder5 = stringBuilder2.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder4 = stringBuilder5;
            bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        }
        stringBuilder2 = $this$renderToText_u24lambda_u2d0;
        Object object = $this$renderToText.getResultingDescriptor();
        Intrinsics.checkNotNull((Object)object);
        object = Intrinsics.stringPlus((String)"Resulting descriptor: ", (Object)AbstractResolvedCallsTestKt.getText((DeclarationDescriptor)object));
        bl6 = false;
        StringBuilder stringBuilder6 = stringBuilder2.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        stringBuilder4 = stringBuilder6;
        bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$renderToText_u24lambda_u2d0;
        boolean bl9 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$renderToText_u24lambda_u2d0;
        Iterator iterator = Intrinsics.stringPlus((String)"Explicit receiver kind = ", (Object)$this$renderToText.getExplicitReceiverKind());
        bl6 = false;
        StringBuilder stringBuilder7 = stringBuilder2.append((String)((Object)iterator));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        stringBuilder4 = stringBuilder7;
        bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$renderToText_u24lambda_u2d0;
        iterator = Intrinsics.stringPlus((String)"Dispatch receiver = ", (Object)AbstractResolvedCallsTestKt.getText((Receiver)$this$renderToText.getDispatchReceiver()));
        bl6 = false;
        StringBuilder stringBuilder8 = stringBuilder2.append((String)((Object)iterator));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        stringBuilder4 = stringBuilder8;
        bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        stringBuilder2 = $this$renderToText_u24lambda_u2d0;
        iterator = Intrinsics.stringPlus((String)"Extension receiver = ", (Object)AbstractResolvedCallsTestKt.getText((Receiver)$this$renderToText.getExtensionReceiver()));
        bl6 = false;
        StringBuilder stringBuilder9 = stringBuilder2.append((String)((Object)iterator));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        stringBuilder4 = stringBuilder9;
        bl7 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        iterator = $this$renderToText.getCall().getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"call.valueArguments");
        Iterator valueArguments = iterator;
        if (!valueArguments.isEmpty()) {
            iterator = $this$renderToText_u24lambda_u2d0;
            bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)iterator)).append('\n'), (String)"append('\\n')");
            iterator = $this$renderToText_u24lambda_u2d0;
            String string2 = "Value arguments mapping:";
            boolean bl10 = false;
            StringBuilder stringBuilder10 = ((StringBuilder)((Object)iterator)).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(value)");
            StringBuilder stringBuilder11 = stringBuilder10;
            boolean bl11 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append('\\n')");
            iterator = $this$renderToText_u24lambda_u2d0;
            boolean bl12 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)((Object)iterator)).append('\n'), (String)"append('\\n')");
            iterator = valueArguments.iterator();
            while (iterator.hasNext()) {
                StringBuilder stringBuilder12;
                ValueArgument valueArgument = (ValueArgument)iterator.next();
                Intrinsics.checkNotNull((Object)valueArgument);
                String argumentText = AbstractResolvedCallsTestKt.getText(valueArgument);
                Object object2 = $this$renderToText.getArgumentMapping(valueArgument);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getArgumentMapping(valueArgument)");
                String argumentMappingText = AbstractResolvedCallsTestKt.getText((ArgumentMapping)object2);
                object2 = $this$renderToText_u24lambda_u2d0;
                String string3 = argumentMappingText + ' ' + argumentText;
                boolean bl13 = false;
                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object2).append(string3), (String)"append(value)");
                boolean bl14 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append('\\n')");
            }
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }
}

