/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.tests.di.ContainerForTests;
import org.jetbrains.kotlin.tests.di.InjectionKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.FakeCallKind;
import org.junit.Assert;

public class ExpectedResolveDataUtil {
    private ExpectedResolveDataUtil() {
    }

    @NotNull
    public static Map<String, DeclarationDescriptor> prepareDefaultNameToDescriptors(@NotNull KotlinCoreEnvironment environment) {
        if (environment == null) {
            ExpectedResolveDataUtil.$$$reportNull$$$0(0);
        }
        Project project = environment.getProject();
        DefaultBuiltIns builtIns = DefaultBuiltIns.getInstance();
        HashMap<String, DeclarationDescriptor> nameToDescriptor = new HashMap<String, DeclarationDescriptor>();
        nameToDescriptor.put("kotlin::Int.plus(Int)", (DeclarationDescriptor)ExpectedResolveDataUtil.standardFunction(builtIns.getInt(), "plus", project, environment, new KotlinType[]{builtIns.getIntType()}));
        FunctionDescriptor descriptorForGet = ExpectedResolveDataUtil.standardFunction(builtIns.getArray(), "get", project, environment, new KotlinType[]{builtIns.getIntType()});
        nameToDescriptor.put("kotlin::Array.get(Int)", (DeclarationDescriptor)descriptorForGet.getOriginal());
        nameToDescriptor.put("kotlin::Int.compareTo(Double)", (DeclarationDescriptor)ExpectedResolveDataUtil.standardFunction(builtIns.getInt(), "compareTo", project, environment, new KotlinType[]{builtIns.getDoubleType()}));
        FunctionDescriptor descriptorForSet = ExpectedResolveDataUtil.standardFunction(builtIns.getArray(), "set", project, environment, new KotlinType[]{builtIns.getIntType(), builtIns.getIntType()});
        nameToDescriptor.put("kotlin::Array.set(Int, Int)", (DeclarationDescriptor)descriptorForSet.getOriginal());
        HashMap<String, DeclarationDescriptor> hashMap = nameToDescriptor;
        if (hashMap == null) {
            ExpectedResolveDataUtil.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @NotNull
    public static Map<String, PsiElement> prepareDefaultNameToDeclaration(@NotNull KotlinCoreEnvironment environment) {
        if (environment == null) {
            ExpectedResolveDataUtil.$$$reportNull$$$0(2);
        }
        Project project = environment.getProject();
        HashMap<String, PsiElement> nameToDeclaration = new HashMap<String, PsiElement>();
        PsiClass java_util_Collections = ExpectedResolveDataUtil.findClass("java.util.Collections", environment);
        nameToDeclaration.put("java::java.util.Collections.emptyList()", (PsiElement)ExpectedResolveDataUtil.findMethod(java_util_Collections, "emptyList"));
        nameToDeclaration.put("java::java.util.Collections", (PsiElement)java_util_Collections);
        PsiClass java_util_List = ExpectedResolveDataUtil.findClass("java.util.ArrayList", environment);
        nameToDeclaration.put("java::java.util.List", (PsiElement)ExpectedResolveDataUtil.findClass("java.util.List", environment));
        nameToDeclaration.put("java::java.util.ArrayList", (PsiElement)java_util_List);
        nameToDeclaration.put("java::java.util.ArrayList.set()", (PsiElement)java_util_List.findMethodsByName("set", true)[0]);
        nameToDeclaration.put("java::java.util.ArrayList.get()", (PsiElement)java_util_List.findMethodsByName("get", true)[0]);
        nameToDeclaration.put("java::java", ExpectedResolveDataUtil.findPackage("java", project));
        nameToDeclaration.put("java::java.util", ExpectedResolveDataUtil.findPackage("java.util", project));
        nameToDeclaration.put("java::java.lang", ExpectedResolveDataUtil.findPackage("java.lang", project));
        nameToDeclaration.put("java::java.lang.Object", (PsiElement)ExpectedResolveDataUtil.findClass("java.lang.Object", environment));
        nameToDeclaration.put("java::java.lang.Comparable", (PsiElement)ExpectedResolveDataUtil.findClass("java.lang.Comparable", environment));
        PsiClass java_lang_System = ExpectedResolveDataUtil.findClass("java.lang.System", environment);
        nameToDeclaration.put("java::java.lang.System", (PsiElement)java_lang_System);
        PsiMethod[] methods = ExpectedResolveDataUtil.findClass("java.io.PrintStream", environment).findMethodsByName("print", true);
        nameToDeclaration.put("java::java.io.PrintStream.print(Object)", (PsiElement)methods[8]);
        nameToDeclaration.put("java::java.io.PrintStream.print(Int)", (PsiElement)methods[2]);
        nameToDeclaration.put("java::java.io.PrintStream.print(char[])", (PsiElement)methods[6]);
        nameToDeclaration.put("java::java.io.PrintStream.print(Double)", (PsiElement)methods[5]);
        PsiField outField = java_lang_System.findFieldByName("out", true);
        Assert.assertNotNull((String)"'out' property wasn't found", (Object)outField);
        nameToDeclaration.put("java::java.lang.System.out", (PsiElement)outField);
        PsiClass java_lang_Number = ExpectedResolveDataUtil.findClass("java.lang.Number", environment);
        nameToDeclaration.put("java::java.lang.Number", (PsiElement)java_lang_Number);
        nameToDeclaration.put("java::java.lang.Number.intValue()", (PsiElement)java_lang_Number.findMethodsByName("intValue", true)[0]);
        HashMap<String, PsiElement> hashMap = nameToDeclaration;
        if (hashMap == null) {
            ExpectedResolveDataUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private static PsiElement findPackage(String qualifiedName, Project project) {
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage javaFacadePackage = javaFacade.findPackage(qualifiedName);
        Assert.assertNotNull((String)("Package wasn't found: " + qualifiedName), (Object)javaFacadePackage);
        PsiPackage psiPackage = javaFacadePackage;
        if (psiPackage == null) {
            ExpectedResolveDataUtil.$$$reportNull$$$0(4);
        }
        return psiPackage;
    }

    @NotNull
    private static PsiMethod findMethod(PsiClass psiClass, String name) {
        PsiMethod[] emptyLists = psiClass.findMethodsByName(name, true);
        PsiMethod psiMethod = emptyLists[0];
        if (psiMethod == null) {
            ExpectedResolveDataUtil.$$$reportNull$$$0(5);
        }
        return psiMethod;
    }

    @NotNull
    private static PsiClass findClass(String qualifiedName, KotlinCoreEnvironment environment) {
        ModuleDescriptor module2 = JvmResolveUtil.analyze(environment).getModuleDescriptor();
        ClassDescriptor classDescriptor = DescriptorUtilsKt.resolveTopLevelClass((ModuleDescriptor)module2, (FqName)new FqName(qualifiedName), (LookupLocation)NoLookupLocation.FROM_TEST);
        Assert.assertNotNull((String)("Class descriptor wasn't resolved: " + qualifiedName), (Object)classDescriptor);
        PsiClass psiClass = (PsiClass)DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)classDescriptor);
        Assert.assertNotNull((String)("Class declaration wasn't found: " + classDescriptor), (Object)psiClass);
        PsiClass psiClass2 = psiClass;
        if (psiClass2 == null) {
            ExpectedResolveDataUtil.$$$reportNull$$$0(6);
        }
        return psiClass2;
    }

    @NotNull
    private static FunctionDescriptor standardFunction(ClassDescriptor classDescriptor, String name, Project project, KotlinCoreEnvironment environment, KotlinType ... parameterTypes) {
        ModuleDescriptorImpl emptyModule = KotlinTestUtils.createEmptyModule();
        ContainerForTests container2 = InjectionKt.createContainerForTests(project, (ModuleDescriptor)emptyModule);
        emptyModule.setDependencies(new ModuleDescriptorImpl[]{emptyModule});
        emptyModule.initialize((PackageFragmentProvider)PackageFragmentProvider.Empty.INSTANCE);
        LexicalScopeImpl lexicalScope = new LexicalScopeImpl((HierarchicalScope)ImportingScope.Empty.INSTANCE, (DeclarationDescriptor)classDescriptor, false, classDescriptor.getThisAsReceiverParameter(), LexicalScopeKind.SYNTHETIC);
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)environment.getConfiguration());
        ExpressionTypingContext context = ExpressionTypingContext.newContext((BindingTrace)new BindingTraceContext(), (LexicalScope)lexicalScope, (DataFlowInfo)DataFlowInfoFactory.EMPTY, (KotlinType)TypeUtils.NO_EXPECTED_TYPE, (LanguageVersionSettings)languageVersionSettings, (DataFlowValueFactory)container2.getDataFlowValueFactory());
        KtExpression callElement = KtPsiFactoryKt.KtPsiFactory((Project)project).createExpression(name);
        TemporaryBindingTrace traceWithFakeArgumentInfo = TemporaryBindingTrace.create((BindingTrace)context.trace, (String)"trace to store fake argument for", (Object)name);
        ArrayList<KtExpression> fakeArguments = new ArrayList<KtExpression>(parameterTypes.length);
        for (KotlinType type : parameterTypes) {
            fakeArguments.add(ExpressionTypingUtils.createFakeExpressionOfType((Project)project, (BindingTrace)traceWithFakeArgumentInfo, (String)("fakeArgument" + fakeArguments.size()), (KotlinType)type));
        }
        OverloadResolutionResults functions = container2.getFakeCallResolver().resolveFakeCall((ResolutionContext)context, null, Name.identifier((String)name), callElement, callElement, FakeCallKind.OTHER, fakeArguments);
        for (ResolvedCall resolvedCall : functions.getResultingCalls()) {
            List unsubstitutedValueParameters = ((FunctionDescriptor)resolvedCall.getResultingDescriptor()).getValueParameters();
            int unsubstitutedValueParametersSize = unsubstitutedValueParameters.size();
            for (int i = 0; i < unsubstitutedValueParametersSize; ++i) {
                ValueParameterDescriptor unsubstitutedValueParameter = (ValueParameterDescriptor)unsubstitutedValueParameters.get(i);
                if (!unsubstitutedValueParameter.getType().equals((Object)parameterTypes[i])) continue;
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
                if (functionDescriptor == null) {
                    ExpectedResolveDataUtil.$$$reportNull$$$0(7);
                }
                return functionDescriptor;
            }
        }
        throw new IllegalArgumentException("Not found: kotlin::" + classDescriptor.getName() + "." + name + "(" + Arrays.toString(parameterTypes) + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/ExpectedResolveDataUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/ExpectedResolveDataUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDefaultNameToDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareDefaultNameToDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "standardFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareDefaultNameToDescriptors";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareDefaultNameToDeclaration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

