/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ErrorTypeReport;
import org.jetbrains.kotlin.fir.FirResolveBench;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.RTableContext;
import org.jetbrains.kotlin.fir.TableTimeUnit;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.resolve.transformers.FirResolveProcessor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a@\u0010\u0005\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t\u001a\u0016\u0010\f\u001a\u00020\u0001*\u00060\rR\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a(\u0010\f\u001a\u00020\u0001*\u00060\rR\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u001a$\u0010\u0017\u001a\u00020\u0001*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a:\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0!2\b\b\u0002\u0010\"\u001a\u00020\u00102\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u0002H \u0012\u0004\u0012\u00020\u001d0$\u001a.\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H 0\u001f\"\u0004\b\u0000\u0010 *\b\u0012\u0004\u0012\u0002H 0!2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\"\u001a\u00020\u0010\u001a\u001a\u0010%\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001d\u001a\u0012\u0010)\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010&\u001a\u00020'\u00a8\u0006*"}, d2={"checkFirProvidersConsistency", "", "firFiles", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "doFirResolveTestBench", "processors", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirResolveProcessor;", "gc", "", "withProgress", "silent", "linePerSecondCell", "Lorg/jetbrains/kotlin/fir/RTableContext$RTableRowContext;", "Lorg/jetbrains/kotlin/fir/RTableContext;", "linePerSec", "", "lines", "", "time", "", "timeUnit", "Lorg/jetbrains/kotlin/fir/TableTimeUnit;", "printMeasureAsTable", "measure", "Lorg/jetbrains/kotlin/fir/FirResolveBench$Measure;", "statistics", "Lorg/jetbrains/kotlin/fir/FirResolveBench$TotalStatistics;", "label", "", "progress", "Lkotlin/sequences/Sequence;", "T", "", "step", "computeLabel", "Lkotlin/Function1;", "report", "stream", "Ljava/io/PrintStream;", "header", "reportErrors", "tests-common"})
public final class FirResolveBenchKt {
    public static final void checkFirProvidersConsistency(@NotNull List<? extends FirFile> firFiles) {
        Object $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
        Iterable $this$groupBy$iv = firFiles;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv22 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            FirFile it = (FirFile)element$iv$iv;
            boolean bl = false;
            FirSession key$iv$iv = it.getSession();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv22;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object object = destination$iv$iv22;
        $i$f$groupBy = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            $this$groupByTo$iv$iv = object = iterator2.next();
            boolean destination$iv$iv22 = false;
            FirSession session = (FirSession)$this$groupByTo$iv$iv.getKey();
            destination$iv$iv22 = object;
            boolean bl = false;
            List files = (List)destination$iv$iv22.getValue();
            FirProviderImpl provider = (FirProviderImpl)MainSessionComponentsKt.getFirProvider((FirSession)session);
            provider.ensureConsistent(files);
        }
    }

    public static final void doFirResolveTestBench(@NotNull List<? extends FirFile> firFiles, @NotNull List<? extends FirResolveProcessor> processors, boolean gc, boolean withProgress, boolean silent) {
        Intrinsics.checkNotNullParameter(firFiles, (String)"firFiles");
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        if (gc) {
            System.gc();
        }
        FirResolveBench bench = new FirResolveBench(withProgress);
        bench.processFiles(firFiles, processors);
        if (!silent) {
            FirResolveBench.TotalStatistics totalStatistics = bench.getTotalStatistics();
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
            FirResolveBenchKt.report(totalStatistics, printStream, "");
        }
        bench.throwFailure();
    }

    public static /* synthetic */ void doFirResolveTestBench$default(List list, List list2, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        FirResolveBenchKt.doFirResolveTestBench(list, list2, bl, bl2, bl3);
    }

    @NotNull
    public static final <T> Sequence<T> progress(@NotNull Collection<? extends T> $this$progress, @NotNull String label, double step) {
        Intrinsics.checkNotNullParameter($this$progress, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return FirResolveBenchKt.progress($this$progress, step, (Function1)new Function1<T, String>(label){
            final /* synthetic */ String $label;
            {
                this.$label = $label;
                super(1);
            }

            @NotNull
            public final String invoke(T it) {
                return this.$label;
            }
        });
    }

    public static /* synthetic */ Sequence progress$default(Collection collection, String string, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.1;
        }
        return FirResolveBenchKt.progress(collection, string, d);
    }

    @NotNull
    public static final <T> Sequence<T> progress(@NotNull Collection<? extends T> $this$progress, double step, @NotNull Function1<? super T, String> computeLabel) {
        Intrinsics.checkNotNullParameter($this$progress, (String)"<this>");
        Intrinsics.checkNotNullParameter(computeLabel, (String)"computeLabel");
        int n = 1;
        int n2 = (int)((double)$this$progress.size() * step);
        boolean bl = false;
        int intStep = Math.max(n, n2);
        Ref.IntRef progress2 = new Ref.IntRef();
        long startTime = System.currentTimeMillis();
        return SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)$this$progress), (Function1)new Function1<T, Unit>(progress2, intStep, startTime, $this$progress, computeLabel){
            final /* synthetic */ Ref.IntRef $progress;
            final /* synthetic */ int $intStep;
            final /* synthetic */ long $startTime;
            final /* synthetic */ Collection<T> $this_progress;
            final /* synthetic */ Function1<T, String> $computeLabel;
            {
                this.$progress = $progress;
                this.$intStep = $intStep;
                this.$startTime = $startTime;
                this.$this_progress = $receiver;
                this.$computeLabel = $computeLabel;
                super(1);
            }

            public final void invoke(T it) {
                if (this.$progress.element % this.$intStep == 0) {
                    long currentTime = System.currentTimeMillis();
                    long elapsed = currentTime - this.$startTime;
                    String eta = this.$progress.element > 0 ? FirResolveBenchKt.access$progress$formatTime((long)((double)(elapsed / (long)this.$progress.element) * 1.0 * (double)(this.$this_progress.size() - this.$progress.element))) : "Unknown";
                    String string = (String)this.$computeLabel.invoke(it) + ": " + this.$progress.element * 100 / this.$this_progress.size() + "% (" + this.$progress.element + '/' + this.$this_progress.size() + "), ETA: " + eta + ", Elapsed: " + FirResolveBenchKt.access$progress$formatTime(elapsed);
                    boolean bl = false;
                    System.out.println((Object)string);
                }
                int n = this.$progress.element;
                this.$progress.element = n + 1;
            }
        });
    }

    public static /* synthetic */ Sequence progress$default(Collection collection, double d, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            d = 0.1;
        }
        return FirResolveBenchKt.progress(collection, d, function1);
    }

    public static final void reportErrors(@NotNull FirResolveBench.TotalStatistics $this$reportErrors, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)$this$reportErrors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Iterable $this$sortedByDescending$iv = $this$reportErrors.getErrorTypesReports().values();
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ErrorTypeReport it = (ErrorTypeReport)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getCount());
                it = (ErrorTypeReport)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getCount();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ErrorTypeReport it = (ErrorTypeReport)element$iv;
            boolean bl2 = false;
            stream.print("" + it.getCount() + ':');
            stream.println(it.getReport());
        }
    }

    public static final void report(@NotNull FirResolveBench.TotalStatistics $this$report, @NotNull PrintStream stream, @NotNull String header) {
        RTableContext.RTableRowContext ctx$iv;
        Intrinsics.checkNotNullParameter((Object)$this$report, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        boolean bl = false;
        boolean bl2 = false;
        PrintStream $this$report_u24lambda_u2d6 = stream;
        boolean bl3 = false;
        $this$report_u24lambda_u2d6.println();
        $this$report_u24lambda_u2d6.println("========== " + header + " ==========");
        $this$report_u24lambda_u2d6.println("Unresolved (untouched) implicit types: " + $this$report.getUnresolvedTypes() + " (" + FirResolveBenchKt.report$lambda-6$percentOf($this$report.getUnresolvedTypes(), $this$report.getTotalTypes()) + ')');
        $this$report_u24lambda_u2d6.println("Resolved types: " + $this$report.getResolvedTypes() + " (" + FirResolveBenchKt.report$lambda-6$percentOf($this$report.getResolvedTypes(), $this$report.getTotalTypes()) + ')');
        $this$report_u24lambda_u2d6.println("Correctly resolved types: " + $this$report.getGoodTypes() + " (" + FirResolveBenchKt.report$lambda-6$percentOf($this$report.getGoodTypes(), $this$report.getResolvedTypes()) + " of resolved)");
        $this$report_u24lambda_u2d6.println("Erroneously resolved types: " + $this$report.getErrorTypes() + " (" + FirResolveBenchKt.report$lambda-6$percentOf($this$report.getErrorTypes(), $this$report.getResolvedTypes()) + " of resolved)");
        $this$report_u24lambda_u2d6.println(Intrinsics.stringPlus((String)"   - unresolved calls: ", (Object)$this$report.getErrorFunctionCallTypes()));
        $this$report_u24lambda_u2d6.println(Intrinsics.stringPlus((String)"   - unresolved q.accesses: ", (Object)$this$report.getErrorQualifiedAccessTypes()));
        $this$report_u24lambda_u2d6.println("Erroneously resolved implicit types: " + $this$report.getImplicitTypes() + " (" + FirResolveBenchKt.report$lambda-6$percentOf($this$report.getImplicitTypes(), $this$report.getResolvedTypes()) + " of resolved)");
        $this$report_u24lambda_u2d6.println(Intrinsics.stringPlus((String)"Unique error types: ", (Object)$this$report.getUniqueErrorTypes()));
        boolean $i$f$printTable = false;
        RTableContext rTableContext = new RTableContext();
        boolean bl4 = false;
        boolean bl5 = false;
        RTableContext $this$report_u24lambda_u2d6_u24lambda_u2d5 = rTableContext;
        boolean bl6 = false;
        RTableContext this_$iv = $this$report_u24lambda_u2d6_u24lambda_u2d5;
        boolean $i$f$row = false;
        RTableContext.RTableRowContext $this$report_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d3 = ctx$iv = new RTableContext.RTableRowContext(this_$iv);
        boolean bl7 = false;
        $this$report_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d3.cell("Stage", $this$report_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d3.getLEFT());
        String[] stringArray = new String[]{"Time", "Time per file", "Files: OK/E/T", "CPU", "User", "GC", "GC count", "L/S"};
        RTableContext.RTableRowContext.cells$default($this$report_u24lambda_u2d6_u24lambda_u2d5_u24lambda_u2d3, stringArray, false, 2, null);
        this_$iv.rowCells(ctx$iv.getRowData());
        $this$report_u24lambda_u2d6_u24lambda_u2d5.separator();
        Map<String, FirResolveBench.Measure> $this$forEach$iv = $this$report.getTimePerTransformer();
        boolean $i$f$forEach = false;
        Map<String, FirResolveBench.Measure> map = $this$forEach$iv;
        boolean bl8 = false;
        Iterator<Map.Entry<String, FirResolveBench.Measure>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, FirResolveBench.Measure> element$iv;
            Map.Entry<String, FirResolveBench.Measure> $dstr$transformer$measure = element$iv = iterator.next();
            boolean bl9 = false;
            Map.Entry<String, FirResolveBench.Measure> entry = $dstr$transformer$measure;
            boolean bl10 = false;
            String transformer = entry.getKey();
            Map.Entry<String, FirResolveBench.Measure> entry2 = $dstr$transformer$measure;
            boolean bl11 = false;
            FirResolveBench.Measure measure = entry2.getValue();
            FirResolveBenchKt.printMeasureAsTable($this$report_u24lambda_u2d6_u24lambda_u2d5, measure, $this$report, transformer);
        }
        Collection collection = $this$report.getTimePerTransformer().keySet();
        boolean bl12 = false;
        if (!collection.isEmpty()) {
            $this$report_u24lambda_u2d6_u24lambda_u2d5.separator();
            FirResolveBenchKt.printMeasureAsTable($this$report_u24lambda_u2d6_u24lambda_u2d5, $this$report.getTotalMeasure(), $this$report, "Total time");
        }
        rTableContext.printout(stream);
    }

    private static final void printMeasureAsTable(RTableContext $this$printMeasureAsTable, FirResolveBench.Measure measure, FirResolveBench.TotalStatistics statistics, String label) {
        RTableContext.RTableRowContext $this$timeCell_u24default$iv;
        RTableContext.RTableRowContext ctx$iv;
        long time = measure.getTime();
        int counter = measure.getFiles();
        RTableContext this_$iv = $this$printMeasureAsTable;
        boolean $i$f$row = false;
        RTableContext.RTableRowContext $this$printMeasureAsTable_u24lambda_u2d7 = ctx$iv = new RTableContext.RTableRowContext(this_$iv);
        boolean bl = false;
        $this$printMeasureAsTable_u24lambda_u2d7.cell(label, $this$printMeasureAsTable_u24lambda_u2d7.getLEFT());
        RTableContext.RTableRowContext rTableRowContext = $this$printMeasureAsTable_u24lambda_u2d7;
        int fractionDigits$iv = 0;
        TableTimeUnit outputUnit$iv = TableTimeUnit.MS;
        TableTimeUnit inputUnit$iv = TableTimeUnit.NS;
        boolean $i$f$timeCell = false;
        DecimalFormat decimalFormat = new DecimalFormat();
        boolean bl2 = false;
        boolean bl3 = false;
        DecimalFormat $this$timeCell_u24lambda_u2d0$iv = decimalFormat;
        boolean bl4 = false;
        $this$timeCell_u24lambda_u2d0$iv.setMaximumFractionDigits(fractionDigits$iv);
        $this$timeCell_u24lambda_u2d0$iv.setGroupingUsed(true);
        DecimalFormat df$iv = decimalFormat;
        RTableContext.RTableRowContext.cell$default($this$timeCell_u24default$iv, df$iv.format(outputUnit$iv.convert(time, inputUnit$iv)) + ' ' + outputUnit$iv.getPostfixText(), false, 2, null);
        $this$timeCell_u24default$iv = $this$printMeasureAsTable_u24lambda_u2d7;
        long time$iv = time / (long)counter;
        TableTimeUnit outputUnit$iv2 = TableTimeUnit.MS;
        TableTimeUnit inputUnit$iv2 = TableTimeUnit.NS;
        int fractionDigits$iv2 = outputUnit$iv2.getFractionDigits();
        boolean $i$f$timeCell2 = false;
        DecimalFormat decimalFormat2 = new DecimalFormat();
        boolean bl5 = false;
        boolean bl6 = false;
        DecimalFormat $this$timeCell_u24lambda_u2d0$iv2 = decimalFormat2;
        $i$a$-apply-TableRenderingKt$timeCell$df$1$iv = false;
        $this$timeCell_u24lambda_u2d0$iv2.setMaximumFractionDigits(fractionDigits$iv2);
        $this$timeCell_u24lambda_u2d0$iv2.setGroupingUsed(true);
        DecimalFormat df$iv2 = decimalFormat2;
        RTableContext.RTableRowContext.cell$default($this$timeCell_u24default$iv, df$iv2.format(outputUnit$iv2.convert(time$iv, inputUnit$iv2)) + ' ' + outputUnit$iv2.getPostfixText(), false, 2, null);
        RTableContext.RTableRowContext.cell$default($this$printMeasureAsTable_u24lambda_u2d7, "" + counter + '/' + (statistics.getFileCount() - counter) + '/' + statistics.getFileCount(), false, 2, null);
        $this$timeCell_u24default$iv = $this$printMeasureAsTable_u24lambda_u2d7;
        time$iv = measure.getCpu();
        fractionDigits$iv2 = 0;
        outputUnit$iv2 = TableTimeUnit.MS;
        inputUnit$iv2 = TableTimeUnit.NS;
        $i$f$timeCell2 = false;
        decimalFormat2 = new DecimalFormat();
        bl5 = false;
        bl6 = false;
        $this$timeCell_u24lambda_u2d0$iv2 = decimalFormat2;
        $i$a$-apply-TableRenderingKt$timeCell$df$1$iv = false;
        $this$timeCell_u24lambda_u2d0$iv2.setMaximumFractionDigits(fractionDigits$iv2);
        $this$timeCell_u24lambda_u2d0$iv2.setGroupingUsed(true);
        df$iv2 = decimalFormat2;
        RTableContext.RTableRowContext.cell$default($this$timeCell_u24default$iv, df$iv2.format(outputUnit$iv2.convert(time$iv, inputUnit$iv2)) + ' ' + outputUnit$iv2.getPostfixText(), false, 2, null);
        $this$timeCell_u24default$iv = $this$printMeasureAsTable_u24lambda_u2d7;
        time$iv = measure.getUser();
        outputUnit$iv2 = TableTimeUnit.MS;
        inputUnit$iv2 = TableTimeUnit.NS;
        fractionDigits$iv2 = outputUnit$iv2.getFractionDigits();
        $i$f$timeCell2 = false;
        decimalFormat2 = new DecimalFormat();
        bl5 = false;
        bl6 = false;
        $this$timeCell_u24lambda_u2d0$iv2 = decimalFormat2;
        $i$a$-apply-TableRenderingKt$timeCell$df$1$iv = false;
        $this$timeCell_u24lambda_u2d0$iv2.setMaximumFractionDigits(fractionDigits$iv2);
        $this$timeCell_u24lambda_u2d0$iv2.setGroupingUsed(true);
        df$iv2 = decimalFormat2;
        RTableContext.RTableRowContext.cell$default($this$timeCell_u24default$iv, df$iv2.format(outputUnit$iv2.convert(time$iv, inputUnit$iv2)) + ' ' + outputUnit$iv2.getPostfixText(), false, 2, null);
        $this$timeCell_u24default$iv = $this$printMeasureAsTable_u24lambda_u2d7;
        time$iv = measure.getGcTime();
        inputUnit$iv2 = TableTimeUnit.MS;
        outputUnit$iv2 = TableTimeUnit.MS;
        fractionDigits$iv2 = outputUnit$iv2.getFractionDigits();
        $i$f$timeCell2 = false;
        decimalFormat2 = new DecimalFormat();
        bl5 = false;
        bl6 = false;
        $this$timeCell_u24lambda_u2d0$iv2 = decimalFormat2;
        $i$a$-apply-TableRenderingKt$timeCell$df$1$iv = false;
        $this$timeCell_u24lambda_u2d0$iv2.setMaximumFractionDigits(fractionDigits$iv2);
        $this$timeCell_u24lambda_u2d0$iv2.setGroupingUsed(true);
        df$iv2 = decimalFormat2;
        RTableContext.RTableRowContext.cell$default($this$timeCell_u24default$iv, df$iv2.format(outputUnit$iv2.convert(time$iv, inputUnit$iv2)) + ' ' + outputUnit$iv2.getPostfixText(), false, 2, null);
        RTableContext.RTableRowContext.cell$default($this$printMeasureAsTable_u24lambda_u2d7, String.valueOf(measure.getGcCollections()), false, 2, null);
        FirResolveBenchKt.linePerSecondCell($this$printMeasureAsTable_u24lambda_u2d7, statistics.getTotalLines(), time, TableTimeUnit.NS);
        this_$iv.rowCells(ctx$iv.getRowData());
    }

    public static final void linePerSecondCell(@NotNull RTableContext.RTableRowContext $this$linePerSecondCell, double linePerSec) {
        Intrinsics.checkNotNullParameter((Object)$this$linePerSecondCell, (String)"<this>");
        DecimalFormat decimalFormat = new DecimalFormat();
        boolean bl = false;
        boolean bl2 = false;
        DecimalFormat $this$linePerSecondCell_u24lambda_u2d8 = decimalFormat;
        boolean bl3 = false;
        $this$linePerSecondCell_u24lambda_u2d8.setMaximumFractionDigits(1);
        $this$linePerSecondCell_u24lambda_u2d8.setGroupingUsed(true);
        DecimalFormat df = decimalFormat;
        RTableContext.RTableRowContext.cell$default($this$linePerSecondCell, df.format(linePerSec), false, 2, null);
    }

    public static final void linePerSecondCell(@NotNull RTableContext.RTableRowContext $this$linePerSecondCell, int lines, long time, @NotNull TableTimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$linePerSecondCell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        double linePerSec = (double)lines / TableTimeUnit.S.convert(time, timeUnit);
        FirResolveBenchKt.linePerSecondCell($this$linePerSecondCell, linePerSec);
    }

    public static /* synthetic */ void linePerSecondCell$default(RTableContext.RTableRowContext rTableRowContext, int n, long l, TableTimeUnit tableTimeUnit, int n2, Object object) {
        if ((n2 & 4) != 0) {
            tableTimeUnit = TableTimeUnit.NS;
        }
        FirResolveBenchKt.linePerSecondCell(rTableRowContext, n, l, tableTimeUnit);
    }

    private static final String progress$formatTime(long $this$progress_u24formatTime) {
        return $this$progress_u24formatTime < 1000L ? $this$progress_u24formatTime + "ms" : ($this$progress_u24formatTime < 60000L ? $this$progress_u24formatTime / (long)1000 + "s " + $this$progress_u24formatTime % (long)1000 + "ms" : $this$progress_u24formatTime / (long)60000 + "m " + $this$progress_u24formatTime % (long)60000 / (long)1000 + "s " + $this$progress_u24formatTime % (long)60000 % (long)1000 + "ms");
    }

    private static final String report$lambda-6$percentOf(int $this$report_u24lambda_u2d6_u24percentOf, int other) {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.1f%%";
        Object[] objectArray = new Object[]{(double)$this$report_u24lambda_u2d6_u24percentOf * 100.0 / (double)other};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public static final /* synthetic */ String access$progress$formatTime(long $receiver) {
        return FirResolveBenchKt.progress$formatTime($receiver);
    }
}

