/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.KotlinTestUtils;

public class TestCheckerUtil {
    @NotNull
    public static KtFile createCheckAndReturnPsiFile(@NotNull String fileName, @NotNull String text, @NotNull Project project) {
        if (fileName == null) {
            TestCheckerUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            TestCheckerUtil.$$$reportNull$$$0(1);
        }
        if (project == null) {
            TestCheckerUtil.$$$reportNull$$$0(2);
        }
        KtFile myFile = KotlinTestUtils.createFile(fileName, text, project);
        TestCheckerUtil.ensureParsed((PsiFile)myFile);
        TestCase.assertEquals((String)"light virtual file text mismatch", (String)text, (String)((LightVirtualFile)myFile.getVirtualFile()).getContent().toString());
        TestCase.assertEquals((String)"virtual file text mismatch", (Object)text, (Object)LoadTextUtil.loadText((VirtualFile)myFile.getVirtualFile()));
        TestCase.assertEquals((String)"doc text mismatch", (String)text, (String)myFile.getViewProvider().getDocument().getText());
        TestCase.assertEquals((String)"psi text mismatch", (String)text, (String)myFile.getText());
        KtFile ktFile = myFile;
        if (ktFile == null) {
            TestCheckerUtil.$$$reportNull$$$0(3);
        }
        return ktFile;
    }

    private static void ensureParsed(PsiFile file) {
        file.accept(new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/TestCheckerUtil$1", "visitElement"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/checkers/TestCheckerUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/checkers/TestCheckerUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckAndReturnPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCheckAndReturnPsiFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

