/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.PsiClassRenderer;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\rH\u0002J8\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\rJ\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/asJava/LightClassTestCommon;", "", "()V", "NOT_GENERATED_DIRECTIVE", "", "SUBJECT_FQ_NAME_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "actualText", "fqName", "lightClass", "Lcom/intellij/psi/PsiClass;", "normalizeText", "Lkotlin/Function1;", "getActualLightClassText", "testDataFile", "Ljava/io/File;", "findLightClass", "removeEmptyDefaultImpls", "text", "tests-common"})
public final class LightClassTestCommon {
    @NotNull
    public static final LightClassTestCommon INSTANCE = new LightClassTestCommon();
    private static final Pattern SUBJECT_FQ_NAME_PATTERN = Pattern.compile("^//\\s*(.*)$", 8);
    @NotNull
    private static final String NOT_GENERATED_DIRECTIVE = "// NOT_GENERATED";

    private LightClassTestCommon() {
    }

    @NotNull
    public final String getActualLightClassText(@NotNull File testDataFile, @NotNull Function1<? super String, ? extends PsiClass> findLightClass2, @NotNull Function1<? super String, String> normalizeText) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(findLightClass2, (String)"findLightClass");
        Intrinsics.checkNotNullParameter(normalizeText, (String)"normalizeText");
        String string = FileUtil.loadFile((File)testDataFile, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(testDataFile, true)");
        String text = string;
        Matcher matcher = SUBJECT_FQ_NAME_PATTERN.matcher(text);
        TestCase.assertTrue((String)"No FqName specified. First line of the form '// f.q.Name' expected", (boolean)matcher.find());
        String fqName = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"fqName");
        PsiClass lightClass = (PsiClass)findLightClass2.invoke((Object)fqName);
        return this.actualText(fqName, lightClass, normalizeText);
    }

    private final String actualText(String fqName, PsiClass lightClass, Function1<? super String, String> normalizeText) {
        if (lightClass == null) {
            return NOT_GENERATED_DIRECTIVE;
        }
        TestCase.assertTrue((String)("Not a light class: " + lightClass + " (" + fqName + ')'), (boolean)(lightClass instanceof KtLightClass));
        return (String)normalizeText.invoke((Object)PsiClassRenderer.INSTANCE.renderClass(lightClass, true));
    }

    @NotNull
    public final String removeEmptyDefaultImpls(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.replace$default((String)text, (String)"\n    static final class DefaultImpls {\n    }\n", (String)"", (boolean)false, (int)4, null);
    }
}

