/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.TestHelperGeneratorKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.test.TargetBackend;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"createTextForCodegenTestHelpers", "", "backend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "createTextForCoroutineHelpers", "isReleaseCoroutines", "", "checkStateMachine", "checkTailCallOptimization", "tests-common"})
public final class TestHelperGeneratorKt {
    @NotNull
    public static final String createTextForCoroutineHelpers(boolean isReleaseCoroutines, boolean checkStateMachine, boolean checkTailCallOptimization) {
        String string = isReleaseCoroutines ? StandardNames.COROUTINES_PACKAGE_FQ_NAME_RELEASE.asString() : StandardNames.COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (isReleaseCoroutines)\n            StandardNames.COROUTINES_PACKAGE_FQ_NAME_RELEASE.asString()\n        else\n            StandardNames.COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.asString()");
        String coroutinesPackage = string;
        String handleExceptionContinuationBody = isReleaseCoroutines ? "override fun resumeWith(result: Result<Any?>) {\n   result.exceptionOrNull()?.let(x)\n}" : "override fun resumeWithException(exception: Throwable) {\n   x(exception)\n}\n\noverride fun resume(data: Any?) {}";
        String continuationAdapterBody = isReleaseCoroutines ? "override fun resumeWith(result: Result<T>) {\n   if (result.isSuccess) {\n       resume(result.getOrThrow())\n   } else {\n       resumeWithException(result.exceptionOrNull()!!)\n   }\n}\n\nabstract fun resumeWithException(exception: Throwable)\nabstract fun resume(value: T)" : "";
        String checkStateMachineString = "class StateMachineCheckerClass {\n    private var counter = 0\n    var finished = false\n\n    var proceed: () -> Unit = {}\n\n    fun reset() {\n        counter = 0\n        finished = false\n        proceed = {}\n    }\n\n    suspend fun suspendHere() = suspendCoroutine<Unit> { c ->\n        counter++\n        proceed = { c.resume(Unit) }\n    }\n\n    fun check(numberOfSuspensions: Int, checkFinished: Boolean = true) {\n        for (i in 1..numberOfSuspensions) {\n            if (counter != i) error(\"Wrong state-machine generated: suspendHere should be called exactly once in one state. Expected \" + i + \", got \" + counter)\n            proceed()\n        }\n        if (counter != numberOfSuspensions)\n            error(\"Wrong state-machine generated: wrong number of overall suspensions. Expected \" + numberOfSuspensions + \", got \" + counter)\n        if (finished) error(\"Wrong state-machine generated: it is finished early\")\n        proceed()\n        if (checkFinished && !finished) error(\"Wrong state-machine generated: it is not finished yet\")\n    }\n}\nval StateMachineChecker = StateMachineCheckerClass()\nobject CheckStateMachineContinuation: ContinuationAdapter<Unit>() {\n    override val context: CoroutineContext\n        get() = EmptyCoroutineContext\n\n    override fun resume(value: Unit) {\n        StateMachineChecker.proceed = {\n            StateMachineChecker.finished = true\n        }\n    }\n\n    override fun resumeWithException(exception: Throwable) {\n        throw exception\n    }\n}";
        String checkTailCallOptimizationString = "class TailCallOptimizationCheckerClass {\n    private val stackTrace = arrayListOf<StackTraceElement?>()\n\n    suspend fun saveStackTrace() = suspendCoroutineUninterceptedOrReturn<Unit> {\n        saveStackTrace(it)\n    }\n\n    fun saveStackTrace(c: Continuation<*>) {\n        if (c !is CoroutineStackFrame) error(\"Continuation \" + c + \" is not subtype of CoroutineStackFrame\")\n        stackTrace.clear()\n        var csf: CoroutineStackFrame? = c\n        while (csf != null) {\n            stackTrace.add(csf.getStackTraceElement())\n            csf = csf.callerFrame\n        }\n    }\n\n    fun checkNoStateMachineIn(method: String) {\n        stackTrace.find { it?.methodName?.startsWith(method) == true }?.let { error(\"tail-call optimization miss: method at \" + it + \" has state-machine \" +\n            stackTrace.joinToString(separator = \"\\n\")) }\n    }\n\n    fun checkStateMachineIn(method: String) {\n        stackTrace.find { it?.methodName?.startsWith(method) == true } ?: error(\"tail-call optimization hit: method \" + method + \" has no state-machine \" +\n            stackTrace.joinToString(separator = \"\\n\"))\n    }\n}\n\nval TailCallOptimizationChecker = TailCallOptimizationCheckerClass()";
        return StringsKt.trimMargin$default((String)("\n            |package helpers\n            |import " + coroutinesPackage + ".*\n            |import " + coroutinesPackage + ".intrinsics.*\n            |" + (checkTailCallOptimization ? "import " + coroutinesPackage + ".jvm.internal.*" : "") + "\n            |\n            |fun <T> handleResultContinuation(x: (T) -> Unit): Continuation<T> = object: Continuation<T> {\n            |    override val context = EmptyCoroutineContext\n            |    " + TestHelperGeneratorKt.createTextForCoroutineHelpers$continuationBody(isReleaseCoroutines, "T", (Function1<? super String, String>)((Function1)createTextForCoroutineHelpers.1.INSTANCE)) + "\n            |}\n            |\n            |fun handleExceptionContinuation(x: (Throwable) -> Unit): Continuation<Any?> = object: Continuation<Any?> {\n            |    override val context = EmptyCoroutineContext\n            |    " + handleExceptionContinuationBody + "\n            |}\n            |\n            |open class EmptyContinuation(override val context: CoroutineContext = EmptyCoroutineContext) : Continuation<Any?> {\n            |    companion object : EmptyContinuation()\n            |    " + TestHelperGeneratorKt.createTextForCoroutineHelpers$continuationBody(isReleaseCoroutines, "Any?", (Function1<? super String, String>)((Function1)createTextForCoroutineHelpers.2.INSTANCE)) + "\n            |}\n            |\n            |class ResultContinuation : Continuation<Any?> {\n            |    override val context = EmptyCoroutineContext\n            |    " + TestHelperGeneratorKt.createTextForCoroutineHelpers$continuationBody(isReleaseCoroutines, "Any?", (Function1<? super String, String>)((Function1)createTextForCoroutineHelpers.3.INSTANCE)) + "\n            |\n            |    var result: Any? = null\n            |}\n            |\n            |abstract class ContinuationAdapter<in T> : Continuation<T> {\n            |    override val context: CoroutineContext = EmptyCoroutineContext\n            |    " + continuationAdapterBody + "\n            |}\n            |\n            |" + (checkStateMachine ? checkStateMachineString : "") + "\n            |" + (checkTailCallOptimization ? checkTailCallOptimizationString : "") + "\n        "), null, (int)1, null);
    }

    @NotNull
    public static final String createTextForCodegenTestHelpers(@NotNull TargetBackend backend) {
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        return StringsKt.trimMargin$default((String)("\n        |package helpers\n        |\n        |fun isIR() = " + backend.isIR() + "\n    "), null, (int)1, null);
    }

    private static final String createTextForCoroutineHelpers$continuationBody(boolean $isReleaseCoroutines, String t, Function1<? super String, String> useResult) {
        return $isReleaseCoroutines ? StringsKt.trimMargin$default((String)("\n                |override fun resumeWith(result: Result<" + t + ">) {\n                |   " + (String)useResult.invoke((Object)"result.getOrThrow()") + "\n                |}\n            "), null, (int)1, null) : StringsKt.trimMargin$default((String)("\n                |override fun resume(data: " + t + ") { " + (String)useResult.invoke((Object)"data") + " }\n                |override fun resumeWithException(exception: Throwable) { throw exception }\n            "), null, (int)1, null);
    }
}

