/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.JvmFileClassInfo;
import org.jetbrains.kotlin.psi.psiUtil.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.psi.psiUtil.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.psi.psiUtil.PackagePartClassUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/JvmFileClassUtil;", "", "<init>", "()V", "MULTIFILE_PART_NAME_DELIMITER", "", "JVM_PACKAGE_NAME_SHORT", "JVM_MULTIFILE_CLASS_SHORT", "JVM_NAME_SHORT", "manglePartName", "facadeName", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getFileClassInfoNoResolve", "Lorg/jetbrains/kotlin/psi/psiUtil/JvmFileClassInfo;", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/psiUtil/JvmFileClassUtil$ParsedJvmFileClassAnnotations;", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "shortName", "getLiteralStringFromAnnotation", "annotation", "getLiteralStringEntryFromAnnotation", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "ParsedJvmFileClassAnnotations", "psi-impl"})
@SourceDebugExtension(value={"SMAP\nJvmFileClassUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFileClassUtil.kt\norg/jetbrains/kotlin/psi/psiUtil/JvmFileClassUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1#2:82\n296#3,2:83\n*S KotlinDebug\n*F\n+ 1 JvmFileClassUtil.kt\norg/jetbrains/kotlin/psi/psiUtil/JvmFileClassUtil\n*L\n60#1:83,2\n*E\n"})
public final class JvmFileClassUtil {
    @NotNull
    public static final JvmFileClassUtil INSTANCE = new JvmFileClassUtil();

    private JvmFileClassUtil() {
    }

    private final String manglePartName(String facadeName, KtFile file) {
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(file);
    }

    @NotNull
    public final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ParsedJvmFileClassAnnotations parsedAnnotations = this.parseJvmNameOnFileNoResolve(file);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file.getPackageFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string = parsedAnnotations.getJvmName();
            if (string == null) {
                string = PackagePartClassUtils.getFilePartShortName(file);
            }
            String simpleName = string;
            Name name2 = Name.identifier(simpleName);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            FqName facadeClassFqName = ((FqName)packageFqName).child(name2);
            if (parsedAnnotations.isMultifileClass()) {
                Name name3 = Name.identifier(this.manglePartName(simpleName, file));
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(((FqName)packageFqName).child(name3), facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, file), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     */
    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file) {
        jvmNameAnnotation = this.findAnnotationEntryOnFileNoResolve(file, "JvmName");
        v0 = jvmNameAnnotation;
        if (v0 == null) ** GOTO lbl-1000
        p0 = v0;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v1 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
        v0 = v1;
        if (v1 != null) {
            p0 = var5_6 = v0;
            $i$a$-takeIf-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v2 = Name.isValidIdentifier((String)p0) ? var5_6 : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 = jvmName = null;
        }
        if ((v3 = (jvmPackageNameAnnotation = this.findAnnotationEntryOnFileNoResolve(file, "JvmPackageName"))) == null) ** GOTO lbl-1000
        p0 = v3;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v4 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
        v3 = v4;
        if (v4 != null) {
            p0 = v3;
            $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v5 = new FqName((String)p0);
        } else lbl-1000:
        // 2 sources

        {
            v5 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = this.findAnnotationEntryOnFileNoResolve(file, "JvmMultifileClass") != null;
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    private final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(KtFile file, String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Object object = file.getFileAnnotationList();
        if (object != null && (object = ((KtFileAnnotationList)object).getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    KtExpression ktExpression = it.getCalleeExpression();
                    if (!Intrinsics.areEqual((Object)(ktExpression != null && (ktExpression = ((KtConstructorCalleeExpression)ktExpression).getConstructorReferenceExpression()) != null ? ktExpression.getReferencedName() : null), (Object)shortName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    private final String getLiteralStringFromAnnotation(KtAnnotationEntry annotation) {
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = this.getLiteralStringEntryFromAnnotation(annotation);
        return ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
    }

    private final KtLiteralStringTemplateEntry getLiteralStringEntryFromAnnotation(KtAnnotationEntry annotation) {
        Object object;
        block4: {
            block3: {
                KtExpression ktExpression;
                List<? extends ValueArgument> list = annotation.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getValueArguments(...)");
                object = (ValueArgument)CollectionsKt.firstOrNull(list);
                if (object == null) break block3;
                ValueArgument $this$getLiteralStringEntryFromAnnotation_u24lambda_u240 = object;
                boolean bl = false;
                KtStringTemplateExpression ktStringTemplateExpression = $this$getLiteralStringEntryFromAnnotation_u24lambda_u240 instanceof KtValueArgument ? ((KtValueArgument)$this$getLiteralStringEntryFromAnnotation_u24lambda_u240).getStringTemplateExpression() : ((ktExpression = $this$getLiteralStringEntryFromAnnotation_u24lambda_u240.getArgumentExpression()) instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null);
                object = ktStringTemplateExpression;
                if (ktStringTemplateExpression != null) break block4;
            }
            return null;
        }
        Object stringTemplateExpression = object;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)stringTemplateExpression).getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object object2 = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        return object2 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object2 : null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/JvmFileClassUtil$ParsedJvmFileClassAnnotations;", "", "jvmName", "", "jvmPackageName", "Lorg/jetbrains/kotlin/name/FqName;", "isMultifileClass", "", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;Z)V", "getJvmName", "()Ljava/lang/String;", "getJvmPackageName", "()Lorg/jetbrains/kotlin/name/FqName;", "()Z", "psi-impl"})
    private static final class ParsedJvmFileClassAnnotations {
        @Nullable
        private final String jvmName;
        @Nullable
        private final FqName jvmPackageName;
        private final boolean isMultifileClass;

        public ParsedJvmFileClassAnnotations(@Nullable String jvmName, @Nullable FqName jvmPackageName, boolean isMultifileClass) {
            this.jvmName = jvmName;
            this.jvmPackageName = jvmPackageName;
            this.isMultifileClass = isMultifileClass;
        }

        @Nullable
        public final String getJvmName() {
            return this.jvmName;
        }

        @Nullable
        public final FqName getJvmPackageName() {
            return this.jvmPackageName;
        }

        public final boolean isMultifileClass() {
            return this.isMultifileClass;
        }
    }
}

