/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.KtSourceElementOffsetStrategy;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConePostponedInferenceDiagnostic;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001ar\u0010\b\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n0\tj\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00012\"\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n`\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0000\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u00172\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0018\u001a\u00020\u0014*\u00020\u00192\u0006\u0010\f\u001a\u00020\r\"*\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0000\u001a\u00020\u00018\u00c0\u0002@\u00c0\u0002X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resultType", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "getResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "setResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "remapArgumentsWithVararg", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lkotlin/collections/LinkedHashMap;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "varargParameter", "varargArrayType", "argumentMapping", "argumentList", "", "writeResultType", "", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "expectedConeType", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "replaceReturnTypeIfNotExhaustive", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "resolve"})
@SourceDebugExtension(value={"SMAP\nBodyResolveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n+ 2 FirVarargArgumentsExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirVarargArgumentsExpressionBuilderKt\n+ 3 FirSpreadArgumentExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSpreadArgumentExpressionBuilderKt\n*L\n1#1,172:1\n32#1,2:175\n32#1,2:177\n49#2:173\n56#3:174\n*S KotlinDebug\n*F\n+ 1 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n*L\n129#1:175,2\n169#1:177,2\n62#1:173\n77#1:174\n*E\n"})
public final class BodyResolveUtilsKt {
    @NotNull
    public static final ConeKotlinType getResultType(@NotNull FirExpression $this$resultType) {
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"<this>");
        boolean $i$f$getResultType = false;
        return FirTypeUtilsKt.getResolvedType($this$resultType);
    }

    public static final void setResultType(@NotNull FirExpression $this$resultType, @NotNull ConeKotlinType type) {
        Intrinsics.checkNotNullParameter((Object)$this$resultType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$setResultType = false;
        $this$resultType.replaceConeTypeOrNull(type);
    }

    @NotNull
    public static final LinkedHashMap<FirExpression, FirValueParameter> remapArgumentsWithVararg(@NotNull FirSession session, @NotNull FirValueParameter varargParameter, @NotNull ConeKotlinType varargArrayType, @NotNull LinkedHashMap<FirExpression, FirValueParameter> argumentMapping2, @NotNull List<? extends FirExpression> argumentList) {
        FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
        Object object;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)varargParameter, (String)"varargParameter");
        Intrinsics.checkNotNullParameter((Object)varargArrayType, (String)"varargArrayType");
        Intrinsics.checkNotNullParameter(argumentMapping2, (String)"argumentMapping");
        Intrinsics.checkNotNullParameter(argumentList, (String)"argumentList");
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default(varargArrayType, false, 1, null);
        Object varargElementType = coneKotlinType != null && (object = ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType$default(coneKotlinType, null, 1, null)) != null ? TypeUtilsKt.removeAnnotations(object) : null;
        object = TypeComponentsKt.getTypeContext(session);
        AbstractConeSubstitutor annotationsRemovingSubstitutor2 = new AbstractConeSubstitutor((ConeInferenceContext)object){

            public ConeKotlinType substituteType(ConeKotlinType type) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                if (!(type instanceof ConeClassLikeType)) {
                    return null;
                }
                if (!ConeBuiltinTypeUtilsKt.isNonPrimitiveArray(type)) {
                    return null;
                }
                ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.singleOrNull((Object[])type.getTypeArguments());
                if (coneTypeProjection == null) {
                    return null;
                }
                ConeTypeProjection argument = coneTypeProjection;
                ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(argument);
                if (coneKotlinType == null || (coneKotlinType = TypeUtilsKt.removeAnnotations(coneKotlinType)) == null) {
                    return null;
                }
                ConeTypeProjection newArgument = ConeTypeProjectionKt.replaceType(argument, coneKotlinType);
                ConeTypeProjection[] coneTypeProjectionArray = new ConeTypeProjection[]{newArgument};
                return ConeTypeUtilsKt.withArguments((ConeClassLikeType)type, coneTypeProjectionArray);
            }
        };
        ConeKotlinType varargArrayType2 = annotationsRemovingSubstitutor2.substituteOrSelf(varargArrayType);
        int indexAfterVarargs = 0;
        indexAfterVarargs = argumentList.size();
        LinkedHashMap<FirExpression, FirValueParameter> newArgumentMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        boolean $i$f$buildVarargArgumentsExpression = false;
        FirVarargArgumentsExpressionBuilder $this$remapArgumentsWithVararg_u24lambda_u240 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
        boolean bl = false;
        $this$remapArgumentsWithVararg_u24lambda_u240.setConeElementTypeOrNull((ConeKotlinType)varargElementType);
        $this$remapArgumentsWithVararg_u24lambda_u240.setConeTypeOrNull(varargArrayType2);
        KtSourceElement firstVarargElementSource = null;
        KtSourceElement lastVarargElementSource = null;
        Iterator iterator2 = ((Iterable)argumentList).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i2 = n2++;
            FirExpression arg = (FirExpression)iterator2.next();
            FirValueParameter valueParameter2 = argumentMapping2.get(arg);
            if (valueParameter2 == null) {
                ((Map)newArgumentMapping).put(arg, null);
                continue;
            }
            if (Intrinsics.areEqual((Object)valueParameter2, (Object)varargParameter) || valueParameter2.isVararg() && !(arg instanceof FirNamedArgumentExpression)) {
                FirExpression firExpression;
                Collection collection = $this$remapArgumentsWithVararg_u24lambda_u240.getArguments();
                if (arg instanceof FirNamedArgumentExpression) {
                    FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder;
                    boolean $i$f$buildSpreadArgumentExpression = false;
                    FirSpreadArgumentExpressionBuilder $this$remapArgumentsWithVararg_u24lambda_u240_u240 = firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
                    boolean bl2 = false;
                    $this$remapArgumentsWithVararg_u24lambda_u240_u240.setSource(((FirNamedArgumentExpression)arg).getSource());
                    $this$remapArgumentsWithVararg_u24lambda_u240_u240.setExpression(((FirNamedArgumentExpression)arg).getExpression());
                    $this$remapArgumentsWithVararg_u24lambda_u240_u240.setNamed(true);
                    $this$remapArgumentsWithVararg_u24lambda_u240_u240.setFakeSpread(!((FirNamedArgumentExpression)arg).isSpread());
                    firExpression = firSpreadArgumentExpressionBuilder.build();
                } else {
                    firExpression = arg;
                }
                FirExpression firExpression2 = firExpression;
                collection.add(firExpression2);
                if (firstVarargElementSource == null) {
                    firstVarargElementSource = arg.getSource();
                }
                lastVarargElementSource = arg.getSource();
                continue;
            }
            if ($this$remapArgumentsWithVararg_u24lambda_u240.getArguments().isEmpty()) {
                ((Map)newArgumentMapping).put(arg, valueParameter2);
                continue;
            }
            indexAfterVarargs = i2;
            break;
        }
        KtSourceElementOffsetStrategy strategy = firstVarargElementSource != null && lastVarargElementSource != null ? (KtSourceElementOffsetStrategy)new KtSourceElementOffsetStrategy.Custom.Delegated(firstVarargElementSource, lastVarargElementSource) : (KtSourceElementOffsetStrategy)KtSourceElementOffsetStrategy.Default.INSTANCE;
        KtSourceElement ktSourceElement = firstVarargElementSource;
        $this$remapArgumentsWithVararg_u24lambda_u240.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.VarargArgument.INSTANCE, strategy) : null);
        FirVarargArgumentsExpression varargArgument = firVarargArgumentsExpressionBuilder.build();
        ((Map)newArgumentMapping).put(varargArgument, varargParameter);
        int n3 = argumentList.size();
        for (int i3 = indexAfterVarargs; i3 < n3; ++i3) {
            FirExpression arg = argumentList.get(i3);
            ((Map)newArgumentMapping).put(arg, argumentMapping2.get(arg));
        }
        return newArgumentMapping;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeResultType(@NotNull FirBlock $this$writeResultType, @NotNull FirSession session) {
        void type$iv;
        void $this$resultType$iv;
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$writeResultType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = CollectionsKt.lastOrNull($this$writeResultType.getStatements());
        FirExpression resultExpression = object instanceof FirExpression ? (FirExpression)object : null;
        object = $this$writeResultType;
        if (resultExpression == null) {
            coneKotlinType = session.getBuiltinTypes().getUnitType().getConeType();
        } else {
            coneKotlinType = resultExpression.getConeTypeOrNull();
            if (coneKotlinType == null) {
                coneKotlinType = new ConeErrorType(ConePostponedInferenceDiagnostic.INSTANCE, false, null, null, null, null, null, 126, null);
            }
        }
        ConeKotlinType coneKotlinType2 = coneKotlinType;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull((ConeKotlinType)type$iv);
    }

    @NotNull
    public static final ConeKotlinType expectedConeType(@NotNull ConstantValueKind $this$expectedConeType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$expectedConeType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConstantValueKind constantValueKind = $this$expectedConeType;
        if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Null.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getNullableNothingType().getConeType();
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getBooleanType().getConeType();
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getChar(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getByte(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getShort(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getLong(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getString(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getFloat(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getDouble(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUByte(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUShort(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getULong(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else {
            if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Error.INSTANCE)) {
                throw new IllegalStateException("Unexpected error ConstantValueKind".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    public static final void replaceReturnTypeIfNotExhaustive(@NotNull FirWhenExpression $this$replaceReturnTypeIfNotExhaustive, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceReturnTypeIfNotExhaustive, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (!ExhaustivenessStatusKt.isProperlyExhaustive($this$replaceReturnTypeIfNotExhaustive) && !$this$replaceReturnTypeIfNotExhaustive.getUsedAsExpression()) {
            void $this$resultType$iv;
            FirExpression firExpression = $this$replaceReturnTypeIfNotExhaustive;
            ConeKotlinType type$iv = session.getBuiltinTypes().getUnitType().getConeType();
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceConeTypeOrNull(type$iv);
        }
    }

    private static final ConeKotlinType expectedConeType$constructLiteralType(FirSession $session, ClassId classId, boolean isNullable) {
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($session).getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null) {
            return new ConeErrorType(new ConeSimpleDiagnostic("Missing stdlib class: " + classId, DiagnosticKind.MissingStdlibClass), false, null, null, null, null, null, 126, null);
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        return TypeConstructionUtilsKt.constructClassType$default(symbol.toLookupTag(), null, false, null, 7, null);
    }

    static /* synthetic */ ConeKotlinType expectedConeType$constructLiteralType$default(FirSession firSession, ClassId classId, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return BodyResolveUtilsKt.expectedConeType$constructLiteralType(firSession, classId, bl);
    }
}

