/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.DfaType;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0017*\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\u0019\u001a\u00020\u000b*\u0006\u0012\u0002\b\u00030\u00182\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u001a2\u0006\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "computeMissingCases", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "inferVariantsFromSubjectSmartCast", "subject", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "data", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker$Info;", "collectAllSubclasses", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "collectAllSubclassesTo", "", "visited", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Info", "ConditionChecker", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,684:1\n12#2:685\n12#2:699\n3347#3,4:686\n3351#3,6:692\n1915#3,2:700\n86#4:690\n37#5:691\n1#6:698\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker\n*L\n418#1:685\n579#1:699\n438#1:686,4\n438#1:692,6\n584#1:700,2\n438#1:690\n438#1:691\n*E\n"})
final class WhenOnSealedClassExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnSealedClassExhaustivenessChecker INSTANCE = new WhenOnSealedClassExhaustivenessChecker();

    private WhenOnSealedClassExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Modality modality;
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = ToSymbolUtilsKt.toRegularClassSymbol(subjectType, session);
        if (object != null && (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) != null) {
            FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)object;
            boolean $i$f$getModality = false;
            modality = $this$modality$iv.getStatus().getModality();
        } else {
            modality = null;
        }
        return modality == Modality.SEALED;
    }

    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol(subjectType, session);
        if (firClassSymbol == null || (firClassSymbol = this.collectAllSubclasses(firClassSymbol, session)) == null) {
            return;
        }
        FirClassSymbol<?> allSubclasses = firClassSymbol;
        Set checkedSubclasses = new LinkedHashSet();
        Info info = new Info((Set<? extends FirClassSymbol<?>>)((Object)allSubclasses), checkedSubclasses, session);
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.DataFlowBasedExhaustiveness)) {
            FirPureAbstractElement firPureAbstractElement = whenExpression.getSubjectVariable();
            if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null) {
                FirPureAbstractElement initializer = firPureAbstractElement;
                boolean bl = false;
                INSTANCE.inferVariantsFromSubjectSmartCast((FirExpression)initializer, info);
            }
        }
        whenExpression.accept(ConditionChecker.INSTANCE, info);
        Set notCheckedSubclasses = SetsKt.minus((Set)((Object)allSubclasses), (Iterable)checkedSubclasses);
        Iterable $this$partition$iv = notCheckedSubclasses;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirClassSymbol it = (FirClassSymbol)element$iv;
            boolean bl = false;
            FirClassSymbol $this$isEnumClass$iv = it;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            boolean bl2 = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List notCheckedEnumClasses = (List)pair.component1();
        List notCheckedRegularClasses = (List)pair.component2();
        for (FirClassSymbol notCheckedEnumClasses2 : notCheckedEnumClasses) {
            WhenOnEnumExhaustivenessChecker.INSTANCE.computeMissingCases(whenExpression, ScopeUtilsKt.defaultType(notCheckedEnumClasses2), session, destination);
        }
        for (FirClassSymbol notCheckedRegularClasses2 : notCheckedRegularClasses) {
            destination.add(new WhenMissingCase.IsTypeCheckIsMissing(notCheckedRegularClasses2.getClassId(), ((FirClass)notCheckedRegularClasses2.getFir()).getClassKind().isSingleton(), notCheckedRegularClasses2.getOwnTypeParameterSymbols().size()));
        }
    }

    private final void inferVariantsFromSubjectSmartCast(FirExpression subject, Info data) {
        if (!(subject instanceof FirSmartCastExpression)) {
            return;
        }
        for (DfaType knownNonType : ((FirSmartCastExpression)subject).getLowerTypesFromSmartCast()) {
            FirClassSymbol symbol;
            FirBasedSymbol firBasedSymbol;
            DfaType dfaType = knownNonType;
            FirBasedSymbol firBasedSymbol2 = firBasedSymbol = dfaType instanceof DfaType.Cone ? (FirBasedSymbol)ToSymbolUtilsKt.toSymbol(((DfaType.Cone)knownNonType).getType(), data.getSession()) : (dfaType instanceof DfaType.Symbol ? ((DfaType.Symbol)knownNonType).getSymbol() : null);
            if ((firBasedSymbol instanceof FirClassSymbol ? (FirClassSymbol)firBasedSymbol : null) == null) continue;
            symbol = symbol;
            ConditionChecker.INSTANCE.processBranch(symbol, false, data);
        }
    }

    private final Set<FirClassSymbol<?>> collectAllSubclasses(FirClassSymbol<?> $this$collectAllSubclasses, FirSession session) {
        Set set;
        Set $this$collectAllSubclasses_u24lambda_u240 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        WhenOnSealedClassExhaustivenessChecker.collectAllSubclassesTo$default(INSTANCE, $this$collectAllSubclasses, $this$collectAllSubclasses_u24lambda_u240, session, null, 4, null);
        return set;
    }

    private final void collectAllSubclassesTo(FirClassSymbol<?> $this$collectAllSubclassesTo, Set<FirClassSymbol<?>> destination, FirSession session, Set<FirRegularClassSymbol> visited2) {
        if (!($this$collectAllSubclassesTo instanceof FirRegularClassSymbol)) {
            destination.add($this$collectAllSubclassesTo);
            return;
        }
        if (!visited2.add((FirRegularClassSymbol)$this$collectAllSubclassesTo)) {
            return;
        }
        FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)((FirRegularClassSymbol)$this$collectAllSubclassesTo).getFir();
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getStatus().getModality() == Modality.SEALED) {
            if (Intrinsics.areEqual((Object)ClassMembersKt.isJavaNonAbstractSealed((FirRegularClass)((FirRegularClassSymbol)$this$collectAllSubclassesTo).getFir()), (Object)true)) {
                destination.add($this$collectAllSubclassesTo);
            }
            Iterable $this$forEach$iv = SealedClassInheritorsKt.getSealedClassInheritors((FirRegularClass)((FirRegularClassSymbol)$this$collectAllSubclassesTo).getFir(), session);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirRegularClassSymbol symbol;
                ClassId it = (ClassId)element$iv;
                boolean bl = false;
                FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(session).getClassLikeSymbolByClassId(it);
                FirRegularClassSymbol firRegularClassSymbol = symbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                if (firRegularClassSymbol == null) continue;
                INSTANCE.collectAllSubclassesTo(firRegularClassSymbol, destination, session, visited2);
            }
        } else {
            destination.add($this$collectAllSubclassesTo);
        }
    }

    static /* synthetic */ void collectAllSubclassesTo$default(WhenOnSealedClassExhaustivenessChecker whenOnSealedClassExhaustivenessChecker, FirClassSymbol firClassSymbol, Set set, FirSession firSession, Set set2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            set2 = new LinkedHashSet();
        }
        whenOnSealedClassExhaustivenessChecker.collectAllSubclassesTo(firClassSymbol, set, firSession, set2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\"\u0010\r\u001a\u00020\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0002J$\u0010\u0012\u001a\u00020\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0002H\u0002J$\u0010\u0013\u001a\u00020\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J*\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0016*\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0002H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker$Info;", "<init>", "()V", "visitEqualityOperatorCall", "", "equalityOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "data", "visitTypeOperatorCall", "typeOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "processBranch", "symbolToCheck", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "isNegated", "", "processBranchUsingSubtyping", "processBranchUsingSealedInheritors", "info", "collectAllSuperclasses", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker$ConditionChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,684:1\n57#2:685\n777#3:686\n873#3,2:687\n777#3:689\n873#3,2:690\n2792#3,3:692\n812#3,12:695\n873#3,2:707\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessComputer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker$ConditionChecker\n*L\n484#1:685\n525#1:686\n525#1:687,2\n530#1:689\n530#1:690,2\n544#1:692,3\n558#1:695,12\n558#1:707,2\n*E\n"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Info> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Info data) {
            FirRegularClassSymbol firRegularClassSymbol;
            FirRegularClass firClass;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            switch (WhenMappings.$EnumSwitchMapping$0[equalityOperatorCall.getOperation().ordinal()]) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: 
                case 4: {
                    bl = true;
                    break;
                }
                default: {
                    return;
                }
            }
            boolean isNegated = bl;
            FirCall $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            FirExpression firExpression = FirExpressionUtilKt.unwrapSmartcastExpression($this$arguments$iv.getArgumentList().getArguments().get(1));
            FirResolvedQualifier firResolvedQualifier = firExpression instanceof FirResolvedQualifier ? (FirResolvedQualifier)firExpression : null;
            if (firResolvedQualifier == null) {
                return;
            }
            FirResolvedQualifier argument = firResolvedQualifier;
            FirClassLikeSymbol<?> firClassLikeSymbol = argument.getSymbol();
            FirRegularClassSymbol firRegularClassSymbol2 = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            FirRegularClass firRegularClass = firClass = firRegularClassSymbol2 != null ? (FirRegularClass)firRegularClassSymbol2.getFir() : null;
            if ((firRegularClass != null ? firRegularClass.getClassKind() : null) == ClassKind.OBJECT) {
                firRegularClassSymbol = firClass.getSymbol();
            } else {
                FirRegularClass firRegularClass2 = firClass;
                firRegularClassSymbol = firRegularClass2 != null ? firRegularClass2.getCompanionObjectSymbol() : null;
            }
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol symbol = firRegularClassSymbol;
            this.processBranch(symbol, isNegated, data);
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull Info data) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            switch (WhenMappings.$EnumSwitchMapping$0[typeOperatorCall.getOperation().ordinal()]) {
                case 5: {
                    bl = false;
                    break;
                }
                case 6: {
                    bl = true;
                    break;
                }
                default: {
                    return;
                }
            }
            boolean isNegated = bl;
            FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(typeOperatorCall.getConversionTypeRef()), data.getSession(), null, 2, null), data.getSession());
            if (firClassSymbol == null) {
                return;
            }
            FirClassSymbol<?> symbol = firClassSymbol;
            this.processBranch(symbol, isNegated, data);
        }

        public final void processBranch(@NotNull FirClassSymbol<?> symbolToCheck, boolean isNegated, @NotNull Info data) {
            Intrinsics.checkNotNullParameter(symbolToCheck, (String)"symbolToCheck");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(data.getSession()).supportsFeature(LanguageFeature.ImprovedExhaustivenessChecksIn23)) {
                this.processBranchUsingSubtyping(symbolToCheck, isNegated, data);
            } else {
                this.processBranchUsingSealedInheritors(symbolToCheck, isNegated, data);
            }
        }

        private final void processBranchUsingSubtyping(FirClassSymbol<?> symbolToCheck, boolean isNegated, Info data) {
            List list;
            FirClassSymbol subclass;
            Iterable $this$filterTo$iv$iv;
            boolean $i$f$filterTo;
            Collection destination$iv$iv;
            boolean $i$f$filter;
            Iterable $this$filter$iv;
            boolean bl = isNegated;
            if (!bl) {
                $this$filter$iv = data.getAllSubclasses();
                $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    subclass = (FirClassSymbol)element$iv$iv;
                    boolean bl2 = false;
                    if (!ConditionChecker.processBranchUsingSubtyping$isSubclassOf(subclass, data, symbolToCheck)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else if (bl) {
                $this$filter$iv = data.getAllSubclasses();
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    subclass = (FirClassSymbol)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!ConditionChecker.processBranchUsingSubtyping$isSubclassOf(subclass, data, symbolToCheck) && !ConditionChecker.processBranchUsingSubtyping$isSubclassOf(symbolToCheck, data, subclass))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List subclassesCheckedByTheBranch = list;
            data.getCheckedSubclasses().addAll(subclassesCheckedByTheBranch);
        }

        private final void processBranchUsingSealedInheritors(FirClassSymbol<?> symbolToCheck, boolean isNegated, Info info) {
            boolean bl;
            Set<FirClassSymbol<?>> supertypesWhichAreSealedInheritors;
            Set subclassesOfType;
            block4: {
                subclassesOfType = INSTANCE.collectAllSubclasses(symbolToCheck, info.getSession());
                supertypesWhichAreSealedInheritors = this.collectAllSuperclasses((FirBasedSymbol)symbolToCheck, info.getSession(), info);
                Iterable $this$none$iv = subclassesOfType;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FirClassSymbol it = (FirClassSymbol)element$iv;
                        boolean bl2 = false;
                        if (!info.getAllSubclasses().contains(it)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (bl && supertypesWhichAreSealedInheritors.isEmpty()) {
                return;
            }
            Set checkedSubclasses = isNegated ? SetsKt.minus(info.getAllSubclasses(), (Iterable)subclassesOfType) : SetsKt.plus((Set)subclassesOfType, (Iterable)supertypesWhichAreSealedInheritors);
            info.getCheckedSubclasses().addAll(checkedSubclasses);
        }

        /*
         * WARNING - void declaration
         */
        private final Set<FirClassSymbol<?>> collectAllSuperclasses(FirBasedSymbol<?> $this$collectAllSuperclasses, FirSession session, Info info) {
            void destination$iv;
            void $this$filterTo$iv;
            void $this$filterIsInstanceTo$iv$iv;
            if (!($this$collectAllSuperclasses instanceof FirClassSymbol)) {
                return SetsKt.emptySet();
            }
            if (!info.getAllSubclasses().contains($this$collectAllSuperclasses)) {
                return SetsKt.emptySet();
            }
            ConeClassLikeLookupTag lookupTag = ((FirClassSymbol)$this$collectAllSuperclasses).toLookupTag();
            Iterable $this$filterIsInstance$iv = info.getAllSubclasses();
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirRegularClassSymbol)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            Collection $i$f$filterIsInstance22 = new LinkedHashSet();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                FirRegularClassSymbol it = (FirRegularClassSymbol)element$iv;
                boolean bl = false;
                if (!SupertypeUtilsKt.isSubclassOf(it, lookupTag, session, true, true)) continue;
                destination$iv.add(element$iv);
            }
            return (Set)destination$iv;
        }

        private static final boolean processBranchUsingSubtyping$isSubclassOf(FirClassSymbol<?> $this$processBranchUsingSubtyping_u24isSubclassOf, Info $data, FirClassSymbol<?> other) {
            return SupertypeUtilsKt.isSubclassOf($this$processBranchUsingSubtyping_u24isSubclassOf, other.toLookupTag(), $data.getSession(), false, true);
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FirOperation.values().length];
                try {
                    nArray[FirOperation.EQ.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.IDENTITY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.NOT_EQ.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.NOT_IDENTITY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.IS.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FirOperation.NOT_IS.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnSealedClassExhaustivenessChecker$Info;", "", "allSubclasses", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "checkedSubclasses", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Ljava/util/Set;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getAllSubclasses", "()Ljava/util/Set;", "getCheckedSubclasses", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "resolve"})
    private static final class Info {
        @NotNull
        private final Set<FirClassSymbol<?>> allSubclasses;
        @NotNull
        private final Set<FirClassSymbol<?>> checkedSubclasses;
        @NotNull
        private final FirSession session;

        public Info(@NotNull Set<? extends FirClassSymbol<?>> allSubclasses, @NotNull Set<FirClassSymbol<?>> checkedSubclasses, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter(allSubclasses, (String)"allSubclasses");
            Intrinsics.checkNotNullParameter(checkedSubclasses, (String)"checkedSubclasses");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.allSubclasses = allSubclasses;
            this.checkedSubclasses = checkedSubclasses;
            this.session = session;
        }

        @NotNull
        public final Set<FirClassSymbol<?>> getAllSubclasses() {
            return this.allSubclasses;
        }

        @NotNull
        public final Set<FirClassSymbol<?>> getCheckedSubclasses() {
            return this.checkedSubclasses;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }
    }
}

