/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.actualizer.checker;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizerUtilsKt;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualChecker;
import org.jetbrains.kotlin.backend.common.actualizer.checker.IrExpectActualCheckersUtilsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.mpp.DeclarationSymbolMarker;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualAnnotationMatchChecker;
import org.jetbrains.kotlin.resolve.calls.mpp.ExpectActualMatchingContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\nH\u0002R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrAnnotationMatchingKmpChecker;", "Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrExpectActualChecker;", "<init>", "()V", "check", "", "context", "Lorg/jetbrains/kotlin/backend/common/actualizer/checker/IrExpectActualChecker$Context;", "isFakeOverride", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Z", "getContainingActualClassIfFakeOverride", "actualSymbol", "ir.actualization"})
@SourceDebugExtension(value={"SMAP\nIrAnnotationMatchingKmpChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrAnnotationMatchingKmpChecker.kt\norg/jetbrains/kotlin/backend/common/actualizer/checker/IrAnnotationMatchingKmpChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class IrAnnotationMatchingKmpChecker
implements IrExpectActualChecker {
    @NotNull
    public static final IrAnnotationMatchingKmpChecker INSTANCE = new IrAnnotationMatchingKmpChecker();

    private IrAnnotationMatchingKmpChecker() {
    }

    @Override
    public void check(@NotNull IrExpectActualChecker.Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrExpectActualChecker.Context $this$check_u24lambda_u240 = context2;
        boolean bl = false;
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        if (!languageVersionSettings.supportsFeature(LanguageFeature.MultiplatformRestrictions)) {
            return;
        }
        for (Map.Entry<IrSymbol, IrSymbol> entry : $this$check_u24lambda_u240.getExpectActualMap().getExpectToActual().entrySet()) {
            AbstractExpectActualAnnotationMatchChecker.Incompatibility incompatibility;
            IrSymbol expectSymbol = entry.getKey();
            IrSymbol actualSymbol = entry.getValue();
            if (expectSymbol instanceof IrTypeParameterSymbol || AbstractExpectActualAnnotationMatchChecker.INSTANCE.areAnnotationsCompatible(expectSymbol, (DeclarationSymbolMarker)actualSymbol, null, $this$check_u24lambda_u240.getMatchingContext()) == null) continue;
            IrSymbolOwner irSymbolOwner = expectSymbol.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            IrSymbol it = IrExpectActualCheckersUtilsKt.getTypealiasSymbolIfActualizedViaTypealias((IrDeclaration)irSymbolOwner, $this$check_u24lambda_u240.getClassActualizationInfo());
            boolean bl2 = false;
            IrTypeAliasSymbol irTypeAliasSymbol = it;
            it = irTypeAliasSymbol != null ? (IrSymbol)irTypeAliasSymbol : INSTANCE.getContainingActualClassIfFakeOverride(actualSymbol);
            boolean bl3 = false;
            IrSymbol irSymbol = it;
            if (irSymbol == null) {
                irSymbol = actualSymbol;
            }
            IrSymbol irSymbol2 = irSymbol;
            it = irSymbol2;
            boolean bl4 = false;
            IrSymbolOwner irSymbolOwner2 = it.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
            IrSymbol irSymbol3 = IrUtilsKt.getFileOrNull((IrDeclaration)irSymbolOwner2) != null ? irSymbol2 : null;
            if (irSymbol3 == null) {
                irSymbol3 = expectSymbol;
            }
            IrSymbol reportOn = irSymbol3;
            IrDiagnosticReporter irDiagnosticReporter = $this$check_u24lambda_u240.getDiagnosticsReporter();
            DeclarationSymbolMarker declarationSymbolMarker = incompatibility.getExpectSymbol();
            Intrinsics.checkNotNull((Object)declarationSymbolMarker, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSymbol");
            IrSymbol irSymbol4 = (IrSymbol)declarationSymbolMarker;
            DeclarationSymbolMarker declarationSymbolMarker2 = incompatibility.getActualSymbol();
            Intrinsics.checkNotNull((Object)declarationSymbolMarker2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrSymbol");
            IrActualizerUtilsKt.reportActualAnnotationsNotMatchExpect(irDiagnosticReporter, irSymbol4, (IrSymbol)declarationSymbolMarker2, incompatibility.getType().mapAnnotationType(IrAnnotationMatchingKmpChecker::check$lambda$0$3), reportOn);
        }
    }

    private final boolean isFakeOverride(IrSymbol $this$isFakeOverride) {
        IrSymbolOwner irSymbolOwner = $this$isFakeOverride.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        return IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)irSymbolOwner);
    }

    private final IrSymbol getContainingActualClassIfFakeOverride(IrSymbol actualSymbol) {
        if (!this.isFakeOverride(actualSymbol)) {
            return null;
        }
        IrSymbolOwner irSymbolOwner = actualSymbol.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        IrClass irClass = IrExpectActualCheckersUtilsKt.getContainingTopLevelClass((IrDeclaration)irSymbolOwner);
        return irClass != null ? irClass.getSymbol() : null;
    }

    private static final IrConstructorCall check$lambda$0$3(ExpectActualMatchingContext.AnnotationCallInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getAnnotationSymbol();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
        return (IrConstructorCall)object;
    }
}

