/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.type;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrTypeChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;
import org.jetbrains.kotlin.ir.validation.checkers.context.ContextUpdater;
import org.jetbrains.kotlin.ir.validation.checkers.context.TypeParameterScopeUpdater;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/type/IrTypeParameterScopeChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrTypeChecker;", "<init>", "()V", "requiredContextUpdaters", "", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/ContextUpdater;", "getRequiredContextUpdaters", "()Ljava/util/Set;", "check", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "container", "Lorg/jetbrains/kotlin/ir/IrElement;", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "checkTypeParameterReference", "element", "typeParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "ir.validation"})
public final class IrTypeParameterScopeChecker
implements IrTypeChecker {
    @NotNull
    public static final IrTypeParameterScopeChecker INSTANCE = new IrTypeParameterScopeChecker();

    private IrTypeParameterScopeChecker() {
    }

    @Override
    @NotNull
    public Set<ContextUpdater> getRequiredContextUpdaters() {
        return SetsKt.setOf((Object)TypeParameterScopeUpdater.INSTANCE);
    }

    @Override
    public void check(@NotNull IrType type, @NotNull IrElement container, @NotNull CheckerContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            IrSimpleType irSimpleType = type instanceof IrSimpleType ? (IrSimpleType)type : null;
            IrClassifierSymbol irClassifierSymbol = irSimpleType != null ? irSimpleType.getClassifier() : null;
            IrTypeParameterSymbol irTypeParameterSymbol = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
            if (irTypeParameterSymbol == null) break block0;
            IrTypeParameterSymbol it = irTypeParameterSymbol;
            boolean bl = false;
            INSTANCE.checkTypeParameterReference(context2, container, it);
        }
    }

    private final void checkTypeParameterReference(CheckerContext context2, IrElement element, IrTypeParameterSymbol typeParameterSymbol) {
        if (!context2.getTypeParameterScopeStack().isVisibleInCurrentScope(typeParameterSymbol)) {
            context2.error(this, element, "The following element references a type parameter '" + RenderIrElementKt.render$default((IrElement)typeParameterSymbol.getOwner(), null, 1, null) + "' that is not available in the current scope.");
        }
    }
}

